const express = require('express');
const router = express.Router();
const rest = require('../../rest/rest');

router.post('/submit', (req, res) => {
  rest
    .postResource(
      process.env.END_POINT_BASE_URI + process.env.ADDITIONAL_INFO,
      req.body
    )
    .then(data => {
      res.status(200).json(data);
    })
    .catch(error => console.log('submit rfai', error));
});

router.post('/updateRfai', (req, res) => {
  rest
    .postResource(
      process.env.END_POINT_BASE_URI + process.env.UPDATE_RFAI,
      req.body
    )
    .then(data => {
      res.status(200).json(data);
    })
    .catch(error => console.log('Update rfai', error));
});

router.get('/populateClaim/:id', (req, res) => {
  const id = req.params.id;
  rest
    .getResource(
      process.env.END_POINT_BASE_URI +
        process.env.POPULATE_CLAIM +
        '/' +
        id +
        '?level=line'
    )
    .then(data => {
      if (data) {
        res.status(200).json(data);
      } else {
        res.status(500).json(data);
      }
    })
    .catch(error => {
      console.log('Reports getStations error ', error);
    });
});

router.get('/viewSubmit/:id', (req, res) => {
  const id = req.params.id;
  rest
    .getResource(
      process.env.END_POINT_BASE_URI + process.env.SUBMISSION_INFO + '/' + id
    )
    .then(data => {
      if (data) {
        // console.log(
        //   `${process.env.END_POINT_BASE_URI}${process.env.SUBMISSION_INFO}` +
        //     JSON.stringify(data)
        // );
        res.status(200).json(data);
      } else {
        res.status(500).json(data);
      }
    })
    .catch(error => {
      console.log('Reports getStations error ', error);
    });
});

router.post('/getHccs', (req, res) => {
  rest
    .postResource(
      process.env.END_POINT_BASE_URI + process.env.GET_HCCSCODE,
      req.body
    )
    .then(data => {
      if (data) {
        res.status(200).json(data);
      } else {
        res.status(500).json(data);
      }
    })
    .catch(error => {
      console.log('Reports getStations error ', error);
    });
});

router.post('/getLoincCodes', (req, res) => {
  rest
    .postResource(
      process.env.END_POINT_BASE_URI + process.env.GET_LOINCCODES,
      req.body
    )
    .then(data => {
      if (data) {
        res.status(200).json(data);
      } else {
        res.status(500).json(data);
      }
    })
    .catch(error => {
      console.log('Reports getStations error ', error);
    });
});

router.post('/getLoincCodeModifiers', (req, res) => {
  rest
    .postResource(
      process.env.END_POINT_BASE_URI + process.env.GET_LOINCODEMODIFIERS,
      req.body
    )
    .then(data => {
      if (data) {
        res.status(200).json(data);
      } else {
        res.status(500).json(data);
      }
    })
    .catch(error => {
      console.log('Reports getStations error ', error);
    });
});
router.post('/addCodes', (req, res) => {
  rest
    .postResource(
      process.env.END_POINT_BASE_URI + process.env.ADD_CODES,
      req.body
    )
    .then(data => {
      res.status(200).json(data);
    })
    .catch(error => console.log('Add Codes', error));
});

router.get('/getEmailTemplates', (req, res) => {
  rest
    .getResource(
      process.env.END_POINT_BASE_URI + process.env.GET_EMAILTEMPLATES
    )
    .then(data => {
      if (data) {
        // console.log(JSON.stringify(data));
        res.status(200).json(data);
      } else {
        res.status(500).json(data);
      }
    })
    .catch(error => {
      console.log('Reports getStations error ', error);
    });
});
router.put('/submitEmailTempaltes', (req, res) => {
  console.log('reached submit', req.body);
  rest
    .putResource(
      process.env.END_POINT_BASE_URI + process.env.SUBMIT_EMAILTEMPALTES,
      req.body
    )
    .then(data => {
      // console.log('data', data);
      res.status(200).json(data);
    })
    .catch(error => console.log('Submit Emails', error));
});
module.exports = router;
