var Client = require('node-rest-client').Client;
var client = new Client();
const auth = require('../auth/auth');

module.exports.getResource = function(url, body) {
  return new Promise(function(resolve, reject) {
    auth.getAccessToken().then(access_token => {
      var args = {
        headers: {
          Authorization: access_token,
          'Content-Type': 'application/json'
        },
        data: body
      };
      resolve(
        new Promise(function(resolve, reject) {
          client.get(url, args, function(data, response) {
            resolve(data);
          });
        })
      );
    });
  });
};

module.exports.postResource = function(url, body) {
  return new Promise(function(resolve, reject) {
    auth.getAccessToken().then(access_token => {
      var args = {
        headers: {
          Authorization: access_token,
          'Content-Type': 'application/json'
        },
        data: body
      };
      resolve(
        new Promise(function(resolve, reject) {
          client.post(url, args, function(data, response) {
            // console.log('data ', data)
            // console.log('response ', response.headers)
            resolve(data);
          });
        })
      );
    });
  });
};

module.exports.putResource = function(url, body) {
  return new Promise(function(resolve, reject) {
    auth.getAccessToken().then(access_token => {
      var args = {
        headers: {
          Authorization: access_token,
          'Content-Type': 'application/json'
          // 'Cache-control': 'no-cache, no-store',
          // Pragma: 'no-cache',
          // Expires: 'Sat 01 Jan 2000 00:00:00 GMT'
        },
        data: body
      };
      resolve(
        new Promise(function(resolve, reject) {
          client.put(url, args, function(data, response) {
            resolve(data);
          });
        })
      );
    });
  });
};
module.exports.deleteResource = function(url, body) {
  return new Promise(function(resolve, reject) {
    auth.getAccessToken().then(access_token => {
      var args = {
        headers: {
          Authorization: access_token,
          'Content-Type': 'application/json'
        },
        data: body
      };
      resolve(
        new Promise(function(resolve, reject) {
          client.delete(url, args, function(data, response) {
            resolve(data);
          });
        })
      );
    });
  });
};
// For rest calls that needs to pass guid
module.exports.getResource2 = function(url, guid) {
  return new Promise(function(resolve, reject) {
    auth.getAccessToken().then(access_token => {
      var args = {
        parameters: {
          guid: guid
        },
        headers: {
          Authorization: access_token,
          'Content-Type': 'application/json'
        }
      };
      resolve(
        new Promise(function(resolve, reject) {
          client.get(url, args, function(data, response) {
            resolve(data);
          });
        })
      );
    });
  });
};
