const express = require('express');
const router = express.Router();
const rest = require('./../rest/rest');
var Client = require('node-rest-client').Client;
const dns = require('dns');


router.get('/ssoTest', (req, res) => {
    
    // console.log('req', req)
    let ip = '';
    dns.lookup(req.headers.host.split(':')[0], (err, ipAddress) => {
        if (err) {
            // console.log('err ', err);
            ip = req.headers.host.split(':')[0];
        }
        // console.log('ipAddress', ipAddress);
        ip = ipAddress;
    })
    const hostname = { 'hostname': ip }
    rest.postResource(process.env.END_POINT_BASE_URI + process.env.SSO, hostname)
        .then(response => {
            console.log('response ', response)
            const jspBody = {
                u: response.encodedPostBackUrl,
                c: response.encodedCapturedUrl,
                s: response.sessionInformation
            }
            console.log(jspBody);
            res.status(200).json(jspBody);
        }).catch(error => {
            console.log('error');
            res.status(400).json(error);
        })
})
router.post('/postback', (req, res) => {
    //console.log('req.body: ', req.body);
    //console.log('req.body.i: ', req.body.i);
    //console.log('req.body.i (stringified): ', JSON.stringify(req.body));
    // rest.postResource(process.env.END_POINT_BASE_URI + process.env.SSO_POST_BACK, req.body.i)
    // .then(response => {
        //console.log('Postback response ', response);
        // res.status(200).redirect('/login/'+ req.body.i);
    // }).catch(error => {
    //     console.log('error ', error);
    //     res.status(400).json('error');
    // })
    const user = req.body.i
    res.status(200).redirect('/login/'+ user);
})
router.post('/getUserRoles', (req, res) => {
    rest.postResource(process.env.END_POINT_BASE_URI + process.env.SSO_USER_ROLES, req.body)
        .then(roles => {
            res.status(200).json(roles);
        }).catch(error => {
            console.log('error from getUserRoles sso ', error)
            res.status(400).json(error);
        })
})

module.exports = router;