package po;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class LoginPO {
	WebDriver driver;
	
	public LoginPO(WebDriver driver){
		this.driver = driver;
		PageFactory.initElements(driver, this);
	}
	
	@FindBy(id = "userName") 
	private WebElement selectUserNameDrp;
	
	@FindBy(id = "loginAdminBtn") 
	private WebElement acceptBtm;
	
	@FindBy(xpath = "//option[@value ='VHAISEWVUSER']") 
	private WebElement optionDrp;
	
	
	public void selectUserNameDropDown(String userName){
		WebDriverWait wait = new WebDriverWait(driver,10);
		wait.until(ExpectedConditions.elementToBeClickable(optionDrp));
		Select select = new Select(selectUserNameDrp);
		select.selectByValue(userName);
	}
	
	public void acceptBtnClick(){
		acceptBtm.click();
	}
	
	
}
