package po;

import java.util.ArrayList;
import java.util.List;

import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class EDI_WebViewerClaimDentalPO {
	WebDriver driver;
	
	public EDI_WebViewerClaimDentalPO(WebDriver driver){
		this.driver = driver;
		PageFactory.initElements(driver, this);
	}
	
	
	@FindBy(xpath= "/html/body/app-root/app-ewv/div/div[2]/section/div[3]/div/div/table/tbody/tr[1]/td[1]")
	private WebElement submissionType; //Claim type: Dent, Prof, Inst
	
	@FindBy(id = "patientInfo") 
	private WebElement lblPatientInfo;
	
//	
//	@FindBy(id = "???????") 
//	private WebElement dataPatientInfo;
	
	
	
	
	
	@FindBy(id = "quickView") 
	private WebElement tabQuickView;
	
	
	@FindBy(id = "detailView") 
	private WebElement tabDetailView;
	
	
	
	
	
	@FindBy(id = "IPT_vendorInfo_ewvMaster_1") 
	private WebElement vendorInfo;
	
	
	
	
	public char getClaimType(){
		return submissionType.getText().charAt(0); //get the first char of type :I, P, D
	}
	
//	
//	public ArrayList<String> billingInfoData() {
//		ArrayList<String> array = new ArrayList<String>();
//		for(WebElement item: billingInfo) {
//			array.add(item.getText());
//			System.out.println(item.getText());
//		}
//	return array;
//	}
//	
	
	
	
	public void waitForPageLoaded() {
        ExpectedCondition<Boolean> expectation = new
                ExpectedCondition<Boolean>() {
                    public Boolean apply(WebDriver driver) {
                        return ((JavascriptExecutor) driver).executeScript("return document.readyState").toString().equals("complete");
                    }
                };
        try {
            Thread.sleep(1000);
            WebDriverWait wait = new WebDriverWait(driver, 30);
            wait.until(expectation);
        } catch (Throwable error) {
            Assert.fail("Timeout waiting for Page Load Request to complete.");
        }
    }
	
	
	
	
	
	
}
