package po;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class EDI_PDILookupPO {
	WebDriver driver;
	
	public EDI_PDILookupPO(WebDriver driver){
		this.driver = driver;
		PageFactory.initElements(driver, this);
	}
	
	@FindBy(xpath = "/html/body/app-root/app-ewv-search/div/div[2]/section/div/div/div/div/h1") 
	private WebElement title;
	
	@FindBy(id = "pdiSearchParam")
	private WebElement inpPDILookup;
	
	@FindBy(id = "pdiSearch")
	WebElement  btnRetrieve;
	
	@FindBy(id = "pdiyClear")
	WebElement  btnResetForm;
	
	
	
	public String getTitle() {
        WebDriverWait wait = new WebDriverWait(driver,10);
		wait.until(ExpectedConditions.elementToBeClickable(btnRetrieve));
		return title.getText();
	}
	
	//enters a pdi into input field
	public void setPDINumber(String  pdiNumber) {
		inpPDILookup.sendKeys(pdiNumber);
	}
	
	
	public void clickButtonRetrieve() {
		btnRetrieve.click();
	}
	
	
	public void clickButtonResetForm() {
		btnResetForm.click();
	}
	
	
}
