package automation.Pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.junit.Test;

import automation.ExplorerSuite;
import automation.SharedCodeClass;

public class Search275 extends ExplorerSuite {
	
	@Test
	public void loadRunner(){
		driver.get(baseUrl + "search275");
		testPage();
	}

	public void testPage(){
		
		Map<String, String> elements =new HashMap<String, String>();
		elements.put("breadcrumbs", "275 Search  /");
		elements.put("tab-label", "275 Search");
		SharedCodeClass.assertByTextByClass(elements);
		
		List<String> h1Contents=new ArrayList<String>();
		h1Contents.add("Attachments Retrieval  |  275 Search");
		SharedCodeClass.findAllEllementsTag("h1",h1Contents);
		
		List<String> h3Contents=new ArrayList<String>();
		h3Contents.add("Search Criteria");
		SharedCodeClass.findAllEllementsTag("h3",h3Contents);
		
		
		Map<String, String> idText =new HashMap<String, String>();
		idText.put("noteTitle", "Enter any combination of parameters to find matching attachments.");
		SharedCodeClass.assertByTextById(idText);
		
		
		List<String> labelText=new ArrayList<String>();
		labelText.add("275 Search");
		labelText.add("Attachment ID");
		labelText.add("Patient Last Name");
		labelText.add("Provider Name");
		labelText.add("Attachment Control Number");
		labelText.add("Patient First Name");
		labelText.add("Provider NPI");
		labelText.add("Report Type Code");
		labelText.add("Patient ID");
		labelText.add("Payer Control Number");
		labelText.add("Status");
		labelText.add("Patient Control Number");
		labelText.add("Claim ID");
		labelText.add("Medical Record Number");
		labelText.add("Service Start Date mm/dd/yyyy");
		labelText.add("Service End Date mm/dd/yyyy");
		SharedCodeClass.findAllEllementsTag("label",labelText);
		
		ArrayList<String> inputId=new ArrayList<String>();
		inputId.add("attachmentId");
		inputId.add("patientLastName");
		inputId.add("providerName");
		inputId.add("controlNumber");
		inputId.add("patientFirstName");
		inputId.add("providerNpi");
		inputId.add("reportTypeCode");
		inputId.add("payerControlNumber");
		inputId.add("status");
		inputId.add("patientControlNumber");
		inputId.add("claimId");
		inputId.add("medicalRecordNumber");
		inputId.add("serviceStartDate");
		inputId.add("serviceEndDate");
		SharedCodeClass.assertById(inputId);
		
		
		
		SharedCodeClass.findElementId("searchButton");
		SharedCodeClass.findElementId("resetButton");
		Map<String,String> buttonElements =new HashMap<String,String>();
		elements.put("searchButton","Submit");
		elements.put("resetButton","Reset Form");
		SharedCodeClass.assertByTextById(buttonElements);
	}
}
