package automation.Pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.junit.Test;

import automation.ExplorerSuite;
import automation.SharedCodeClass;

public class RfaiLookupTest extends ExplorerSuite {
	
	@Test
	public void localRunner(){
		driver.get(baseUrl + "lookup");
		SharedCodeClass.waitForLoad(driver);
		testTitle();
		testLabels();
		testButtons();
		advancedSearchPage();
	}
	@Test
	public void testTitle(){
		Map<String,String> elements =new HashMap();
		elements.put("page-title", "277 RFAI Submission Search");
		SharedCodeClass.assertByTextByClass(elements);
	}
	
	@Test
	public void testLabels(){
		ArrayList<String> labels = new ArrayList<String>();
		labels.add("Quick Search");
		labels.add("Advanced Search");
		labels.add("Any Combination of Submission ID/ PDI/ Claim ID/ Patient ID/ Provider NPI");		
		SharedCodeClass.findAllEllementsTag("label",labels);
	}
	
	@Test
	public void testButtons(){
		SharedCodeClass.findElementId("primarySearch");
		SharedCodeClass.findElementId("primaryClear");
		Map<String,String> elements =new HashMap();
		elements.put("primarySearch","Search");
		elements.put("primaryClear","Reset Form");
		SharedCodeClass.assertByTextById(elements);		
	}
	
	@Test
	public void advancedSearchPage(){
		// First we will click the Advanced Search Link Then assert all the elements from that page
		SharedCodeClass.clickById("advancedSearch");
		Map<String,String> elements =new HashMap();
		elements.put("section-header","RFAI Advanced Search");
		SharedCodeClass.assertByTextByClass(elements);
		
		// Assert for label tags in Advanced Section
		ArrayList<String> labels = new ArrayList<String>();
		labels.add("Quick Search");
		labels.add("Advanced Search");
		labels.add("PDI or Claim ID");
		labels.add("Billing Provider Name");
		labels.add("Provider NPI");
		labels.add("Provider TIN");
		labels.add("Patient Last Name");
		labels.add("Patient First Name");
		labels.add("Patient Identifier");
		labels.add("Patient Control Number");
		labels.add("Medical Record Number");
		labels.add("Line Item Control Number");
		labels.add("Service Start Date");
		labels.add("Service End Date");
		SharedCodeClass.findAllEllementsTag("label",labels);
		
		// Assert for button in Advanced Section
	
		SharedCodeClass.findElementId("advancedSearch");
		SharedCodeClass.findElementId("advancedClear");
		Map<String,String> buttomElements =new HashMap();
		buttomElements.put("advancedSearch","Search");
		buttomElements.put("advancedClear","Reset Form");
		SharedCodeClass.assertByTextById(elements);
		
		//Assert the Service Start an End Date so that End Date is less than start date
		try {
			SharedCodeClass.fillAllElementById("serviceStartDate", "02/01/2018");
			SharedCodeClass.fillAllElementById("serviceEndDate", "01/01/2018");
			SharedCodeClass.fillAllElementById("billingProvider", "testText");
			ArrayList<String> error = new ArrayList<String>();
			error.add("invalidDateRange");
			SharedCodeClass.assertById(error);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
	}
	
}
