package automation.Pages;



import java.io.IOException;
import java.util.List;

import org.junit.Assert;
import automation.ExplorerSuite;
import automation.SharedCodeClass;
import po.EDI_PDILookupPO;
import po.EDI_WebViewerClaimDentalPO;
import po.LoginPO;


/***
 * 
 * @author EKutsenko,
 * @version 1.0
 */


public class EDI_WebViewerPDILookup extends ExplorerSuite {
	EDI_PDILookupPO ediWebViewerLookup;
	EDI_WebViewerClaimDentalPO ediWebViewerClaimInfo;
	LoginPO selectLogin;
	
	
	public void localRunner() throws IOException, InterruptedException{
		//driver.manage().timeouts().implicitlyWait(10, TimeUnit.SECONDS);
		ediWebViewerLookup = new EDI_PDILookupPO(driver);
		ediWebViewerClaimInfo = new EDI_WebViewerClaimDentalPO(driver);
		loadPage();
		testTitle();
		testInputPositiveDental();
		//testTable();
		
	}
	
	
    public void loadPage() throws InterruptedException {
    	selectLogin = new LoginPO(driver);
    	selectLogin.selectUserNameDropDown("VHAISEWVUSER");
    	selectLogin.acceptBtnClick();
    	//Thread.sleep(3000);
    		
    }
	
    
    //Test a Title, it should be "EDI Web Viewer"
	public void testTitle() throws IOException, InterruptedException{
		String expecteds = "EDI Web Viewer";
		try {
			
			String actuals = ediWebViewerLookup.getTitle();
		//	Thread.sleep(3000);
		    Assert.assertEquals("Title is wrong!", expecteds, actuals);
		    System.out.println("Verify a title is passed");
		    SharedCodeClass.addReport("Verify a title is passed");
		} catch (AssertionError  | Exception e) {
			System.out.println("Verify a title is FAILED with a error: " + e);
			SharedCodeClass.addReport("Verify a title is FAILED with a error: " + e.getMessage());
			SharedCodeClass.addReport("***********************************************************");
		}
	}
	
	
	//Verify that a dental pdi brings a user to a EDI Web Viewer Dental claim page
	public void testInputPositiveDental() throws IOException, InterruptedException{
		String pdiDental = "200617203000952";
		char actual;
		char expected = 'D';
		try {
			ediWebViewerLookup.setPDINumber(pdiDental);
			ediWebViewerLookup.clickButtonRetrieve();
			ediWebViewerClaimInfo.waitForPageLoaded();
			actual = ediWebViewerClaimInfo.getClaimType();
			Assert.assertEquals("Claim Type is wrong!", expected, actual);
			
		    System.out.println("Verify a dental pdi is passed");
		    SharedCodeClass.addReport("Verify a dental pdi is passed");
		} catch (AssertionError  | Exception e) {
			System.out.println("Verify a a dental pdi is FAILED with a error: " + e);
			SharedCodeClass.addReport("Verify a a dental pdi is FAILED with a error: " + e.getMessage());
			SharedCodeClass.addReport("***********************************************************");
		}
	}
	
	
	
	
	
/*
	public void testTable() {
		
		driver.findElement(By.id("searchButton")).click();
//		WebElement wait = (new WebDriverWait(driver, 10))
//				  .until(ExpectedConditions.presenceOfAllElementsLocatedBy(By.xpath("//table/thead/tr/th")));
		List<WebElement> headers =  driver.findElements(By.xpath("//table/thead/tr/th"));
		for(WebElement header: headers) {
			System.out.println(header.getText());
		}
		
	}  */
	   
}
