package automation.Pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.junit.Test;

import automation.ExplorerSuite;
import automation.SharedCodeClass;

public class Admin extends ExplorerSuite {
	
	@Test
	public void localRunner() throws InterruptedException{
		SharedCodeClass.waitForLoad(driver);
	    Thread.sleep(2000);
		SharedCodeClass.clickById("NAV_arsAdmin_appNav_1");
		testTitle();
		testLabels();
		testButton();
		testNotificationTab();
	}

	public void testTitle(){
		Map<String,String> elements =new HashMap();
		elements.put("pagetitle", "277 RFAI Submission Codes");
		SharedCodeClass.assertByTextById(elements);		
	}
	@Test
	public void testLabels() throws InterruptedException{
		ArrayList<String> labels = new ArrayList<String>();
		labels.add("Manage Codes");
		labels.add("Health Care Claim Status Category Codes");
		labels.add("Add New Code");
		labels.add("LOINC Codes");
		labels.add("Add New Code");
		labels.add("LOINC Modifier Codes");
		labels.add("Add New Code");
		labels.add("Manage Users");
		labels.add("Notifications");
		SharedCodeClass.findAllEllementsTag("label",labels);
		Thread.sleep(6000);
		
	}
	public void testButton(){
		SharedCodeClass.findElementId("submitChanges");
		SharedCodeClass.findElementId("cancel");
		Map<String,String> elements =new HashMap();
		elements.put("submitChanges","Submit Changes");
		elements.put("cancel","Cancel");
		SharedCodeClass.assertByTextById(elements);
	}
	public void testNotificationTab(){
		SharedCodeClass.clickById("tab3");
		ArrayList<String> h3Text = new ArrayList<String>();
		h3Text.add("ARS Notification Management");
		SharedCodeClass.findAllEllementsTag("h3", h3Text);
		// Expand all then test
		SharedCodeClass.clickById("acc4");
		SharedCodeClass.clickById("acc5");
		SharedCodeClass.clickById("acc6");
		SharedCodeClass.clickById("acc7");
		SharedCodeClass.clickById("acc8");
		ArrayList<String> labels = new ArrayList<String>();		
		labels.add("Manage Codes");
		labels.add("Manage Users");
		labels.add("Notifications");
		labels.add("Submission Pending Email");
		labels.add("Heading");
		labels.add("Email Message");
		labels.add("Submission Error Email");	
		labels.add("Heading");
		labels.add("Email Message");
		labels.add("Submission Abandoned Email");		
		labels.add("Heading");
		labels.add("Email Message");
		labels.add("Submission Complete/Closed Email");	
		labels.add("Heading");
		labels.add("Email Message");			
		labels.add("Submission Manually Closed Email");
		labels.add("Heading");
		labels.add("Email Message");	
		SharedCodeClass.findAllEllementsTag("label",labels);
		
		
		// testing buttons
		
		SharedCodeClass.findElementId("submitPendingChanges");
		SharedCodeClass.findElementId("cancelPendingChanges");
		SharedCodeClass.findElementId("submitErrorChanges");
		SharedCodeClass.findElementId("cancelErrorChanges");
		SharedCodeClass.findElementId("submitAbondonedChanges");
		SharedCodeClass.findElementId("cancelAbondonedChanges");
		SharedCodeClass.findElementId("submitClosedChanges");
		SharedCodeClass.findElementId("cancelClosedChanges");
		SharedCodeClass.findElementId("submitManuallyClosedChanges");
		SharedCodeClass.findElementId("cancelManuallyClosedChanges");
		Map<String,String> elements =new HashMap();
		elements.put("submitPendingChanges","Submit Changes");
		elements.put("cancelPendingChanges","Cancel");
		elements.put("submitErrorChanges","Submit Changes");
		elements.put("cancelErrorChanges","Cancel");
		elements.put("submitAbondonedChanges","Submit Changes");
		elements.put("cancelAbondonedChanges","Cancel");
		elements.put("submitClosedChanges","Submit Changes");
		elements.put("cancelClosedChanges","Cancel");
		elements.put("submitManuallyClosedChanges","Submit Changes");
		elements.put("cancelManuallyClosedChanges","Cancel");
		SharedCodeClass.assertByTextById(elements);
	}
}
