/*package gov.va.med.ewv.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.ars.dao.fpps.IEwvClaimRepository;
import gov.va.med.ars.exceptions.GenericException;

import gov.va.med.domain.fee.EwvClaims;
import gov.va.med.ewv.codes.DiagnosisCode;
import gov.va.med.ewv.codes.DiagnosisCodesContainer;
import gov.va.med.ewv.codes.ECodesContainer;
import gov.va.med.ewv.codes.ProcedureCode;
import gov.va.med.ewv.codes.ProcedureCodesContainer;
import gov.va.med.ewv.exceptions.NonUniqueRecordsException;
import gov.va.med.ewv.model.response.AmbulanceInfo;
import gov.va.med.ewv.model.response.BillingAndAdmissionInfo;
import gov.va.med.ewv.model.response.ClaimOhi;
import gov.va.med.ewv.model.response.ClaimOhiContainer;
import gov.va.med.ewv.model.response.DetailServiceLineOhiOutputRow;
import gov.va.med.ewv.model.response.DrugLine;
import gov.va.med.ewv.model.response.EwvClaimDetailResponse;
import gov.va.med.ewv.model.response.HealthCareInfoResponse;
import gov.va.med.ewv.model.response.HealthCareInformationLine;
import gov.va.med.ewv.model.response.MedicalEquipmentLine;
import gov.va.med.ewv.model.response.OhiInfoContainer;
import gov.va.med.ewv.model.response.PatientHeaderInfo;
import gov.va.med.ewv.model.response.PatientInfo;
import gov.va.med.ewv.model.response.Provider;
import gov.va.med.ewv.model.response.QuickViewServiceLineOhiOutputRow;
import gov.va.med.ewv.model.response.ServiceLineOhiAdjustment;
import gov.va.med.ewv.model.response.ToothLine;
import gov.va.med.ewv.model.response.VendorInfo;
import gov.va.med.ewv.service.IEwvAmbulanceAndServiceLinesInfoService;
import gov.va.med.ewv.service.IEwvBillingMiscInfoService;
import gov.va.med.ewv.service.IEwvDiagnosisCodesInfoService;
import gov.va.med.ewv.service.IEwvE_CodesInfoService;
import gov.va.med.ewv.service.IEwvHealthCareInfoService;
import gov.va.med.ewv.service.IEwvOhiService;
import gov.va.med.ewv.service.IEwvPatientAndVendorInfoService;
import gov.va.med.ewv.service.IEwvProcedureCodesInfoService;
import gov.va.med.ewv.service.impl.EwvClaimServiceImpl;
import gov.va.med.ewv.util.ClaimFormat;
import gov.va.med.ewv.util.ClaimType;
import gov.va.med.ewv.util.EwvUtils;
import gov.va.med.ewv.util.ServiceLine;

@RunWith(MockitoJUnitRunner.class)
public class EwvClaimServiceImplTest {
	@InjectMocks
	EwvClaimServiceImpl ewvClaimService;
	
	@Mock
	IEwvClaimRepository ewvClaimRepository;
	
	@Mock
	IEwvPatientAndVendorInfoService ewvPatientAndVendorInfoService;
	
	@Mock
	IEwvBillingMiscInfoService ewvBillingMiscInfoService;
	
	@Mock
	IEwvAmbulanceAndServiceLinesInfoService ewvBillingAndServiceLinesInfoService;
	
	@Mock
	IEwvDiagnosisCodesInfoService ewvDiagnosisCodesInfoService;
	
	@Mock
	IEwvHealthCareInfoService ewvHealthCareInfoService;

	@Mock
	IEwvProcedureCodesInfoService ewvProcedureCodesInfoService;
	
	@Mock
	IEwvAmbulanceAndServiceLinesInfoService ewvAmbulanceAndServiceLinesInfoService;

	@Mock
	IEwvOhiService ewvOhiService;
	
	@Mock
	IEwvE_CodesInfoService ewvE_CodesInfoService;
	
	String pdi = "201736500000002";
	EwvClaims ewvClaim;
	EwvClaimDetailResponse response;
	PatientHeaderInfo patientHeaderInfo;
	PatientInfo patientInfo;
	VendorInfo serviceLocationInfo;
	VendorInfo billingProviderInfo;
	BillingAndAdmissionInfo billingMiscellanous;
	DiagnosisCodesContainer diagnosisCodesInfo;
	ProcedureCodesContainer procedureCodesInfo;
	HealthCareInfoResponse healthCareInfo;
	List<ServiceLine> serviceLinesInfo;	
	OhiInfoContainer ohiInfo;
	
	@Test
	public void testMockIsWorking() {
		assertNotNull("EwvClaimServiceImpl Injection Failed", ewvClaimService);
	}

	@Before
	public void init() throws Exception {
		Long guid = 3L;		
		String ediClaimKey = "681A4FD0-CE88-7F6C-E053-4A10BF0A3038";
		ClaimFormat claimFormat = ClaimFormat.FORMAT4010;
		ClaimType claimType = ClaimType.DENTAL;
		String memberId = "666666661";
		String medicareCrossover = "Y";
		String pos = "21";

		 Patient info 
		String patientName = "RODGERS-CROMARTIE, DOMINIQUE";
		String patientIdNumber = "1234567890";
		String patientDob = "01/01/1935";
		String patientGender = "M";
		String patientAddressLine1 = "1122 Maple Street";
		String patientAddressLine2 = "Apt. B";
		String patientCity = "NEW YORK";
		String patientState = "NY";
		String patientPostalCode = "12345";
		String patientCountry = "USA";
		
		 Vendor info 
		String serviceVendorName = "GENERAL DIAGNOSTIC HOSPITAL";
		String serviceVendorTaxIdNum = "1234567890";
		String serviceVendorNpi = "1234567890";;
		String serviceVendorAddressLine1 = "2000 SOUTH US HIGHWAY 1";
		String serviceVendorAddressLine2 = "SUITE 100";
		String serviceVendorCity = "NEW YORK";
		String serviceVendorState = "NY";
		String serviceVendorPostalCode = "12345";
		
		String billingVendorName = "GENERAL MEMORIAL HOSPITAL";
		String billingVendorTaxIdNum = "1234567890";
		String billingVendorNpi = "1234567890";;
		String billingVendorAddressLine1 = "1212 SOUTH US HIGHWAY 1";;
		String billingVendorAddressLine2 = null;
		String billingVendorCity = "NEW YORK";;
		String billingVendorState = "NY";
		String billingVendorPostalCode = "12345";
		
		 Billing info 
		String invoicePatientAccountNum= "1721590-2";
		String invoiceTypeOfBill= "21";
		String invoiceFrequency= "1";
		String invoiceStatementFromDate= "01/01/2017";
		String invoiceStatementToDate= "02/01/2017";
		String invoicePreviousPdi= "1234567890123";
		String invoicePatientPaidAmt= "999.99";
		String invoicePatientSignature= "B";
		String invoicePatientStatus= "UNK";
		String invoicePriorAuthorization1= "12345678901234567890";
		String invoicePriorAuthorization2= "";
		String invoiceAdmissionType= "UNK";
		String invoiceAdmissionSource= "UNK";
		String invoiceAdmissionDate = "01/01/2017";
		String invoiceAdmissionHour = "15:00";
		String invoiceAccidentDate= "01/01/2017";
		String invoiceAccidentIndicator= "123456";
		String invoiceProvAcceptsAssignmt= "A"; //which field?
		String invoiceAssignmentOfBenefits= "Y";
		String invoiceDischargeDateHour= "02/01/2017 15:00";
		String invoiceAdmissionDateHour = "01/01/2017 15:00";
		String svcLineTotalClaimCharges = "999.99";
		String pcn = invoicePatientAccountNum;
		String pcnShort = EwvUtils.shorten(pcn, 20);		
		String hccodesPoaNotes = "123456789012345678901234567890";
		String hccodesPrincipalDiagnosis = "998";
		String hccodesAdmittingDiagnosis = "998";
		String hccodesReasonForVists = "998";
		String hccodesECode = "998";
		String hccodesPrincipalProcedure = "998";
		String hccodesPrincipalProcDate = "03/01/2017";		
		String admittingDiagnosis = hccodesAdmittingDiagnosis;
        String reasonForVisit = hccodesReasonForVists;
        String eCode = hccodesECode;
        String poaNotesPlain = hccodesPoaNotes;
        String poaNotesLong = EwvUtils.addLineBreaks(poaNotesPlain);
        String poaNotesShort = EwvUtils.shorten(poaNotesLong, 15);
        boolean usePoaNotesModelPanel = false;
        if (poaNotesShort.endsWith("...")) {
          usePoaNotesModelPanel = true;
        }
		String priorAuthorizationReferralShort = EwvUtils.shorten(invoicePriorAuthorization1, 20);
		String renderingPrvdName = "";
		String renderingPrvdNpi = "";
		String renderingPrvdTaxonomyCode = "";
		String dischargeDateOrHour = "02/01/17";
		String reasonForVisit2_5010 = "";
		String reasonForVisit3_5010 = "";
		String referralShort_5010 = "";
		String referralLong_5010 = "";
		
        // Needed to altered once the updated model jar is added 
//        String reasonForVisit2_5010 = claim.getHccodesReasonForVisit2_5010();
//        String reasonForVisit3_5010 = claim.getHccodesReasonForVisit3_5010();
//        String referralLong_5010 = claim.getInvoiceReferral_5010();
		
		patientHeaderInfo = new PatientHeaderInfo(claimFormat, claimType, medicareCrossover, patientName,
				billingVendorNpi, memberId, billingVendorTaxIdNum, pdi, pcn, pcnShort, Boolean.FALSE);
		
		patientInfo = new PatientInfo(patientName, patientIdNumber, patientDob, "", patientGender, patientAddressLine1,
				patientAddressLine2, patientCity, patientState, patientPostalCode, patientCountry);
		
		
		serviceLocationInfo = new VendorInfo(serviceVendorName, serviceVendorTaxIdNum, serviceVendorNpi, "", 
				serviceVendorAddressLine1, serviceVendorAddressLine2, serviceVendorCity, serviceVendorState, serviceVendorPostalCode, "");
				
		billingProviderInfo = new VendorInfo(billingVendorName, billingVendorTaxIdNum, billingVendorNpi, "", 
				billingVendorAddressLine1, billingVendorAddressLine2, billingVendorCity, billingVendorState, billingVendorPostalCode, "");
		   

		billingMiscellanous = new BillingAndAdmissionInfo();
		billingMiscellanous.setStatementFromTo(invoiceStatementFromDate + " - " + invoiceStatementToDate);
		billingMiscellanous.setPatientAccountNumber(pcn);
		billingMiscellanous.setPatientPaidAmount(invoicePatientPaidAmt);
		billingMiscellanous.setPatientSignature(invoicePatientSignature);
		billingMiscellanous.setPatientStatus(invoicePatientStatus);
		billingMiscellanous.setPriorAuthorizationReferralLong(invoicePriorAuthorization1);
		billingMiscellanous.setPriorAuthorizationReferralShort(priorAuthorizationReferralShort);
		billingMiscellanous.setPreviousPDIOrClaimNumber(invoicePreviousPdi);
		billingMiscellanous.setAdmissionType(invoiceAdmissionType);
		billingMiscellanous.setAdmissionSource(invoiceAdmissionSource);
		billingMiscellanous.setAdmissionDate(invoiceAdmissionDate);
		billingMiscellanous.setAdmissionHour(invoiceAdmissionHour);
		billingMiscellanous.setTypeOfBillOrFrequency(pos);
		billingMiscellanous.setAccidentIndicator(invoiceAccidentIndicator);
		billingMiscellanous.setAccidentDate(invoiceAccidentDate);
		billingMiscellanous.setAssignmentOfBenefits(invoiceAssignmentOfBenefits);
		billingMiscellanous.setDischargeDateOrHour(invoiceDischargeDateHour);
		billingMiscellanous.setTotalClaimCharges(svcLineTotalClaimCharges);
		billingMiscellanous.setStatementFromToEWV2(invoiceStatementFromDate + " Thru " + invoiceStatementToDate);
		billingMiscellanous.setProviderAcceptsAssignment(invoiceProvAcceptsAssignmt);
		billingMiscellanous.setFrequency(invoiceFrequency);
		billingMiscellanous.setPoaNotesLong(poaNotesLong);
		billingMiscellanous.setPoaNotesShort(poaNotesShort);
		billingMiscellanous.setAdmittingDiagnosis(admittingDiagnosis);
		billingMiscellanous.setReasonForVisit(reasonForVisit);
		billingMiscellanous.setEeCode(eCode);
		billingMiscellanous.setUsePoaNotesModalPanel(usePoaNotesModelPanel);
		billingMiscellanous.setMedicareIcn("");
		billingMiscellanous.setAdmissionDateOrHour("01/01/17 15:00");
		billingMiscellanous.setRenderingPrvdName("");
		billingMiscellanous.setRenderingPrvdName(renderingPrvdName);
		billingMiscellanous.setRenderingPrvdNpi(renderingPrvdNpi);
		billingMiscellanous.setRenderingPrvdTaxonomyCode(renderingPrvdTaxonomyCode);
		billingMiscellanous.setDischargeDateOrHour(dischargeDateOrHour);
		billingMiscellanous.setReasonForVisit2_5010(reasonForVisit2_5010);
		billingMiscellanous.setReasonForVisit3_5010(reasonForVisit3_5010);
		billingMiscellanous.setReferralLong_5010(referralLong_5010);
		billingMiscellanous.setReferralShort_5010(referralShort_5010);
		
		String presentOnAdmissionNotesShort = null;
		String presentOnAdmissionNotesLong = null;
		boolean usePresentOnAdmissionModalPanel = false;

		String principalDiagnosisMasterCode = null;
		String principalDiagnosisPoa = null;
		String admittingDiagnosisMasterCode = null;
		String reasonForVisitMasterCode = null;
		String eCodeMasterCode = null;

		List<DiagnosisCode> diagnosisCodes = null;

		diagnosisCodesInfo = new DiagnosisCodesContainer(presentOnAdmissionNotesShort, presentOnAdmissionNotesLong,
				usePresentOnAdmissionModalPanel, principalDiagnosisMasterCode, principalDiagnosisPoa,
				admittingDiagnosisMasterCode, reasonForVisitMasterCode, eCodeMasterCode, diagnosisCodes);

		String principalProcedure = null;
		String dateOfPrincipalProcedure = null;

		// For Phase II, there is no need to use four columns
		List<ProcedureCode> procedureCodes = null;

		procedureCodesInfo = new ProcedureCodesContainer(principalProcedure, dateOfPrincipalProcedure, procedureCodes);

		List<HealthCareInformationLine> healthCareValueInformationBeanList = null;
		List<HealthCareInformationLine> healthCareConditionInformationBeanList = null;
		List<HealthCareInformationLine> healthCareOccurranceSpanInformationBeanList = null;
		List<HealthCareInformationLine> healthCareOccurranceInformationBeanList = null;
		List<HealthCareInformationLine> healthCareDRGInformationBeanList = null;

		healthCareInfo = new HealthCareInfoResponse();

		String beginDateOfService = "03/11/17";
		String endDateOfService = "03/11/17";
		String dateOfService = null; // Not sure this is used
		String revCode = null;
		String procedureCode = null;
		String ndcCode = null;
		String modifiers = null;
		String quantityOrType = null;
		// Ohi Stuff
		String primaryPayerPaidAmount = null;
		List<ServiceLineOhiAdjustment> primaryOhiServiceLineAdjustments = null;
		String secondaryPayerPaidAmount = null;
		List<ServiceLineOhiAdjustment> secondaryOhiServiceLineAdjustments = null;
		// Added quantity and type for Phase II, when they should be separate
		String quantity = null;
		String type = null;
		String serviceTax = null;
		String facilityTax = null;
		String charge = null;
		String lineNumber = null;
		List<DrugLine> listOfDrugLines = null;
		List<ToothLine> listOfTeeth = null;
		List<MedicalEquipmentLine> listOfEquipment = null;
		String dxDtPointers = null;
		String salesTax = null;
		List<Provider> listOfProviderInfo = null;
		// String pos;

		// 5010 Stuff
		AmbulanceInfo serviceLineLevelAmbulanceInfo = null;

		ServiceLine sl = new ServiceLine(dateOfService, beginDateOfService, endDateOfService, revCode, procedureCode,
				ndcCode, modifiers, quantityOrType, quantity, type, primaryPayerPaidAmount,
				primaryOhiServiceLineAdjustments, secondaryPayerPaidAmount, secondaryOhiServiceLineAdjustments,
				serviceTax, facilityTax, charge, lineNumber, listOfDrugLines, listOfTeeth, listOfEquipment,
				dxDtPointers, salesTax, listOfProviderInfo, pos, serviceLineLevelAmbulanceInfo);

		serviceLinesInfo = new ArrayList<>();
		serviceLinesInfo.add(sl);

		List<ClaimOhiContainer> claimOhiList = null;
	    List<QuickViewServiceLineOhiOutputRow> quickviewServiceLineOhiOutputRows = null;
	    List<DetailServiceLineOhiOutputRow> detailServiceLineOhiOutputRows = null;
	    ClaimOhi primaryOhi = null;
	    ClaimOhi secondaryOhi = null;
	    boolean isTertiaryOhi = false;
	    
	    boolean hasMultiplePrimaryPayers = false;
	    boolean hasMultipleSecondaryPayers = false;
	    boolean hasMultiplePayersWithSamePayerId = false;
	    boolean hasPayerIdProblem = false;
	    boolean hasMultipleAdjudicationsFromSamePayer = false;

		ohiInfo = new OhiInfoContainer(claimOhiList, primaryOhi, secondaryOhi, isTertiaryOhi,
				quickviewServiceLineOhiOutputRows, detailServiceLineOhiOutputRows, hasPayerIdProblem,
				hasMultiplePrimaryPayers, hasMultipleSecondaryPayers, hasMultiplePayersWithSamePayerId,
				hasMultipleAdjudicationsFromSamePayer);        
	    
		ECodesContainer e_CodesInfo = null;
		response = new EwvClaimDetailResponse(patientHeaderInfo, patientInfo,
			serviceLocationInfo, billingProviderInfo, billingMiscellanous,
			diagnosisCodesInfo, procedureCodesInfo, e_CodesInfo,
			healthCareInfo, serviceLinesInfo, ohiInfo); 
		
		BigDecimal ewvClaim_guid = new BigDecimal(guid);
		ewvClaim = new EwvClaims();
		ewvClaim.setBillingVendorName(billingVendorName);
		ewvClaim.setBillingVendorNpi(billingVendorNpi);
		ewvClaim.setBillingVendorAddressLine1(billingVendorAddressLine1);
		ewvClaim.setBillingVendorAddressLine2(billingVendorAddressLine2);
		ewvClaim.setBillingVendorCity(billingVendorCity);
		ewvClaim.setBillingVendorState(billingVendorState);
		ewvClaim.setBillingVendorPostalCode(billingVendorPostalCode);
		ewvClaim.setBillingVendorTaxIdNum(billingVendorTaxIdNum);
		
		ewvClaim.setClaimType(claimType.getValueOf());
		ewvClaim.setEdiClaimKey(ediClaimKey);
		ewvClaim.setGuid(ewvClaim_guid);
		ewvClaim.setInvoiceAccidentDate(invoiceAccidentDate);
		ewvClaim.setInvoiceAccidentIndicator(invoiceAccidentIndicator);
		ewvClaim.setInvoiceAdmissionDateHour(invoiceAdmissionDateHour);
		ewvClaim.setInvoiceAdmissionSource(invoiceAdmissionSource);
		ewvClaim.setInvoiceAdmissionType(invoiceAdmissionType);
		ewvClaim.setInvoiceAssignmentOfBenefits(invoiceAssignmentOfBenefits);
		ewvClaim.setInvoiceDischargeDateHour(invoiceDischargeDateHour);
		ewvClaim.setInvoiceFrequency(invoiceFrequency);
		ewvClaim.setInvoicePatientAccountNum(invoicePatientAccountNum);
		ewvClaim.setInvoicePatientPaidAmt(invoicePatientPaidAmt);
		ewvClaim.setInvoicePatientSignature(invoicePatientSignature);
		ewvClaim.setInvoicePatientStatus(invoicePatientStatus);
		ewvClaim.setInvoicePreviousPdi(invoicePreviousPdi);
		ewvClaim.setInvoicePriorAuthorization1(invoicePriorAuthorization1);
		ewvClaim.setInvoicePriorAuthorization2(invoicePriorAuthorization2);
		ewvClaim.setInvoiceProvAcceptsAssignmt(invoiceProvAcceptsAssignmt);
		ewvClaim.setInvoiceStatementFromDate(invoiceStatementFromDate);
		ewvClaim.setInvoiceStatementToDate(invoiceStatementToDate);
		ewvClaim.setInvoiceTypeOfBill(invoiceTypeOfBill);
		ewvClaim.setMedicareCrossover(medicareCrossover);
		ewvClaim.setMemberId(memberId);
		ewvClaim.setPcn(pcn);
		ewvClaim.setPdi(pdi);
		ewvClaim.setPos(pos);
		ewvClaim.setPatientAddressLine1(patientAddressLine1);
		ewvClaim.setPatientAddressLine2(patientAddressLine2);
		ewvClaim.setPatientCity(patientCity);
		ewvClaim.setPatientCountry(patientCountry);
		ewvClaim.setPatientDob(patientDob);
		ewvClaim.setPatientGender(patientGender);
		ewvClaim.setPatientIdNumber(patientIdNumber);
		ewvClaim.setPatientName(patientName);
		ewvClaim.setPatientState(patientState);
		ewvClaim.setPatientPostalCode(patientPostalCode);
		ewvClaim.setPatientState(patientState);
		
		ewvClaim.setServiceVendorName(serviceVendorName);
		ewvClaim.setServiceVendorNpi(serviceVendorNpi);
		ewvClaim.setServiceVendorAddressLine1(serviceVendorAddressLine1);
		ewvClaim.setServiceVendorAddressLine2(serviceVendorAddressLine2);
		ewvClaim.setServiceVendorCity(serviceVendorCity);
		ewvClaim.setServiceVendorState(serviceVendorState);
		ewvClaim.setServiceVendorPostalCode(serviceVendorPostalCode);
		ewvClaim.setServiceVendorTaxIdNum(serviceVendorTaxIdNum);
		ewvClaim.setSvcLineTotalClaimCharges(svcLineTotalClaimCharges);	
		ewvClaim.setHccodesAdmittingDiagnosis(hccodesAdmittingDiagnosis);
		ewvClaim.setHccodesReasonForVists(hccodesReasonForVists);
		ewvClaim.setHccodesECode(hccodesECode);
		ewvClaim.setHccodesPoaNotes(hccodesPoaNotes);   
	}
	
	@Test
	public void getReports_getEwvClaim_Success() throws GenericException, NonUniqueRecordsException {
		ClaimType claimType = ClaimType.typeOf(ewvClaim.getClaimType());
		when(ewvClaimRepository.getEwvClaimByPdiNumber(pdi)).thenReturn(ewvClaim);
		when(ewvPatientAndVendorInfoService.populatePatientHeaderInfo(ewvClaim)).thenReturn(patientHeaderInfo);
        when(ewvPatientAndVendorInfoService.populatePatientInfo(ewvClaim)).thenReturn(patientInfo);
        when(ewvPatientAndVendorInfoService.populateServiceLocationInfo(ewvClaim)).thenReturn(serviceLocationInfo);
        when(ewvPatientAndVendorInfoService.populateBillingProviderInfo(ewvClaim)).thenReturn(billingProviderInfo);
        when(ewvBillingMiscInfoService.populateBillingAndAdmissionInfo(claimType, ewvClaim)).thenReturn(billingMiscellanous);
        when(ewvDiagnosisCodesInfoService.populateDiagnosisCodes(ewvClaim)).thenReturn(diagnosisCodesInfo);
        when(ewvProcedureCodesInfoService.populateProcedureCodesContainer(ewvClaim)).thenReturn(procedureCodesInfo);
        when(ewvHealthCareInfoService.populateHealthCareInfoResponse(ewvClaim)).thenReturn(healthCareInfo);
        when(ewvAmbulanceAndServiceLinesInfoService.populateServiceLines(ewvClaim)).thenReturn(serviceLinesInfo);
        when(ewvOhiService.getOhiData(ewvClaim)).thenReturn(ohiInfo);
		
        try {
			EwvClaimDetailResponse resultSet = new EwvClaimDetailResponse();
			resultSet.setPatientHeaderInfo(ewvPatientAndVendorInfoService.populatePatientHeaderInfo(ewvClaim));
			resultSet.setPatientInfo(ewvPatientAndVendorInfoService.populatePatientInfo(ewvClaim));
			resultSet.setServiceLocationInfo(ewvPatientAndVendorInfoService.populateServiceLocationInfo(ewvClaim));
			resultSet.setBillingProviderInfo(ewvPatientAndVendorInfoService.populateBillingProviderInfo(ewvClaim));
			resultSet.setBillingMiscellanous(ewvBillingMiscInfoService.populateBillingAndAdmissionInfo(claimType, ewvClaim));
			resultSet.setDiagnosisCodesInfo(ewvDiagnosisCodesInfoService.populateDiagnosisCodes(ewvClaim));
			resultSet.setProcedureCodesInfo(ewvProcedureCodesInfoService.populateProcedureCodesContainer(ewvClaim));	    	
			resultSet.setHealthCareInfo(ewvHealthCareInfoService.populateHealthCareInfoResponse(ewvClaim));   			    
			resultSet.setServiceLinesInfo(ewvAmbulanceAndServiceLinesInfoService.populateServiceLines(ewvClaim));   			    
			resultSet.setOhiInfo(ewvOhiService.getOhiData(ewvClaim));
			
			// System.out.println("response - " + response.getPatientHeaderInfo().toString());
			// System.out.println("resultSet - " + resultSet.getPatientHeaderInfo().toString());
			assertEquals(resultSet.getPatientHeaderInfo().toString(), patientHeaderInfo.toString());

			// System.out.println("response - " + response.getPatientInfo().toString());
			// System.out.println("resultSet - " + resultSet.getPatientInfo().toString());
			assertEquals(resultSet.getPatientInfo().toString(), patientInfo.toString());

			// System.out.println("response - " + response.getServiceLocationInfo().toString());
			// System.out.println("resultSet - " + resultSet.getServiceLocationInfo().toString());
			assertEquals(resultSet.getServiceLocationInfo().toString(), serviceLocationInfo.toString());

			// System.out.println("response - " + response.getBillingProviderInfo().toString());
			// System.out.println("resultSet - " + resultSet.getBillingProviderInfo().toString());
			assertEquals(resultSet.getBillingProviderInfo().toString(), billingProviderInfo.toString());

			System.out.println("response - " + response.getBillingMiscellanous().toString());
			System.out.println("resultSet     - " + resultSet.getBillingMiscellanous().toString());
			// assertEquals(resultSet.getBillingMiscellanous().toString(), this.ewvBillingMiscInfoService.toString());
			System.out.println("response - " + response.getDiagnosisCodesInfo().toString());
			System.out.println("resultSet     - " + resultSet.getDiagnosisCodesInfo().toString());
			
			System.out.println("response - " + response.getProcedureCodesInfo().toString());
			System.out.println("resultSet     - " + resultSet.getProcedureCodesInfo().toString());
			
			System.out.println("response - " + response.getProcedureCodesInfo().toString());
			System.out.println("resultSet     - " + resultSet.getProcedureCodesInfo().toString());
			
			System.out.println("response - " + response.getServiceLinesInfo().toString());
			System.out.println("resultSet     - " + resultSet.getServiceLinesInfo().toString());
			
			System.out.println("response - " + response.getOhiInfo().toString());
			System.out.println("resultSet     - " + resultSet.getOhiInfo().toString());

		} catch (Exception e) {
			throw e;
		}
	}
}
*/