/*package gov.va.med.ewv.controller;

import static org.hamcrest.Matchers.is;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;


import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import gov.va.med.ewv.util.ClaimFormat;
import gov.va.med.ewv.util.ClaimType;
import gov.va.med.ars.filter.CORSFilter;
import gov.va.med.ewv.controller.EwvClaimController;
import gov.va.med.ewv.model.response.BillingAndAdmissionInfo;
import gov.va.med.ewv.model.response.EwvClaimDetailResponse;
import gov.va.med.ewv.model.response.PatientHeaderInfo;
import gov.va.med.ewv.model.response.PatientInfo;
import gov.va.med.ewv.model.response.VendorInfo;
import gov.va.med.ewv.service.IEwvClaimService;



@RunWith(MockitoJUnitRunner.class)
public class EwvClaimControllerTest {

	private MockMvc mockMvc;
	
	@Mock
	private IEwvClaimService ewvClaimService;
		
	@InjectMocks
	private EwvClaimController ewvClaimController;
	
	EwvClaimDetailResponse response;		
	String pdi = "201736500000002";	
	
	
	@Before
	public void init() throws Exception {
		mockMvc = MockMvcBuilders.standaloneSetup(ewvClaimController).addFilters(new CORSFilter()).build();
		
		Long guid = 3L;		
		String ediClaimKey = "681A4FD0-CE88-7F6C-E053-4A10BF0A3038";
		ClaimType claimType = ClaimType.DENTAL;
		String memberId = "666666661";
		String pcn = "A1234567890123456";
		String medicareCrossover = "Y";
		String pos = "21";

		 Patient info 
		String pcnShort = "A123456789...";
		String patientName = "RODGERS-CROMARTIE, DOMINIQUE";
		String patientIdNumber = "1234567890";
		String patientDob = "01/01/1935";
		String patientGender = "M";
		String patientAddressLine1 = "1122 Maple Street";
		String patientAddressLine2 = "Apt. B";
		String patientCity = "NEW YORK";
		String patientState = "NY";
		String patientPostalCode = "12345";
		String patientCountry = "USA";
		
		PatientHeaderInfo patientHeaderInfo = new PatientHeaderInfo(ClaimFormat.NONE, claimType, medicareCrossover, patientName,
				"billingNPI", memberId, "tin123", pdi, pcn, pcnShort, Boolean.FALSE);
		
		PatientInfo patientInfo = new PatientInfo(patientName, patientIdNumber, patientDob, "", patientGender, patientAddressLine1,
				patientAddressLine2, patientCity, patientState, patientPostalCode, patientCountry);
		
		 Vendor info 
		String serviceVendorName = "GENERAL DIAGNOSTIC HOSPITAL";
		String serviceVendorTaxIdNum = "1234567890";
		String serviceVendorNpi = "1234567890";;
		String serviceVendorAddressLine1 = "2000 SOUTH US HIGHWAY 1";
		String serviceVendorAddressLine2 = "SUITE 100";
		String serviceVendorCity = "NEW YORK";
		String serviceVendorState = "NY";
		String serviceVendorPostalCode = "12345";
		VendorInfo serviceLocationInfo = new VendorInfo(serviceVendorName, serviceVendorTaxIdNum, serviceVendorNpi, "billingVendorTaxonomyCode", 
				serviceVendorAddressLine1, serviceVendorAddressLine2, serviceVendorCity, serviceVendorState, serviceVendorPostalCode, "USA");
		
		String billingVendorName = "GENERAL MEMORIAL HOSPITAL";
		String billingVendorTaxIdNum = "1234567890";
		String billingVendorNpi = "1234567890";;
		String billingVendorAddressLine1 = "1212 SOUTH US HIGHWAY 1";;
		String billingVendorAddressLine2 = null;
		String billingVendorCity = "NEW YORK";;
		String billingVendorState = "NY";
		String billingVendorPostalCode = "12345";
		
		VendorInfo billingProviderInfo = new VendorInfo(billingVendorName, billingVendorTaxIdNum, billingVendorNpi, "billingVendorTaxonomyCode", 
				billingVendorAddressLine1, billingVendorAddressLine2, billingVendorCity, billingVendorState, billingVendorPostalCode, "USA");
		
		 Billing info 
		String invoicePatientAccountNum= "1721590-2";
		String invoiceTypeOfBill= "21";
		String invoiceFrequency= "1";
		String invoiceStatementFromDate= "01/01/2017";
		String invoiceStatementToDate= "02/01/2017";
		String invoicePreviousPdi= "1234567890123";
		String invoicePatientPaidAmt= "999.99";
		String invoicePatientSignature= "B";
		String invoicePatientStatus= "UNK";
		String invoicePriorAuthorization1= "12345678901234567890";
		String invoicePriorAuthorization2= "";
		String invoiceAdmissionType= "UNK";
		String invoiceAdmissionSource= "UNK";
		String invoiceAdmissionDate = "01/01/2017";
		String invoiceAdmissionHour = "15:00";
		String invoiceAccidentDate= "01/01/2017";
		String invoiceAccidentIndicator= "123456";
		String invoiceProvAcceptsAssignmt= "A"; //which field?
		String invoiceAssignmentOfBenefits= "Y";
		String invoiceDischargeDateHour= "02/01/2017 15:00";
		
		BillingAndAdmissionInfo billingMiscellanous = new BillingAndAdmissionInfo();
		billingMiscellanous.setStatementFromTo(invoiceStatementFromDate + "" + invoiceStatementToDate);
		billingMiscellanous.setPatientPaidAmount(invoicePatientPaidAmt);
		billingMiscellanous.setPatientSignature(invoicePatientSignature);
		billingMiscellanous.setPatientStatus(invoicePatientStatus);
		billingMiscellanous.setPriorAuthorizationReferralLong(invoicePriorAuthorization1);
		billingMiscellanous.setPriorAuthorizationReferralShort(invoicePriorAuthorization2);
		billingMiscellanous.setPreviousPDIOrClaimNumber(invoicePreviousPdi);
		billingMiscellanous.setAdmissionType(invoiceAdmissionType);
		billingMiscellanous.setAdmissionSource(invoiceAdmissionSource);
		billingMiscellanous.setAdmissionDate(invoiceAdmissionDate);
		billingMiscellanous.setAdmissionHour(invoiceAdmissionHour);
		billingMiscellanous.setTypeOfBillOrFrequency(invoiceFrequency);
		billingMiscellanous.setAccidentIndicator(invoiceAccidentIndicator);
		billingMiscellanous.setAccidentDate(invoiceAccidentDate);
		billingMiscellanous.setAssignmentOfBenefits(invoiceAssignmentOfBenefits);
		billingMiscellanous.setDischargeDateOrHour(invoiceDischargeDateHour);
		
		response = new EwvClaimDetailResponse(patientHeaderInfo, patientInfo,
				serviceLocationInfo, billingProviderInfo,
				billingMiscellanous);
	}
	
	@Test
	public void getDetail_success() throws Exception {
		
		when(ewvClaimService.getEwvClaim(pdi)).thenReturn(response);
				
		mockMvc.perform(get("/api/v1/ewvClaim/{pdiNumber}", pdi)).andDo(print()).andExpect(status().isOk())
				.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE))
				.andExpect(jsonPath("$.patientHeaderInfo.claimFormat", is("NONE")))
				.andExpect(jsonPath("$.patientHeaderInfo.claimType", is("DENTAL")))
				.andExpect(jsonPath("$.patientHeaderInfo.medicareCrossOver", is("Y")))
				.andExpect(jsonPath("$.patientHeaderInfo.patientName", is("RODGERS-CROMARTIE, DOMINIQUE")))
				.andExpect(jsonPath("$.patientHeaderInfo.billingNPI", is("billingNPI")))
				.andExpect(jsonPath("$.patientHeaderInfo.memberID", is("666666661")))
				.andExpect(jsonPath("$.patientHeaderInfo.tin", is("tin123")))
				.andExpect(jsonPath("$.patientHeaderInfo.pdi", is("2017 365 00 000002")))
				.andExpect(jsonPath("$.patientHeaderInfo.pcn", is("A1234567890123456")))
				.andExpect(jsonPath("$.patientHeaderInfo.pcnShort", is("A123456789...")))
				.andExpect(jsonPath("$.patientHeaderInfo.usePcnModalPanel", is(Boolean.FALSE)));
		
		verify(ewvClaimService, times(1)).getEwvClaim(pdi);
	}
}
*/