package gov.va.med.ars.service.impl;

import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.ars.configuration.AppConfig;
import gov.va.med.ars.configuration.spring.SpringMvcConfig;
import gov.va.med.ars.constants.ErrorMessages;
import gov.va.med.ars.dao.ars.IArsRole;
import gov.va.med.ars.dao.ars.IArsUserRepository;
import gov.va.med.ars.dao.ars.IArsUserRoleUsages;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.filter.CORSFilter;
import gov.va.med.ars.model.request.UserSearchRequest;
import gov.va.med.ars.model.response.GenericResponse;
import gov.va.med.ars.model.response.SearchClaimAttachments275Response;
import gov.va.med.ars.model.response.UserDetailsResponse;
import gov.va.med.ars.service.impl.UserAdministrationServiceImpl;
import gov.va.med.domain.ars.ArsRole;
import gov.va.med.domain.ars.ArsUser;
import gov.va.med.domain.ars.ArsUserRoleUsages;
import gov.va.med.domain.ars.ArsUserRoleUsagesId;
import gov.va.med.domain.ars.ClaimattachmentsView;

import static org.mockito.Mockito.when;
import static org.mockito.Mockito.doNothing;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.*;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoMoreInteractions;

@RunWith(MockitoJUnitRunner.class)
public class UserAdministrationRestServiceImplTest {
	private static final Logger logger = LogManager.getLogger(UserAdministrationRestServiceImplTest.class);
	private MockMvc mockMvc;
	public static final MediaType APPLICATION_JSON_UTF8 = new MediaType(MediaType.APPLICATION_JSON.getType(),
			MediaType.APPLICATION_JSON.getSubtype(), Charset.forName("utf8"));

	@Mock
	IArsUserRepository arsUserRepository;

	@Mock
	IArsRole arsRoleRepository;

	@Mock
	IArsUserRoleUsages arsUserRoleUsagesRepository;

	@InjectMocks
	private UserAdministrationServiceImpl userAdministrationServiceImpl;

	@Test
	public void testMockIsWorking() {
		assertNotNull("UserAdministrationServiceImpl Injection Failed", userAdministrationServiceImpl);
		logger.info("userAdministrationServiceImpl" + userAdministrationServiceImpl);
	}

	@Test
	public void testgetAllUserDetailsSuccess() throws Exception {
		UserSearchRequest userSearchRequest = new UserSearchRequest();
		userSearchRequest.setAdmin("");
		userSearchRequest.setCreatedBy("");
		userSearchRequest.setDescending(false);
		userSearchRequest.setDomain("");
		userSearchRequest.setEdit("");
		userSearchRequest.setEmail("");
		userSearchRequest.setExport("");
		userSearchRequest.setFirstName("");
		userSearchRequest.setLastName("");
		userSearchRequest.setPageNumber(1);
		userSearchRequest.setPageSize(10);
		userSearchRequest.setPhone("");
		userSearchRequest.setSortColumn("admin");
		userSearchRequest.setStatus("");
		userSearchRequest.setUserName("PII");

		Set<ArsUserRoleUsages> hashSet = new HashSet<>();

		DateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
		List<ArsUser> listuserDetails = new ArrayList<>();
		ArsUser arsUser = new ArsUser();

		arsUser.setArsUserId(100);
		arsUser.setUserName("PII");
		arsUser.setEnabled("y");
		arsUser.setLastName("user");
		arsUser.setFirstName("Base");
		arsUser.setMiddleName("NM");
		arsUser.setPhoneNumber("");
		arsUser.setEmailAddress("PII                 ");
		arsUser.setLastLoginDate(dateFormat.parse("08112016"));
		arsUser.setArsUserRoleUsageses(hashSet);
		arsUser.setCreatedBy("ARS_ADMIN");
		arsUser.setDateCreated(dateFormat.parse("08112016"));
		arsUser.setDateModified(dateFormat.parse("08112016"));
		arsUser.setDeactivationComments("");
		arsUser.setDeactivationReasonCd((long) 1);
		arsUser.setDomain("Base");
		arsUser.setEnableExport(true);
		arsUser.setEnableEdit(true);
		arsUser.setEnableAdmin(true);

		listuserDetails.add(arsUser);

		Page<ArsUser> pagedResponse = new PageImpl<ArsUser>(listuserDetails);

		when(arsUserRepository.count(any(Specification.class))).thenReturn((long) 1);

		when(arsUserRepository.findAll(any(Specification.class), any(PageRequest.class))).thenReturn(pagedResponse);

		GenericResponse repositoryResponse = userAdministrationServiceImpl.getAllUserDetails(userSearchRequest);

		verify(arsUserRepository, times(1)).count(any(Specification.class));
		verify(arsUserRepository, times(1)).findAll(any(Specification.class), any(PageRequest.class));
		verifyNoMoreInteractions(arsUserRepository);

		List<UserDetailsResponse> resultResponseList = (List<UserDetailsResponse>) repositoryResponse.getResponse();
		assertEquals(10, repositoryResponse.getpageSize());
		assertEquals(new Long(1), repositoryResponse.gettotalNumberOfResults());
		assertEquals(10, repositoryResponse.getpageSize());
		assertEquals("PII", resultResponseList.get(0).getUserName());
		assertEquals("Yes", resultResponseList.get(0).getAdmin());
		assertEquals("Yes", resultResponseList.get(0).getEdit());
		assertEquals("Yes", resultResponseList.get(0).getExport());
		assertEquals("Active", resultResponseList.get(0).getStatus());
		assertEquals("Base", resultResponseList.get(0).getDomain());

	}

	@Test
	public void testgetUserByIdSuccess() throws Exception {
		String userId = "PII";

		Set<ArsUserRoleUsages> hashSet = new HashSet<>();

		DateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");

		List<ArsUser> listuserDetails = new ArrayList<>();
		ArsUser arsUser = new ArsUser();

		arsUser.setArsUserId(100);
		arsUser.setUserName("PII");
		arsUser.setEnabled("y");
		arsUser.setLastName("user");
		arsUser.setFirstName("Base");
		arsUser.setMiddleName("NM");
		arsUser.setPhoneNumber("");
		arsUser.setEmailAddress("PII                 ");
		arsUser.setLastLoginDate(dateFormat.parse("08112016"));
		arsUser.setArsUserRoleUsageses(hashSet);
		arsUser.setCreatedBy("PII");
		arsUser.setDateCreated(dateFormat.parse("08112016"));
		arsUser.setDateModified(dateFormat.parse("08112016"));
		arsUser.setDeactivationComments("");
		arsUser.setDeactivationReasonCd((long) 1);
		arsUser.setDomain("Base");
		arsUser.setEnableExport(true);
		arsUser.setEnableEdit(true);
		arsUser.setEnableAdmin(true);

		listuserDetails.add(arsUser);

		when(arsUserRepository.findByUserNameIgnoreCase(userId)).thenReturn(arsUser);
		
		UserDetailsResponse userById = userAdministrationServiceImpl.getUserById(userId);
		verify(arsUserRepository, times(1)).findByUserNameIgnoreCase(userId);
		
		verifyNoMoreInteractions(arsUserRepository);

		assertEquals("PII", userById.getUserName());
		assertEquals("Yes", userById.getAdmin());
		assertEquals("Yes", userById.getEdit());
		assertEquals("Yes", userById.getExport());
		assertEquals("Active", userById.getStatus());
		assertEquals("Base", userById.getDomain());

	}
	//Testing edit when enable admin is set to true

	@Test
	public void testeditUserByUserNameOnAdminSuccess() throws Exception {
		UserSearchRequest userSearchRequest = new UserSearchRequest();
		userSearchRequest.setAdmin("true");
		userSearchRequest.setCreatedBy("");
		userSearchRequest.setDescending(false);
		userSearchRequest.setDomain("notbase");
		userSearchRequest.setEdit("");
		userSearchRequest.setEmail("");
		userSearchRequest.setExport("");
		userSearchRequest.setFirstName("");
		userSearchRequest.setLastName("");
		userSearchRequest.setPageNumber(1);
		userSearchRequest.setPageSize(10);
		userSearchRequest.setPhone("");
		userSearchRequest.setSortColumn("");
		userSearchRequest.setStatus("");
		userSearchRequest.setUserName("PII");
		userSearchRequest.setExport("y");
		userSearchRequest.setEdit("y");
		userSearchRequest.setAdmin("y");
		userSearchRequest.setModifiedBy("user");
		userSearchRequest.setStatus("ACTIVE");
		userSearchRequest.setUserId((long) 100);

		Set<ArsUserRoleUsages> hashSet = new HashSet<>();

		DateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");

		ArsUser updatedarsUser = new ArsUser();

		updatedarsUser.setArsUserId(100);
		updatedarsUser.setUserName("PII");
		updatedarsUser.setEnabled("ACTIVE");
		updatedarsUser.setLastName("");
		updatedarsUser.setFirstName("");
		updatedarsUser.setMiddleName("NM");
		updatedarsUser.setPhoneNumber("");
		updatedarsUser.setEmailAddress("");
		updatedarsUser.setLastLoginDate(dateFormat.parse("08112016"));
		updatedarsUser.setDeactivationReasonCd((long) 1);
		updatedarsUser.setDeactivationComments("");
		updatedarsUser.setCreatedBy("ARS_ADMIN");
		updatedarsUser.setDateCreated(dateFormat.parse("08112016"));
		updatedarsUser.setModifiedBy("user");
		updatedarsUser.setDateModified(new Date());
		updatedarsUser.setEnableExport(true);
		updatedarsUser.setEnableEdit(true);
		updatedarsUser.setEnableAdmin(true);
		updatedarsUser.setDomain("notbase");

		updatedarsUser.setArsUserRoleUsageses(hashSet);

		ArsRole arsRole = new ArsRole();
		arsRole.setRoleName("ADMIN");
		arsRole.setArsRoleId(100);
		// arsRole.setArsRolePermissionsUsageses(arsRolePermissionsUsageses);
		// arsRole.setArsUserRoleUsageses(userrolemapping);
		arsRole.setCreatedBy("user");
		arsRole.setDateCreated(dateFormat.parse("08112016"));
		arsRole.setDescription("description");

		ArsUserRoleUsagesId arsUserRoleUsagesId = new ArsUserRoleUsagesId();
		arsUserRoleUsagesId.setArsRoleId((long) 100);
		arsUserRoleUsagesId.setArsUserId((long) 100);

		ArsUserRoleUsages userrolemapping = new ArsUserRoleUsages();
		userrolemapping.setId(arsUserRoleUsagesId);
		userrolemapping.setArsUser(updatedarsUser);
		userrolemapping.setArsRole(arsRole);
		userrolemapping.setCreatedBy("Admin");
		userrolemapping.setDateCreated(new Date());
		when(arsUserRepository.findByArsUserId((long) 100)).thenReturn(updatedarsUser);

		when(arsUserRepository.save(updatedarsUser)).thenReturn(updatedarsUser);
//		 doNothing().when(arsUserRepository).updateUserByUserName(userSearchRequest.getUserName().toUpperCase(),
//		 userSearchRequest.getDomain(), true, true, true);

		when(arsRoleRepository.findByRoleNameIgnoreCase("ADMIN")).thenReturn(arsRole);

		when(arsUserRoleUsagesRepository.save(userrolemapping)).thenReturn(userrolemapping);
		 arsUserRoleUsagesRepository.save(userrolemapping);

	boolean editUserByUserName = userAdministrationServiceImpl.editUserByUserName(userSearchRequest);

		verify(arsUserRepository, times(1)).findByArsUserId(userSearchRequest.getUserId());
		verify(arsUserRepository, times(1)).save(any(ArsUser.class));
		verify(arsRoleRepository, times(1)).findByRoleNameIgnoreCase("ADMIN");
		
		verify(arsUserRoleUsagesRepository, times(2)).save(any(ArsUserRoleUsages.class));
		verifyNoMoreInteractions(arsUserRepository);
		verifyNoMoreInteractions(arsRoleRepository);
		verifyNoMoreInteractions(arsUserRoleUsagesRepository);
		assertTrue(editUserByUserName);


	}

	
	//edit when enable admin is set to false
	@Test
	public void testeditUserByUserName_Success() throws Exception {
		UserSearchRequest userSearchRequest = new UserSearchRequest();
		userSearchRequest.setAdmin("true");
		userSearchRequest.setCreatedBy("");
		userSearchRequest.setDescending(false);
		userSearchRequest.setDomain("notbase");
		userSearchRequest.setEdit("");
		userSearchRequest.setEmail("");
		userSearchRequest.setExport("");
		userSearchRequest.setFirstName("");
		userSearchRequest.setLastName("");
		userSearchRequest.setPageNumber(1);
		userSearchRequest.setPageSize(10);
		userSearchRequest.setPhone("");
		userSearchRequest.setSortColumn("");
		userSearchRequest.setStatus("");
		userSearchRequest.setUserName("PII");
		userSearchRequest.setExport("y");
		userSearchRequest.setEdit("y");
		userSearchRequest.setAdmin("n");
		userSearchRequest.setModifiedBy("user");
		userSearchRequest.setStatus("ACTIVE");
		userSearchRequest.setUserId((long) 100);

		Set<ArsUserRoleUsages> hashSet = new HashSet<>();

		DateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");

		ArsUser updatedarsUser = new ArsUser();

		updatedarsUser.setArsUserId(100);
		updatedarsUser.setUserName("PII");
		updatedarsUser.setEnabled("ACTIVE");
		updatedarsUser.setLastName("");
		updatedarsUser.setFirstName("");
		updatedarsUser.setMiddleName("NM");
		updatedarsUser.setPhoneNumber("");
		updatedarsUser.setEmailAddress("");
		updatedarsUser.setLastLoginDate(dateFormat.parse("08112016"));
		updatedarsUser.setDeactivationReasonCd((long) 1);
		updatedarsUser.setDeactivationComments("");
		updatedarsUser.setCreatedBy("ARS_ADMIN");
		updatedarsUser.setDateCreated(dateFormat.parse("08112016"));
		updatedarsUser.setModifiedBy("user");
		updatedarsUser.setDateModified(new Date());
		updatedarsUser.setEnableExport(true);
		updatedarsUser.setEnableEdit(true);
	    updatedarsUser.setEnableAdmin(false);
		updatedarsUser.setDomain("notbase");
		updatedarsUser.setArsUserRoleUsageses(hashSet);

		ArsRole arsRole = new ArsRole();
		arsRole.setRoleName("ADMIN");
		arsRole.setArsRoleId(100);
		// arsRole.setArsRolePermissionsUsageses(arsRolePermissionsUsageses);
		// arsRole.setArsUserRoleUsageses(userrolemapping);
		arsRole.setCreatedBy("user");
		arsRole.setDateCreated(dateFormat.parse("08112016"));
		arsRole.setDescription("description");

		ArsUserRoleUsagesId arsUserRoleUsagesId = new ArsUserRoleUsagesId();
		arsUserRoleUsagesId.setArsRoleId((long) 100);
		arsUserRoleUsagesId.setArsUserId((long) 100);

		ArsUserRoleUsages userrolemapping = new ArsUserRoleUsages();
		userrolemapping.setId(arsUserRoleUsagesId);
		userrolemapping.setArsUser(updatedarsUser);
		userrolemapping.setArsRole(arsRole);
		userrolemapping.setCreatedBy("Admin");
		userrolemapping.setDateCreated(new Date());
		when(arsUserRepository.findByArsUserId((long) 100)).thenReturn(updatedarsUser);
		when(arsUserRepository.save(updatedarsUser)).thenReturn(updatedarsUser);
		// doNothing().when(arsUserRepository).updateUserByUserName(userSearchRequest.getUserName().toUpperCase(),
		// userSearchRequest.getDomain(), true, true, true);

		when(arsRoleRepository.findByRoleNameIgnoreCase("ADMIN")).thenReturn(arsRole);

		 doNothing().when(arsUserRoleUsagesRepository).delete(userrolemapping);
		 arsUserRoleUsagesRepository.delete(userrolemapping);

		boolean editUserByUserName = userAdministrationServiceImpl.editUserByUserName(userSearchRequest);

		verify(arsUserRepository, times(1)).findByArsUserId(userSearchRequest.getUserId());
		//verify(arsUserRepository, times(1)).save(Matchers.refEq(updatedarsUser));
		verify(arsUserRepository, times(1)).save(any(ArsUser.class));
		verify(arsRoleRepository, times(1)).findByRoleNameIgnoreCase("ADMIN");

		verify(arsUserRoleUsagesRepository, times(1)).delete(userrolemapping);
		verifyNoMoreInteractions(arsUserRepository);
		verifyNoMoreInteractions(arsRoleRepository);
	   // verifyNoMoreInteractions(arsUserRoleUsagesRepository);
       assertTrue(editUserByUserName);
	}

	@Test
	public void testdeleteUserByUserName_Success() throws Exception {
		Long userId = (long) 100;

		Set<ArsUserRoleUsages> hashSet = new HashSet<>();

		DateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
		Date date = new Date();

		List<ArsUser> listuserDetails = new ArrayList<>();
		ArsUser arsUser = new ArsUser();

		arsUser.setArsUserId(100);
		arsUser.setUserName("PII");
		arsUser.setEnabled("y");
		arsUser.setLastName("user");
		arsUser.setFirstName("Base");
		arsUser.setMiddleName("NM");
		arsUser.setPhoneNumber("");
		arsUser.setEmailAddress("PII                 ");
		arsUser.setLastLoginDate(dateFormat.parse("08112016"));

		arsUser.setArsUserRoleUsageses(hashSet);
		arsUser.setCreatedBy("PII");

		arsUser.setDateCreated(dateFormat.parse("08112016"));

		arsUser.setDateModified(dateFormat.parse("08112016"));

		arsUser.setDeactivationComments("");
		arsUser.setDeactivationReasonCd((long) 1);
		arsUser.setDomain("Base");
		arsUser.setEnableExport(true);
		arsUser.setEnableEdit(true);
		arsUser.setEnableAdmin(true);

		listuserDetails.add(arsUser);

		when(arsUserRepository.findByArsUserId(userId)).thenReturn(arsUser);
		Mockito.doNothing().when(arsUserRepository).delete(arsUser);

		boolean deleteUserByUserName = userAdministrationServiceImpl.deleteUserByUserName(userId);
		verify(arsUserRepository, times(1)).findByArsUserId(userId);
		verify(arsUserRepository, times(1)).delete(arsUser);
		verifyNoMoreInteractions(arsUserRepository);

		assertTrue(deleteUserByUserName);

	}

}
