package gov.va.med.ars.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.domain.Specification;
import gov.va.med.ars.dao.ars.IClaimAttachmentsViewRepository;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.request.SearchClaimAttachments275Request;
import gov.va.med.ars.model.response.GenericResponse;
import gov.va.med.ars.model.response.SearchClaimAttachments275Response;
import gov.va.med.domain.ars.ClaimattachmentsView;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

@RunWith(MockitoJUnitRunner.class)
public class SearchClaimAttachments275ServiceImplTest {
	private static final Logger logger = LogManager.getLogger(SearchClaimAttachments275ServiceImplTest.class);
	
	
	@InjectMocks
	SearchClaimAttachments275ServiceImpl searchClaimAttachments275Service;
	
	@Mock
	IClaimAttachmentsViewRepository iClaimAttachmentsViewRepository;

	
	@Test
	public void testMockIsWorking() {
		assertNotNull("SearchClaimAttachments275Service Injection Failed", searchClaimAttachments275Service);
	}
	
	@SuppressWarnings("unchecked")
	@Test 
	public void getAll275SearchResult_Test_Success() throws GenericException{
		SearchClaimAttachments275Request request=new SearchClaimAttachments275Request();
		request.setAttachId("101");
		request.setAttachCtrNumber("");
		request.setClaimId("");
		request.setStatus("");
		request.setPatientLastName("");
		request.setPatientFirstName("");
		request.setPatientCtrNumber("");
		request.setPatientIdentifier("");
		request.setProviderName("");
		request.setProviderNpi("");
		request.setMedicalRecordNumber("");
		request.setPayerControlNumber("");
		request.setReportTypeCode("");
		request.setClaimServiceEndDate("");
		request.setClaimServiceEndDate("");
		request.setPageSize(10);
		request.setSortColumn("");
		request.setDescending(false);
		request.setPageNumber(1);
		
		
		List<ClaimattachmentsView> attachmentsList = new ArrayList<ClaimattachmentsView>();
		ClaimattachmentsView record=new ClaimattachmentsView();
		record.setAttachmentId(101);
		record.setAttachmentControlNumber("678987");
		record.setClaimIdentifier("100000");
		record.setExternalClaimId("11111");
		record.setStatus("Active");
		record.setPatientFirstName("Koti, Divya");
		record.setPatientControlNumber("252525");
		record.setPatientIdentifierNumber("34567");
		record.setProviderName("Mohite");
		record.setProviderNpi("678947");
		record.setMedicalRecordNumber("123456789");
		record.setPayerClaimControlNumber("202154");
		record.setReportCode("09");
		record.setAttachmentType("PDF");
		record.setClaimServiceStartDate("20161108");
		record.setClaimServiceEndDate("20161108");
		record.setAttachmentPath("");		
		attachmentsList.add(record);
		
		
		Page<ClaimattachmentsView> pagedResponse = new PageImpl<ClaimattachmentsView>(attachmentsList);
				
		when(iClaimAttachmentsViewRepository.count(any(Specification.class))).thenReturn((long)1);
		when(iClaimAttachmentsViewRepository.findAll(any(Specification.class),any(PageRequest.class))).thenReturn(pagedResponse);
	
		
		GenericResponse repositoryResponse=searchClaimAttachments275Service.getAll275SearchResult(request);
		
		verify(iClaimAttachmentsViewRepository, times(1)).count(any(Specification.class));
		verify(iClaimAttachmentsViewRepository, times(1)).findAll(any(Specification.class),any(PageRequest.class));
		
		List<SearchClaimAttachments275Response> resultResponseList = (List<SearchClaimAttachments275Response>) repositoryResponse.getResponse();
		assertEquals(10,repositoryResponse.getpageSize());
		assertEquals(new Long(1), repositoryResponse.gettotalNumberOfResults());
		assertEquals(10,repositoryResponse.getpageSize());		
		assertEquals(101, resultResponseList.get(0).getAttachId());
		assertEquals("678987",resultResponseList.get(0).getAttachCtrNumber());
		assertEquals("11111",resultResponseList.get(0).getClaimIdentifier());
		assertEquals("11111",resultResponseList.get(0).getExternalClaimId());
		assertEquals("Active",resultResponseList.get(0).getStatus());
		assertEquals("252525",resultResponseList.get(0).getPatientCtrNumber());
		assertEquals("34567",resultResponseList.get(0).getPatientIdentifier());
		assertEquals("Mohite",resultResponseList.get(0).getProviderName());
		assertEquals("678947",resultResponseList.get(0).getProviderNpi());
		assertEquals("123456789",resultResponseList.get(0).getMedicalRecordNumber());
		assertEquals("09",resultResponseList.get(0).getReportTypeCode());
		assertEquals("PDF",resultResponseList.get(0).getAttachType());
		assertEquals("11/08/2016",resultResponseList.get(0).getClaimServiceStartDate());
		assertEquals("11/08/2016",resultResponseList.get(0).getClaimServiceEndDate());
		
	}
		
	@Test(expected = GenericException.class)	
	public void getAll275SearchResult_Test_AtLeastOneFieldShouldExsist() throws GenericException {
		SearchClaimAttachments275Request request=new SearchClaimAttachments275Request();
		request.setAttachId("");
		request.setAttachCtrNumber("");
		request.setClaimId("");
		request.setStatus("");
		request.setPatientLastName("");
		request.setPatientFirstName("");
		request.setPatientCtrNumber("");
		request.setPatientIdentifier("");
		request.setProviderName("");
		request.setProviderNpi("");
		request.setMedicalRecordNumber("");
		request.setPayerControlNumber("");
		request.setReportTypeCode("");
		request.setClaimServiceEndDate("");
		request.setClaimServiceEndDate("");
		request.setPageSize(10);
		request.setSortColumn("");
		request.setDescending(false);
		request.setPageNumber(1);
		
		GenericResponse repositoryResponse=searchClaimAttachments275Service.getAll275SearchResult(request);
	
	}
	
}

