package gov.va.med.ars.service.impl;

import static org.junit.Assert.assertFalse;
import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.ars.configuration.AppConfig;
import gov.va.med.ars.configuration.spring.SpringMvcConfig;
import gov.va.med.ars.controller.Rfai277SubmissionController;
import gov.va.med.ars.dao.ars.ClaimSubmissionRepository;
import gov.va.med.ars.dao.ars.HccsCdRepository;
import gov.va.med.ars.dao.ars.LoincCdRepository;
import gov.va.med.ars.dao.ars.LoincModCdRepository;
import gov.va.med.ars.dao.ars.RfaiLookupRepository;
import gov.va.med.ars.filter.CORSFilter;
import gov.va.med.ars.model.response.RfaiRelatedItemResponse;
import gov.va.med.ars.model.response.Rfai277SubmissionResponse;
import gov.va.med.ars.model.response.RfaiAttachmentResponse;
import gov.va.med.ars.model.response.RfaiLineItemResponse;
import gov.va.med.ars.service.IRfai277SubmissionService;
import gov.va.med.domain.ars.ClaimSubmission;

@Ignore
@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = { AppConfig.class, SpringMvcConfig.class })
public class Rfai277SubmissionServiceImplTest {

	private static final Logger logger = LogManager.getLogger(Rfai277SubmissionServiceImplTest.class);
	
	@Autowired
	ClaimSubmissionRepository claimSubRepo;
	
	@Autowired
	HccsCdRepository hccsRepo;
	
	@Autowired
	LoincCdRepository loincRepo;
	
	@Autowired
	LoincModCdRepository loincModRepo;
	
	@Autowired
	RfaiLookupRepository rfaiRepository;
	
	private MockMvc mockMvc;
	public static final MediaType APPLICATION_JSON_UTF8 = new MediaType(MediaType.APPLICATION_JSON.getType(),
			MediaType.APPLICATION_JSON.getSubtype(), Charset.forName("utf8"));

	@Mock
	private IRfai277SubmissionService rfaiSubmissionService;

	@InjectMocks
	private Rfai277SubmissionController rfaiSubmissionController;
	
	@Before
	public void init() throws Exception {
		MockitoAnnotations.initMocks(this);
		mockMvc = MockMvcBuilders.standaloneSetup(rfaiSubmissionController).addFilters(new CORSFilter()).build();
	}

	@Test
	public void TestGetRfaiSubmissionResults() throws Exception {
		
		//GenericResponse genericResponse = new GenericResponse();
		//RfaiSubmissionResponse rfaiSubmissionResponse = new RfaiSubmissionResponse();
		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
		
		Long submissionId = 52L;
		String requestJson = ow.writeValueAsString(submissionId);
		
		//get claim submission data
		ClaimSubmission claimSubmission = rfaiRepository.getClaimSubInfo(submissionId);
		List<String> hccsCds = new ArrayList<String>();
		List<String> loincCds = new ArrayList<String>();
		List<String> loincModCds = new ArrayList<String>();
		
		hccsCds.add(claimSubmission.getHccsCd().getStchccstatuscatCd());
		loincCds.add(claimSubmission.getLoincCd().getStcloincCd());
		loincModCds.add(claimSubmission.getLoincModCd().getStcloincCdMod());
		List<ClaimSubmission> relatedSubmissions = rfaiRepository.findBytrn02fppsClaimId(claimSubmission.getTrn02fppsClaimId());
		List<RfaiRelatedItemResponse> relatedItemResponses = new ArrayList<RfaiRelatedItemResponse>();
		List<RfaiAttachmentResponse> rfaiAttachmentResponses = new ArrayList<RfaiAttachmentResponse>();
		List<RfaiLineItemResponse> rfaiLineItemResponse = new ArrayList<RfaiLineItemResponse>();
		
		Rfai277SubmissionResponse rfaiSubmissionResponse = new Rfai277SubmissionResponse(10086L,
																				  "CONTACT_INFO",
																				  "PENDING",
																				  "01/31/2018",
																				  "DragonPayerName",
																				  "12115",
																				  "InformationReceiver",
																				  "01/31/2018",
																				  "DragonProviderInformation",
																				  "456789012",
																				  "87643210",
																				  "Dragon",
																				  "Whosa",
																				  "888888888",
																				  "123121234",
																				  "DragonPayerControlNumber",
																				  "DragonBillType",
																				  "DragonClearingHouseId",
																				  "DragonMedicalRecordNumber",
																				  relatedItemResponses,
																				  rfaiAttachmentResponses,
																				  rfaiLineItemResponse);
		when(rfaiSubmissionService.getRfaiSubmissionResults(52l)).thenReturn(rfaiSubmissionResponse);
		
		//mockMvc.perform(get("/api/v1/submission/{id}", (long) 52))
		//		.andDo(print()).andExpect(status().isOk())
		//		.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));

		//logger.info("getSubmissionResultsSuccess:" + result.andReturn().getResponse().getStatus());
		//assertFalse(HttpStatus.OK.value() != result.andReturn().getResponse().getStatus());
		ResultActions result = mockMvc
				.perform(get("/api/v1/submission/52")).andDo(print()).andExpect(status().isOk())
				.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));

		logger.info("getSimpleSearchSuccess:" + result.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() != result.andReturn().getResponse().getStatus());
	}
}