package gov.va.med.ars.integration;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoMoreInteractions;
import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.ars.configuration.AppConfig;
import gov.va.med.ars.configuration.spring.SpringMvcConfig;
import gov.va.med.ars.model.request.UserSearchRequest;
import gov.va.med.ars.model.response.GenericResponse;
import gov.va.med.ars.model.response.UserDetailsResponse;

@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = { AppConfig.class, SpringMvcConfig.class })
public class UserAdministrationRestIntegrationTest {
private static final Logger logger = LogManager.getLogger(UserAdministrationRestIntegrationTest.class);
	
	@Autowired
	private WebApplicationContext wac;
	private MockMvc mockMvc;
	
	@Before
	public void setup() {
		this.mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
	}
	@Test
	public void testsearchAllUsers_failure() throws Exception {
		UserSearchRequest userSearchRequest = new UserSearchRequest();
		userSearchRequest.setAdmin("");
		userSearchRequest.setCreatedBy("");
		userSearchRequest.setDescending(false);
		userSearchRequest.setDomain("");
		userSearchRequest.setEdit("");
		userSearchRequest.setEmail("");
		userSearchRequest.setExport("");
		userSearchRequest.setFirstName("");
		userSearchRequest.setLastName("");
		userSearchRequest.setPageNumber(1);
		userSearchRequest.setPageSize(10);
		userSearchRequest.setPhone("");
		userSearchRequest.setSortColumn("");
		userSearchRequest.setStatus("");
		userSearchRequest.setUserName("");
		userSearchRequest.setExport("");
		userSearchRequest.setEdit("");
		userSearchRequest.setAdmin("");
		
		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
		String requestJson = ow.writeValueAsString(userSearchRequest);
		
		ResultActions result = mockMvc.perform(post("/api/v1/userSearch").contentType(MediaType.APPLICATION_JSON).content(requestJson))
				.andDo(print())
				.andExpect(status().is2xxSuccessful())
				.andExpect(content().contentType("application/json;charset=UTF-8"));
				
		logger.info("testsearchAllUsers_success:" + result.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.SERVICE_UNAVAILABLE.value() == result.andReturn().getResponse().getStatus());

	}

	@Test
	public void testEditUser_failure() throws Exception {
		UserSearchRequest userSearchRequest = new UserSearchRequest();
		userSearchRequest.setAdmin("");
		userSearchRequest.setCreatedBy("");
		userSearchRequest.setDescending(false);
		userSearchRequest.setDomain("");
		userSearchRequest.setEdit("");
		userSearchRequest.setEmail("");
		userSearchRequest.setExport("");
		userSearchRequest.setFirstName("");
		userSearchRequest.setLastName("");
		userSearchRequest.setPageNumber(1);
		userSearchRequest.setPageSize(10);
		userSearchRequest.setPhone("");
		userSearchRequest.setSortColumn("");
		userSearchRequest.setStatus("");
		userSearchRequest.setUserName("");
		userSearchRequest.setExport("");
		userSearchRequest.setEdit("");
		userSearchRequest.setAdmin("");


		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
		String requestJson = ow.writeValueAsString(userSearchRequest);
		ResultActions result = mockMvc
				.perform(post("/api/v1/editUser").contentType(MediaType.APPLICATION_JSON).content(requestJson))
				.andDo(print()).andExpect(status().is5xxServerError());
		
		logger.info("testEditUserSuccess:" + result.andReturn().getResponse().getStatus());
		assertTrue(HttpStatus.INTERNAL_SERVER_ERROR.value() == result.andReturn().getResponse().getStatus());

	}

	@Test
	public void testgetUserById_failure() throws Exception {
		String userId = "PII";
		logger.info("integration testing");

		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
		String requestJson = ow.writeValueAsString(userId);
		ResultActions result = mockMvc.perform(
				get("/api/v1/userDetails/" + userId).contentType(MediaType.APPLICATION_JSON).content(requestJson))
				.andDo(print()).andExpect(status().is2xxSuccessful());

		logger.info("testsearchAllUsers_success:" + result.andReturn().getResponse().getStatus());
		assertTrue(HttpStatus.OK.value() == result.andReturn().getResponse().getStatus());
		
	}

	@Test
	public void testdeleteUser_failure() throws Exception {
		Long userId = (long) 100;
	

		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
		String requestJson = ow.writeValueAsString(userId);
		ResultActions result = mockMvc.perform(
				get("/api/v1/userDelete/" + userId).contentType(MediaType.APPLICATION_JSON).content(requestJson))
				.andDo(print()).andExpect(status().is5xxServerError());
		
		logger.info("testdeleteUserSuccess:" + result.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() == result.andReturn().getResponse().getStatus());
	}
	
}
