package gov.va.med.ars.integration;

import javax.sql.DataSource;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.CacheManager;
import org.springframework.orm.hibernate5.HibernateExceptionTranslator;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;



/**
 * @author Eyuel Taddese
 *
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = {gov.va.med.ars.configuration.AppConfig.class, gov.va.med.ars.configuration.hibernate.ArsPersistenceConfig.class, gov.va.med.ars.configuration.spring.SpringMvcConfig.class})
@ActiveProfiles("dev")
@WebAppConfiguration
public class SpringTest {
	@Autowired
	private CacheManager cacheManager;
	
	@Autowired
	@Qualifier("arsEntityManager")
	private LocalContainerEntityManagerFactoryBean entityManagerFactoryBean;
	
	@Autowired
	@Qualifier("arsDataSource")
	private DataSource dataSource;
	
	@Autowired
	private HibernateExceptionTranslator hibernateExceptionTranslator;


	@Test
	public void whenDataSourceIsInstantiated_thenNoExceptions() {
		Assert.assertNotNull("Spring Data failed",dataSource);
	}
	
	@Test
	public void whenCacheManagerIsInstantiated_thenNoExceptions() {
		Assert.assertNotNull("Spring Data failed",cacheManager);
	}
	
	
	@Test
	public void whenPersistanceConfigBeanIsInstantiated_thenNoExceptions() {
		Assert.assertNotNull(entityManagerFactoryBean);
	}
	
	@Test
	public void whenHibernateExceptionTranslatorIsInstantiated_thenNoException() {
		Assert.assertNotNull(hibernateExceptionTranslator);
	}
}