package gov.va.med.ars.integration;


import static org.junit.Assert.*;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import org.springframework.http.HttpStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.ars.configuration.AppConfig;
import gov.va.med.ars.configuration.spring.SpringMvcConfig;
import gov.va.med.ars.model.request.SearchClaimAttachments275Request;

@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = { AppConfig.class, SpringMvcConfig.class })
public class Search275ControllerIntegration {

private static final Logger logger = LogManager.getLogger(RfaiControllerIntegrationTest.class);
	
	@Autowired
	private WebApplicationContext wac;
	private MockMvc mockMvc;
	
	@Before
	public void setup() {
		this.mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
	}
	
	/*@Test
	public void testGet275Attachments_Success() throws Exception {
		
		SearchClaimAttachments275Request request=new SearchClaimAttachments275Request();
		request.setAttachId("704");
		request.setAttachCtrNumber("");
		request.setClaimId("");
		request.setStatus("");
		request.setPatientLastName("");
		request.setPatientFirstName("");
		request.setPatientCtrNumber("");
		request.setPatientIdentifier("");
		request.setProviderName("");
		request.setProviderNpi("");
		request.setMedicalRecordNumber("");
		request.setPayerControlNumber("");
		request.setReportTypeCode("");
		request.setClaimServiceEndDate("");
		request.setClaimServiceEndDate("");
		request.setPageSize(10);
		request.setSortColumn("");
		request.setDescending(false);
		request.setPageNumber(1);
		
		
		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
		String requestJson = ow.writeValueAsString(request);
		
		
		ResultActions s =mockMvc.perform(post("/api/v1/searchClaimAttachments275/search").contentType(MediaType.APPLICATION_JSON)
				.content(requestJson)).andDo(print()).andExpect(status().isOk()).andExpect(content().contentType("application/json;charset=UTF-8"));;
		logger.info("testGetClaims_Success:" + s.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
	}*/	
	
	
	@Test
	public void testGetClaims_LargeNumber_Failure() throws Exception {
		
		SearchClaimAttachments275Request request=new SearchClaimAttachments275Request();
		request.setAttachId("");
		request.setAttachCtrNumber("");
		request.setClaimId("");
		request.setStatus("");
		request.setPatientLastName("");
		request.setPatientFirstName("");
		request.setPatientCtrNumber("");
		request.setPatientIdentifier("");
		request.setProviderName("");
		request.setProviderNpi("");
		request.setMedicalRecordNumber("");
		request.setPayerControlNumber("");
		request.setReportTypeCode("");
		request.setClaimServiceEndDate("");
		request.setClaimServiceEndDate("");
		request.setPageSize(10);
		request.setSortColumn("");
		request.setDescending(false);
		request.setPageNumber(1);
		
		
		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
		String requestJson = ow.writeValueAsString(request);		
		
		ResultActions s =mockMvc.perform(post("/api/v1/searchClaimAttachments275/search").contentType(MediaType.APPLICATION_JSON)
				.content(requestJson)).andDo(print()).andExpect(status().is5xxServerError()).andExpect(content().contentType("application/json;charset=UTF-8"));
		logger.info("testGetClaims_Success:" + s.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() == s.andReturn().getResponse().getStatus());
	}
	
	
}
