package gov.va.med.ars.controller;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoMoreInteractions;
import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.MediaType;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.ars.configuration.AppConfig;
import gov.va.med.ars.configuration.spring.SpringMvcConfig;
import gov.va.med.ars.filter.CORSFilter;
import gov.va.med.ars.model.request.UserSearchRequest;
import gov.va.med.ars.service.IUserAdminService;
import javafx.util.Pair;

@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = { AppConfig.class, SpringMvcConfig.class })
public class UserAdminControllerTest {
	
	private MockMvc mockMvc;
	
	@Mock
	private IUserAdminService adminService;
	
	@InjectMocks
	private UserAdminController adminController;
	
	@Before
	public void init() throws Exception {
		MockitoAnnotations.initMocks(this);
		mockMvc = MockMvcBuilders.standaloneSetup(adminController).addFilters(new CORSFilter()).build();
	}
	
	@SuppressWarnings("restriction")
	@Test
	public void testCreateUser() throws Exception {
		
		UserSearchRequest request = new UserSearchRequest();
		request.setAdmin("y");
		request.setCreatedBy("ARS_ADMIN");
		request.setDomain("DNS      ");
		request.setStatus("Y");
		request.setEdit("Y");
		request.setExport("Y");
		request.setUserName("PII");

		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
		String requestBodyJson = ow.writeValueAsString(request);
		
		when(adminService.createUser(any(UserSearchRequest.class))).thenReturn(new Pair <String,Boolean>("User was successfully created.",true));
		
		mockMvc.perform(post("/api/v1/admin/createUser").contentType(MediaType.APPLICATION_JSON)
				.content(requestBodyJson)).andDo(print()).andExpect(status().isCreated());	
		
		verify(adminService, times(1)).createUser(Matchers.refEq(request));
		verifyNoMoreInteractions(adminService);
	}
}