package gov.va.med.ars.controller;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertFalse;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoMoreInteractions;
import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

import javax.validation.constraints.AssertTrue;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.ars.configuration.AppConfig;
import gov.va.med.ars.configuration.spring.SpringMvcConfig;
import gov.va.med.ars.constants.ErrorMessages;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.filter.CORSFilter;
import gov.va.med.ars.model.request.SearchClaimAttachments275Request;
import gov.va.med.ars.model.response.GenericResponse;
import gov.va.med.ars.model.response.SearchClaimAttachments275Response;
import gov.va.med.ars.service.ISearchClaimAttachments275Service;
import static org.mockito.Mockito.*;

@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = { AppConfig.class, SpringMvcConfig.class })
public class SearchClaimAttachments275ControllerTest {

	private static final Logger logger = LogManager.getLogger(SearchClaimAttachments275ControllerTest.class);
	
	private MockMvc mockMvc;
	public static final MediaType APPLICATION_JSON_UTF8 = new MediaType(MediaType.APPLICATION_JSON.getType(),
			MediaType.APPLICATION_JSON.getSubtype(), Charset.forName("utf8"));
	
	@Mock
	private ISearchClaimAttachments275Service iSearchClaimAttachments275Service;
	
	@Mock
	private GenericException genericException=new GenericException(ErrorMessages.INVALID_REQUEST,
			"At least one field information needs to be added", HttpStatus.NOT_FOUND);
	
	@InjectMocks
	private SearchClaimAttachments275Controller searchClaimAttachments275Controller;

	@Before
	public void init() throws Exception {
		MockitoAnnotations.initMocks(this);
		mockMvc = MockMvcBuilders.standaloneSetup(searchClaimAttachments275Controller).addFilters(new CORSFilter()).build();
	}
	
	
	// Followed rules to test a conroller	

	@Test
	public void testSearchClaimAttachmentsSuccess() throws Exception {
		
		SearchClaimAttachments275Request request=new SearchClaimAttachments275Request();
		request.setAttachId("101");
		request.setAttachCtrNumber("");
		request.setClaimId("");
		request.setStatus("");
		request.setPatientLastName("");
		request.setPatientFirstName("");
		request.setPatientCtrNumber("");
		request.setPatientIdentifier("");
		request.setProviderName("");
		request.setProviderNpi("");
		request.setMedicalRecordNumber("");
		request.setPayerControlNumber("");
		request.setReportTypeCode("");
		request.setClaimServiceEndDate("");
		request.setClaimServiceEndDate("");
		request.setPageSize(10);
		request.setSortColumn("");
		request.setDescending(false);
		
		SearchClaimAttachments275Response response=new SearchClaimAttachments275Response();
		List<SearchClaimAttachments275Response> listResponse = new ArrayList<>();
		response.setAttachId(101);
		response.setAttachCtrNumber("678987");
		response.setClaimId("100000");
		response.setExternalClaimId("11111");
		response.setStatus("Active");
		response.setPatientName("Koti, Divya");
		response.setPatientCtrNumber("252525");
		response.setPatientIdentifier("34567");
		response.setProviderName("Mohite");
		response.setProviderNpi("678947");
		response.setMedicalRecordNumber("123456789");
		response.setPayerControlNumber("202154");
		response.setReportTypeCode("09");
		response.setAttachType("PDF");
		response.setClaimServiceStartDate("08/11/2016");
		response.setClaimServiceEndDate("08/11/2016");
		listResponse.add(response);
		
		GenericResponse searchResponse=new GenericResponse();		
		searchResponse.setpageNumber(1);
		searchResponse.setpageSize(10);
		searchResponse.setsortColumn("claimServiceEndDate");
		searchResponse.settotalNumberOfResults((long) 1);
		searchResponse.setResponse(listResponse);
		
				
		//when(iSearchClaimAttachments275Service.getAll275SearchResult(request)).thenReturn(searchResponse);
		
		//The above one did not work so used  below call which opts an OPTIOn any
		when(iSearchClaimAttachments275Service.getAll275SearchResult(any(SearchClaimAttachments275Request.class)))
			    .thenReturn(searchResponse);

		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
		String requestJson = ow.writeValueAsString(request);
		mockMvc.perform(post("/api/v1/searchClaimAttachments275/search").contentType(MediaType.APPLICATION_JSON)
				.content(requestJson)).andDo(print()).andExpect(status().isOk())
		.andExpect(content().contentType("application/json;charset=UTF-8"))
		.andExpect(jsonPath("$.pageNumber", is(1)))
		.andExpect(jsonPath("$.pageSize", is(10)))
		.andExpect(jsonPath("$.sortColumn", is("claimServiceEndDate")))
		.andExpect(jsonPath("$.totalNumberOfResults", is(1)))
		.andExpect(jsonPath("$.response[0].attachId", is(101)))
		.andExpect(jsonPath("$.response[0].attachCtrNumber", is("678987")))
		.andExpect(jsonPath("$.response[0].externalClaimId", is("11111")))
		.andExpect(jsonPath("$.response[0].status", is("Active")))
		.andExpect(jsonPath("$.response[0].patientName", is("Koti, Divya")))
		.andExpect(jsonPath("$.response[0].patientCtrNumber", is("252525")))		
		.andExpect(jsonPath("$.response[0].patientIdentifier", is("34567")))
		.andExpect(jsonPath("$.response[0].providerName", is("Mohite")))
		.andExpect(jsonPath("$.response[0].providerNpi", is("678947")))
		.andExpect(jsonPath("$.response[0].medicalRecordNumber", is("123456789")))
		.andExpect(jsonPath("$.response[0].payerControlNumber", is("202154")))
		.andExpect(jsonPath("$.response[0].reportTypeCode", is("09")))
		.andExpect(jsonPath("$.response[0].claimServiceStartDate", is("08/11/2016")))
		.andExpect(jsonPath("$.response[0].claimServiceEndDate", is("08/11/2016")))
		.andExpect(jsonPath("$.response[0].attachType", is("PDF")))
		.andExpect(jsonPath("$.response[0].claimId", is("100000")));
		
		verify(iSearchClaimAttachments275Service, times(1)).getAll275SearchResult(Matchers.refEq(request));
		verifyNoMoreInteractions(iSearchClaimAttachments275Service);
	}
	
	
	
	//Exception on getting all fields in request as empty
	@Test
	public void testSearchClaimAttachmentsFailure() throws Exception {
	    
		SearchClaimAttachments275Request request=new SearchClaimAttachments275Request();
		request.setAttachId("");
		request.setAttachCtrNumber("");
		request.setClaimId("");
		request.setStatus("");
		request.setPatientLastName("");
		request.setPatientFirstName("");
		request.setPatientCtrNumber("");
		request.setPatientIdentifier("");
		request.setProviderName("");
		request.setProviderNpi("");
		request.setMedicalRecordNumber("");
		request.setPayerControlNumber("");
		request.setReportTypeCode("");
		request.setClaimServiceEndDate("");
		request.setClaimServiceEndDate("");
		request.setPageSize(10);
		request.setSortColumn("");
		request.setDescending(false);
		
		// try these 2 approach if the when does not work. 
		
		/*when(iSearchClaimAttachments275Service.getAll275SearchResult(any(SearchClaimAttachments275Request.class)))
	    .thenThrow(new GenericException(ErrorMessages.INVALID_REQUEST,
				"At least one field information needs to be added", HttpStatus.NOT_FOUND));		*/
		/*when(iSearchClaimAttachments275Service.getAll275SearchResult(any(SearchClaimAttachments275Request.class)))
	    .thenThrow(genericException);
		*/
		when(iSearchClaimAttachments275Service.getAll275SearchResult(request))
	    .thenThrow(genericException);
		
	        
		/*  assertEquals("Invalid parametercount: expected=3, passed=2", exception.getMessage());*/
	        
		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
		String requestJson = ow.writeValueAsString(request);

		mockMvc.perform(post("/api/v1/searchClaimAttachments275/search").content(requestJson)).andDo(print()).andExpect(status().is(415));
		
		/*verify(iSearchClaimAttachments275Service, times(1)).getAll275SearchResult(request);
		verifyNoMoreInteractions(SearchClaimAttachments275Request.class);*/
		
	}
	
}
