package gov.va.med.ars.controller;

import static org.hamcrest.Matchers.is;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoMoreInteractions;
import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.MediaType;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import gov.va.med.ars.configuration.AppConfig;
import gov.va.med.ars.configuration.spring.SpringMvcConfig;
import gov.va.med.ars.filter.CORSFilter;
import gov.va.med.ars.model.response.Rfai277SubmissionResponse;
import gov.va.med.ars.model.response.RfaiAttachmentResponse;
import gov.va.med.ars.model.response.RfaiRelatedItemResponse;
import gov.va.med.ars.service.IRfai277SubmissionService;


@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = { AppConfig.class, SpringMvcConfig.class })
public class Rfai277SubmissionControllerTest {
	
	private MockMvc mockMvc;
	public static final MediaType APPLICATION_JSON_UTF8 = new MediaType(MediaType.APPLICATION_JSON.getType(),
			MediaType.APPLICATION_JSON.getSubtype(), Charset.forName("utf8"));

	@Mock
	private IRfai277SubmissionService irfai277SubmissionService;

	@InjectMocks
	private Rfai277SubmissionController rfai277SubmissionController;

	@Before
	public void init() throws Exception {
		MockitoAnnotations.initMocks(this);
		mockMvc = MockMvcBuilders.standaloneSetup(rfai277SubmissionController).addFilters(new CORSFilter()).build();
	}
	
	@Test
	public void TestgetSubmissionById() throws Exception {
		Rfai277SubmissionResponse rfai277SubmissionResponse = new Rfai277SubmissionResponse();
		rfai277SubmissionResponse.setClaimId(1L);
		rfai277SubmissionResponse.setRfaiStatus("rfai status");
		rfai277SubmissionResponse.setRfaiSubmissionDate("12/12/2017");
		rfai277SubmissionResponse.setPayerName("payer name");
		rfai277SubmissionResponse.setPayerId("1111");
		rfai277SubmissionResponse.setInformationReceiver("info receiver");
		rfai277SubmissionResponse.setResponseDate("12/12/2017");
		rfai277SubmissionResponse.setBillingProvider("billing provider");
		rfai277SubmissionResponse.setProviderNpi("provider npi");
		rfai277SubmissionResponse.setProviderTin("provider tin");
		rfai277SubmissionResponse.setPatientLastname("last name");
		rfai277SubmissionResponse.setPatientFirstName("first name");
		rfai277SubmissionResponse.setPatientIdentifier("22");
		rfai277SubmissionResponse.setPatientcontrolNumber("44");
		rfai277SubmissionResponse.setPayerClaimControlNumber("66");
		rfai277SubmissionResponse.setBillType("bill type");
		rfai277SubmissionResponse.setClearingHouseId("88");
		rfai277SubmissionResponse.setMedicalRecordNumber("100");
		
		List<RfaiRelatedItemResponse> rfaiRelatedItemResponses = new ArrayList<RfaiRelatedItemResponse>();
		RfaiRelatedItemResponse relatedItemResponse = new RfaiRelatedItemResponse();
		relatedItemResponse.setSubmissionId(59);
		relatedItemResponse.setClaimId(2L);
		relatedItemResponse.setEndDate("12/11/2017");
		relatedItemResponse.setMedicalRecordNumber("123");
		relatedItemResponse.setPatientControlNumber("999");
		relatedItemResponse.setPatientName("Last Name");
		rfaiRelatedItemResponses.add(relatedItemResponse);
		
		List<RfaiAttachmentResponse> rfaiAttachmentResponses = new ArrayList<RfaiAttachmentResponse>();
		RfaiAttachmentResponse attachmentResponse = new RfaiAttachmentResponse();
		attachmentResponse.setClaimLevel("claim level");
		attachmentResponse.setLoincCodes("11488-4");
		attachmentResponse.setLoincModCodes("11488-4");
		attachmentResponse.setStatusCode("R0");
		rfaiAttachmentResponses.add(attachmentResponse);
		
		rfai277SubmissionResponse.setRfaiRelatedItemResponse(rfaiRelatedItemResponses);
		rfai277SubmissionResponse.setRfaiAttachmentResponse(rfaiAttachmentResponses);
		
		when(irfai277SubmissionService.getRfaiSubmissionResults(1l)).thenReturn(rfai277SubmissionResponse);
		
		mockMvc.perform(get("/api/v1/submission/{id}", (long) 1)).andDo(print()).andExpect(status().isOk())
		.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE))
		.andExpect(jsonPath("$.claimId", is(1)))
		.andExpect(jsonPath("$.rfaiStatus", is("rfai status")))
		.andExpect(jsonPath("$.rfaiSubmissionDate", is("12/12/2017")))
		.andExpect(jsonPath("$.payerName", is("payer name")))
		.andExpect(jsonPath("$.payerId", is("1111")))
		.andExpect(jsonPath("$.informationReceiver", is("info receiver")))
		.andExpect(jsonPath("$.responseDate", is("12/12/2017")))
		.andExpect(jsonPath("$.billingProvider", is("billing provider")))
		.andExpect(jsonPath("$.providerNpi", is("provider npi")))
		.andExpect(jsonPath("$.providerTin", is("provider tin")))
		.andExpect(jsonPath("$.patientLastname", is("last name")))
		.andExpect(jsonPath("$.patientFirstName", is("first name")))
		.andExpect(jsonPath("$.patientIdentifier", is("22")))
		.andExpect(jsonPath("$.patientcontrolNumber", is("44")))
		.andExpect(jsonPath("$.payerClaimControlNumber", is("66")))
		.andExpect(jsonPath("$.billType", is("bill type")))
		.andExpect(jsonPath("$.clearingHouseId", is("88")))
		.andExpect(jsonPath("$.medicalRecordNumber", is("100")))
		.andExpect(jsonPath("$.rfaiRelatedItemResponse[0].submissionId", is(59)))
		.andExpect(jsonPath("$.rfaiRelatedItemResponse[0].claimId", is(2)))
		.andExpect(jsonPath("$.rfaiRelatedItemResponse[0].endDate", is("12/11/2017")))
		.andExpect(jsonPath("$.rfaiRelatedItemResponse[0].medicalRecordNumber", is("123")))
		.andExpect(jsonPath("$.rfaiRelatedItemResponse[0].patientControlNumber", is("999")))
		.andExpect(jsonPath("$.rfaiRelatedItemResponse[0].patientName", is("Last Name")))
		.andExpect(jsonPath("$.rfaiAttachmentResponse[0].claimLevel", is("claim level")))
		.andExpect(jsonPath("$.rfaiAttachmentResponse[0].loincCodes", is("11488-4")))
		.andExpect(jsonPath("$.rfaiAttachmentResponse[0].loincModCodes", is("11488-4")))
		.andExpect(jsonPath("$.rfaiAttachmentResponse[0].statusCode", is("R0")));
			
		verify(irfai277SubmissionService, times(1)).getRfaiSubmissionResults((long) 1);
		verifyNoMoreInteractions(irfai277SubmissionService);	
	}
}