package gov.va.med.ars.controller;
import static org.hamcrest.Matchers.is;
import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import gov.va.med.ars.filter.CORSFilter;

import gov.va.med.ars.service.IAuthenticatorService;

@RunWith(MockitoJUnitRunner.class)
public class AuthenticatorControllerTest {

	private MockMvc mockMvc;
	public static final MediaType APPLICATION_JSON_UTF8 = new MediaType(MediaType.APPLICATION_JSON.getType(),
			MediaType.APPLICATION_JSON.getSubtype(), Charset.forName("utf8"));
	
	@Mock
	private IAuthenticatorService authenticatorService;
	
	@InjectMocks
	private AuthenticatorController authenticatorController;
	
	@Before
	public void init() throws Exception {
		MockitoAnnotations.initMocks(this);
		mockMvc = MockMvcBuilders.standaloneSetup(authenticatorController).addFilters(new CORSFilter()).build();
	}
	
	// getUsers() returns all users from db
	@Test
	public void getUsers() throws Exception {
		List<String> users = new ArrayList<>();
		users.add("ARSADMIN");
		users.add("EWVUSER");
		users.add("READONLY");
		when (authenticatorService.getUsers()).thenReturn(users);
		
		mockMvc.perform(get("/api/v1/users")).andDo(print()).andExpect(status().isOk())
		.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE))
		.andExpect(jsonPath("$[0]", is("ARSADMIN")))
		.andExpect(jsonPath("$[1]", is("EWVUSER")))
		.andExpect(jsonPath("$[2]", is("READONLY")));
	}
	

	
}
