package gov.va.med.ars.controller;

import static org.hamcrest.Matchers.is;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoMoreInteractions;
import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.MediaType;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import gov.va.med.ars.configuration.AppConfig;
import gov.va.med.ars.configuration.spring.SpringMvcConfig;
import gov.va.med.ars.filter.CORSFilter;
import gov.va.med.ars.model.response.AttachmentsStorageResponse;
import gov.va.med.ars.service.IArsAttachmentsStorageService;

@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = { AppConfig.class, SpringMvcConfig.class })
public class ArsAttachmentsStorageControllerTest {
	
	private MockMvc mockMvc;
	public static final MediaType APPLICATION_JSON_UTF8 = new MediaType(MediaType.APPLICATION_JSON.getType(),
			MediaType.APPLICATION_JSON.getSubtype(), Charset.forName("utf8"));

	@Mock
	private IArsAttachmentsStorageService arsAttachmentsStorageService;

	@InjectMocks
	private ArsAttachmentsStorageController arsAttachmentsStorageController;
	
	@Before
	public void init() throws Exception {
		MockitoAnnotations.initMocks(this);
		mockMvc = MockMvcBuilders.standaloneSetup(arsAttachmentsStorageController).addFilters(new CORSFilter()).build();
	}
	
	@Test
	public void testGetAttachemntsStorageInfo() throws Exception {
		
		AttachmentsStorageResponse response = new AttachmentsStorageResponse();
		response.setTotalStorage(new BigDecimal(232));
		response.setAvailableStorage(new BigDecimal(200));
		response.setUsedStorage(new BigDecimal(32));
		response.setPeakUsage(new BigDecimal(16));
		response.setFromDate("03/28/2018");
		response.setToDate("04/03/2018");
		
		List<BigDecimal> usedStorageStatistic = new ArrayList<>();
		List<BigDecimal> totalStorageStatistic = new ArrayList<>();
		usedStorageStatistic.add(new BigDecimal(0));
		usedStorageStatistic.add(new BigDecimal(32));
		usedStorageStatistic.add(new BigDecimal(121));
		usedStorageStatistic.add(new BigDecimal(120));
		usedStorageStatistic.add(new BigDecimal(121));
		usedStorageStatistic.add(new BigDecimal(121));
		usedStorageStatistic.add(new BigDecimal(121));
		
		totalStorageStatistic.add(new BigDecimal(0));
		totalStorageStatistic.add(new BigDecimal(222));
		totalStorageStatistic.add(new BigDecimal(141));
		totalStorageStatistic.add(new BigDecimal(321));
		totalStorageStatistic.add(new BigDecimal(232));
		totalStorageStatistic.add(new BigDecimal(220));
		totalStorageStatistic.add(new BigDecimal(121));
		
		response.setUsedStorageStatistic(usedStorageStatistic);
		response.setTotalStorageStatistic(totalStorageStatistic);
		
		when(arsAttachmentsStorageService.getAttachemntsStorageInfo()).thenReturn(response);
		
		mockMvc.perform(get("/api/v1/attachments/storageInfo")).andDo(print()).andExpect(status().isOk())
		.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE))
		.andExpect(jsonPath("$.totalStorage", is(232)))
		.andExpect(jsonPath("$.availableStorage", is(200)))
		.andExpect(jsonPath("$.usedStorage", is(32)))
		.andExpect(jsonPath("$.peakUsage", is(16)))
		.andExpect(jsonPath("$.usedStorageStatistic[1]", is(32)))
		.andExpect(jsonPath("$.totalStorageStatistic[1]", is(222)));
		
		verify(arsAttachmentsStorageService, times(1)).getAttachemntsStorageInfo();
		verifyNoMoreInteractions(arsAttachmentsStorageService);
	}
}