package gov.va.med.ars.controller;

import static org.junit.Assert.assertFalse;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.ars.configuration.AppConfig;
import gov.va.med.ars.configuration.spring.SpringMvcConfig;
import gov.va.med.ars.model.response.RfaiLineItemResponse;
import gov.va.med.ars.model.response.RfaiResponse;


@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = { AppConfig.class, SpringMvcConfig.class })
public class AdditionalInfoRequestControllerTest {
	private static final Logger logger = LogManager.getLogger(AdditionalInfoRequestControllerTest.class);
	
	@Autowired
	private WebApplicationContext wac;
	private MockMvc mockMvc;

	@Before
	public void setup() {
		this.mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
	}
	
	@Test
	public void testSubmitRfaiRequest_Success() throws Exception {
		RfaiResponse rfaiRequest = new RfaiResponse();
		rfaiRequest.setClaimId(10095L);
		rfaiRequest.setContactInformation("PII                       ");
		rfaiRequest.setServiceFromDate("12/12/2017");
		rfaiRequest.setServiceToDate("12/12/2017");
		rfaiRequest.setResponseDate("12/12/2017");
		rfaiRequest.setClaimStatus("R4");
		rfaiRequest.setLoincCode("18842-5");
		rfaiRequest.setLoincCodeModifier("18789-8");
		
		List<RfaiLineItemResponse> rfaiLineItemResponse = new ArrayList<RfaiLineItemResponse>();
		RfaiLineItemResponse rfaiLine = new RfaiLineItemResponse();
		rfaiLine.setServiceLineId(10095L);
		rfaiLine.setChargeAmount(new BigDecimal(2.01));
		rfaiLine.setModifiers("modifier");
		rfaiLine.setProcedureCode("256");
		rfaiLine.setRevenueCode("456");
		rfaiLine.setServiceFrom("12/12/2017");
		rfaiLine.setServiceTo("12/12/2017");
		rfaiLine.setServiceLineId(1000089L);
		rfaiLineItemResponse.add(rfaiLine);
		rfaiRequest.setRfaiLineItemResponse(rfaiLineItemResponse);
		
		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();

		String requestJson = ow.writeValueAsString(rfaiRequest);
		
		ResultActions result = mockMvc
				.perform(
						post("/api/v1/additionalInfoRequest").contentType(MediaType.APPLICATION_JSON).content(requestJson))
				.andDo(print()).andExpect(status().isCreated())
				.andExpect(content().contentType("application/json;charset=UTF-8"));
		logger.info("getMedicalCodesSuccess:" + result.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.CREATED.value() != result.andReturn().getResponse().getStatus());
	}
	
	@Test
	public void testSubmitRfaiRequest_Failure() throws Exception {
		RfaiResponse rfaiRequest = new RfaiResponse();
		//rfaiRequest.setClaimId(10095L);
		rfaiRequest.setContactInformation("PII                       ");
		rfaiRequest.setServiceFromDate("12/12/2017");
		rfaiRequest.setServiceToDate("12/12/2017");
		rfaiRequest.setResponseDate("12/12/2017");
		rfaiRequest.setClaimStatus("R4");
		rfaiRequest.setLoincCode("18842-5");
		rfaiRequest.setLoincCodeModifier("18789-8");
		
		List<RfaiLineItemResponse> rfaiLineItemResponse = new ArrayList<RfaiLineItemResponse>();
		RfaiLineItemResponse rfaiLine = new RfaiLineItemResponse();
		rfaiLine.setServiceLineId(10095L);
		rfaiLine.setChargeAmount(new BigDecimal(2.01));
		rfaiLine.setModifiers("modifier");
		rfaiLine.setProcedureCode("256");
		rfaiLine.setRevenueCode("456");
		rfaiLine.setServiceFrom("12/12/2017");
		rfaiLine.setServiceTo("12/12/2017");
		rfaiLine.setServiceLineId(1000089L);
		rfaiLineItemResponse.add(rfaiLine);
		rfaiRequest.setRfaiLineItemResponse(rfaiLineItemResponse);
		
		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();

		String requestJson = ow.writeValueAsString(rfaiRequest);
		
		ResultActions result = mockMvc
				.perform(
						post("/api/v1/additionalInfoRequest").contentType(MediaType.APPLICATION_JSON).content(requestJson))
				.andDo(print()).andExpect(status().isBadRequest())
				.andExpect(content().contentType("application/json;charset=UTF-8"));
		logger.info("getMedicalCodesSuccess:" + result.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.BAD_REQUEST.value() != result.andReturn().getResponse().getStatus());
	}
	
	
}