--------------------------------------------------------
--  File created - Tuesday-March-13-2018   
--------------------------------------------------------
--------------------------------------------------------
--  DDL for View CLAIMATTACHMENTS_VIEW
--------------------------------------------------------

  CREATE OR REPLACE FORCE VIEW "ARS277_REQUEST_TRACKING"."CLAIMATTACHMENTS_VIEW" ("ID", "ATTACHMENT_ID", "ATTACHMENT_PATH", "PROVIDER_NAME", "PROVIDER_FIRST_NAME", "PROVIDER_IDENTIFIER", "PROVIDER_NPI", "ENTITY_TYPE_QUALIFIER", "PATIENT_FIRST_NAME", "PATIENT_LAST_NAME", "PATIENT_IDENTIFIER_NUMBER", "REPORT_CODE", "PATIENT_CONTROL_NUMBER", "REF01", "MEDICAL_RECORD_NUMBER", "CLAIM_IDENTIFIER", "EXTERNAL_CLAIM_ID", "CLAIM_SERVICE_START_DATE", "CLAIM_SERVICE_END_DATE", "ATTACHMENT_NAME", "ATTACHMENT_TYPE", "ATTACHMENT_CONTROL_NUMBER", "PAYER_CLAIM_CONTROL_NUMBER", "STATUS") AS 
  SELECT DISTINCT
        a.attachment_id AS "ID",
        a.attachment_id,
        p.path_string AS attachment_path,
        a.nm103 AS provider_name,
        a.nm104 AS provider_first_name,
        a.nm109 AS provider_identifier,
        a.nm109 AS provider_npi,
        a.nm102 AS entity_type_qualifier,
        b.nm104 AS patient_first_name,
        b.nm103 AS patient_last_name,
        b.nm109 AS patient_identifier_number,
        c.report_code,
        d.ref02 AS patient_control_number,
        e.ref01 AS ref01,
        e.ref02 AS medical_record_number,
        a.claim_key AS claim_identifier,
        c.external_claim_id AS external_claim_id,
            CASE substr(
                g.dtp03,
                1,
                instr(g.dtp03,'-')
            )
                WHEN ' '   THEN g.dtp03
                ELSE substr(
                    g.dtp03,
                    1,
                    instr(g.dtp03,'-') - 1
                )
            END
        AS claim_service_start_date,
        substr(
            dtp03,
            instr(dtp03,'-') + 1,
            length(rtrim(dtp03) )
        ) AS claim_service_end_date,
        c.attachment_name,
        c.attachment_type,
        h.trn02 AS attachment_control_number,
        c.payer_claim_control_number,
        c.status
    FROM
        entityname a
        LEFT OUTER JOIN reference_identification e ON
            a.attachment_id = e.attachment_id
        AND
            e.ref01 = 'EA'
        LEFT OUTER JOIN trace_number h ON a.attachment_id = h.attachment_id
        INNER JOIN paths p ON a.attachment_id = p.attachment_id,
        entityname b,
        transactions c,
        reference_identification d,
        claim_date g
    WHERE
            a.attachment_id = b.attachment_id
        AND
            a.attachment_id = c.attachment_id
        AND
            a.attachment_id = d.attachment_id
        AND
            a.attachment_id = g.attachment_id
        AND
            a.nm101 = '1P'
        AND
            b.nm101 = 'QC'
        AND
            d.ref01 = 'EJ'
        AND
            g.dtp01 = '472'
;
--------------------------------------------------------
--  DDL for Table ARSAUDITLOG
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."ARSAUDITLOG" 
   (	"ID" NUMBER(10,0), 
	"METHODNAME" VARCHAR2(50 BYTE), 
	"USERID" VARCHAR2(60 BYTE), 
	"CLAIMATTACHMENTID" NUMBER(10,0), 
	"ACCESSDATE" TIMESTAMP (3), 
	"REQUESTARGS" VARCHAR2(200 BYTE), 
	"ACTION" VARCHAR2(60 BYTE), 
	"SUCCESS" NUMBER(1,0), 
	"VER" NUMBER(10,0) DEFAULT 1
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table ARSREPORTTYPE
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."ARSREPORTTYPE" 
   (	"CODE" VARCHAR2(20 BYTE), 
	"DEFINITION" VARCHAR2(90 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table ARS_ROLE
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."ARS_ROLE" 
   (	"ARS_ROLE_ID" NUMBER(15,0), 
	"ROLE_NAME" VARCHAR2(30 BYTE), 
	"DESCRIPTION" VARCHAR2(60 BYTE), 
	"CREATED_BY" VARCHAR2(30 BYTE), 
	"DATE_CREATED" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table ARS_ROLE_PERMISSIONS
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."ARS_ROLE_PERMISSIONS" 
   (	"PERMISSION_ID" NUMBER(15,0), 
	"PAGE_NAME" VARCHAR2(30 BYTE), 
	"PERMISSION_NAME" VARCHAR2(40 BYTE), 
	"ARS_ROLE_ID" NUMBER(15,0), 
	"ENABLED" VARCHAR2(1 BYTE), 
	"CREATED_BY" VARCHAR2(30 BYTE), 
	"DATE_CREATED" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table ARS_USER
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."ARS_USER" 
   (	"ARS_USER_ID" NUMBER(15,0), 
	"USER_NAME" VARCHAR2(30 BYTE), 
	"ENABLED" VARCHAR2(1 BYTE), 
	"LAST_NAME" VARCHAR2(30 BYTE), 
	"FIRST_NAME" VARCHAR2(30 BYTE), 
	"MIDDLE_NAME" VARCHAR2(30 BYTE), 
	"PHONE_NUMBER" VARCHAR2(15 BYTE), 
	"EMAIL_ADDRESS" VARCHAR2(100 BYTE), 
	"LAST_LOGIN_DATE" DATE, 
	"DEACTIVATION_REASON_CD" NUMBER(10,0), 
	"DEACTIVATION_COMMENTS" VARCHAR2(200 BYTE), 
	"CREATED_BY" VARCHAR2(30 BYTE), 
	"DATE_CREATED" DATE, 
	"MODIFIED_BY" VARCHAR2(30 BYTE), 
	"DATE_MODIFIED" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 0 PCTUSED 0 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" 
  PARALLEL 2 ;
--------------------------------------------------------
--  DDL for Table ARS_USER_ROLE_USAGES
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."ARS_USER_ROLE_USAGES" 
   (	"ARS_ROLE_ID" NUMBER(15,0), 
	"ARS_USER_ID" NUMBER(15,0), 
	"CREATED_BY" VARCHAR2(30 BYTE), 
	"DATE_CREATED" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 0 PCTUSED 0 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" 
  PARALLEL 2 ;
--------------------------------------------------------
--  DDL for Table BINARY275
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."BINARY275" 
   (	"ATTACHMENT_ID" NUMBER(10,0), 
	"BIN01" NUMBER(10,0), 
	"BINARY275ID" NUMBER
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table CLAIMATTACHMENTS
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."CLAIMATTACHMENTS" 
   (	"ID" NUMBER(10,0), 
	"PROVIDER_NAME" VARCHAR2(132 BYTE), 
	"PROVIDER_IDENTIFIER_NUMBER" VARCHAR2(20 BYTE), 
	"PATIENT_FIRST_NAME" VARCHAR2(60 BYTE), 
	"PATIENT_LAST_NAME" VARCHAR2(60 BYTE), 
	"REPORT_CODE" VARCHAR2(20 BYTE), 
	"PATIENT_CONTROL_NUMBER" VARCHAR2(20 BYTE), 
	"MEDICAL_RECORD_NUMBER" VARCHAR2(20 BYTE), 
	"PATIENT_IDENTIFIER_NUMBER" VARCHAR2(20 BYTE), 
	"PROVIDER_NPI" VARCHAR2(20 BYTE), 
	"CLAIM_IDENTIFIER" VARCHAR2(20 BYTE), 
	"CLAIM_SERVICE_DATE" DATE, 
	"PAYER_CLAIM_CONTROL_NUMBER" VARCHAR2(20 BYTE), 
	"ATTACHMENT_CONTROL_NUMBER" VARCHAR2(20 BYTE), 
	"ATTACHMENT_NAME" VARCHAR2(60 BYTE), 
	"ATTACHMENT_TYPE" VARCHAR2(10 BYTE), 
	"LOINC_CODE" VARCHAR2(100 BYTE), 
	"STATUS" VARCHAR2(10 BYTE), 
	"VER" NUMBER(10,0) DEFAULT 1
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table CLAIM_CONTACT
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."CLAIM_CONTACT" 
   (	"CONTACTUSERID" NUMBER, 
	"CONTACTEMAIL" VARCHAR2(350 BYTE), 
	"DATECREATED" DATE, 
	"DATEMODIFIED" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table CLAIM_DATE
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."CLAIM_DATE" 
   (	"ATTACHMENT_ID" NUMBER(10,0), 
	"LOOP_ID" VARCHAR2(60 BYTE), 
	"CLAIM_KEY" VARCHAR2(60 BYTE), 
	"BATCH_ID" VARCHAR2(300 BYTE), 
	"REC_NUM" NUMBER(10,0), 
	"DTP01" VARCHAR2(60 BYTE), 
	"DTP02" VARCHAR2(60 BYTE), 
	"DTP03" VARCHAR2(60 BYTE), 
	"CLAIM_DATE_ID" NUMBER
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table CLAIM_SUBMISSION
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."CLAIM_SUBMISSION" 
   (	"SUBMISSIONID" NUMBER, 
	"CONTACTUSERID" NUMBER, 
	"HCCS_ID" NUMBER, 
	"LOINC_ID" NUMBER, 
	"LOINC_MOD_ID" NUMBER, 
	"TRN02CPE_PDI" VARCHAR2(15 CHAR), 
	"TRN02FPPS_CLAIM_ID" NUMBER, 
	"HL1NM103PYR_NM" VARCHAR2(250 BYTE), 
	"HL1NM109PYR_ID" VARCHAR2(350 BYTE), 
	"HL2NM103INF_RCVR" VARCHAR2(250 BYTE), 
	"HL1PER04VAMCCNTEM" VARCHAR2(250 BYTE), 
	"HL3NM103SVCBILLPRVNM" VARCHAR2(250 BYTE), 
	"HL3NM109PRVNPI" VARCHAR2(350 BYTE), 
	"HL2NM109SVCPRVTIN" VARCHAR2(350 BYTE), 
	"HL4NM103PTLSTNM" VARCHAR2(250 BYTE), 
	"HL4NM104PTFTNM" VARCHAR2(150 BYTE), 
	"HL4NM109PTID" VARCHAR2(350 BYTE), 
	"REF102PTCTRLNMBR" VARCHAR2(200 BYTE), 
	"TRN02PYRCLMCTRLNMBR" VARCHAR2(250 BYTE), 
	"REF202BILLTYPE" VARCHAR2(250 BYTE), 
	"REF402CLRNGHSID" VARCHAR2(250 BYTE), 
	"REF302MEDRECNMBR" VARCHAR2(250 BYTE), 
	"DTP203RESPONSEDUEDATE" DATE, 
	"DTP103SVCFRMDT" DATE, 
	"DTP103SVCTODT" DATE, 
	"SUBMISSION_STATUS" VARCHAR2(50 BYTE), 
	"GENERATE277_STATUS" VARCHAR2(50 BYTE), 
	"DATECREATED" DATE, 
	"DATESUBMITTED" DATE, 
	"DATEMODIFIED" DATE, 
	"N3RSPCNTADDRSLN" VARCHAR2(350 BYTE), 
	"N3RSPCNTADDLADDRLN" VARCHAR2(350 BYTE), 
	"N4RSPCNTCITY" VARCHAR2(200 BYTE), 
	"N4RSPCNTSTCD" VARCHAR2(10 BYTE), 
	"N4RSPCNTZPCD" VARCHAR2(50 BYTE), 
	"N4RSPCNTCTRYCD" VARCHAR2(200 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table CLAIM_SUBMISSION_NOTE
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."CLAIM_SUBMISSION_NOTE" 
   (	"CLAIM_SUBMISSION_NOTE_ID" NUMBER, 
	"CLAIM_SUBMISSION_ID" NUMBER, 
	"CLAIM_SUBMISSION_NOTE" VARCHAR2(1000 BYTE), 
	"CLAIM_SUBMISSION_OLD_STATUS" VARCHAR2(50 CHAR), 
	"CLAIM_SUBMISSION_NEW_STATUS" VARCHAR2(50 CHAR), 
	"CREATED_BY" VARCHAR2(30 CHAR), 
	"DATE_CREATED" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table CLAIM_SVC_LINES
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."CLAIM_SVC_LINES" 
   (	"SUBMISSIONSVCLINEID" NUMBER, 
	"SUBMISSIONID" NUMBER, 
	"REF02SVCLNNMBR" VARCHAR2(200 BYTE), 
	"DTP03SVCFRMDT" DATE, 
	"DTP03SVCTODT" DATE, 
	"SVC01REVCD" VARCHAR2(200 BYTE), 
	"SVC01PROCCD" VARCHAR2(200 BYTE), 
	"SVC01MOD" VARCHAR2(11 BYTE), 
	"SVC02CHRGAMT" NUMBER(19,4), 
	"DATECREATED" DATE, 
	"DATEMODIFIED" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table CONTACT
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."CONTACT" 
   (	"ATTACHMENT_ID" NUMBER(10,0), 
	"LOOP_ID" VARCHAR2(60 BYTE), 
	"CLAIM_KEY" VARCHAR2(60 BYTE), 
	"BATCH_ID" VARCHAR2(300 BYTE), 
	"PER01" VARCHAR2(60 BYTE), 
	"PER02" VARCHAR2(60 BYTE), 
	"PER03" VARCHAR2(60 BYTE), 
	"PER04" VARCHAR2(60 BYTE), 
	"PER05" VARCHAR2(60 BYTE), 
	"PER06" VARCHAR2(60 BYTE), 
	"PER07" VARCHAR2(60 BYTE), 
	"PER08" VARCHAR2(60 BYTE), 
	"CONTACT_ID" NUMBER
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table DOCUMENT_CATEGORY
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."DOCUMENT_CATEGORY" 
   (	"ATTACHMENT_ID" NUMBER(10,0), 
	"LOOP_ID" VARCHAR2(60 BYTE), 
	"CLAIM_KEY" VARCHAR2(60 BYTE), 
	"BATCH_ID" VARCHAR2(300 BYTE), 
	"CAT01" VARCHAR2(60 BYTE), 
	"CAT02" VARCHAR2(60 BYTE), 
	"CAT03" VARCHAR2(60 BYTE), 
	"EF101" VARCHAR2(60 BYTE), 
	"DOCUMENT_CATEGORYID" NUMBER
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table EMAIL_TEMPLATES
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."EMAIL_TEMPLATES" 
   (	"EMAIL_TEMPLATE_ID" NUMBER, 
	"EMAIL_TEMPLATE_HEADER" VARCHAR2(250 BYTE), 
	"EMAIL_TEMPLATE_BODY" VARCHAR2(250 BYTE), 
	"EMAIL_TEMPLATE_TYPE" VARCHAR2(250 BYTE), 
	"DATEMODIFIED" DATE, 
	"MODIFIEDBY" VARCHAR2(50 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table ENTITYADDRESS
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."ENTITYADDRESS" 
   (	"ATTACHMENT_ID" NUMBER(10,0), 
	"LOOP_ID" VARCHAR2(60 BYTE), 
	"CLAIM_KEY" VARCHAR2(60 BYTE), 
	"BATCH_ID" VARCHAR2(300 BYTE), 
	"N301" VARCHAR2(60 BYTE), 
	"N302" VARCHAR2(60 BYTE), 
	"N401" VARCHAR2(60 BYTE), 
	"N402" VARCHAR2(60 BYTE), 
	"N403" VARCHAR2(60 BYTE), 
	"N404" VARCHAR2(60 BYTE), 
	"N407" VARCHAR2(60 BYTE), 
	"ENTITYADDRESSID" NUMBER
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table ENTITYNAME
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."ENTITYNAME" 
   (	"ATTACHMENT_ID" NUMBER(10,0), 
	"LOOP_ID" VARCHAR2(60 BYTE), 
	"CLAIM_KEY" VARCHAR2(60 BYTE), 
	"BATCH_ID" VARCHAR2(300 BYTE), 
	"NM101" VARCHAR2(60 BYTE), 
	"NM102" VARCHAR2(60 BYTE), 
	"NM103" VARCHAR2(60 BYTE), 
	"NM104" VARCHAR2(60 BYTE), 
	"NM105" VARCHAR2(60 BYTE), 
	"NM106" VARCHAR2(60 BYTE), 
	"NM107" VARCHAR2(60 BYTE), 
	"NM108" VARCHAR2(60 BYTE), 
	"NM109" VARCHAR2(60 BYTE), 
	"PRV01" VARCHAR2(2 BYTE), 
	"PRV02" VARCHAR2(3 BYTE), 
	"PRV03" VARCHAR2(50 BYTE), 
	"ENTITYNAMEID" NUMBER
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table EREPOSDATA
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."EREPOSDATA" 
   (	"DEBUG" CHAR(1 BYTE), 
	"ATTACHMENT_ID" NUMBER, 
	"CLAIM_KEY" VARCHAR2(300 BYTE), 
	"REPORTCODE" VARCHAR2(20 BYTE), 
	"PAYERCLAIMCONTROLNUMBER" VARCHAR2(200 BYTE), 
	"EXTERNALCLAIMID" VARCHAR2(200 BYTE), 
	"EREPOSDATA_ID" NUMBER
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table HCCS_CD
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."HCCS_CD" 
   (	"HCCS_ID" NUMBER, 
	"STCHCCSTATUSCAT_CD" VARCHAR2(35 BYTE), 
	"STCHCCSTATUSCAT_CD_DESC" VARCHAR2(2000 BYTE), 
	"ISACTIVE" CHAR(1 BYTE) DEFAULT '1', 
	"DATECREATED" DATE, 
	"DATEMODIFIED" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table LOINC_CD
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."LOINC_CD" 
   (	"LOINC_ID" NUMBER, 
	"STCLOINC_CD" VARCHAR2(35 BYTE), 
	"STCLOINC_CD_DESC" VARCHAR2(2000 BYTE), 
	"ISACTIVE" CHAR(1 BYTE) DEFAULT '1', 
	"DATECREATED" DATE, 
	"DATEMODIFIED" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table LOINC_MOD_CD
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."LOINC_MOD_CD" 
   (	"LOINC_MOD_ID" NUMBER, 
	"STCLOINC_CD_MOD" VARCHAR2(35 BYTE), 
	"STCLOINC_CD_MOD_DESC" VARCHAR2(2000 BYTE), 
	"ISACTIVE" CHAR(1 BYTE) DEFAULT '1', 
	"DATECREATED" DATE, 
	"DATEMODIFIED" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table OAUTH_CLIENT_AUTHORITIES
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."OAUTH_CLIENT_AUTHORITIES" 
   (	"USERNAME" VARCHAR2(50 BYTE), 
	"AUTHORITY" VARCHAR2(50 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table OAUTH_CLIENT_INFO
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."OAUTH_CLIENT_INFO" 
   (	"USERNAME" VARCHAR2(50 BYTE), 
	"PASSWORD" VARCHAR2(50 BYTE), 
	"ENABLED" NUMBER(1,0), 
	"CREATED_BY" VARCHAR2(30 BYTE), 
	"DATE_CREATED" TIMESTAMP (6), 
	"DESCRIPTION" VARCHAR2(60 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table PATHS
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."PATHS" 
   (	"PATH_ID" NUMBER, 
	"ATTACHMENT_ID" NUMBER, 
	"PATH_STRING" VARCHAR2(1200 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table REFERENCE_IDENTIFICATION
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."REFERENCE_IDENTIFICATION" 
   (	"ATTACHMENT_ID" NUMBER(10,0), 
	"LOOP_ID" VARCHAR2(60 BYTE), 
	"CLAIM_KEY" VARCHAR2(60 BYTE), 
	"BATCH_ID" VARCHAR2(300 BYTE), 
	"REC_NUM" NUMBER(10,0), 
	"REF01" VARCHAR2(60 BYTE), 
	"REF02" VARCHAR2(60 BYTE), 
	"REF03" VARCHAR2(60 BYTE), 
	"REF04" VARCHAR2(60 BYTE), 
	"REFERENCE_IDENTIFICATION_ID" NUMBER
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table SSO_AUTHENTICATION
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."SSO_AUTHENTICATION" 
   (	"GUID" VARCHAR2(36 BYTE), 
	"SESSIONID" VARCHAR2(50 BYTE), 
	"NTNAME" VARCHAR2(20 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 0 PCTUSED 0 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" 
  PARALLEL 2 ;
--------------------------------------------------------
--  DDL for Table STATUS_INFORMATION
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."STATUS_INFORMATION" 
   (	"ATTACHMENT_ID" NUMBER(10,0), 
	"LOOP_ID" VARCHAR2(60 BYTE), 
	"CLAIM_KEY" VARCHAR2(60 BYTE), 
	"BATCH_ID" VARCHAR2(300 BYTE), 
	"STC01_1" VARCHAR2(60 BYTE), 
	"STC01_2" VARCHAR2(60 BYTE), 
	"STC01_3" VARCHAR2(60 BYTE), 
	"STC01_4" VARCHAR2(60 BYTE), 
	"STC10_1" VARCHAR2(60 BYTE), 
	"STC10_2" VARCHAR2(60 BYTE), 
	"STC10_3" VARCHAR2(60 BYTE), 
	"STC10_4" VARCHAR2(60 BYTE), 
	"STC11_1" VARCHAR2(60 BYTE), 
	"STC11_2" VARCHAR2(60 BYTE), 
	"STC11_3" VARCHAR2(60 BYTE), 
	"STC11_4" VARCHAR2(60 BYTE), 
	"STATUS_INFORMATION_ID" NUMBER
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table TRACE_NUMBER
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."TRACE_NUMBER" 
   (	"ATTACHMENT_ID" NUMBER(10,0), 
	"TRN01" VARCHAR2(60 BYTE), 
	"TRN02" VARCHAR2(60 BYTE), 
	"TRACENUMBERID" NUMBER
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table TRANSACTIONS
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."TRANSACTIONS" 
   (	"ATTACHMENT_ID" NUMBER(10,0), 
	"LOOP_ID" VARCHAR2(60 BYTE), 
	"CLAIM_KEY" VARCHAR2(60 BYTE), 
	"BATCH_ID" VARCHAR2(300 BYTE), 
	"ATTACHMENT_MOVED" NUMBER(10,0), 
	"REPORT_CODE" VARCHAR2(20 BYTE), 
	"ATTACHMENT_NAME" VARCHAR2(120 BYTE), 
	"ATTACHMENT_TYPE" VARCHAR2(20 BYTE), 
	"EXTERNAL_CLAIM_ID" VARCHAR2(60 BYTE), 
	"PAYER_CLAIM_CONTROL_NUMBER" VARCHAR2(50 BYTE), 
	"STATUS" VARCHAR2(60 BYTE), 
	"ST01" VARCHAR2(60 BYTE), 
	"ST02" VARCHAR2(60 BYTE), 
	"ST03" VARCHAR2(60 BYTE), 
	"SE01" VARCHAR2(60 BYTE), 
	"SE02" VARCHAR2(60 BYTE), 
	"BGN01" VARCHAR2(60 BYTE), 
	"BGN02" VARCHAR2(60 BYTE), 
	"BGN03" VARCHAR2(60 BYTE), 
	"TRANS_TIMESTMP" TIMESTAMP (3), 
	"LX01" VARCHAR2(10 BYTE), 
	"PATIENT_DOB" DATE, 
	"VA_FACILITY_CD" VARCHAR2(12 BYTE), 
	"TRANSACTIONS_ID" NUMBER
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Table ZIPCODE
--------------------------------------------------------

  CREATE TABLE "ARS277_REQUEST_TRACKING"."ZIPCODE" 
   (	"ZIP_CODE" VARCHAR2(10 BYTE), 
	"FIPS_STATE_CODE" VARCHAR2(2 BYTE), 
	"FIPS_COUNTY_CODE" VARCHAR2(3 BYTE), 
	"URBAN_INDICATOR" VARCHAR2(10 BYTE), 
	"ACTIVE_FLAG" VARCHAR2(1 BYTE), 
	"VA_FACILITY_CD" VARCHAR2(12 BYTE), 
	"CREATED_BY" VARCHAR2(30 BYTE), 
	"DATE_CREATED" TIMESTAMP (3), 
	"MODIFIED_BY" VARCHAR2(30 BYTE), 
	"DATE_MODIFIED" TIMESTAMP (3)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Sequence ARS_ROLE_PERMISSIONS_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."ARS_ROLE_PERMISSIONS_SEQ"  MINVALUE 1 MAXVALUE 999999999999999 INCREMENT BY 1 START WITH 117 NOCACHE  ORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence ARS_ROLE_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."ARS_ROLE_SEQ"  MINVALUE 1 MAXVALUE 999999999999999 INCREMENT BY 1 START WITH 102 NOCACHE  ORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence ARS_USER_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."ARS_USER_SEQ"  MINVALUE 1 MAXVALUE 999999999999999 INCREMENT BY 1 START WITH 102 NOCACHE  ORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence ATTACHMENT_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."ATTACHMENT_ID_SEQ"  MINVALUE -9223372036854775808 MAXVALUE 9223372036854775807 INCREMENT BY 1 START WITH 620 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence BINARY_275_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."BINARY_275_SEQ"  MINVALUE -9223372036854775808 MAXVALUE 9223372036854775807 INCREMENT BY 1 START WITH 221 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence CLAIM_CONTACT_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."CLAIM_CONTACT_SEQ"  MINVALUE 1 MAXVALUE 999999999999999999999999999 INCREMENT BY 1 START WITH 309 NOCACHE  ORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence CLAIM_DATE_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."CLAIM_DATE_SEQ"  MINVALUE -9223372036854775808 MAXVALUE 9223372036854775807 INCREMENT BY 1 START WITH 900 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence CLAIM_SUBMISSION_NOTE_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."CLAIM_SUBMISSION_NOTE_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 176 NOCACHE  ORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence CLAIM_SUBMISSION_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."CLAIM_SUBMISSION_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 941 NOCACHE  ORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence CLAIM_SUBMISSION_SUBMISSIONID
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."CLAIM_SUBMISSION_SUBMISSIONID"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 NOCACHE  ORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence CLAIM_SVC_LINES_SUBMISSIONSVCL
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."CLAIM_SVC_LINES_SUBMISSIONSVCL"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 862 NOCACHE  ORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence CONTACT_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."CONTACT_SEQ"  MINVALUE -9223372036854775808 MAXVALUE 9223372036854775807 INCREMENT BY 1 START WITH 400 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence DOCUMENT_CATEGORY_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."DOCUMENT_CATEGORY_SEQ"  MINVALUE -9223372036854775808 MAXVALUE 9223372036854775807 INCREMENT BY 1 START WITH 620 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence EMAIL_TEMPLATE_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."EMAIL_TEMPLATE_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 7 NOCACHE  ORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence ENTITY_ADDRESS_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."ENTITY_ADDRESS_SEQ"  MINVALUE -9223372036854775808 MAXVALUE 9223372036854775807 INCREMENT BY 1 START WITH 620 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence ENTITY_NAME_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."ENTITY_NAME_SEQ"  MINVALUE -9223372036854775808 MAXVALUE 9223372036854775807 INCREMENT BY 1 START WITH 1260 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence EREPOSDATA_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."EREPOSDATA_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 NOCACHE  NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence HCCS_CD_HCCS_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."HCCS_CD_HCCS_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 141 NOCACHE  ORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence LOINC_CD_LOINC_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."LOINC_CD_LOINC_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 138 NOCACHE  ORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence LOINC_MOD_CD_LOINC_MOD_ID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."LOINC_MOD_CD_LOINC_MOD_ID_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 122 NOCACHE  ORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PATH_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."PATH_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 240 NOCACHE  NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence REFERENCE_IDENTIFICATION_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."REFERENCE_IDENTIFICATION_SEQ"  MINVALUE -9223372036854775808 MAXVALUE 9223372036854775807 INCREMENT BY 1 START WITH 1080 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence STATUS_INFORMATION_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."STATUS_INFORMATION_SEQ"  MINVALUE -9223372036854775808 MAXVALUE 9223372036854775807 INCREMENT BY 1 START WITH 400 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence TRACE_NUMBER_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."TRACE_NUMBER_SEQ"  MINVALUE -9223372036854775808 MAXVALUE 9223372036854775807 INCREMENT BY 1 START WITH 640 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence TRANSACTIONS_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "ARS277_REQUEST_TRACKING"."TRANSACTIONS_SEQ"  MINVALUE -9223372036854775808 MAXVALUE 9223372036854775807 INCREMENT BY 1 START WITH 620 CACHE 20 NOORDER  NOCYCLE ;
REM INSERTING into ARS277_REQUEST_TRACKING.ARSAUDITLOG
SET DEFINE OFF;
REM INSERTING into ARS277_REQUEST_TRACKING.ARSREPORTTYPE
SET DEFINE OFF;
REM INSERTING into ARS277_REQUEST_TRACKING.ARS_ROLE
SET DEFINE OFF;
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE (ARS_ROLE_ID,ROLE_NAME,DESCRIPTION,CREATED_BY,DATE_CREATED) values (100,'BASE_USER','Regular User of Application','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE (ARS_ROLE_ID,ROLE_NAME,DESCRIPTION,CREATED_BY,DATE_CREATED) values (101,'ADMIN','Administrator','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
REM INSERTING into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS
SET DEFINE OFF;
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS (PERMISSION_ID,PAGE_NAME,PERMISSION_NAME,ARS_ROLE_ID,ENABLED,CREATED_BY,DATE_CREATED) values (100,'additionalInformation','populateInfo',100,'Y','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS (PERMISSION_ID,PAGE_NAME,PERMISSION_NAME,ARS_ROLE_ID,ENABLED,CREATED_BY,DATE_CREATED) values (101,'additionalInformation','populateInfo',101,'Y','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS (PERMISSION_ID,PAGE_NAME,PERMISSION_NAME,ARS_ROLE_ID,ENABLED,CREATED_BY,DATE_CREATED) values (102,'additionalInformation','submitInfo',100,'Y','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS (PERMISSION_ID,PAGE_NAME,PERMISSION_NAME,ARS_ROLE_ID,ENABLED,CREATED_BY,DATE_CREATED) values (103,'additionalInformation','submitInfo',101,'Y','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS (PERMISSION_ID,PAGE_NAME,PERMISSION_NAME,ARS_ROLE_ID,ENABLED,CREATED_BY,DATE_CREATED) values (104,'lookup','search',100,'Y','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS (PERMISSION_ID,PAGE_NAME,PERMISSION_NAME,ARS_ROLE_ID,ENABLED,CREATED_BY,DATE_CREATED) values (105,'lookup','search',101,'Y','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS (PERMISSION_ID,PAGE_NAME,PERMISSION_NAME,ARS_ROLE_ID,ENABLED,CREATED_BY,DATE_CREATED) values (106,'lookup','viewSubmission',100,'Y','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS (PERMISSION_ID,PAGE_NAME,PERMISSION_NAME,ARS_ROLE_ID,ENABLED,CREATED_BY,DATE_CREATED) values (107,'lookup','viewSubmission',101,'Y','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS (PERMISSION_ID,PAGE_NAME,PERMISSION_NAME,ARS_ROLE_ID,ENABLED,CREATED_BY,DATE_CREATED) values (108,'viewSubmission','updateRfai',100,'Y','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS (PERMISSION_ID,PAGE_NAME,PERMISSION_NAME,ARS_ROLE_ID,ENABLED,CREATED_BY,DATE_CREATED) values (109,'viewSubmission','updateRfai',101,'Y','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS (PERMISSION_ID,PAGE_NAME,PERMISSION_NAME,ARS_ROLE_ID,ENABLED,CREATED_BY,DATE_CREATED) values (110,'viewSubmission','saveUpdates',100,'Y','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS (PERMISSION_ID,PAGE_NAME,PERMISSION_NAME,ARS_ROLE_ID,ENABLED,CREATED_BY,DATE_CREATED) values (111,'viewSubmission','saveUpdates',101,'Y','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS (PERMISSION_ID,PAGE_NAME,PERMISSION_NAME,ARS_ROLE_ID,ENABLED,CREATED_BY,DATE_CREATED) values (112,'viewSubmission','printRfai',100,'Y','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS (PERMISSION_ID,PAGE_NAME,PERMISSION_NAME,ARS_ROLE_ID,ENABLED,CREATED_BY,DATE_CREATED) values (113,'viewSubmission','printRfai',101,'Y','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_ROLE_PERMISSIONS (PERMISSION_ID,PAGE_NAME,PERMISSION_NAME,ARS_ROLE_ID,ENABLED,CREATED_BY,DATE_CREATED) values (116,'admin','submitChanges',101,'Y','ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
REM INSERTING into ARS277_REQUEST_TRACKING.ARS_USER
SET DEFINE OFF;
Insert into ARS277_REQUEST_TRACKING.ARS_USER (ARS_USER_ID,USER_NAME,ENABLED,LAST_NAME,FIRST_NAME,MIDDLE_NAME,PHONE_NUMBER,EMAIL_ADDRESS,LAST_LOGIN_DATE,DEACTIVATION_REASON_CD,DEACTIVATION_COMMENTS,CREATED_BY,DATE_CREATED,MODIFIED_BY,DATE_MODIFIED) values (100,'AI','Y','User','Base','NM',null,'URL',to_date('13-MAR-18','DD-MON-RR'),null,null,'ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'),null,null);
Insert into ARS277_REQUEST_TRACKING.ARS_USER (ARS_USER_ID,USER_NAME,ENABLED,LAST_NAME,FIRST_NAME,MIDDLE_NAME,PHONE_NUMBER,EMAIL_ADDRESS,LAST_LOGIN_DATE,DEACTIVATION_REASON_CD,DEACTIVATION_COMMENTS,CREATED_BY,DATE_CREATED,MODIFIED_BY,DATE_MODIFIED) values (101,'AI','Y','Admin','Super','User',null,'URL',to_date('13-MAR-18','DD-MON-RR'),null,null,'ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'),null,null);
REM INSERTING into ARS277_REQUEST_TRACKING.ARS_USER_ROLE_USAGES
SET DEFINE OFF;
Insert into ARS277_REQUEST_TRACKING.ARS_USER_ROLE_USAGES (ARS_ROLE_ID,ARS_USER_ID,CREATED_BY,DATE_CREATED) values (100,100,'ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_USER_ROLE_USAGES (ARS_ROLE_ID,ARS_USER_ID,CREATED_BY,DATE_CREATED) values (100,101,'ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.ARS_USER_ROLE_USAGES (ARS_ROLE_ID,ARS_USER_ID,CREATED_BY,DATE_CREATED) values (101,101,'ARS_ADMIN',to_date('07-FEB-18','DD-MON-RR'));
REM INSERTING into ARS277_REQUEST_TRACKING.BINARY275
SET DEFINE OFF;
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (552,7888,153);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (553,7404,154);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (554,116144,155);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (555,26275,156);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (556,26270,157);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (557,26275,158);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (558,26275,159);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (559,936843,160);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (560,26275,161);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (561,114024,162);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (562,478202,163);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (563,355562,164);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (564,26275,165);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (550,7888,151);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (551,7888,152);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (565,7888,166);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (566,7888,167);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (567,7888,168);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (568,7404,169);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (569,116144,170);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (570,26275,171);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (571,26270,172);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (572,26275,173);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (573,26275,174);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (574,936843,175);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (575,26275,176);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (576,114024,177);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (577,478202,178);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (578,355562,179);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (579,26275,180);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (580,237289,181);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (581,71531,182);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (582,7888,183);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (583,7888,184);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (584,7888,185);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (585,7404,186);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (586,116144,187);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (587,26275,188);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (588,26270,189);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (589,26275,190);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (590,26275,191);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (591,936843,192);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (592,26275,193);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (593,114024,194);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (594,478202,195);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (595,355562,196);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (596,26275,197);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (597,7888,198);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (598,7888,199);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (599,7888,200);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (600,7404,201);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (601,116144,202);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (602,26275,203);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (603,26270,204);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (604,26275,205);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (605,26275,206);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (606,936843,207);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (607,26275,208);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (608,114024,209);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (609,478202,210);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (610,355562,211);
Insert into ARS277_REQUEST_TRACKING.BINARY275 (ATTACHMENT_ID,BIN01,BINARY275ID) values (611,26275,212);
REM INSERTING into ARS277_REQUEST_TRACKING.CLAIMATTACHMENTS
SET DEFINE OFF;
REM INSERTING into ARS277_REQUEST_TRACKING.CLAIM_CONTACT
SET DEFINE OFF;
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII             ',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII                           ',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (2,'test@nowhere.com',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII              ',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII              ',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII              ',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII              ',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII              ',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII              ',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII              ',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII              ',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII              ',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (62,'test3@nowhere.com',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (63,'test2@nowhere.com',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII                         ',to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (114,'test@test.gov',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (115,'q@q.com',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (116,'contact',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (117,'test@test1.gov',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (118,'Test@test.com',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (119,'conta',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (120,'q@q.in',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (121,'q@q.us',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (122,'q@q.nz',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (123,'q@q.mn',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (124,'a@a.com',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (125,'a@a.in',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (126,'sddfgsdf',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (127,'fhsfhsfgh',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (128,'a@a.us',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (129,'a@a.nz',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (130,'a@a.mn',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (131,'b@b.com',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (132,'b@b.in',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (133,'Test@Test.com',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (134,'we@we',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (135,'b@b.us',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (136,'b@b.nz',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (137,'b@b.mn',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (138,'c@c.com',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (139,'c@c.in',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (140,'c@c.mn',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (141,'c@c.us',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (142,'dragon@vamsijson.gov',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (143,'c@c.nz',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (144,'d@d.com',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (145,'d@d.in',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (146,'d@d.us',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (147,'d@d.mn',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (148,'d@d.nz',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (149,'e@e.com',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (150,'e@e.in',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (151,'e@e.us',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (152,'e@e.nz',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (153,'f@f.com',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (154,'f@f.in',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (155,'f@f.us',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (156,'f@f.mn',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (157,'f@f.nz',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (158,'Test2@test.com',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (159,'Test3@test.com',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (160,'g@g.com',to_date('17-JAN-18','DD-MON-RR'),to_date('17-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII                            ',to_date('17-JAN-18','DD-MON-RR'),to_date('17-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (162,'g@g.in',to_date('17-JAN-18','DD-MON-RR'),to_date('17-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (163,'g@g.us',to_date('18-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (164,'dragontest@this.again',to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (165,'g@g.nz',to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (166,'g@g.mn',to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (167,null,to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (168,'s@s.us',to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (169,'s@s.in',to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (170,'s@s.com',to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (171,'r@r.mn',to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (172,'h@h.com',to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (173,'h@h.in',to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (174,'h@h.us',to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (175,'h@h.nz',to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (176,'h@h.mn',to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (177,'i@i.com',to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (178,'i@i.in',to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (179,'i@i.us',to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (180,'i@i.mn',to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (181,'i@i.nz',to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (182,'j@j.com',to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (183,'j@j.in',to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (184,'j@j.us',to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (185,'j@j.mn',to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (186,'j@j.nz',to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII                     ',to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (188,'k@k.com',to_date('31-JAN-18','DD-MON-RR'),to_date('31-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (189,'k@k.in',to_date('31-JAN-18','DD-MON-RR'),to_date('31-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (190,'k@k.us',to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (191,'k@k.nz',to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (192,'k@k.mn',to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (193,'l@l.com',to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (194,'l@l.in',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (195,'l@l.us',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (196,'l@l.nz',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (197,'l@l.mn',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (198,'m@m.com',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (199,'charlie.stone@ftc.com',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (200,'m@m.in',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (201,'m@m.us',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (202,'m@m.nz',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (203,'m@m.mn',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (204,'n@n.com',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (205,'n@n.in',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (206,'n@n.mn',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (207,'TESTER@TEST.COM',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (208,'n@n.us',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (209,'n@n.nz',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (210,'o@o.com',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (211,'test@test.COM',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (212,'TEST@test.COM',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (213,'testing',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (214,'o@o.in',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (215,'o@o.us',to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (216,'TeSt',to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (217,'test',to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (218,'TEST',to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (219,'o@o.nz',to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (220,'o@o.mn',to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (221,'p@p.com',to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (222,'test@testing123.com',to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (223,'p@p.in',to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (224,'p@p.us',to_date('11-FEB-18','DD-MON-RR'),to_date('11-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (225,'p@p.nz',to_date('11-FEB-18','DD-MON-RR'),to_date('11-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (226,'p@p.mn',to_date('11-FEB-18','DD-MON-RR'),to_date('11-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (227,'green.maroon@gmail.com',to_date('11-FEB-18','DD-MON-RR'),to_date('11-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (228,'r@r.com',to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (229,'testing.new@gmail.com',to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (230,'r@r.in',to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (231,'r@r.us',to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (232,'r@r.nz',to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (233,'xxxxxxxxxxxxxxxxxxxxxxxxxxxxx',to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (234,'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (235,'test@test.com',to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (236,'s@s.mn',to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (237,'e@e.mn',to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (238,'qwer@qw.com',to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (239,'hello@test.com',to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (240,null,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (241,null,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (242,null,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (243,'contact@information.com',to_date('13-FEB-18','DD-MON-RR'),to_date('13-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (244,'contactinfo@info.com',to_date('13-FEB-18','DD-MON-RR'),to_date('13-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (245,null,to_date('13-FEB-18','DD-MON-RR'),to_date('13-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (246,null,to_date('13-FEB-18','DD-MON-RR'),to_date('13-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (247,null,to_date('13-FEB-18','DD-MON-RR'),to_date('13-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (248,'domain@email.com',to_date('14-FEB-18','DD-MON-RR'),to_date('14-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (249,'dsdfdsfgd',to_date('14-FEB-18','DD-MON-RR'),to_date('14-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (250,null,to_date('14-FEB-18','DD-MON-RR'),to_date('14-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (251,null,to_date('14-FEB-18','DD-MON-RR'),to_date('14-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (252,null,to_date('14-FEB-18','DD-MON-RR'),to_date('14-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (253,null,to_date('14-FEB-18','DD-MON-RR'),to_date('14-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (254,null,to_date('14-FEB-18','DD-MON-RR'),to_date('14-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII                     ',to_date('15-FEB-18','DD-MON-RR'),to_date('15-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (256,null,to_date('15-FEB-18','DD-MON-RR'),to_date('15-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (257,null,to_date('15-FEB-18','DD-MON-RR'),to_date('15-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (258,null,to_date('15-FEB-18','DD-MON-RR'),to_date('15-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (259,null,to_date('15-FEB-18','DD-MON-RR'),to_date('15-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (260,null,to_date('15-FEB-18','DD-MON-RR'),to_date('15-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (261,'ccxc',to_date('15-FEB-18','DD-MON-RR'),to_date('15-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (262,null,to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (263,null,to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (264,null,to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII                 ',to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII                     ',to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (267,'zzz@zzz.com',to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII                      ',to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (269,null,to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (270,null,to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (271,null,to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (272,null,to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (273,null,to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (274,null,to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII            ',to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (276,'va@va.com',to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (277,'test120@test.com',to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (278,null,to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (279,null,to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (280,null,to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (281,null,to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (282,'va@test.gov',to_date('16-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (283,'va@gov',to_date('20-FEB-18','DD-MON-RR'),to_date('20-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (284,'test@gov',to_date('20-FEB-18','DD-MON-RR'),to_date('20-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (285,'cxvxc',to_date('20-FEB-18','DD-MON-RR'),to_date('20-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (286,'xfbvxc',to_date('20-FEB-18','DD-MON-RR'),to_date('20-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (287,'hello1@test.com',to_date('20-FEB-18','DD-MON-RR'),to_date('20-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (288,'xxx',to_date('20-FEB-18','DD-MON-RR'),to_date('20-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (289,'test@test.test',to_date('20-FEB-18','DD-MON-RR'),to_date('20-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (290,'va@tesr',to_date('21-FEB-18','DD-MON-RR'),to_date('21-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (291,'v@r',to_date('21-FEB-18','DD-MON-RR'),to_date('21-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (292,'v@t',to_date('21-FEB-18','DD-MON-RR'),to_date('21-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (293,'v@e',to_date('22-FEB-18','DD-MON-RR'),to_date('22-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (294,'c@w',to_date('22-FEB-18','DD-MON-RR'),to_date('22-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (295,null,to_date('22-FEB-18','DD-MON-RR'),to_date('22-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (296,null,to_date('22-FEB-18','DD-MON-RR'),to_date('22-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (297,null,to_date('22-FEB-18','DD-MON-RR'),to_date('22-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (298,'r@gb',to_date('22-FEB-18','DD-MON-RR'),to_date('22-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (299,'test@123test.com',to_date('22-FEB-18','DD-MON-RR'),to_date('22-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (300,'test@thisisatest.com',to_date('23-FEB-18','DD-MON-RR'),to_date('23-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII                       ',to_date('23-FEB-18','DD-MON-RR'),to_date('23-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (302,'test@testcontact.com',to_date('26-FEB-18','DD-MON-RR'),to_date('26-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII                    ',to_date('26-FEB-18','DD-MON-RR'),to_date('26-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (304,'testuser@test.test',to_date('26-FEB-18','DD-MON-RR'),to_date('26-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (305,'test@testuser.test',to_date('26-FEB-18','DD-MON-RR'),to_date('26-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII                         ',to_date('26-FEB-18','DD-MON-RR'),to_date('26-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values PII                         ',to_date('26-FEB-18','DD-MON-RR'),to_date('26-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_CONTACT (CONTACTUSERID,CONTACTEMAIL,DATECREATED,DATEMODIFIED) values (308,'anna.singh@va.com',to_date('27-FEB-18','DD-MON-RR'),to_date('27-FEB-18','DD-MON-RR'));
REM INSERTING into ARS277_REQUEST_TRACKING.CLAIM_DATE
SET DEFINE OFF;
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (550,'1000D',null,'275_TEST_572_TSET.txt',1,'472','D8','20130811',754);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (551,'2100B',null,'275_TEST_572_TSET.txt',3,'368','D8','20160604',755);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (551,'1000D',null,'275_TEST_572_TSET.txt',1,'472','D8','20130827',756);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (551,'2100A',null,'275_TEST_572_TSET.txt',2,'472','D8','20160303',757);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (552,'2100A',null,'275_TEST_572_TSET.txt',2,'472','D8','20160601',758);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (552,'1000D',null,'275_TEST_572_TSET.txt',1,'472','RD8','20160531-20160608',759);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (552,'2100B',null,'275_TEST_572_TSET.txt',3,'368','D8','20160708',760);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (553,'1000D',null,'275_TEST_572_TSET.txt',1,'472','RD8','20160508-20160508',761);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (553,'2100B',null,'275_TEST_572_TSET.txt',2,'368','D8','20160807',762);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (554,'2100B',null,'275_TEST_572_TSET.txt',2,'368','D8','20160606',763);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (554,'1000D',null,'275_TEST_572_TSET.txt',1,'472','RD8','20160505-20160506',764);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (555,'1000D',null,'275_TEST_572_TSET.txt',1,'472','RD8','20160608-20160608',765);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (555,'2100B',null,'275_TEST_572_TSET.txt',2,'368','D8','20150415',766);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (556,'2100B',null,'275_TEST_572_TSET.txt',2,'368','D8','20160712',767);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (556,'1000D',null,'275_TEST_572_TSET.txt',1,'472','D8','20160613',768);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (557,'1000D',null,'275_TEST_572_TSET.txt',1,'472','D8','20160511',769);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (557,'2100B',null,'275_TEST_572_TSET.txt',2,'368','D8','20160610',770);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (558,'2100B',null,'275_TEST_572_TSET.txt',2,'368','D8','20160714',771);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (558,'1000D',null,'275_TEST_572_TSET.txt',1,'472','RD8','20170614-20170614',772);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (559,'2100A',null,'275_TEST_572_TSET.txt',1,'472','D8','20160606',773);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (559,'2100B',null,'275_TEST_572_TSET.txt',2,'368','D8','20160705',774);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (560,'1000D',null,'275_TEST_572_TSET.txt',1,'472','RD8','20170512-20170512',775);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (560,'2100B',null,'275_TEST_572_TSET.txt',2,'368','D8','20160612',776);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (561,'2100B',null,'275_TEST_572_TSET.txt',2,'368','D8','20160712',777);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (561,'1000D',null,'275_TEST_572_TSET.txt',1,'472','RD8','20170612-20170612',778);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (562,'1000D',null,'275_TEST_572_TSET.txt',1,'472','D8','20160613',779);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (562,'2100B',null,'275_TEST_572_TSET.txt',3,'368','D8','20160715',780);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (562,'2100B',null,'275_TEST_572_TSET.txt',2,'368','D8','20160715',781);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (563,'1000D',null,'275_TEST_572_TSET.txt',1,'472','D8','20160613',782);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (563,'2100B',null,'275_TEST_572_TSET.txt',3,'368','D8','20160715',783);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (563,'2100B',null,'275_TEST_572_TSET.txt',2,'368','D8','20160715',784);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (564,'2100B',null,'275_TEST_572_TSET.txt',2,'368','D8','20160902',785);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (564,'1000D',null,'275_TEST_572_TSET.txt',1,'472','D8','20160303',786);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (550,'2100A',null,'275_TEST_572_TSET.txt',2,'472','D8','20160405',752);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (550,'2100B',null,'275_TEST_572_TSET.txt',3,'368','D8','20160604',753);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (565,'2100A',null,'Dragon1.txt',2,'472','D8','20160405',787);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (565,'1000D',null,'Dragon1.txt',1,'472','D8','20130811',788);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (565,'2100B',null,'Dragon1.txt',3,'368','D8','20160604',789);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (566,'2100B',null,'Dragon1.txt',3,'368','D8','20160604',790);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (566,'1000D',null,'Dragon1.txt',1,'472','D8','20130827',791);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (566,'2100A',null,'Dragon1.txt',2,'472','D8','20160303',792);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (567,'2100B',null,'Dragon1.txt',3,'368','D8','20160708',793);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (567,'2100A',null,'Dragon1.txt',2,'472','D8','20160601',794);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (567,'1000D',null,'Dragon1.txt',1,'472','RD8','20160531-20160608',795);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (568,'2100B',null,'Dragon1.txt',2,'368','D8','20160807',796);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (568,'1000D',null,'Dragon1.txt',1,'472','RD8','20160508-20160508',797);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (569,'1000D',null,'Dragon1.txt',1,'472','RD8','20160505-20160506',798);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (569,'2100B',null,'Dragon1.txt',2,'368','D8','20160606',799);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (570,'1000D',null,'Dragon1.txt',1,'472','RD8','20160608-20160608',800);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (570,'2100B',null,'Dragon1.txt',2,'368','D8','20150415',801);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (571,'2100B',null,'Dragon1.txt',2,'368','D8','20160712',802);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (571,'1000D',null,'Dragon1.txt',1,'472','D8','20160613',803);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (572,'2100B',null,'Dragon1.txt',2,'368','D8','20160610',804);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (572,'1000D',null,'Dragon1.txt',1,'472','D8','20160511',805);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (573,'1000D',null,'Dragon1.txt',1,'472','RD8','20170614-20170614',806);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (573,'2100B',null,'Dragon1.txt',2,'368','D8','20160714',807);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (574,'2100A',null,'Dragon1.txt',1,'472','D8','20160606',808);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (574,'2100B',null,'Dragon1.txt',2,'368','D8','20160705',809);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (575,'1000D',null,'Dragon1.txt',1,'472','RD8','20170512-20170512',810);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (575,'2100B',null,'Dragon1.txt',2,'368','D8','20160612',811);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (576,'1000D',null,'Dragon1.txt',1,'472','RD8','20170612-20170612',812);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (576,'2100B',null,'Dragon1.txt',2,'368','D8','20160712',813);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (577,'2100B',null,'Dragon1.txt',2,'368','D8','20160715',814);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (577,'1000D',null,'Dragon1.txt',1,'472','D8','20160613',815);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (577,'2100B',null,'Dragon1.txt',3,'368','D8','20160715',816);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (578,'2100B',null,'Dragon1.txt',2,'368','D8','20160715',817);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (578,'1000D',null,'Dragon1.txt',1,'472','D8','20160613',818);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (578,'2100B',null,'Dragon1.txt',3,'368','D8','20160715',819);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (579,'1000D',null,'Dragon1.txt',1,'472','D8','20160303',820);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (579,'2100B',null,'Dragon1.txt',2,'368','D8','20160902',821);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (580,'1000D',null,'Dragon2.txt',1,'472','D8','20180111',822);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (580,'2100B',null,'Dragon2.txt',2,'368','D8','20180221',823);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (581,'1000D',null,'Dragon2.txt',1,'472','D8','20180110',824);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (581,'2100B',null,'Dragon2.txt',2,'368','D8','20180221',825);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (582,'2100A',null,'Dragon3.txt',2,'472','D8','20160405',826);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (582,'2100B',null,'Dragon3.txt',3,'368','D8','20160604',827);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (582,'1000D',null,'Dragon3.txt',1,'472','D8','20130811',828);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (583,'2100B',null,'Dragon3.txt',3,'368','D8','20160604',829);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (583,'1000D',null,'Dragon3.txt',1,'472','D8','20130827',830);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (583,'2100A',null,'Dragon3.txt',2,'472','D8','20160303',831);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (584,'2100A',null,'Dragon3.txt',2,'472','D8','20160601',832);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (584,'1000D',null,'Dragon3.txt',1,'472','RD8','20160531-20160608',833);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (584,'2100B',null,'Dragon3.txt',3,'368','D8','20160708',834);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (585,'1000D',null,'Dragon3.txt',1,'472','RD8','20160508-20160508',835);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (585,'2100B',null,'Dragon3.txt',2,'368','D8','20160807',836);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (586,'2100B',null,'Dragon3.txt',2,'368','D8','20160606',837);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (586,'1000D',null,'Dragon3.txt',1,'472','RD8','20160505-20160506',838);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (587,'1000D',null,'Dragon3.txt',1,'472','RD8','20160608-20160608',839);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (587,'2100B',null,'Dragon3.txt',2,'368','D8','20150415',840);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (588,'2100B',null,'Dragon3.txt',2,'368','D8','20160712',841);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (588,'1000D',null,'Dragon3.txt',1,'472','D8','20160613',842);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (589,'1000D',null,'Dragon3.txt',1,'472','D8','20160511',843);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (589,'2100B',null,'Dragon3.txt',2,'368','D8','20160610',844);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (590,'2100B',null,'Dragon3.txt',2,'368','D8','20160714',845);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (590,'1000D',null,'Dragon3.txt',1,'472','RD8','20170614-20170614',846);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (591,'2100A',null,'Dragon3.txt',1,'472','D8','20160606',847);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (591,'2100B',null,'Dragon3.txt',2,'368','D8','20160705',848);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (592,'1000D',null,'Dragon3.txt',1,'472','RD8','20170512-20170512',849);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (592,'2100B',null,'Dragon3.txt',2,'368','D8','20160612',850);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (593,'2100B',null,'Dragon3.txt',2,'368','D8','20160712',851);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (593,'1000D',null,'Dragon3.txt',1,'472','RD8','20170612-20170612',852);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (594,'1000D',null,'Dragon3.txt',1,'472','D8','20160613',853);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (594,'2100B',null,'Dragon3.txt',3,'368','D8','20160715',854);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (594,'2100B',null,'Dragon3.txt',2,'368','D8','20160715',855);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (595,'1000D',null,'Dragon3.txt',1,'472','D8','20160613',856);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (595,'2100B',null,'Dragon3.txt',3,'368','D8','20160715',857);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (595,'2100B',null,'Dragon3.txt',2,'368','D8','20160715',858);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (596,'2100B',null,'Dragon3.txt',2,'368','D8','20160902',859);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (596,'1000D',null,'Dragon3.txt',1,'472','D8','20160303',860);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (597,'1000D',null,'275sCorrespondingTo837Pand837_TEST5.txt',1,'472','D8','20130811',861);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (597,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',3,'368','D8','20160604',862);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (597,'2100A',null,'275sCorrespondingTo837Pand837_TEST5.txt',2,'472','D8','20160405',863);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (598,'1000D',null,'275sCorrespondingTo837Pand837_TEST5.txt',1,'472','D8','20130827',864);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (598,'2100A',null,'275sCorrespondingTo837Pand837_TEST5.txt',2,'472','D8','20160303',865);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (598,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',3,'368','D8','20160604',866);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (599,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',3,'368','D8','20160708',867);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (599,'2100A',null,'275sCorrespondingTo837Pand837_TEST5.txt',2,'472','D8','20160601',868);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (599,'1000D',null,'275sCorrespondingTo837Pand837_TEST5.txt',1,'472','RD8','20160531-20160608',869);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (600,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',2,'368','D8','20160807',870);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (600,'1000D',null,'275sCorrespondingTo837Pand837_TEST5.txt',1,'472','RD8','20160508-20160508',871);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (601,'1000D',null,'275sCorrespondingTo837Pand837_TEST5.txt',1,'472','RD8','20160505-20160506',872);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (601,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',2,'368','D8','20160606',873);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (602,'1000D',null,'275sCorrespondingTo837Pand837_TEST5.txt',1,'472','RD8','20160608-20160608',874);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (602,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',2,'368','D8','20150415',875);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (603,'1000D',null,'275sCorrespondingTo837Pand837_TEST5.txt',1,'472','D8','20160613',876);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (603,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',2,'368','D8','20160712',877);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (604,'1000D',null,'275sCorrespondingTo837Pand837_TEST5.txt',1,'472','D8','20160511',878);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (604,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',2,'368','D8','20160610',879);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (605,'1000D',null,'275sCorrespondingTo837Pand837_TEST5.txt',1,'472','RD8','20170614-20170614',880);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (605,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',2,'368','D8','20160714',881);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (606,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',2,'368','D8','20160705',882);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (606,'2100A',null,'275sCorrespondingTo837Pand837_TEST5.txt',1,'472','D8','20160606',883);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (607,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',2,'368','D8','20160612',884);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (607,'1000D',null,'275sCorrespondingTo837Pand837_TEST5.txt',1,'472','RD8','20170512-20170512',885);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (608,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',2,'368','D8','20160712',886);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (608,'1000D',null,'275sCorrespondingTo837Pand837_TEST5.txt',1,'472','RD8','20170612-20170612',887);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (609,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',2,'368','D8','20160715',888);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (609,'1000D',null,'275sCorrespondingTo837Pand837_TEST5.txt',1,'472','D8','20160613',889);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (609,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',3,'368','D8','20160715',890);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (610,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',2,'368','D8','20160715',891);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (610,'1000D',null,'275sCorrespondingTo837Pand837_TEST5.txt',1,'472','D8','20160613',892);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (610,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',3,'368','D8','20160715',893);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (611,'1000D',null,'275sCorrespondingTo837Pand837_TEST5.txt',1,'472','D8','20160303',894);
Insert into ARS277_REQUEST_TRACKING.CLAIM_DATE (ATTACHMENT_ID,LOOP_ID,CLAIM_KEY,BATCH_ID,REC_NUM,DTP01,DTP02,DTP03,CLAIM_DATE_ID) values (611,'2100B',null,'275sCorrespondingTo837Pand837_TEST5.txt',2,'368','D8','20160902',895);
REM INSERTING into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION
SET DEFINE OFF;
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (1,1,1,1,1,null,10084,'payerName','12115','infoReceiver',null,'providerInfo','234567890','765432109','patientLastname','firstName','999999999','123','234','type','DragonClearingHouseId','123',to_date('01-APR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',null,null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (52,1,2,4,1,null,10086,'payerName','12115','infoReceiver',null,'providerInfo','123456789','876543210','patientLastname','firstName','999999999','519','222','billType','DragonClearingHouseId','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'SUBMITTED','GENERATED',null,null,null,null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (59,1,1,2,3,null,10087,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','345678901','987654321','Dragon','Whosa','888888888','123121234','DragonPayerClaimControlNumber','DragonBillType','clearingHouse','DragonMedicalRecordNumber',to_date('31-JAN-18','DD-MON-RR'),null,null,'SUBMITTED','GENERATED',to_date('11-JAN-18','DD-MON-RR'),null,to_date('11-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (60,1,1,2,3,null,10087,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','456789012','876543210','Dragon','Whosa','888888888','123121234','DragonPayerClaimControlNumber','DragonBillType','DragonClearingHouseId','DragonMedicalRecordNumber',to_date('31-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('11-JAN-18','DD-MON-RR'),null,to_date('13-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (64,1,3,4,1,null,10088,'payerName','12115','infoReceiver',null,'providerInfo','678901234','111111118','patientLastname','firstName','999999999','519','222','billType','clearingHouse','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('11-JAN-18','DD-MON-RR'),null,to_date('11-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (57,1,1,2,3,null,10087,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','012345678','987654321','Dragon','Whosa','888888888','123121234','DragonPayerClaimControlNumber','DragonBillType','DragonClearingHouseId','DragonMedicalRecordNumber',to_date('01-APR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',null,null,null,null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (58,1,1,2,3,null,10087,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','123456789','098765432','Dragon','Whosa','888888888','123121234','DragonPayerClaimControlNumber','DragonBillType','DragonClearingHouseId','DragonMedicalRecordNumber',to_date('31-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',null,null,null,null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (65,1,1,2,3,null,10087,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','234567890','109876543','Dragon','Whosa','888888888','123121234','DragonPayerClaimControlNumber','DragonBillType','DragonClearingHouseId','DragonMedicalRecordNumber',to_date('31-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('11-JAN-18','DD-MON-RR'),null,to_date('11-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (115,1,1,2,3,null,10087,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','345678901','210987654','Dragon','Whosa','888888888','123121234','DragonPayerClaimControlNumber','DragonBillType','DragonClearingHouseId','DragonMedicalRecordNumber',to_date('31-JAN-18','DD-MON-RR'),null,null,'SUBMITTED','SUBMITTED',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (116,1,1,2,3,null,10087,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','456789012','321098765','Dragon','Whosa','888888888','123121234','DragonPayerClaimControlNumber','DragonBillType','DragonClearingHouseId','DragonMedicalRecordNumber',to_date('31-JAN-18','DD-MON-RR'),null,null,'SUBMITTED','SUBMITTED',to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (117,1,1,2,3,null,10087,'DragonPayerName','12115','infoReceiver',null,'DragonProviderInformation','789012345','432109876','Dragon','Whosa','888888888','123121234','DragonPayerClaimControlNumber','DragonBillType','clearingHouse','DragonMedicalRecordNumber',to_date('31-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('11-JAN-18','DD-MON-RR'),null,to_date('11-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (69,1,4,4,1,null,10089,'payerName','12115','infoReceiver',null,'providerInfo','901234567','111111113','patientLastname','firstName','999999999','519','222','billType','clearingHouse','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('11-JAN-18','DD-MON-RR'),null,to_date('11-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (119,1,1,2,3,null,10087,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','890123456','543210987','Dragon','Whosa','888888888','123121234','DragonPayerClaimControlNumber','DragonBillType','clearingHouse','DragonMedicalRecordNumber',to_date('31-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('11-JAN-18','DD-MON-RR'),null,to_date('11-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (71,1,4,4,1,null,10090,'payerName','12115','infoReceiver',null,'providerInfo','345678901','111111113','patientLastname','firstName','999999999','519','222','billType','clearingHouse','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('11-JAN-18','DD-MON-RR'),null,to_date('11-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (122,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'VECTOR REHABILITAT','1000000010','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'SUBMITTED','SUBMITTED',to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (125,1,4,4,1,null,10095,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (145,1,1,2,3,null,10087,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','901234567','654321098','Dragon','Whosa','888888888','123121234','DragonPayerClaimControlNumber','DragonBillType','DragonClearingHouseId','DragonMedicalRecordNumber',to_date('31-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (148,1,2,4,1,null,10087,'payerName','12115','informationReceiver',null,'providerInfo','789012345','987654321','patientLastname','firstName','999999999','519','222','billType','clearingHouse','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (150,1,2,4,1,null,10087,'payerName','12115','informationReceiver',null,'providerInfo','456789012','654321098','patientLastname','firstName','999999999','519','222','billType','clearingHouse','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (156,1,1,2,3,null,10087,'DragonPayerName','12115','infoReceiver',null,'DragonProviderInformation','678901234','098765432','Dragon','Whosa','888888888','123121234','DragonPayerClaimControlNumber','DragonBillType','DragonClearingHouseId','DragonMedicalRecordNumber',to_date('31-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (164,1,2,4,1,null,10087,'payerName','12115','infoReceiver',null,'providerInfo','012345678','654321098','patientLastname','firstName','999999999','519','222','billType','DragonClearingHouseId','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (166,1,1,2,3,null,10000,'Veteran''s Affairs','12115','infoReceiver',null,'VECTOR REHABILITAT','1000000010','111111118','Duncan','Ester','000100006','10000000','10000','231','10000','123456',to_date('20-JAN-18','DD-MON-RR'),null,null,'Manually Closed','SUBMITTED',to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (169,1,1,2,3,null,10087,'DragonPayerName','12115','infoReceiver',null,'DragonProviderInformation','567890123','765432109','Dragon','Whosa','888888888','123121234','DragonPayerClaimControlNumber','DragonBillType','DragonClearingHouseId','DragonMedicalRecordNumber',to_date('31-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (170,1,4,4,1,null,10095,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (171,1,4,4,1,null,10095,'Veteran''s Affairs','84146','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','name','123456','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (172,1,4,4,1,null,10095,'Veteran''s Affairs','84146','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','name','123456','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (175,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (176,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','type','1234567','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (177,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','type','1234567','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (178,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','name','clearingHouse','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (179,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','clearingHouse','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (185,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','123456','Duncan','Ester','000100006','10000000','10000','231','DragonClearingHouseId','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (188,1,1,1,1,null,10000,'Veteran''s Affairs','84146','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','123456',to_date('17-JAN-19','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'Complete','SUBMITTED',to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (189,1,1,1,1,null,10000,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','123456',to_date('17-JAN-18','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (190,1,17,1,1,null,10000,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','name','123456','10000',to_date('17-JAN-18','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (191,1,17,1,1,null,10001,'Veteran''s Affairs','84146','infoReceiver',null,'ROCK VALLEY PHYSICAL THERAPY','1000000003','111111116','Chambers','Atkins','000100082','10000001','10001','231','10000','123456',to_date('17-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (192,1,1,1,2,null,123456,'Veteran Affair''s','12115','12345',null,'loyola','11223344556677','990088776655','Dunn','Deirdre','21','21','11','211','1234567890','123456789',to_date('17-JAN-18','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'),'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (194,1,1,2,2,null,200617299000160,'Veteran''s Affairs','84146','10244',null,'WMHS SPECIALTY SERVICES','1184769952','520591531','RANI','MN','000000005','11110000223','200617299000160','221','051817242879014','EI051817242879014-07',to_date('17-JAN-18','DD-MON-RR'),to_date('30-JAN-11','DD-MON-RR'),to_date('30-JAN-11','DD-MON-RR'),'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (195,1,1,1,1,null,543216,'Vamsi','123456','Information',null,'XXXX','567890123','100111','Last','First','123456','123456','123456','jhgjhgjh','789456','789456',to_date('12-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (196,113,1,2,2,null,200617299000160,'Veteran''s Affairs','84146','10244',null,'WMHS SPECIALTY SERVICES','1184769952','520591531','RANI','MN','000000005','11110000223','200617299000160','221','201611161001616','EI051817242879014-07',to_date('17-JAN-18','DD-MON-RR'),to_date('30-JAN-11','DD-MON-RR'),to_date('30-JAN-11','DD-MON-RR'),'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (198,1,1,8,3,null,10241,'DragonPayerName','12115','infoReceiver',null,'DragonProviderInformation','789012345','876543210','Dragon','Whosa','888888888','10000241','DragonPayerClaimControlNumber','DragonBillType','clearingHouse','DragonMedicalRecordNumber',to_date('20-JAN-18','DD-MON-RR'),null,null,'SUBMITTED','SUBMITTED',to_date('15-JAN-18','DD-MON-RR'),to_date('15-JAN-18','DD-MON-RR'),to_date('15-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (199,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','123456','Duncan','Ester','000100006','10000000','10000','231','DragonClearingHouseId','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('15-JAN-18','DD-MON-RR'),null,to_date('15-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (201,1,1,2,2,null,12345,'Veteran''s Affairs','84146','10242',null,'UNIV OF SOUTH ALABAMA HEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('20-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'SUBMITTED','SUBMITTED',to_date('15-JAN-18','DD-MON-RR'),to_date('15-JAN-18','DD-MON-RR'),to_date('15-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (202,1,5,7,2,null,10241,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','345678901','654321098','Dragon','Whosa','888888888','10000241','DragonPayerClaimControlNumber','DragonBillType','clearingHouse','DragonMedicalRecordNumber',to_date('20-JAN-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('15-JAN-18','DD-MON-RR'),null,to_date('15-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (203,1,2,2,5,null,10242,'Veteran''s Affairs','84146','10242',null,'UNIV OF SOUTH ALABAMA HEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (205,1,2,1,1,null,10000,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','name','123456','123456',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (206,1,2,1,1,null,10000,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (207,1,1,2,1,null,10000,'Veteran''s Affairs','84146','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','name','123456','10000',to_date('21-JAN-18','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (208,1,1,2,1,null,10000,'Veteran''s Affairs','84146','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','name','123456','10000',to_date('21-JAN-18','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (209,114,4,5,5,null,11223,'name','123123','11223',null,'provider name','1212121212','000000012','last name','first name','12121212','121212122','12121212','221','123123123','12121212',to_date('21-JAN-18','DD-MON-RR'),to_date('01-JAN-16','DD-MON-RR'),to_date('01-FEB-16','DD-MON-RR'),'SUBMITTED','SUBMITTED',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (210,1,4,4,5,null,10242,'Veteran''s Affairs','84146','10242',null,'UNIV OF SOUTH ALABAMA HEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (211,114,4,4,5,null,10242,'Veteran''s Affairs','84146','10242',null,'UNIV OF SOUTH ALABAMA HEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (212,114,4,4,5,null,10242,'Veteran''s Affairs','84146','10242',null,'UNIV OF SOUTH ALABAMA HEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (213,114,4,4,5,null,10242,'Veteran''s Affairs','84146','10242',null,'UNIV OF SOUTH ALABAMA HEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (214,114,4,4,5,null,10242,'Veteran''s Affairs','84146','10242',null,'UNIV OF SOUTH ALABAMA HEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (215,114,4,4,5,null,10242,'Veteran''s Affairs','84146','10242',null,'UNIV OF SOUTH ALABAMA HEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (217,114,4,4,5,null,10242,'Veteran''s Affairs','84146','10242',null,'UNIV OF SOUTH ALABAMA HEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (218,114,4,4,5,null,10242,'Veteran''s Affairs','84146','10242',null,'UNIV OF SOUTH ALABAMA HEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (219,114,4,4,5,null,10242,'Veteran''s Affairs','84146','10242',null,'UNIV OF SOUTH ALABAMA HEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (220,1,4,4,1,null,10095,'name','123456','infoReceiver',null,'name','123456','123456','name','name','000100006','123456','123456','name','DragonClearingHouseId','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (221,1,4,4,1,null,10095,'name','123456','name',null,'name','123456','123456','name','name','000100006','123456','123456','name','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (223,1,6,5,7,null,10004,'Veteran''s Affairs','12115','informationReceiver',null,'ROCK VALLEY PHYSICAL THERAPY','1000000003','111111116','Chambers','Atkins','000100082','10000001','10001','231','1234567','123456',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (225,1,4,4,1,null,10095,'name','123456','name',null,'name','123456','111111113','name','name','000100006','123456','123456','name','123456','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (226,115,5,4,6,null,10000,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','123456',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (228,115,4,6,7,null,10000,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','123456',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (229,116,1,1,1,null,123456454444444,'name','123','4654',null,'name','12313','12321','name','name','6541','654','12312','654','654','654',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (230,116,1,1,1,null,123454165465465,'name','123','4654',null,'name','12313','12321','name','name','6541','654','12312','654','654','654',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (231,116,1,1,1,null,123454165465465,'name','123','4654',null,'name','12313','12321','name','name','6541','654','12312','654','654','654',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (232,116,1,1,1,null,564564654654654,'name','123','4654',null,'name','12313','12321','name','name','6541','654','12312','654','EI051817242879014-09','654',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (233,116,1,1,1,null,5645646546546,'name','123','4654',null,'name','12313','12321','name','name','6541','654','12312','654','654','654',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (234,116,1,1,1,null,514754,'name','123','4654',null,'name','12313','12321','name','name','6541','654','12312','654','654','654',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (235,116,1,1,1,null,5147547777,'name','123','4654',null,'name','12313','12321','name','name','6541','654','12312','654','654','654',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (236,116,1,1,1,null,5147547777,'name','123','4654',null,'name','12313','12321','name','name','6541','654','12312','654','654','654',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (237,116,1,1,1,null,5147547777,'name','123','4654',null,'name','12313','12321','name','name','6541','654','12312','654','654','654',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (238,116,1,1,1,null,564654654654654,'name','123','4654',null,'name','12313','12321','name','name','6541','654','12312','654','654','654',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (240,114,3,4,3,null,11223,'1','1','1',null,'1','1','1','1','1','1','1','1','1','1','1',to_date('21-JAN-18','DD-MON-RR'),to_date('01-JAN-16','DD-MON-RR'),to_date('01-FEB-16','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (241,117,6,8,1,null,12345,'1','1','1',null,'1','1','1','1','1','1','1','1','1','1','1',to_date('21-JAN-18','DD-MON-RR'),to_date('01-JAN-16','DD-MON-RR'),to_date('01-FEB-16','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (242,118,5,4,4,null,123456,'VA','12115','Test@test.com',null,'Billing Provider','123456789','999999999','Patient Last Name','Patient First Name','123121234','111111111','123456','137','123123123','555555555',to_date('20-JAN-17','DD-MON-RR'),to_date('01-AUG-17','DD-MON-RR'),to_date('02-AUG-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (243,118,5,4,4,null,123456,'VA','12115','Test@test.com',null,'Billing Provider','123456789','999999999','Patient Last Name','Patient First Name','123121234','111111111','123456','137','123123123','555555555',to_date('20-JAN-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (245,118,5,4,4,null,123456,'VA','12115','Test@test.com',null,'Billing Provider','123456789','999999999','Patient Last Name','Patient First Name','123121234','111111111','123456','137','123123123','555555555',to_date('20-JAN-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (246,118,5,4,4,null,123456,'VA','12115','Test@test.com',null,'Billing Provider','123456789','999999999','Patient Last Name','Patient First Name','123121234','111111111','123456','137','123123123','555555555',to_date('20-JAN-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (247,118,5,4,4,null,123456,'VA','12115','Test@test.com',null,'Billing Provider','123456789','999999999','Patient Last Name','Patient First Name','123121234','111111111','123456','137','123123123','555555555',to_date('20-JAN-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (248,118,5,4,4,null,10244,'Veteran''s Affairs','12115','10244',null,'SKAGIT RADIOLOGY INC','1000000005','111111111','Ortega','Michael','000100091','10000244','10244','221','EI051817242879014-07','EI051817242879014-07',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (250,119,7,3,4,null,10240,'vam','10000','smnbn',null,'name','32178','111111116','Maddi','Vamsi','123455','10000240','10001','type','123456','123456',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (251,11,1,1,1,null,10001,'vam','10000','smnbn',null,'name','32178','244566','Maddi','Vamsi','123455','10999','10001','type','123456','10000',to_date('01-JAN-18','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (252,118,3,4,3,null,10245,'Veteran''s Affairs','12115','10245',null,'PLAZA MED CTR OF FW','1000000008','111111118','Turner','Patrick','000100031','10000245','10245','221','10245','10245',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (253,11,1,1,1,null,10001,'vam','10000','smnbn',null,'name','32178','244566','Maddi','Vamsi','123455','10999','10001','type','123456','123456',to_date('01-JAN-18','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'SUBMITTED','SUBMITTED',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (255,115,2,1,2,null,10240,'Veteran''s Affairs','12115','infoReceiver',null,'ROCK VALLEY PHYSICAL THERAPY','1000000003','111111119','Chambers','Atkins','000100082','10000240','10001','name','10000','123456',to_date('21-JAN-18','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (257,120,1,1,1,null,10240,'Veteran''s Affairs','84146','infoReceiver',null,'ROCK VALLEY PHYSICAL THERAPY','1000000003','111111120','Chambers','Atkins','000100082','123456','10001','231','10000','123456',to_date('01-JAN-18','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (258,11,4,3,4,null,10245,'Veteran''s Affairs','12115','10245',null,'PLAZA MED CTR OF FW','1000000008','111111118','Turner','Patrick','000100031','10000245','10245','221','10245','10245',to_date('21-FEB-18','DD-MON-RR'),null,null,'Abandoned','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('11-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (259,11,2,2,2,null,85951,'Veteran''s Affairs','12115','1629129747',null,'MARY HITCHCOCK MEMORIAL HOSPITAL','1023092053','020222140','GGGGGG','XXXXXX','03756','H6599465803','85951','137','051817242879014','50218131 6',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (260,121,4,5,5,null,10244,'Veteran''s Affairs','12115','10244',null,'SKAGIT RADIOLOGY INC','1000000005','111111111','Ortega','Michael','000100091','10000244','10244','221','EI051817242879014-07','EI051817242879014-07',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'SUBMITTED','SUBMITTED',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (261,11,2,2,2,null,10240,'Veteran''s Affairs','12115','informationReceiver',null,'HUMANA VETERANS HEALTHCARE SERVICES','1000000003','111111112','David','Weaver','000100046','10000240','10002','name','10000','10000',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (262,11,2,2,2,null,10240,'Veteran''s Affairs','12115','informationReceiver',null,'HUMANA VETERANS HEALTHCARE SERVICES','1000000003','765432109','David','Weaver','000100046','10000240','10002','name','1234567','123456',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (264,123,6,8,5,null,10244,'Veteran''s Affairs','12115','10244',null,'SKAGIT RADIOLOGY INC','1000000005','111111111','Ortega','Michael','000100091','10000244','10244','221','EI051817242879014-07','EI051817242879014-07',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (266,125,1,2,3,null,10240,'Veteran''s Affairs','12115','informationReceiver',null,'ROCK VALLEY PHYSICAL THERAPY','1000000003','876543210','Chambers','Atkins','000100082','23123','10001','231','1234567','123456',to_date('01-JAN-18','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (267,11,2,2,2,null,10000,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','type','1234567','10000',to_date('21-JAN-18','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (268,126,3,5,6,null,10000,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','type','1234567','123456',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (269,127,5,6,8,null,10000,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','name','clearingHouse','123456',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (270,128,6,6,7,null,10000,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','clearingHouse','10000',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (271,129,5,5,7,null,10243,'Veteran''s Affairs','12115','10243',null,'UNIV OF WASHINGTON PHYSICIANS','1000000003','111111121','Gomez','Estela','000100003','10000243','10243','221','EI051817242879014-08','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (272,130,2,2,5,null,200617203000156,'Veteran''s Affairs','12115','10243',null,'UNIV OF WASHINGTON PHYSICIANS','1000000003','111111121','Gomez','Estela','000100003','10000243','10243','221','EI051817242879014-08','EI051817242879014-08',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (273,131,2,2,5,null,200617270000158,'Veteran''s Affairs','84146','10242',null,'HEDGES CLINIC SERVICE CORP','1326111600','362748681','JOHN','GA','000000003','11110000225','200617270000158','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (274,132,4,6,6,null,2135235235,'rwrwerwqer','51253235235','12352135213',null,'2352352135','235235235','25235235','1235235235','12352352135','123521352135','2352352135','2135235235','123512351235','123521352135','2135235235',to_date('01-JAN-19','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (275,133,3,3,4,null,10240,'Veteran''s Affairs','12115','informationReceiver',null,'HUMANA VETERANS HEALTHCARE SERVICES','1000000001','543210987','Kennedy','Vonda','000100086','10000240','10009','231','DragonClearingHouseId','10000',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (276,118,5,3,4,null,200617203000156,'Veteran''s Affairs','84146','10240',null,'LMH HEALTH PROFESSIONALS','1508086554','311425530','JACK','CC','000000001','11110000223','200617203000156','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (277,134,1,1,1,null,1234567,'asd','12','12',null,'12','12','12','we','we','12','12','12','211','12','12',to_date('21-JAN-18','DD-MON-RR'),to_date('03-JAN-18','DD-MON-RR'),to_date('05-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (278,135,4,4,6,null,4567457645,'364576425745','45743573475','34574357',null,'34574357','34573457','4574357457','43573457','34574357','43573457','675673567657','4567457645','3457457','5656754687','5674568756',to_date('01-JAN-19','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (279,133,3,3,3,null,200067070767,'Payer Name','12115','Information Receiver',null,'Billing Provider','111111111','222222222','Patient Last Name','First Name','555555555','123121234','200067070767','137','999999999','000000000',to_date('18-JAN-18','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('02-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (280,134,1,1,1,null,10243,'Veteran''s Affairs','12115','10243',null,'UNIV OF WASHINGTON PHYSICIANS','1000000003','111111121','Gomez','Estela','000100003','10000243','10243','221','EI051817242879014-08','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (281,136,1,1,1,null,10243,'Veteran''s Affairs','12115','10243',null,'UNIV OF WASHINGTON PHYSICIANS','1000000003','111111121','Gomez','Estela','000100003','10000243','10243','221','EI051817242879014-08','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'SUBMITTED','SUBMITTED',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (282,137,1,1,1,null,10243,'Veteran''s Affairs','12115','10243',null,'UNIV OF WASHINGTON PHYSICIANS','1000000003','111111121','Gomez','Estela','000100003','10000243','10243','221','EI051817242879014-08','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (283,138,1,1,1,null,10243,'Veteran''s Affairs','12115','10243',null,'UNIV OF WASHINGTON PHYSICIANS','1000000003','111111121','Gomez','Estela','000100003','10000243','10243','221','EI051817242879014-08','EI051817242879014-08',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (284,139,1,1,1,null,10243,'Veteran''s Affairs','12115','10243',null,'UNIV OF WASHINGTON PHYSICIANS','1000000003','111111121','Gomez','Estela','000100003','10000243','10243','221','EI051817242879014-08','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'SUBMITTED','SUBMITTED',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (285,133,4,4,3,null,999999999,'Payer Name','12115','Information Receiver',null,'Billing Provider','000000000','111111111','Last Name','First Name','888888888','123121234','999999999','137','123456789','123121234',to_date('20-JAN-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (286,140,4,5,4,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIV OF SOUTH ALABAMA HEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (287,141,1,4,1,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIVOFSOUTHALABAMAHEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (288,142,1,2,3,null,10240,'Veteran''s Affairs','12115','informationReceiver',null,'GENETIVA HEALTH SVC','1000000009','432109876','Henderson','Yvonne','000100022','10000240','10020','231','DragonClearingHouseId','10000',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (289,143,1,4,1,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIVOFSOUTHALABAMAHEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (290,144,1,4,1,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIVOFSOUTHALABAMAHEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (291,142,1,2,3,null,10240,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000007','987654321','Stuart','Howe','000170001','10000240','10021','type','DragonClearingHouseId','10000',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (292,1,4,4,1,null,10095,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','244566','Duncan','Ester','000100006','10000000','10000','231','123456','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (293,145,1,3,4,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIVOFSOUTHALABAMAHEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (294,146,1,3,4,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIVOFSOUTHALABAMAHEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (295,147,1,3,4,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIVOFSOUTHALABAMAHEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (296,142,1,2,3,null,10240,'payerName','12115','infoReceiver',null,'providerInfo','234567890','876543210','patientLastname','firstName','999999999','10000240','234','type','DragonClearingHouseId','123',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (297,148,1,1,1,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIVOFSOUTHALABAMAHEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (298,149,1,1,1,null,10242,'payerName','12115','infoReceiver',null,'providerInfo','012345678','098765432','patientLastname','firstName','999999999','10000242','222','billType','DragonClearingHouseId','123',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (299,150,1,1,1,null,10242,'DragonPayerName','12115','infoReceiver',null,'DragonProviderInformation','678901234','109876543','Dragon','Whosa','888888888','10000242','DragonPayerClaimControlNumber','DragonBillType','DragonClearingHouseId','DragonMedicalRecordNumber',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (300,151,1,1,1,null,10242,'payerName','12115','informationReceiver',null,'providerInfo','456789012','210987654','patientLastname','firstName','999999999','10000242','222','billType','clearingHouse','123',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (301,152,1,1,1,null,10242,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','901234567','654321098','Dragon','Whosa','888888888','10000242','DragonPayerClaimControlNumber','DragonBillType','DragonClearingHouseId','DragonMedicalRecordNumber',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'SUBMITTED','SUBMITTED',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (302,153,1,1,1,null,10240,'payerName','12115','infoReceiver',null,'providerInfo','123456789','654321098','patientLastname','firstName','999999999','10000240','222','billType','DragonClearingHouseId','123',to_date('21-JAN-18','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (303,154,1,1,1,null,10240,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','890123456','987654321','Dragon','Whosa','888888888','10000240','DragonPayerClaimControlNumber','DragonBillType','clearingHouse','DragonMedicalRecordNumber',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (304,155,1,1,1,null,10242,'payerName','12115','informationReceiver',null,'providerInfo','789012345','765432109','patientLastname','firstName','999999999','10000242','222','billType','clearingHouse','123',to_date('21-JAN-18','DD-MON-RR'),null,null,'SUBMITTED','SUBMITTED',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (305,156,2,1,2,null,10240,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','111111116','Duncan','Ester','000100006','519','10000','231','123456','10000',to_date('21-JAN-18','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'SUBMITTED','SUBMITTED',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (306,157,1,1,1,null,10240,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','111111116','Duncan','Ester','000100006','519','10000','231','123456','10000',to_date('21-JAN-18','DD-MON-RR'),null,null,'SUBMITTED','SUBMITTED',to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (307,118,6,2,4,null,200617203000156,'Veteran''s Affairs','84146','10240',null,'LMH HEALTH PROFESSIONALS','1508086554','311425530','JACK','CC','000000001','11110000223','200617203000156','211','051817242871234','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (308,158,1,8,1,null,85951,'Veteran''s Affairs','12115','1629129747',null,'MARY HITCHCOCK MEMORIAL HOSPITAL','1023092053','020222140','GGGGGG','XXXXXX','03756','H6599465803','85951','137','051817242879014','50218131 6',to_date('21-JAN-18','DD-MON-RR'),null,null,'SUBMITTED','SUBMITTED',to_date('16-JAN-18','DD-MON-RR'),to_date('17-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (309,159,5,5,18,null,222222222,'Payer Name','111111111','Information Receiver',null,'Billing Provider Name','333333333','444444444','Patient Last Name','Patient First Name','555555555','666666666','222222222','777777777','888888888','999999999',to_date('20-JAN-18','DD-MON-RR'),to_date('01-AUG-17','DD-MON-RR'),to_date('02-AUG-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (310,160,3,1,2,null,10002,'Veteran''s Affairs','12115','informationReceiver',null,'HUMANA VETERANS HEALTHCARE SERVICES','1000000003','111111112','David','Weaver','000100046','10000002','10002','name','1234567','123456',to_date('22-JAN-18','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('17-JAN-18','DD-MON-RR'),null,to_date('17-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (313,1,4,4,1,null,10095,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','111111116','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('18-JAN-18','DD-MON-RR'),null,to_date('18-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (314,1,4,4,1,null,10095,'vam','10000','smnbn',null,'name','32178','111111116','Maddi','Vamsi','123455','10999','10001','type','123456','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('18-JAN-18','DD-MON-RR'),null,to_date('18-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (315,1,4,4,1,null,10095,'vam','10000','smnbn',null,'name','32178','111111112','Maddi','Vamsi','123455','10999','10001','type','123456','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('18-JAN-18','DD-MON-RR'),null,to_date('18-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (316,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'ROCK VALLEY PHYSICAL THERAPY','1000000003','111111112','Chambers','Atkins','000100082','10000001','10001','name','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('18-JAN-18','DD-MON-RR'),null,to_date('18-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (322,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'GENETIVA HEALTH SVC','1000000009','876543210','Henderson','Yvonne','000100022','10000020','10020','231','DragonClearingHouseId','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('18-JAN-18','DD-MON-RR'),null,to_date('18-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (323,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000007','543210987','Stuart','Howe','000170001','10000021','10021','type','DragonClearingHouseId','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('18-JAN-18','DD-MON-RR'),null,to_date('18-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (327,163,5,3,6,null,10242,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','456789012','098765432','Dragon','Whosa','888888888','10000242','DragonPayerClaimControlNumber','DragonBillType','DragonClearingHouseId','DragonMedicalRecordNumber',to_date('23-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'SUBMITTED','SUBMITTED',to_date('18-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (328,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'VECTOR REHABILITAT','1000000010','111111118','Duncan','Ester','000100006','123121234','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('19-JAN-18','DD-MON-RR'),null,to_date('19-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (330,1,4,4,1,null,10095,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('19-JAN-18','DD-MON-RR'),null,to_date('19-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (333,1,4,4,1,null,10095,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','519','10000','name','123456','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('19-JAN-18','DD-MON-RR'),null,to_date('19-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (335,164,2,2,2,null,85951,'Veteran''s Affairs','12115','1629129747',null,'MARY HITCHCOCK MEMORIAL HOSPITAL','1023092053','020222140','GGGGGG','XXXXXX','03756','H6599465803','85951','137','051817242879014','50218131 6',to_date('24-JAN-18','DD-MON-RR'),to_date('25-OCT-16','DD-MON-RR'),to_date('25-OCT-16','DD-MON-RR'),'SUBMITTED','SUBMITTED',to_date('19-JAN-18','DD-MON-RR'),to_date('20-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (336,164,2,2,2,null,85951,'Veteran''s Affairs','12115','1629129747',null,'MARY HITCHCOCK MEMORIAL HOSPITAL','1023092053','020222140','GGGGGG','XXXXXX','03756','H6599465803','85951','137','051817242879014','50218131 6',to_date('24-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('19-JAN-18','DD-MON-RR'),null,to_date('19-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (337,164,2,2,2,null,85951,'Veteran''s Affairs','12115','1629129747',null,'MARY HITCHCOCK MEMORIAL HOSPITAL','1023092053','020222140','GGGGGG','XXXXXX','03756','H6599465803','85951','137','051817242879014','50218131 6',to_date('24-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('19-JAN-18','DD-MON-RR'),null,to_date('19-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (340,165,2,2,3,null,10009,'Veteran''s Affairs','12115','informationReceiver',null,'HUMANA VETERANS HEALTHCARE SERVICES','1000000001','111111119','Kennedy','Vonda','000100086','10000009','10009','231','DragonClearingHouseId','10000',to_date('24-JAN-18','DD-MON-RR'),to_date('12-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('19-JAN-18','DD-MON-RR'),null,to_date('19-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (342,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-JAN-18','DD-MON-RR'),null,to_date('22-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (343,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-JAN-18','DD-MON-RR'),null,to_date('22-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (345,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','type','1234567','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-JAN-18','DD-MON-RR'),null,to_date('22-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (347,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','name','clearingHouse','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-JAN-18','DD-MON-RR'),null,to_date('23-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (348,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','519','10000','231','clearingHouse','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-JAN-18','DD-MON-RR'),null,to_date('23-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (350,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','519','10000','231','DragonClearingHouseId','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-JAN-18','DD-MON-RR'),null,to_date('23-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (356,1,4,4,1,null,10095,'name','123456','name',null,'name','123456','123456','name','name','000100006','10000000','123456','name','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('24-JAN-18','DD-MON-RR'),null,to_date('24-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (357,1,4,4,1,null,10095,'name','123456','name',null,'name','123456','123456','name','name','123456','10000000','123456','name','123456','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('24-JAN-18','DD-MON-RR'),null,to_date('24-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (358,142,1,2,3,null,10240,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','111111112','Duncan','Ester','000100006','10000240','10000','231','10000','10000',to_date('21-JAN-18','DD-MON-RR'),null,null,'SUBMITTED','SUBMITTED',to_date('24-JAN-18','DD-MON-RR'),to_date('24-JAN-18','DD-MON-RR'),to_date('24-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (359,142,1,2,3,null,10240,'vam','10000','smnbn',null,'name','32178','111111112','Maddi','Vamsi','123455','10000240','10001','type','123456','10000',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('24-JAN-18','DD-MON-RR'),null,to_date('24-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (361,1,4,4,1,null,10095,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','123456','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (363,166,1,2,1,null,10000,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','DragonClearingHouseId','10000',to_date('30-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (364,167,1,1,1,null,10000,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','DragonClearingHouseId','10000',to_date('30-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (365,168,1,1,1,null,12345,'name','12345','name',null,'name','12345','12345','name','name','12345','12345','12345','type','12345','12345',to_date('01-JAN-17','DD-MON-RR'),to_date('01-JAN-16','DD-MON-RR'),to_date('01-JAN-16','DD-MON-RR'),'SUBMITTED','SUBMITTED',to_date('25-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (366,169,1,1,1,null,10245,'Veterans Affair''s','12115','123456',null,'qwerty','123456','123456','qwerty','qwerty','123456','123456','10245','211','123456','123456',to_date('02-JAN-18','DD-MON-RR'),to_date('09-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (367,170,1,1,1,null,10245,'Veterans Affair''s','12115','123456',null,'qwerty','123456','123456','qwerty','qwerty','123456','123456','10245','211','123456','123456',to_date('02-JAN-18','DD-MON-RR'),to_date('09-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (368,171,1,1,1,null,10000,'name','123456','infoReceiver',null,'name','123456','123456','name','name','000100006','123456','123456','name','DragonClearingHouseId','123456',to_date('25-JAN-18','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (370,173,1,1,1,null,10000,'name','123456','name',null,'name','123456','123456','name','name','000100006','123456','123456','name','10000','123456',to_date('01-FEB-18','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (371,174,1,1,1,null,12345,'name','123456','name',null,'name','123456','123456','name','name','123456','123456',null,'123456','123456','123456',to_date('01-JAN-18','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (373,176,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('30-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (374,177,1,1,1,null,10000,'name','123456','name',null,'name','123456','123456','name','name','000100006','123456','123456','name','10000','123456',to_date('01-JAN-18','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (375,178,1,1,2,null,10000,'name','123456','name',null,'name','123456','123456','name','name','123456','123456','123456','name','123456','123456',to_date('25-FEB-18','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (376,1,4,4,1,null,10095,'vam','10000','smnbn',null,'name','32178','244566','Maddi','Vamsi','123455','10000000','10001','type','123456','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (377,1,4,4,1,null,10095,'vam','10000','smnbn',null,'name','32178','244566','Maddi','Vamsi','123455','10000000','10001','type','123456','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (378,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'ROCK VALLEY PHYSICAL THERAPY','1000000003','111111116','Chambers','Atkins','000100082','10000000','10001','name','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (382,179,6,4,8,null,10245,'Veteran''s Affairs','12115','10245',null,'PLAZA MED CTR OF FW','1000000008','111111118','Turner','Patrick','000100031','10000245','10245','221','10245','10245',to_date('31-JAN-18','DD-MON-RR'),null,null,'SUBMITTED','SUBMITTED',to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (385,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'HUMANA VETERANS HEALTHCARE SERVICES','1000000001','111111119','Kennedy','Vonda','000100086','10000000','10009','231','DragonClearingHouseId','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-JAN-18','DD-MON-RR'),null,to_date('26-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (386,181,5,4,7,null,10245,'1234','12345','1',null,'billing name','123','11111','last name','first name','1111','111','123','101','102','103',to_date('31-JAN-18','DD-MON-RR'),to_date('20-OCT-17','DD-MON-RR'),to_date('20-FEB-18','DD-MON-RR'),'SUBMITTED','SUBMITTED',to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (388,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000007','111111112','Stuart','Howe','000170001','123456','10021','type','DragonClearingHouseId','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-JAN-18','DD-MON-RR'),null,to_date('26-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (389,1,4,4,1,null,10095,'payerName','12115','infoReceiver',null,'providerInfo','234567890','765432109','patientLastname','firstName','999999999','123456','234','type','DragonClearingHouseId','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-JAN-18','DD-MON-RR'),null,to_date('26-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (393,1,4,4,1,null,10095,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','345678901','987654321','Dragon','Whosa','888888888','123456','DragonPayerClaimControlNumber','DragonBillType','clearingHouse','DragonMedicalRecordNumber',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (394,1,4,4,1,null,10095,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','456789012','876543210','Dragon','Whosa','888888888','10000000','DragonPayerClaimControlNumber','DragonBillType','DragonClearingHouseId','DragonMedicalRecordNumber',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (399,1,4,4,1,null,10095,'DragonPayerName','12115','infoReceiver',null,'DragonProviderInformation','678901234','111111113','Dragon','Whosa','888888888','10000001','DragonPayerClaimControlNumber','DragonBillType','DragonClearingHouseId','DragonMedicalRecordNumber',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (401,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'VECTOR REHABILITAT','1000000010','111111113','Duncan','Ester','000100006','10000002','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (403,1,4,4,1,null,10095,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000001','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (406,1,4,4,1,null,10095,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000021','10000','name','123456','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (408,1,4,4,1,null,10095,'Veteran''s Affairs','84146','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','519','10000','name','123456','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (411,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (413,133,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','123456','10000',to_date('04-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (417,133,1,1,1,null,2222222222,'Payer Name','111111111','Information Receiver',null,'Billing Provider Name','3333333333','4444444444','Patient Last Name','Patient First Name','5555555555','6666666666','2222222222','Bill Type','7777777777','8888888888',to_date('15-FEB-18','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('13-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (419,186,6,8,3,null,10245,'Veteran''s Affairs','12115','10245',null,'PLAZA MED CTR OF FW','1000000008','111111118','Turner','Patrick','000100031','10000245','10245','221','10245','10245',to_date('04-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (420,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','type','1234567','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (421,187,6,6,8,null,10002,'Veteran''s Affairs','12115','informationReceiver',null,'HUMANA VETERANS HEALTHCARE SERVICES','1000000003','111111112','David','Weaver','000100046','10000002','10002','name','10000','10000',to_date('04-FEB-18','DD-MON-RR'),null,null,'SUBMITTED','SUBMITTED',to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (372,175,1,1,1,null,12345,'name','123456','name',null,'name','123456','123456','name','name','123456','123456',null,'123456','123456','123456',to_date('23-JAN-18','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (423,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','123456','Duncan','Ester','000100006','519','10000','name','clearingHouse','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (424,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','123456','Duncan','Ester','000100006','519','10000','231','clearingHouse','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (425,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','123456','Duncan','Ester','000100006','123121234','10000','231','DragonClearingHouseId','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (427,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','123456','Duncan','Ester','000100006','123121234','10000','231','DragonClearingHouseId','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (430,118,1,2,2,null,10020,'Veteran''s Affairs','12115','informationReceiver',null,'GENETIVA HEALTH SVC','1000000009','111111120','Henderson','Yvonne','000100022','10000020','10020','231','DragonClearingHouseId','10000',to_date('04-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (431,118,1,1,1,null,10021,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000007','111111112','Stuart','Howe','000170001','10000021','10021','type','DragonClearingHouseId','10000',to_date('04-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (432,188,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','123456','10000',to_date('05-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('31-JAN-18','DD-MON-RR'),null,to_date('31-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (433,189,16,7,2,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('05-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('31-JAN-18','DD-MON-RR'),null,to_date('31-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (435,1,4,4,1,null,10095,'name','123456','name',null,'name','123456','111111113','name','name','000100006','123121234','123456','name','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('01-FEB-18','DD-MON-RR'),null,to_date('01-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (441,1,4,4,1,null,10095,'name','123456','name',null,'name','123456','244566','name','name','000100006','519','123456','name','123456','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('02-FEB-18','DD-MON-RR'),null,to_date('02-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (318,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'HUMANA VETERANS HEALTHCARE SERVICES','1000000003','111111119','David','Weaver','000100046','10000002','10002','name','10000','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('18-JAN-18','DD-MON-RR'),null,to_date('18-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (352,1,4,4,1,null,10095,'name','123456','infoReceiver',null,'name','123456','123456','name','name','000100006','10000000','123456','name','DragonClearingHouseId','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-JAN-18','DD-MON-RR'),null,to_date('23-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (362,1,4,4,1,null,10095,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (344,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-JAN-18','DD-MON-RR'),null,to_date('22-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (312,162,3,3,5,null,10000,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','DragonClearingHouseId','123456',to_date('22-JAN-18','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('17-JAN-18','DD-MON-RR'),null,to_date('17-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (429,133,1,1,1,null,10001,'Veteran''s Affairs','12115','infoReceiver',null,'ROCK VALLEY PHYSICAL THERAPY','1000000003','111111116','Chambers','Atkins','000100082','10000001','10001','name','10000','123456',to_date('04-FEB-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (326,1,4,4,1,null,10095,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','890123456','876543210','Dragon','Whosa','888888888','123121234','DragonPayerClaimControlNumber','DragonBillType','clearingHouse','DragonMedicalRecordNumber',to_date('12-DEC-17','DD-MON-RR'),to_date('30-JAN-11','DD-MON-RR'),to_date('30-JAN-11','DD-MON-RR'),'PENDING','GENERATED',to_date('18-JAN-18','DD-MON-RR'),null,to_date('18-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (339,1,4,4,1,null,10095,'Veteran''s Affairs','84146','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','name','123456','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('19-JAN-18','DD-MON-RR'),null,to_date('19-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (381,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'HUMANA VETERANS HEALTHCARE SERVICES','1000000003','111111112','David','Weaver','000100046','10000000','10002','name','1234567','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-JAN-18','DD-MON-RR'),null,to_date('26-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (397,1,4,4,1,null,10095,'payerName','12115','informationReceiver',null,'providerInfo','890123456','111111113','patientLastname','firstName','999999999','10999','222','billType','clearingHouse','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (404,1,4,4,1,null,10095,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000009','10000','name','123456','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (412,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (426,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','519','10000','231','DragonClearingHouseId','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (311,161,11,5,15,null,10242,'payerName','12115','informationReceiver',null,'providerInfo','890123456','321098765','patientLastname','firstName','999999999','10000242','222','billType','clearingHouse','123',to_date('22-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('17-JAN-18','DD-MON-RR'),null,to_date('17-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (174,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (325,1,4,4,1,null,10095,'payerName','12115','infoReceiver',null,'providerInfo','123456789','987654321','patientLastname','firstName','999999999','519','222','billType','DragonClearingHouseId','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('18-JAN-18','DD-MON-RR'),null,to_date('18-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (331,1,4,4,1,null,10095,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','name','123456','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('19-JAN-18','DD-MON-RR'),null,to_date('19-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (338,1,4,4,1,null,10095,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','519','10000','231','10000','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('19-JAN-18','DD-MON-RR'),null,to_date('19-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (353,1,4,4,1,null,10095,'name','123456','infoReceiver',null,'name','123456','123456','name','name','000100006','10000000','123456','name','DragonClearingHouseId','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-JAN-18','DD-MON-RR'),null,to_date('23-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (380,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'HUMANA VETERANS HEALTHCARE SERVICES','1000000003','111111112','David','Weaver','000100046','10000000','10002','name','10000','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-JAN-18','DD-MON-RR'),null,to_date('26-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (390,1,4,4,1,null,10095,'payerName','12115','infoReceiver',null,'providerInfo','123456789','876543210','patientLastname','firstName','999999999','123456','222','billType','DragonClearingHouseId','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-JAN-18','DD-MON-RR'),null,to_date('26-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (396,1,4,4,1,null,10095,'payerName','12115','informationReceiver',null,'providerInfo','789012345','111111118','patientLastname','firstName','999999999','10000000','222','billType','clearingHouse','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (405,1,4,4,1,null,10095,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000020','10000','name','123456','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (422,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','519','10000','type','1234567','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (149,1,2,4,1,null,10087,'payerName','12115','informationReceiver',null,'providerInfo','890123456','876543210','patientLastname','firstName','999999999','519','222','billType','clearingHouse','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (319,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'HUMANA VETERANS HEALTHCARE SERVICES','1000000003','111111120','David','Weaver','000100046','10000002','10002','name','1234567','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('18-JAN-18','DD-MON-RR'),null,to_date('18-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (341,1,4,4,1,null,10095,'Veteran''s Affairs','84146','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','519','10000','name','123456','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-JAN-18','DD-MON-RR'),null,to_date('22-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (355,1,4,4,1,null,10095,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('24-JAN-18','DD-MON-RR'),null,to_date('24-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (398,1,4,4,1,null,10095,'payerName','12115','informationReceiver',null,'providerInfo','456789012','111111113','patientLastname','firstName','999999999','10999','222','billType','clearingHouse','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (428,1,4,4,1,null,10095,'name','123456','infoReceiver',null,'name','123456','123456','name','name','000100006','123121234','123456','name','DragonClearingHouseId','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (123,1,4,4,1,null,10095,'Veteran''s Affairs','84146','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'SUBMITTED','SUBMITTED',to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (173,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (193,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','123456','Duncan','Ester','000100006','10000000','10000','231','DragonClearingHouseId','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (317,1,4,4,1,null,10095,'Veteran''s Affairs','84146','infoReceiver',null,'ROCK VALLEY PHYSICAL THERAPY','1000000003','111111116','Chambers','Atkins','000100082','10000001','10001','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('18-JAN-18','DD-MON-RR'),null,to_date('18-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (332,1,4,4,1,null,10095,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','519','10000','name','123456','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('19-JAN-18','DD-MON-RR'),null,to_date('19-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (346,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','type','1234567','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-JAN-18','DD-MON-RR'),null,to_date('23-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (351,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','DragonClearingHouseId','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-JAN-18','DD-MON-RR'),null,to_date('23-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (387,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'GENETIVA HEALTH SVC','1000000009','111111120','Henderson','Yvonne','000100022','10000000','10020','231','DragonClearingHouseId','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-JAN-18','DD-MON-RR'),null,to_date('26-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (400,1,4,4,1,null,10095,'payerName','12115','infoReceiver',null,'providerInfo','012345678','111111113','patientLastname','firstName','999999999','10000001','222','billType','DragonClearingHouseId','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (409,1,4,4,1,null,10095,'Veteran''s Affairs','84146','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','name','123456','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (439,1,4,4,1,null,10095,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','231','10000','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('01-FEB-18','DD-MON-RR'),null,to_date('01-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (133,1,4,4,1,null,10095,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','name','123456','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (222,1,4,4,1,null,10095,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (254,1,4,4,1,null,10095,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','244566','Duncan','Ester','000100006','10000000','10000','231','123456','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (320,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'ROCK VALLEY PHYSICAL THERAPY','1000000003','111111112','Chambers','Atkins','000100082','10000001','10001','231','1234567','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('18-JAN-18','DD-MON-RR'),null,to_date('18-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (354,1,4,4,1,null,10095,'name','123456','name',null,'name','123456','123456','name','name','000100006','10000000','123456','name','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('24-JAN-18','DD-MON-RR'),null,to_date('24-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (379,1,4,4,1,null,10095,'Veteran''s Affairs','84146','infoReceiver',null,'ROCK VALLEY PHYSICAL THERAPY','1000000003','111111116','Chambers','Atkins','000100082','10000000','10001','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (395,1,4,4,1,null,10095,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','901234567','654321098','Dragon','Whosa','888888888','10000000','DragonPayerClaimControlNumber','DragonBillType','DragonClearingHouseId','DragonMedicalRecordNumber',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (434,1,4,4,1,null,10095,'name','123456','infoReceiver',null,'name','123456','111111113','name','name','000100006','123121234','123456','name','DragonClearingHouseId','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('01-FEB-18','DD-MON-RR'),null,to_date('01-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (135,1,4,4,1,null,10095,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','name','123456','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (200,1,4,4,1,null,10095,'name','123456','infoReceiver',null,'name','123456','111111113','name','name','000100006','123456','123456','name','DragonClearingHouseId','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('15-JAN-18','DD-MON-RR'),null,to_date('15-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (321,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'HUMANA VETERANS HEALTHCARE SERVICES','1000000001','765432109','Kennedy','Vonda','000100086','10000009','10009','231','DragonClearingHouseId','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('18-JAN-18','DD-MON-RR'),null,to_date('18-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (384,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'ROCK VALLEY PHYSICAL THERAPY','1000000003','111111116','Chambers','Atkins','000100082','10000000','10001','231','1234567','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-JAN-18','DD-MON-RR'),null,to_date('26-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (391,1,4,4,1,null,10095,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','890123456','543210987','Dragon','Whosa','888888888','10000000','DragonPayerClaimControlNumber','DragonBillType','clearingHouse','DragonMedicalRecordNumber',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (440,1,4,4,1,null,10095,'name','123456','name',null,'name','123456','244566','name','name','000100006','123121234','123456','name','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('02-FEB-18','DD-MON-RR'),null,to_date('02-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (204,1,1,1,1,null,10000,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','name','123456','123456',to_date('21-JAN-17','DD-MON-RR'),null,null,'Complete','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (227,115,2,3,6,null,10000,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','123456',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (369,172,1,1,1,null,10000,'name','123456','infoReceiver',null,'name','123456','123456','name','name','000100006','123456','123456','name','DragonClearingHouseId','123456',to_date('01-FEB-18','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('25-JAN-18','DD-MON-RR'),null,to_date('25-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (163,1,4,4,1,null,10095,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','name','123456','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (224,1,4,4,1,null,10095,'name','123456','name',null,'name','123456','111111113','name','name','000100006','123456','123456','name','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (324,1,4,4,1,null,10095,'payerName','12115','infoReceiver',null,'providerInfo','234567890','432109876','patientLastname','firstName','999999999','123','234','type','DragonClearingHouseId','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('18-JAN-18','DD-MON-RR'),null,to_date('18-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (329,1,4,4,1,null,10095,'Veteran''s Affairs','84146','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('19-JAN-18','DD-MON-RR'),null,to_date('19-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (349,1,4,4,1,null,10095,'Veteran''s Affairs','12115','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','519','10000','231','DragonClearingHouseId','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-JAN-18','DD-MON-RR'),null,to_date('23-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (360,1,4,4,1,null,10095,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','123456','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('24-JAN-18','DD-MON-RR'),null,to_date('24-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (392,1,4,4,1,null,10095,'DragonPayerName','12115','infoReceiver',null,'DragonProviderInformation','789012345','432109876','Dragon','Whosa','888888888','123456','DragonPayerClaimControlNumber','DragonBillType','clearingHouse','DragonMedicalRecordNumber',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (407,1,4,4,1,null,10095,'Veteran''s Affairs','84146','informationReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123','10000','231','10000','10000',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (410,1,4,4,1,null,10095,'Veteran''s Affairs','12115','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','123121234','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('30-JAN-18','DD-MON-RR'),null,to_date('30-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (216,114,4,4,5,null,10242,'Veteran''s Affairs','84146','10242',null,'UNIV OF SOUTH ALABAMA HEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('21-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-JAN-18','DD-MON-RR'),null,to_date('16-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (187,1,1,1,1,null,200617203000156,'Veteran''s Affairs','84146','10240',null,'LMH HEALTH PROFESSIONALS','1508086554','311425530','JACK','CC','000000001','11110000223','200617203000156','211','051817242879014','EI051817242879014-08',to_date('17-JAN-18','DD-MON-RR'),to_date('12-APR-11','DD-MON-RR'),to_date('12-APR-11','DD-MON-RR'),'PENDING','GENERATED',to_date('12-JAN-18','DD-MON-RR'),null,to_date('12-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (197,1,12,6,11,null,200617204000157,'Veteran''s Affairs','84146','10241',null,'MID OHIO EMERGENCY SERVIC','1386691780','311603722','JAME','CD','000000002','11110000223','200617204000157','211','201611161001616','EI051817242879014-08',to_date('20-JAN-18','DD-MON-RR'),to_date('12-APR-11','DD-MON-RR'),to_date('12-APR-11','DD-MON-RR'),'PENDING','GENERATED',to_date('15-JAN-18','DD-MON-RR'),null,to_date('15-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (442,1,4,4,1,null,10095,'Veteran''s Affairs','84146','10242',null,'UNIV OF SOUTH ALABAMA HEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('20-JAN-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('05-FEB-18','DD-MON-RR'),to_date('15-JAN-18','DD-MON-RR'),to_date('05-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (443,1,4,4,1,null,10095,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','890123456','543210987','Dragon','Whosa','888888888','10000000','DragonPayerClaimControlNumber','DragonBillType','clearingHouse','DragonMedicalRecordNumber',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('05-FEB-18','DD-MON-RR'),null,to_date('05-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (444,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('05-FEB-18','DD-MON-RR'),null,to_date('05-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (445,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('05-FEB-18','DD-MON-RR'),null,to_date('05-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (446,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-FEB-18','DD-MON-RR'),null,to_date('06-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (447,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-FEB-18','DD-MON-RR'),null,to_date('06-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (448,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-FEB-18','DD-MON-RR'),null,to_date('06-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (449,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-FEB-18','DD-MON-RR'),null,to_date('06-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (450,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-FEB-18','DD-MON-RR'),null,to_date('06-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (451,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-FEB-18','DD-MON-RR'),null,to_date('06-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (452,1,1,1,1,null,10084,'payerName','12115','infoReceiver',null,'providerInfo','234567890','765432109','patientLastname','firstName','999999999','123','234','type','DragonClearingHouseId','123',to_date('01-APR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',null,null,null,null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (453,1,1,1,1,null,10084,'payerName','12115','infoReceiver',null,'providerInfo','234567890','765432109','patientLastname','firstName','999999999','123','234','type','DragonClearingHouseId','123',to_date('01-APR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',null,null,null,null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (454,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-FEB-18','DD-MON-RR'),null,to_date('06-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (455,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-FEB-18','DD-MON-RR'),null,to_date('06-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (456,1,1,1,1,null,10084,'payerName','12115','infoReceiver',null,'providerInfo','234567890','765432109','patientLastname','firstName','999999999','123','234','type','DragonClearingHouseId','123',to_date('01-APR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',null,null,null,null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (457,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-FEB-18','DD-MON-RR'),null,to_date('06-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (458,1,1,1,1,null,10084,'payerName','12115','infoReceiver',null,'providerInfo','234567890','765432109','patientLastname','firstName','999999999','123','234','type','DragonClearingHouseId','123',to_date('01-APR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',null,null,null,null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (459,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-FEB-18','DD-MON-RR'),null,to_date('06-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (460,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-FEB-18','DD-MON-RR'),null,to_date('06-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (461,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-FEB-18','DD-MON-RR'),null,to_date('06-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (462,1,1,1,1,null,10084,'payerName','12115','infoReceiver',null,'providerInfo','234567890','765432109','patientLastname','firstName','999999999','123','234','type','DragonClearingHouseId','123',to_date('01-APR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',null,null,null,null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (463,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-FEB-18','DD-MON-RR'),null,to_date('06-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (464,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (465,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (466,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (467,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (468,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (469,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (471,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (472,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (473,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (474,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (475,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (476,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (477,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (478,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (479,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (480,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (481,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (482,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (483,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (484,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (485,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (486,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (487,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (488,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (489,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (490,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (491,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (492,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (493,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('07-FEB-18','DD-MON-RR'),null,to_date('07-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (494,194,6,6,6,null,10245,'Veteran''s Affairs','12115','10245',null,'PLAZAMEDCTROFFW','1000000008','111111118','Turner','Patrick','000100031','10000245','10245','221','10245','10245',to_date('01-APR-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('13-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (499,199,2,2,2,null,10245,'Veteran''s Affairs','12115','10245',null,'PLAZAMEDCTROFFW','1000000008','111111118','Turner','Patrick','000100031','10000245','10245','221','10245','10245',to_date('13-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (500,200,4,4,5,null,10245,'Veteran''s Affairs','12115','10245',null,'PLAZAMEDCTROFFW','1000000008','111111118','Turner','Patrick','000100031','10000245','10245','221','10245','10245',to_date('13-FEB-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (501,201,4,4,5,null,10245,'Veteran''s Affairs','12115','10245',null,'PLAZAMEDCTROFFW','1000000008','111111118','Turner','Patrick','000100031','10000245','10245','221','10245','10245',to_date('13-FEB-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (502,202,8,4,2,null,10241,'Veteran''s Affairs','12115','10241',null,'PLAZAMEDCTROFFW','1000000004','111111121','Burgess','Meyers','000100032','10000241','10241','211','201611161001616','201611161001616',to_date('13-FEB-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (503,203,5,5,5,null,10245,'Veteran''s Affairs','12115','10245',null,'PLAZAMEDCTROFFW','1000000008','111111118','Turner','Patrick','000100031','10000245','10245','221','10245','10245',to_date('13-FEB-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (504,204,6,6,5,null,10241,'Veteran''s Affairs','12115','10241',null,'PLAZAMEDCTROFFW','1000000004','111111121','Burgess','Meyers','000100032','10000241','10241','211','201611161001616','201611161001616',to_date('13-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (505,205,5,5,5,null,10241,'Veteran''s Affairs','12115','10241',null,'PLAZAMEDCTROFFW','1000000004','111111121','Burgess','Meyers','000100032','10000241','10241','211','201611161001616','201611161001616',to_date('13-FEB-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (506,206,8,4,5,null,10241,'Veteran''s Affairs','12115','10241',null,'PLAZAMEDCTROFFW','1000000004','111111121','Burgess','Meyers','000100032','10000241','10241','211','201611161001616','201611161001616',to_date('13-FEB-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (507,207,4,5,7,null,10241,'Veteran''s Affairs','12115','10241',null,'PLAZAMEDCTROFFW','1000000004','111111121','Burgess','Meyers','000100032','10000241','10241','211','201611161001616','201611161001616',to_date('13-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (508,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (509,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (510,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (511,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (512,208,6,8,6,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIVOFSOUTHALABAMAHEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('13-FEB-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (513,209,6,8,6,null,10241,'Veteran''s Affairs','12115','10241',null,'PLAZAMEDCTROFFW','1000000004','111111121','Burgess','Meyers','000100032','10000241','10241','211','201611161001616','201611161001616',to_date('13-FEB-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (514,210,6,8,6,null,10241,'Veteran''s Affairs','12115','10241',null,'PLAZAMEDCTROFFW','1000000004','111111121','Burgess','Meyers','000100032','10000241','10241','211','201611161001616','201611161001616',to_date('13-FEB-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (515,211,6,5,4,null,10241,'Veteran''s Affairs','12115','10241',null,'PLAZAMEDCTROFFW','1000000004','111111121','Burgess','Meyers','000100032','10000241','10241','211','201611161001616','201611161001616',to_date('13-FEB-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (516,212,6,5,4,null,10241,'Veteran''s Affairs','12115','10241',null,'PLAZAMEDCTROFFW','1000000004','111111121','Burgess','Meyers','000100032','10000241','10241','211','201611161001616','201611161001616',to_date('13-FEB-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (517,213,1,8,1,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIVOFSOUTHALABAMAHEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('13-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (518,214,9,5,17,null,200617204000157,'Veteran''s Affairs','84146','10241',null,'MID OHIO EMERGENCY SERVIC','1386691780','311603722','JAME','CD','000000002','11110000223','200617204000157','211','201611161001616','201611161001616',to_date('13-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (519,215,4,4,5,null,10245,'Veteran''s Affairs','12115','10245',null,'PLAZAMEDCTROFFW','1000000008','111111118','Turner','Patrick','000100031','10000245','10245','221','10245','10245',to_date('13-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (520,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (521,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (522,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('08-FEB-18','DD-MON-RR'),null,to_date('08-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (523,216,3,3,6,null,12345,'Payer name','12345','info receiver',null,'billing provider Name','1234567890','123456','last Name','First Name','1234567','1234','12345678','123',null,null,to_date('01-FEB-18','DD-MON-RR'),to_date('01-AUG-16','DD-MON-RR'),to_date('01-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (524,216,3,3,6,null,12345,'Payer name','12345','info receiver',null,'billing provider Name','1234567890','123456','last Name','First Name','1234567','1234','12345678','123','111','222',to_date('01-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (525,217,2,2,2,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIVOFSOUTHALABAMAHEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('14-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (526,218,1,2,3,null,11111,'Payer Names','11111','Information Receiver',null,'Billing Provider Name ','33333','44444','Patient Last Name ','Patient Last Name ','55555','12345','22222','123','111','222',to_date('25-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (527,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (528,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (529,217,10,5,5,null,22222,'payer name ','111','111',null,'bill provider name','111','111','last','first','111','111','111','111','111','111',to_date('09-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (530,217,10,5,5,null,22222,'payer name ','111','111',null,'bill provider name','111','111','last','first','111','111','111','111','111','111',to_date('09-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (534,219,7,8,6,null,10243,'Veteran''s Affairs','12115','10243',null,'UNIVOFWASHINGTONPHYSICIANS','1000000003','111111121','Gomez','Estela','000100003','10000243','10243','221','EI051817242879014-08','EI051817242879014-08',to_date('14-FEB-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (535,220,5,6,5,null,10243,'Veteran''s Affairs','12115','10243',null,'UNIVOFWASHINGTONPHYSICIANS','1000000003','111111121','Gomez','Estela','000100003','10000243','10243','221','EI051817242879014-08','EI051817242879014-08',to_date('14-FEB-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (537,221,4,4,7,null,10244,'Veteran''s Affairs','12115','10244',null,'SKAGITRADIOLOGYINC','1000000005','111111111','Ortega','Michael','000100091','10000244','10244','221','EI051817242879014-07','EI051817242879014-07',to_date('14-FEB-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (538,217,4,4,7,null,10244,'Veteran''s Affairs','12115','10244',null,'SKAGITRADIOLOGYINC','1000000005','111111111','Ortega','Michael','000100091','10000244','10244','221','EI051817242879014-07','EI051817242879014-07',to_date('14-FEB-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (539,217,4,4,7,null,10244,'Veteran''s Affairs','12115','10244',null,'SKAGITRADIOLOGYINC','1000000005','111111111','Ortega','Michael','000100091','10000244','10244','221','EI051817242879014-07','EI051817242879014-07',to_date('14-FEB-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (540,222,4,4,7,null,10244,'Veteran''s Affairs','12115','10244',null,'SKAGITRADIOLOGYINC','1000000005','111111111','Ortega','Michael','000100091','10000244','10244','221','EI051817242879014-07','EI051817242879014-07',to_date('14-FEB-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (541,164,4,4,7,null,10244,'Veteran''s Affairs','12115','10244',null,'SKAGITRADIOLOGYINC','1000000005','111111111','Ortega','Michael','000100091','10000244','10244','221','EI051817242879014-07','EI051817242879014-07',to_date('14-FEB-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (547,113,1,8,11,null,10241,'Veteran''s Affairs','12115','10241',null,'PLAZAMEDCTROFFW','1000000004','111111121','Burgess','Meyers','000100032','10000241','10241','211','201611161001616','201611161001616',to_date('14-FEB-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (548,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (550,1,1,1,2,null,10084,'payerName','payerId','infoReceiver',null,'providerInfo','provideNpi',null,'patientLastname','firstName','indentifier','123','234','billType','clearingHouse','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (551,1,4,4,1,null,10087,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','123456789',null,'Jahan','Kawsar','indentifier','519','222','billType','clearingHouse','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (552,1,4,4,1,null,10087,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','123456789',null,'Jahan','Kawsar','indentifier','519','222','billType','clearingHouse','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (553,1,4,4,1,null,10087,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','123456789',null,'Jahan','Kawsar','indentifier','519','222','billType','clearingHouse','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (554,1,4,4,1,null,10087,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','123456789',null,'Jahan','Kawsar','indentifier','519','222','billType','clearingHouse','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (555,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (556,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (557,217,1,1,1,null,22222,'1','1','1',null,'1','1','1','1','1','1','1','1','1','1','1',to_date('09-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (558,217,1,1,1,null,33333,'1','1','1',null,'1','1','1','1','1','1','1','1','1','1','1',to_date('14-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (559,223,4,4,5,null,10245,'Veteran''s Affairs','12115','10245',null,'PLAZAMEDCTROFFW','1000000008','111111118','Turner','Patrick','000100031','10000245','10245','221','10245','10245',to_date('14-FEB-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (560,1,4,4,1,null,10087,'DragonPayerName','12115','informationReceiver',null,'DragonProviderInformation','123456789',null,'Jahan','Kawsar','indentifier','519','222','billType','clearingHouse','123',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (561,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (562,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (563,217,3,2,1,null,10241,'Veteran''s Affairs','12115','10241',null,'PLAZAMEDCTROFFW','1000000004','111111121','Burgess','Meyers','000100032','10000241','10241','211','201611161001616','201611161001616',to_date('28-FEB-18','DD-MON-RR'),null,null,'Error','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (564,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (565,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (566,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (567,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (568,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (569,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (570,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (571,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (572,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('09-FEB-18','DD-MON-RR'),null,to_date('09-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (573,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('10-FEB-18','DD-MON-RR'),null,to_date('10-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (574,224,4,4,6,null,10245,'Veteran''s Affairs','12115','10245',null,'PLAZAMEDCTROFFW','1000000008','111111118','Turner','Patrick','000100031','10000245','10245','221','10245','10245',to_date('16-FEB-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('11-FEB-18','DD-MON-RR'),null,to_date('11-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (575,225,3,4,6,null,10241,'Veteran''s Affairs','12115','10241',null,'PLAZAMEDCTROFFW','1000000004','111111121','Burgess','Meyers','000100032','10000241','10241','211','201611161001616','201611161001616',to_date('16-FEB-18','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('11-FEB-18','DD-MON-RR'),null,to_date('11-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (576,226,6,5,4,null,10243,'Veteran''s Affairs','12115','10243',null,'UNIVOFWASHINGTONPHYSICIANS','1000000003','111111121','Gomez','Estela','000100003','10000243','10243','221','EI051817242879014-08','EI051817242879014-08',to_date('16-FEB-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('11-FEB-18','DD-MON-RR'),null,to_date('11-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (577,227,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('16-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('11-FEB-18','DD-MON-RR'),null,to_date('11-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (578,228,1,2,3,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('17-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (579,229,17,5,2,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('17-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (580,230,1,1,1,null,10000,'fdghfdhd','10000','xxxxxxxxxxxxxxx',null,'Njlkjkljlkjlkjlkjl','89898989',null,'last','xxxxxxxxxxxx','10000','10000','19999','xxxxxxxxxxx','9999999999','999999',to_date('12-FEB-19','DD-MON-RR'),to_date('01-JAN-20','DD-MON-RR'),to_date('01-JAN-20','DD-MON-RR'),'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (581,231,4,4,6,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIVOFSOUTHALABAMAHEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('17-FEB-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (582,232,16,1,14,null,10000,'xxxxxxx','123456','xxxxxxx',null,'xxxxxxx','123456','123456','xxxxxxx','xxxxxxx','123456','123456','123456','xxxxxxx','123456',null,to_date('12-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'),'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (583,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (584,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (585,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (586,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (587,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (588,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (589,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (590,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (591,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (592,233,1,2,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('17-FEB-18','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (593,234,2,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('12-FEB-22','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (594,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (595,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (596,235,3,2,1,null,10244,'Veteran''s Affairs','12115','10244',null,'SKAGITRADIOLOGYINC','1000000005','111111111','Ortega','Michael','000100091','10000244','10244','221','EI051817242879014-07','EI051817242879014-07',to_date('25-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (597,236,14,7,14,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIVOFSOUTHALABAMAHEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('17-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (598,235,1,1,1,null,22222,'payer name','123','555',null,'billing provider name','111','222','last name','first name','333','444','22222','777','888','000',to_date('28-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (599,235,17,8,8,null,12345,'1','2','11',null,'4','5','6','7','8','9','10','3','12','13','14',to_date('01-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (600,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (601,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (602,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (603,237,1,1,2,null,10000,'XXXXXXX','12345',null,null,'12345','12345','12345','XXXXXXX','XXXXXXX','12345','12345','12345','XXXXXXX','12345',null,to_date('12-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (604,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (605,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (606,238,4,1,6,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('12-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (607,239,5,5,7,null,10241,'Veteran''s Affairs','12115','10241',null,'PLAZAMEDCTROFFW','1000000004','111111121','Burgess','Meyers','000100032','10000241','10241','211','201611161001616','201611161001616',to_date('25-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (609,239,6,4,7,null,10244,'Veteran''s Affairs','12115','10244',null,'SKAGITRADIOLOGYINC','1000000005','111111111','Ortega','Michael','000100091','10000244','10244','221','EI051817242879014-07','EI051817242879014-07',to_date('01-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (610,240,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (611,239,4,4,5,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIVOFSOUTHALABAMAHEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('15-MAY-19','DD-MON-RR'),null,null,'Manually Closed','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (612,239,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (613,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (614,241,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('17-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (615,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (616,238,4,1,6,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('28-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (617,242,2,3,4,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('01-JAN-20','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (618,239,1,1,1,null,11111,'1','1','1',null,'1','1','1','1','1','1','1','1','1','1','1',to_date('27-FEB-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (619,239,1,1,1,null,11111,'1','1','1',null,'1','1','1','1','1','1','1','1','1','1','1',to_date('27-OCT-17','DD-MON-RR'),null,null,'Error','GENERATED',to_date('12-FEB-18','DD-MON-RR'),null,to_date('12-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (620,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('13-FEB-18','DD-MON-RR'),null,to_date('13-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (402,1,4,4,1,null,10095,'Veteran''s Affairs','84146','infoReceiver',null,'RIVERSIDE METH HOS','1000000004','111111113','Duncan','Ester','000100006','10000002','10000','231','10000','123456',to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('29-JAN-18','DD-MON-RR'),null,to_date('29-JAN-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (621,243,1,1,1,null,2222222222,'PayerName','1111111111','InformationReceiver',null,'BillingProviderName','3333333333','4444444444','PatientLastName','PatientFirstName','5555555555','6666666666','2222222222','BillType','7777777777','8888888888',to_date('19-FEB-17','DD-MON-RR'),null,null,'Complete','GENERATED',to_date('13-FEB-18','DD-MON-RR'),null,to_date('13-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (622,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('13-FEB-18','DD-MON-RR'),null,to_date('13-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (623,244,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('01-APR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('13-FEB-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (624,245,2,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('13-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('13-FEB-18','DD-MON-RR'),null,to_date('13-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (625,246,2,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('13-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('13-FEB-18','DD-MON-RR'),null,to_date('13-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (626,247,2,1,1,null,10001,'Veteran''s Affairs','12115',null,null,'ROCKVALLEYPHYSICALTHERAPY','1000000003','111111116','Chambers','Atkins','000100082','10000001','10001',null,null,null,to_date('13-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('13-FEB-18','DD-MON-RR'),null,to_date('13-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (627,11,1,1,1,null,2222222222,'PayerName','1111111111','InformationReceiver',null,'BillingProviderName','3333333333','4444444444','PatientLastName','PatientFirstName','5555555555','6666666666','2222222222','BillType','7777777777','8888888888',to_date('16-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (628,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (629,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (630,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (631,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (632,248,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('14-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (633,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (634,249,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('14-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (635,250,1,1,1,null,10000,'VA','12345','info',null,'VA',null,'12345','last name','VA first name','12345','12345','10000','bill type','12345','12345',to_date('14-FEB-20','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (636,251,1,1,1,null,10000,'VA','12345','info',null,'VA',null,'12345','last name','VA first name','12345','12345','10000','bill type','12345','12345',to_date('14-FEB-20','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (637,252,1,1,1,null,10000,'VA','12345','info',null,'VA',null,'12345','last name','VA first name','12345','12345','10000','bill type','12345','12345',to_date('14-FEB-20','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (638,253,1,1,1,null,10000,'VA','12345','info',null,'VA',null,'12345','last name','VA first name','12345','12345','10000','bill type','12345','12345',to_date('14-FEB-20','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (639,254,1,1,1,null,10000,'VA','12345','info',null,'VA',null,'12345','last name','VA first name','12345','12345','10000','bill type','12345','12345',to_date('14-FEB-20','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (640,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (641,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (642,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (643,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('14-FEB-18','DD-MON-RR'),null,to_date('14-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (644,255,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('16-FEB-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('15-FEB-18','DD-MON-RR'),null,to_date('15-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (645,255,1,1,1,null,85951,'Veteran''s Affairs','12115','1629129747',null,'MARY HITCHCOCK MEMORIAL HOSPITAL','1023092053','020222140','GGGGGG','XXXXXX','03756','H6599465803','85951','137','051817242879014','50218131 6',to_date('16-FEB-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('15-FEB-18','DD-MON-RR'),null,to_date('15-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (646,255,1,1,1,null,200617203000156,'Veteran''s Affairs','84146','10240',null,'LMH HEALTH PROFESSIONALS','1508086554','311425530','JACK','CC','000000001','11110000223','200617203000156','211','051817242871234','051817242879014',to_date('16-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('15-FEB-18','DD-MON-RR'),null,to_date('15-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (647,256,1,1,1,null,456321,'va','456321','info',null,'va','456321','456321','va','va','456321','456321','456321','type','456321','456321',to_date('15-FEB-18','DD-MON-RR'),to_date('01-FEB-15','DD-MON-RR'),to_date('01-FEB-17','DD-MON-RR'),'PENDING','GENERATED',to_date('15-FEB-18','DD-MON-RR'),null,to_date('15-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (648,257,1,1,1,null,456321,'va','456321','info',null,'va','456321','456321','va','va','456321','456321','456321','type','456321','456321',to_date('15-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('15-FEB-18','DD-MON-RR'),null,to_date('15-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (649,258,1,1,4,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('15-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('15-FEB-18','DD-MON-RR'),null,to_date('15-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (650,259,1,1,4,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('15-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('15-FEB-18','DD-MON-RR'),null,to_date('15-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (651,260,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('01-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('15-FEB-18','DD-MON-RR'),null,to_date('15-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (652,261,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('15-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('15-FEB-18','DD-MON-RR'),null,to_date('15-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (653,262,1,1,1,null,10310,'Veterans Affair''s','12115','765890342',null,'St Judes Hospital','734562198','734562189','Creek','Troy','654987','456328971','10310','211','765890341','765890344',to_date('16-FEB-18','DD-MON-RR'),to_date('15-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (654,263,1,1,1,null,10310,'Veterans Affair''s','12115','765890341',null,'St Judes Hospital','734562196','734562180','Creek','Jane','654982','456328973','10310','211','765890348','765890345',to_date('16-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (655,264,1,1,1,null,10311,'Veterans Affair''s','12115','765890341',null,'St Judes Hospital','734562197','734562181','Creek','Dana','654982','456328973','10311','211','765890348','765890345',to_date('16-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (656,265,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('20-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (659,265,16,8,18,null,200617270000158,'Veteran''s Affairs','84146','10242',null,'HEDGES CLINIC SERVICE CORP','1326111600','362748681','JOHN','GA','000000003','11110000225','200617270000158','231','EI051817242879014-09','EI051817242879014-09',to_date('20-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (660,266,2,2,2,null,85951,'Veteran''s Affairs','12115','1629129747',null,'MARY HITCHCOCK MEMORIAL HOSPITAL','1023092053','020222140','GGGGGG','XXXXXX','03756','H6599465803','85951','137','051817242879014','50218131 6',to_date('25-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (661,267,1,1,1,null,10245,'Veteran''s Affairs','12115','10245',null,'PLAZAMEDCTROFFW','1000000008','111111118','Turner','Patrick','000100031','10000245','10245','221','10245','10245',to_date('16-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (662,265,9,3,3,null,85951,'Veteran''s Affairs','12115','1629129747',null,'MARY HITCHCOCK MEMORIAL HOSPITAL','1023092053','020222140','GGGGGG','XXXXXX','03756','H6599465803','85951','137','051817242879014','50218131 6',to_date('25-FEB-18','DD-MON-RR'),to_date('25-OCT-16','DD-MON-RR'),to_date('25-OCT-16','DD-MON-RR'),'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (664,265,10,4,9,null,85951,'Veteran''s Affairs','12115','1629129747',null,'MARY HITCHCOCK MEMORIAL HOSPITAL','1023092053','020222140','GGGGGG','XXXXXX','03756','H6599465803','85951','137','051817242879014','50218131 6',to_date('25-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (665,268,1,1,3,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('20-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (666,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (670,272,1,1,1,null,12345,'va','12345','Information Receiver',null,'va','12345','12345','va','va','12345','12345','12345','type','12345','12345',to_date('16-FEB-18','DD-MON-RR'),to_date('01-JAN-16','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (671,273,3,2,2,null,10312,'Veterans Affairs','12115','122333',null,'Biller','123123123','321321321','Patient','Joe','112233','123','10312','211','22223','33332',to_date('28-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (672,274,3,2,2,null,10312,'Veterans Affairs','12115','122333',null,'Biller','123123123','321321321','Patient','Joe','112233','123','10312','211','22223','33332',to_date('28-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (673,275,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('16-FEB-18','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (674,276,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('16-FEB-18','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (675,277,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('16-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (676,278,1,1,1,null,12345,'name','12345','test',null,'name','12345','12345','name','name','12345','12345','12345','12345','12345','12345',to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'),to_date('03-FEB-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (677,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (678,279,1,1,1,null,12345,'name','12345','test',null,'name','12345','12345','name','name','12345','12345','12345','12345','12345','12345',to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'),to_date('03-FEB-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (679,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (680,280,1,1,1,null,12345,'name','12345','name',null,'name','12345','12345','name','name','12345','12345','12345','name','12345','12345',to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (681,161,2,3,2,null,85951,'Veteran''s Affairs','12115','1629129747',null,'MARY HITCHCOCK MEMORIAL HOSPITAL','1023092053','020222140','GGGGGG','XXXXXX','03756','H6599465803','85951','137','051817242879014','50218131 6',to_date('20-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (682,281,1,2,2,null,12345,'name','123456','name',null,'name','123456','123456','name','name','123456','123456','12345','name','123456','123456',to_date('16-FEB-18','DD-MON-RR'),to_date('01-JAN-18','DD-MON-RR'),to_date('01-JAN-19','DD-MON-RR'),'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (683,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (684,282,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('01-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (685,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (686,282,1,1,1,null,12345,'test','12345','test',null,'test','12345','12345','test','test','12345','12345','12345','test','12345','12345',to_date('15-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'),to_date('16-FEB-18','DD-MON-RR'),'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (687,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('16-FEB-18','DD-MON-RR'),null,to_date('16-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (688,283,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('20-FEB-18','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (689,284,9,4,8,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('01-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (690,11,12,6,5,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('17-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (691,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (692,285,2,4,5,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('01-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (693,286,131,5,5,null,10000,'xx','121','xxxxx',null,'xxxxx','121','23424','xxxxx','xxxxx','3434','12222','10000','xxxxx','12222','1221',to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'),to_date('20-FEB-18','DD-MON-RR'),'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (694,239,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (695,239,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (696,287,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (697,239,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (698,239,5,2,4,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('01-JAN-20','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (699,239,5,2,4,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('01-JAN-20','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (700,239,5,2,4,null,10002,'Veteran''s Affairs','12115',null,null,'HUMANAVETERANSHEALTHCARESERVICES','1000000003','111111112','David','Weaver','000100046','10000002','10002',null,null,null,to_date('01-JAN-20','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (701,239,5,2,2,null,12345,'xxxx','12345','xxxx',null,'xxxx','12345','12345','xxxx','xxxx','12345','12345','12345','xxxx','12345','12345',to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'),to_date('20-FEB-18','DD-MON-RR'),'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (702,288,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (703,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (704,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (705,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (706,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (707,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (708,289,3,2,1,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIVOFSOUTHALABAMAHEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('25-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('20-FEB-18','DD-MON-RR'),null,to_date('20-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (709,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('21-FEB-18','DD-MON-RR'),null,to_date('21-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (710,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('21-FEB-18','DD-MON-RR'),null,to_date('21-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (711,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('21-FEB-18','DD-MON-RR'),null,to_date('21-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (712,290,4,1,3,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('01-JAN-18','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),to_date('16-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('21-FEB-18','DD-MON-RR'),null,to_date('21-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (713,291,3,2,4,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('01-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('21-FEB-18','DD-MON-RR'),null,to_date('21-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (714,292,3,3,5,null,12345,'xxxx','12345','xxxx',null,'xxxx','12345','12345','xxxx','xxxx','12345','12345','12345','xxxx','12345','12345',to_date('01-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('21-FEB-18','DD-MON-RR'),null,to_date('21-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (715,292,6,4,5,null,12345,'text','12345','text',null,'text','12345','12345','text','text','12345','12345','12345','text','12345','12345',to_date('21-FEB-18','DD-MON-RR'),to_date('01-FEB-14','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'),'PENDING','GENERATED',to_date('21-FEB-18','DD-MON-RR'),null,to_date('21-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (716,292,1,4,3,null,12345,'text','12345','terg',null,'tex','12345','12345','text','text','12345','12345','12345','thrtfh','12345','12345',to_date('01-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('21-FEB-18','DD-MON-RR'),null,to_date('21-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (717,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('21-FEB-18','DD-MON-RR'),null,to_date('21-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (718,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('21-FEB-18','DD-MON-RR'),null,to_date('21-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (719,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('21-FEB-18','DD-MON-RR'),null,to_date('21-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (720,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('21-FEB-18','DD-MON-RR'),null,to_date('21-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (721,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('21-FEB-18','DD-MON-RR'),null,to_date('21-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (722,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('21-FEB-18','DD-MON-RR'),null,to_date('21-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (723,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (724,292,3,2,2,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('01-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (725,293,3,2,2,null,12345,'xxxx','12345','xxxx',null,'xxxx','12345','12345','xxxx','xxxx','12345','12345','12345','xxxx','12345','12345',to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'),'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (726,294,2,5,5,null,12345,'xxxx','12345','xxxx',null,'xxxx','12345','12345','xxxx','xxxx','12345','12345','12345','xxxx','12345','12345',to_date('01-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (727,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (728,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (729,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (730,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (731,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (732,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (733,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (734,289,3,4,113,null,10244,'Veteran''s Affairs','12115','10244',null,'SKAGITRADIOLOGYINC','1000000005','111111111','Ortega','Michael','000100091','10000244','10244','221','EI051817242879014-07','EI051817242879014-07',to_date('01-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (735,295,2,2,1,null,1,'1','1','1',null,'1','1','1','1','1','1','1','1','1','1','1',to_date('03-MAR-18','DD-MON-RR'),to_date('10-FEB-17','DD-MON-RR'),to_date('20-FEB-17','DD-MON-RR'),'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (736,296,2,2,1,null,11111,'1','1','1',null,'1','1','1','1','1','1','12345','11111','1','1','1',to_date('03-MAR-18','DD-MON-RR'),to_date('10-FEB-17','DD-MON-RR'),to_date('20-FEB-17','DD-MON-RR'),'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (737,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (738,297,1,1,1,null,11001,'Veterans Affair''s','12115','845621373',null,'Christus Spohn Hospital','845621378','845621371','Butler','Gerard','845621379','845621372','11001','211','845621376','845621375',to_date('27-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (739,289,132,128,1,null,10243,'Veteran''s Affairs','12115','10243',null,'UNIVOFWASHINGTONPHYSICIANS','1000000003','111111121','Gomez','Estela','000100003','10000243','10243','221','EI051817242879014-08','EI051817242879014-08',to_date('28-FEB-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (740,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (741,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (742,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (743,298,2,2,4,null,12345,'xxxxx','12345','xxxxx',null,'xxxxx','12345','12345','xxxxx','xxxxx','12345','12345','12345','xxxxx','123456','1233',to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-15','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'),'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (744,289,1,1,1,null,12345,'1','1','1',null,'1','1','1','1','1','1','1','12345','1','1','1',to_date('27-FEB-18','DD-MON-RR'),to_date('01-JAN-17','DD-MON-RR'),to_date('02-JAN-17','DD-MON-RR'),'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (745,299,1,128,1,null,11111,'1','1','1',null,'1','1','1','1','1','1','1','11111','1','1','1',to_date('01-MAR-18','DD-MON-RR'),to_date('01-JAN-17','DD-MON-RR'),to_date('02-JAN-17','DD-MON-RR'),'PENDING','GENERATED',to_date('22-FEB-18','DD-MON-RR'),null,to_date('22-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (746,300,131,128,19,null,22222,'1','1','1',null,'1','1','1','1','1','1','1','22222','1','1','1',to_date('05-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-FEB-18','DD-MON-RR'),null,to_date('23-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (747,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-FEB-18','DD-MON-RR'),null,to_date('23-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (748,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-FEB-18','DD-MON-RR'),null,to_date('23-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (749,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-FEB-18','DD-MON-RR'),null,to_date('23-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (750,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-FEB-18','DD-MON-RR'),null,to_date('23-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (751,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-FEB-18','DD-MON-RR'),null,to_date('23-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (752,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-FEB-18','DD-MON-RR'),null,to_date('23-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (753,301,1,1,1,null,11002,'Veterans Affair''s','12115','326481934',null,'CHRISTUS SPOHN HOSPITAL','326481939','326481931','Salvatore','Stephen','326481932','326481933','11002','211','326481935','326481936',to_date('28-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-FEB-18','DD-MON-RR'),null,to_date('23-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (754,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-FEB-18','DD-MON-RR'),null,to_date('23-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (755,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-FEB-18','DD-MON-RR'),null,to_date('23-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (756,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-FEB-18','DD-MON-RR'),null,to_date('23-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (757,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('23-FEB-18','DD-MON-RR'),null,to_date('23-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (758,301,1,1,1,null,10245,'Veteran''s Affairs','12115','10245',null,'PLAZAMEDCTROFFW','1000000008','111111118','Turner','Patrick','000100031','10000245','10245','221','10245','10245',to_date('03-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('25-FEB-18','DD-MON-RR'),null,to_date('25-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (759,302,1,2,3,null,44444,'1','1','1',null,'1','1','1','1','1','1','1','44444','1','1','1',to_date('10-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (760,303,1,2,3,null,10242,'Veteran''s Affairs','12115','10242',null,'UNIVOFSOUTHALABAMAHEA','1000000003','111111121','Dunn','Deirdre','000100010','10000242','10242','231','EI051817242879014-09','EI051817242879014-09',to_date('10-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (761,303,5,5,19,null,55555,'payer name','123','info receiver',null,'billing provider name','456','789','last name','first name','0123','45678','55555','111','222','333',to_date('20-MAR-18','DD-MON-RR'),to_date('01-JAN-17','DD-MON-RR'),to_date('02-FEB-17','DD-MON-RR'),'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (762,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (763,289,1,2,3,null,200617204000157,'Veteran''s Affairs','84146','10241',null,'MID OHIO EMERGENCY SERVIC','1386691780','311603722','JAME','CD','000000002','11110000223','200617204000157','211','201611161001616','201611161001616',to_date('15-MAR-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (764,304,4,4,5,null,77777,'payer name','123','info receiver',null,'billing provider name','456','789','last name','first name','0123','45678','77777','111','222','333',to_date('05-MAR-18','DD-MON-RR'),to_date('02-JAN-17','DD-MON-RR'),to_date('04-MAR-17','DD-MON-RR'),'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (765,289,4,5,5,null,10244,'Veteran''s Affairs','12115','10244',null,'SKAGITRADIOLOGYINC','1000000005','111111111','Ortega','Michael','000100091','10000244','10244','221','EI051817242879014-07','EI051817242879014-07',to_date('20-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (766,289,17,128,9,null,200617204000157,'Veteran''s Affairs','84146','10241',null,'MID OHIO EMERGENCY SERVIC','1386691780','311603722','JAME','CD','000000002','11110000223','200617204000157','211','201611161001616','201611161001616',to_date('04-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (767,305,5,5,3,null,10243,'Veteran''s Affairs','12115','10243',null,'UNIVOFWASHINGTONPHYSICIANS','1000000003','111111121','Gomez','Estela','000100003','10000243','10243','221','EI051817242879014-08','EI051817242879014-08',to_date('10-MAR-18','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),to_date('15-SEP-17','DD-MON-RR'),'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (768,289,7,1,19,null,22222,'payer name','111','777',null,'bill pro name','333','444','last name','first name','555','666','22222','888','999','000',to_date('15-MAR-18','DD-MON-RR'),to_date('11-NOV-17','DD-MON-RR'),to_date('01-DEC-17','DD-MON-RR'),'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (769,303,3,2,2,null,10241,'Veteran''s Affairs','12115','10241',null,'PLAZAMEDCTROFFW','1000000004','111111121','Burgess','Meyers','000100032','10000241','10241','211','201611161001616','201611161001616',to_date('04-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (770,306,10,7,11,null,11111,'payer name','111','666',null,'billing provider name','222','333','last name','first name','444','55555','11111','777','888','999',to_date('10-MAR-18','DD-MON-RR'),to_date('20-JAN-17','DD-MON-RR'),to_date('25-FEB-17','DD-MON-RR'),'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (771,307,10,6,7,null,99999,'PAYER name','999','4444',null,'bill pro NAME','8888','7777','last','first','6666','5555','99999','3333','2222','1111',to_date('05-MAR-18','DD-MON-RR'),to_date('10-MAY-17','DD-MON-RR'),to_date('20-OCT-17','DD-MON-RR'),'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (772,303,13,4,6,null,200617204000157,'Veteran''s Affairs','84146','10241',null,'MID OHIO EMERGENCY SERVIC','1386691780','311603722','JAME','CD','000000002','11110000223','200617204000157','211','201611161001616','201611161001616',to_date('01-APR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (773,303,5,5,6,null,200617204000157,'Veteran''s Affairs','84146','10241',null,'MID OHIO EMERGENCY SERVIC','1386691780','311603722','JAME','CD','000000002','11110000223','200617204000157','211','201611161001616','201611161001616',to_date('20-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (774,307,5,6,4,null,22222,'payer NAME','111','777',null,'bill Name','333','444','last','first','555','666','22222','888','999','1000',to_date('01-APR-18','DD-MON-RR'),to_date('20-JAN-17','DD-MON-RR'),to_date('15-NOV-17','DD-MON-RR'),'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (775,306,10,6,12,null,10244,'Veteran''s Affairs','12115','10244',null,'SKAGITRADIOLOGYINC','1000000005','111111111','Ortega','Michael','000100091','10000244','10244','221','EI051817242879014-07','EI051817242879014-07',to_date('05-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('26-FEB-18','DD-MON-RR'),null,to_date('26-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (776,303,1,2,3,null,12345,'payer name','2','9',null,'bill provider name','3','4','5','6','7','8','12345','10','11','12',to_date('05-MAR-18','DD-MON-RR'),to_date('20-AUG-17','DD-MON-RR'),to_date('11-NOV-17','DD-MON-RR'),'PENDING','GENERATED',to_date('27-FEB-18','DD-MON-RR'),null,to_date('27-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (777,289,3,3,3,null,11111,'name','1','1',null,'name','1','1','1','1','1','1','11111','1','1','1',to_date('01-APR-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'),to_date('02-FEB-18','DD-MON-RR'),'PENDING','GENERATED',to_date('27-FEB-18','DD-MON-RR'),null,to_date('27-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (778,303,1,1,1,null,12345,'1','1','1',null,'1','1','1','1','1','1','1','12345','1','1','1',to_date('04-APR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('27-FEB-18','DD-MON-RR'),null,to_date('27-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (779,303,1,2,3,null,10243,'Veteran''s Affairs','12115','10243',null,'UNIVOFWASHINGTONPHYSICIANS','1000000003','111111121','Gomez','Estela','000100003','10000243','10243','221','EI051817242879014-08','EI051817242879014-08',to_date('02-APR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('27-FEB-18','DD-MON-RR'),null,to_date('27-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (782,303,2,2,2,null,77777,'payer name','111','666',null,'bill provider name','222','333','last','First','444','555','77777','777','888','999',to_date('10-MAR-18','DD-MON-RR'),to_date('10-OCT-17','DD-MON-RR'),to_date('15-NOV-17','DD-MON-RR'),'PENDING','GENERATED',to_date('27-FEB-18','DD-MON-RR'),null,to_date('27-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (783,308,7,8,5,null,200617204000157,'Veteran''s Affairs','84146','10241',null,'MID OHIO EMERGENCY SERVIC','1386691780','311603722','JAME','CD','000000002','11110000223','200617204000157','211','201611161001616','201611161001616',to_date('05-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('27-FEB-18','DD-MON-RR'),null,to_date('27-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (784,303,1,1,1,null,88888,'payer name','1','7',null,'2','3','4','last','first','5','6','88888','8','9','10',to_date('15-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('27-FEB-18','DD-MON-RR'),null,to_date('27-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (785,293,3,2,3,null,12345,'xxxx','12345','xxxx',null,'xxxx','12345','12345','xxxx','xxxx','12345','12345','12345','xxxx','12234','12234',to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'),to_date('27-FEB-18','DD-MON-RR'),'PENDING','GENERATED',to_date('27-FEB-18','DD-MON-RR'),null,to_date('27-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (786,161,2,3,5,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('05-MAR-18','DD-MON-RR'),null,null,'COMPLETE','GENERATED',to_date('28-FEB-18','DD-MON-RR'),null,to_date('28-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (787,161,2,1,9,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('05-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('28-FEB-18','DD-MON-RR'),null,to_date('28-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (788,161,1,1,1,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('05-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('28-FEB-18','DD-MON-RR'),null,to_date('28-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (789,161,3,1,9,null,10000,'Veteran''s Affairs','12115','100001111',null,'RIVERSIDEMETHHOS','1000000004','111111113','Duncan','Ester','000100006','10000000','10000','231','10000','10000',to_date('31-MAY-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('28-FEB-18','DD-MON-RR'),null,to_date('28-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (790,303,1,2,2,null,1,'1','1','1',null,'1','1','1','1','1','1','1','1','1','1','1',to_date('28-FEB-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('28-FEB-18','DD-MON-RR'),null,to_date('28-FEB-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (791,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('01-MAR-18','DD-MON-RR'),null,to_date('01-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (792,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('02-MAR-18','DD-MON-RR'),null,to_date('02-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (793,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('02-MAR-18','DD-MON-RR'),null,to_date('02-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (794,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('02-MAR-18','DD-MON-RR'),null,to_date('02-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (795,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('02-MAR-18','DD-MON-RR'),null,to_date('02-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (796,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('02-MAR-18','DD-MON-RR'),null,to_date('02-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (797,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('02-MAR-18','DD-MON-RR'),null,to_date('02-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (798,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('02-MAR-18','DD-MON-RR'),null,to_date('02-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (799,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('05-MAR-18','DD-MON-RR'),null,to_date('05-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (800,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('05-MAR-18','DD-MON-RR'),null,to_date('05-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (801,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('05-MAR-18','DD-MON-RR'),null,to_date('05-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (802,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('05-MAR-18','DD-MON-RR'),null,to_date('05-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (803,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('05-MAR-18','DD-MON-RR'),null,to_date('05-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (804,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('05-MAR-18','DD-MON-RR'),null,to_date('05-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (805,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('05-MAR-18','DD-MON-RR'),null,to_date('05-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (806,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('05-MAR-18','DD-MON-RR'),null,to_date('05-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (807,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('05-MAR-18','DD-MON-RR'),null,to_date('05-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (808,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('05-MAR-18','DD-MON-RR'),null,to_date('05-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (809,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('05-MAR-18','DD-MON-RR'),null,to_date('05-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (810,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (811,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (812,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (813,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (814,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (815,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (816,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (817,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (818,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (819,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (820,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (821,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (822,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (823,161,1,1,1,null,85951,'Veteran''s Affairs','12115','1629129747',null,'MARY HITCHCOCK MEMORIAL HOSPITAL','1023092053','020222140','GGGGGG','XXXXXX','03756','H6599465803','85951','137','051817242879014','50218131 6',to_date('10-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (824,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (825,161,14,4,8,null,200617203000156,'Veteran''s Affairs','84146','10240',null,'LMH HEALTH PROFESSIONALS','1508086554','311425530','JACK','CC','000000001','11110000223','200617203000156','211','051817242871234','051817242879014',to_date('10-MAR-18','DD-MON-RR'),to_date('18-APR-11','DD-MON-RR'),to_date('18-APR-11','DD-MON-RR'),'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (826,161,1,1,1,null,85951,'Veteran''s Affairs','12115','1629129747',null,'MARY HITCHCOCK MEMORIAL HOSPITAL','1023092053','020222140','GGGGGG','XXXXXX','03756','H6599465803','85951','137','051817242879014','50218131 6',to_date('10-MAR-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (827,161,5,5,8,null,200617203000156,'Veteran''s Affairs','84146','10240',null,'LMH HEALTH PROFESSIONALS','1508086554','311425530','JACK','CC','000000001','11110000223','200617203000156','211','051817242871234','051817242879014',to_date('10-OCT-18','DD-MON-RR'),null,null,'PENDING','GENERATED',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (828,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (829,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (830,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (831,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (832,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (833,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('06-MAR-18','DD-MON-RR'),null,to_date('06-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (834,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (835,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (836,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (837,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (838,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (839,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (840,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (841,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (845,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (842,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (844,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (843,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (846,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (847,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (848,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (849,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (851,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (850,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (852,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (853,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (854,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (855,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (856,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('07-MAR-18','DD-MON-RR'),null,to_date('07-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (857,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (858,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (859,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (860,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (861,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (862,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (863,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (864,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (865,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (866,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (867,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (868,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (869,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (870,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (871,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (872,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (873,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (874,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (875,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (876,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (877,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (878,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (879,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (880,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (881,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (882,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (883,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (884,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (885,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (886,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (887,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (888,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (889,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (890,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (891,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (892,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (893,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (894,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (895,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (896,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (897,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (898,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (899,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (900,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (901,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (902,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (903,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (904,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (905,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (906,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (907,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (908,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (909,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (910,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (911,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (912,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (913,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (914,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (915,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (916,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (917,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (918,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (919,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (920,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (921,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (922,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (923,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (924,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (925,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (926,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (927,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (928,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (929,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (930,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (931,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (932,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (933,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('08-MAR-18','DD-MON-RR'),null,to_date('08-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (934,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('09-MAR-18','DD-MON-RR'),null,to_date('09-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (935,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('09-MAR-18','DD-MON-RR'),null,to_date('09-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (936,142,1,2,3,null,10240,'Veteran''s Affairs','12115','10240',null,'JOHN MUIR TRAUMA PHYS','1000000006','111111119','Holden','Ines','000100090','10000240','10240','211','051817242879014','051817242879014',to_date('21-JAN-18','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('10-MAR-18','DD-MON-RR'),null,to_date('10-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (937,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('11-MAR-18','DD-MON-RR'),null,to_date('11-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (938,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('12-MAR-18','DD-MON-RR'),null,to_date('12-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (939,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('12-MAR-18','DD-MON-RR'),null,to_date('12-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION (SUBMISSIONID,CONTACTUSERID,HCCS_ID,LOINC_ID,LOINC_MOD_ID,TRN02CPE_PDI,TRN02FPPS_CLAIM_ID,HL1NM103PYR_NM,HL1NM109PYR_ID,HL2NM103INF_RCVR,HL1PER04VAMCCNTEM,HL3NM103SVCBILLPRVNM,HL3NM109PRVNPI,HL2NM109SVCPRVTIN,HL4NM103PTLSTNM,HL4NM104PTFTNM,HL4NM109PTID,REF102PTCTRLNMBR,TRN02PYRCLMCTRLNMBR,REF202BILLTYPE,REF402CLRNGHSID,REF302MEDRECNMBR,DTP203RESPONSEDUEDATE,DTP103SVCFRMDT,DTP103SVCTODT,SUBMISSION_STATUS,GENERATE277_STATUS,DATECREATED,DATESUBMITTED,DATEMODIFIED,N3RSPCNTADDRSLN,N3RSPCNTADDLADDRLN,N4RSPCNTCITY,N4RSPCNTSTCD,N4RSPCNTZPCD,N4RSPCNTCTRYCD) values (940,1,4,4,1,null,10095,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,to_date('12-DEC-17','DD-MON-RR'),null,null,'PENDING','PENDING',to_date('12-MAR-18','DD-MON-RR'),null,to_date('12-MAR-18','DD-MON-RR'),null,null,null,null,null,null);
REM INSERTING into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE
SET DEFINE OFF;
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (100,57,'Adding a Dragon Note','PENDING','DragonStatus',null,to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (101,452,'Adding a Dragon Note','PENDING','DragonStatus',null,to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (102,453,'Adding a Dragon Note','PENDING','DragonStatus',null,to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (103,456,'Adding a Dragon Note','PENDING','DragonStatus',null,to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (104,458,'Adding a Dragon Note','PENDING','DragonStatus',null,to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (105,462,'Adding a Dragon Note','PENDING','DragonStatus',null,to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (106,462,'Adding a Dragon Note','DragonStatus','DragonStatus2',null,to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (107,1,'Adding a Dragon Note','PENDING','DragonStatus2',null,to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (109,1,null,'DragonStatus2','DragonStatus2',null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (110,1,null,'DragonStatus2','DragonStatus2',null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (111,1,null,'DragonStatus2',null,null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (112,1,null,null,'NEWSTATUS',null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (113,1,null,'NEWSTATUS','NEWSTATUS',null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (114,1,null,'NEWSTATUS','NEWSTATUS',null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (115,1,null,'NEWSTATUS','NEWSTATUS',null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (116,1,null,'NEWSTATUS','NEWSTATUS2',null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (117,166,'Test','SUBMITTED','Complete',null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (118,166,'Test','Complete','Complete',null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (119,188,'test','SUBMITTED','Complete',null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (120,166,'Notes','Complete','Closed',null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (121,166,'notes','Closed','Abandoned',null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (122,166,'Notes','Abandoned','Closed',null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (123,166,'tests','Closed','Error',null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (124,204,'New update','PENDING','Complete',null,to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (125,258,null,'PENDING','Error',null,to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (126,258,null,'Error','Pending Response',null,to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (127,258,'notes','Pending Response','Pending Response',null,to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (128,494,'THIS IS A NOTE',null,'ABANDONED',null,to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (129,494,'THIS IS A NOTE','ABANDONED','ABANDONED',null,to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (130,494,'THIS IS A NOTE','ABANDONED','ABANDONED',null,to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (131,494,'THIS IS A NOTE','ABANDONED','ABANDONED',null,to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (132,166,'test','Error','Complete',null,to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (133,166,'Test','Complete','Complete',null,to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (134,166,'test','Complete','Error',null,to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (135,166,'Test','Error','Complete',null,to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (136,252,null,'PENDING','PENDING',null,to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (137,252,null,'PENDING','Abandoned',null,to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (138,252,null,'Abandoned','Pending Response',null,to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (139,563,null,null,'Pending Response',null,to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (140,563,null,'Pending Response','Error',null,to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (141,563,'test comments

test comments 2','Error','Error',null,to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (142,258,null,'Pending Response','Abandoned',null,to_date('11-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (143,166,'Test','Complete','Error',null,to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (144,494,'THIS IS A NOTE','ABANDONED','ABANDONED',null,to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (145,494,'THIS IS A NOTE','ABANDONED','ABANDONED',null,to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (146,166,null,'Error','Error',null,to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (147,603,'Test','PENDING','Complete',null,to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (148,603,null,'Complete','Complete',null,to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (149,603,'Abondoned','Complete','Abandoned',null,to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (150,611,'updated response due date TEST','PENDING','PENDING',null,to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (151,611,'updated response due date TEST
updated to error TEST 2
','PENDING','Error',null,to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (152,606,'save 1
','PENDING','PENDING',null,to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (153,611,'write something','Error','Error',null,to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (154,611,'write something','Error','Error',null,to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (155,619,'comment required? test
','PENDING','Error',null,to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (156,494,'THIS IS A NOTE','ABANDONED','ABANDONED',null,to_date('13-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (157,621,'Updated for Testing','PENDING','Manually Closed',null,to_date('13-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (158,621,'Updated for Testing','Manually Closed','Manually Closed',null,to_date('13-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (159,621,'Note','Manually Closed','Complete',null,to_date('13-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (160,621,'Note','Complete','Complete',null,to_date('13-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (161,621,'Note','Complete','Complete',null,to_date('13-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (162,60,'alter','PENDING','PENDING',null,to_date('13-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (163,623,'THIS IS A NOTE','PENDING','ABANDONED',null,to_date('14-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (164,623,'THIS IS A NOTE','ABANDONED','PENDING',null,to_date('14-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (165,623,'THIS IS A NOTE','PENDING','PENDING',null,to_date('14-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (166,623,'THIS IS A NOTE','PENDING','PENDING',null,to_date('14-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (167,611,'updated to manually closed','Error','Manually Closed',null,to_date('14-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (168,166,'I received this attachment via post and uploaded or provided here: ','Error','Manually Closed',null,to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (169,166,'I received this attachment via post and uploaded or provided here: ','Manually Closed','Manually Closed',null,to_date('16-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (170,623,'THIS IS A NOTE','PENDING','PENDING',null,to_date('02-MAR-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (171,623,'THIS IS A NOTE','PENDING','PENDING',null,to_date('05-MAR-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (172,623,'THIS IS A NOTE','PENDING','PENDING',null,to_date('05-MAR-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (173,623,'THIS IS A NOTE','PENDING','PENDING',null,to_date('06-MAR-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (174,623,'THIS IS A NOTE','PENDING','PENDING',null,to_date('06-MAR-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SUBMISSION_NOTE (CLAIM_SUBMISSION_NOTE_ID,CLAIM_SUBMISSION_ID,CLAIM_SUBMISSION_NOTE,CLAIM_SUBMISSION_OLD_STATUS,CLAIM_SUBMISSION_NEW_STATUS,CREATED_BY,DATE_CREATED) values (175,623,'THIS IS A NOTE','PENDING','PENDING',null,to_date('08-MAR-18','DD-MON-RR'));
REM INSERTING into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES
SET DEFINE OFF;
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (52,440,'10087',to_date('01-DEC-17','DD-MON-RR'),to_date('02-DEC-17','DD-MON-RR'),null,'DragonProcedurecode','DragonMod',3.5,null,null);
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (53,59,'10087',to_date('01-DEC-17','DD-MON-RR'),to_date('02-DEC-17','DD-MON-RR'),null,'DragonProcedurecode','DragonMod',3.5,to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (60,60,'10087',to_date('01-DEC-17','DD-MON-RR'),to_date('02-DEC-17','DD-MON-RR'),null,'DragonProcedurecode','DragonMod',3.5,to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (63,64,'10088',to_date('11-SEP-17','DD-MON-RR'),to_date('21-SEP-17','DD-MON-RR'),'16','aaa',null,111,to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (64,65,'10087',to_date('01-DEC-17','DD-MON-RR'),to_date('02-DEC-17','DD-MON-RR'),'DragonRevenueCode','DragonProcedurecode','DragonMod',3.5,to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (114,115,'10087',to_date('01-DEC-17','DD-MON-RR'),to_date('02-DEC-17','DD-MON-RR'),'DragonRevenueCode','DragonProcedurecode','DragonMod',3.5,to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (115,116,'10087',to_date('01-DEC-17','DD-MON-RR'),to_date('02-DEC-17','DD-MON-RR'),'DragonRevenueCode','DragonProcedurecode','DragonMod',3.5,to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (116,117,'10087',to_date('01-DEC-17','DD-MON-RR'),to_date('02-DEC-17','DD-MON-RR'),'DragonRevenueCode','DragonProcedurecode','DragonMod',3.5,to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (68,69,'10089',to_date('11-SEP-17','DD-MON-RR'),to_date('21-SEP-17','DD-MON-RR'),'16','aaa',null,111,to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (118,119,'10087',to_date('01-DEC-17','DD-MON-RR'),to_date('02-DEC-17','DD-MON-RR'),'DragonRevenueCode','DragonProcedurecode','DragonMod',3.5,to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (70,71,'10090',to_date('11-SEP-17','DD-MON-RR'),to_date('21-SEP-17','DD-MON-RR'),'16','aaa',null,111,to_date('11-JAN-18','DD-MON-RR'),to_date('11-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (121,122,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (122,123,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (123,125,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (130,133,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (131,135,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (140,145,'10087',to_date('01-DEC-17','DD-MON-RR'),to_date('02-DEC-17','DD-MON-RR'),'DragonRevenueCode','DragonProcedurecode','DragonMod',3.5,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (143,148,'10087',to_date('11-SEP-17','DD-MON-RR'),to_date('21-SEP-17','DD-MON-RR'),'16','aaa',null,111,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (144,149,'10087',to_date('11-SEP-17','DD-MON-RR'),to_date('21-SEP-17','DD-MON-RR'),'16','aaa',null,111,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (145,150,'10087',to_date('11-SEP-17','DD-MON-RR'),to_date('21-SEP-17','DD-MON-RR'),'16','aaa',null,111,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (156,156,'10087',to_date('01-DEC-17','DD-MON-RR'),to_date('02-DEC-17','DD-MON-RR'),'DragonRevenueCode','DragonProcedurecode','DragonMod',3.5,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (167,163,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (168,164,'10087',to_date('11-SEP-17','DD-MON-RR'),to_date('21-SEP-17','DD-MON-RR'),'16','aaa',null,111,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (171,166,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'12','10000','JA,EE,QS,SG',4829.52,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (172,166,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'15','10000','G4,RT,LT,P3',17888.41,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (176,169,'10087',to_date('01-DEC-17','DD-MON-RR'),to_date('02-DEC-17','DD-MON-RR'),'DragonRevenueCode','DragonProcedurecode','DragonMod',3.5,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (177,170,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (178,171,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (179,172,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (180,173,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (181,174,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (182,175,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (183,176,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (184,177,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (185,178,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (186,179,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (192,185,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (194,187,'1',to_date('18-APR-11','DD-MON-RR'),to_date('18-APR-11','DD-MON-RR'),'212','99212','21,ac,14,21',60,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (195,191,'10001',to_date('14-SEP-17','DD-MON-RR'),to_date('12-SEP-17','DD-MON-RR'),'15','10001','G4,RT,AA,SG',8539.97,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (196,193,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (197,195,'12345',to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'),'7890554',null,'gfhjgfh',12345,to_date('12-JAN-18','DD-MON-RR'),to_date('12-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (198,198,'10241',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'17','10241','JA,EE,QS,EE',10365.13,to_date('15-JAN-18','DD-MON-RR'),to_date('15-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (199,199,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('15-JAN-18','DD-MON-RR'),to_date('15-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (200,200,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('15-JAN-18','DD-MON-RR'),to_date('15-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (201,204,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'15','10000','G4,RT,LT,P3',17888.41,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (202,205,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'15','10000','G4,RT,LT,P3',17888.41,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (203,206,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'15','10000','G4,RT,LT,P3',17888.41,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (204,220,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (205,221,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (206,222,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (207,224,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (208,225,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (209,226,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'12','10000','JA,EE,QS,SG',4829.52,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (210,226,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'15','10000','G4,RT,LT,P3',17888.41,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (211,227,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'12','10000','JA,EE,QS,SG',4829.52,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (212,227,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'15','10000','G4,RT,LT,P3',17888.41,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (213,228,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'12','10000','JA,EE,QS,SG',4829.52,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (214,228,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'15','10000','G4,RT,LT,P3',17888.41,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (216,243,'2',to_date('07-JUN-17','DD-MON-RR'),to_date('08-JUN-17','DD-MON-RR'),'321',null,'00556',333,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (217,243,'1',to_date('06-JUN-17','DD-MON-RR'),to_date('07-JUN-17','DD-MON-RR'),'123',null,'890',123,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (219,245,'1',to_date('06-JUN-17','DD-MON-RR'),to_date('07-JUN-17','DD-MON-RR'),'123',null,'890',123,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (220,245,'2',to_date('07-JUN-17','DD-MON-RR'),to_date('08-JUN-17','DD-MON-RR'),'321',null,'00556',333,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (221,246,'2',to_date('07-JUN-17','DD-MON-RR'),to_date('08-JUN-17','DD-MON-RR'),'321',null,'00556',333,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (222,246,'1',to_date('06-JUN-17','DD-MON-RR'),to_date('07-JUN-17','DD-MON-RR'),'123',null,'890',123,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (223,247,'2',to_date('07-JUN-17','DD-MON-RR'),to_date('08-JUN-17','DD-MON-RR'),'321',null,'00556',333,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (224,247,'1',to_date('06-JUN-17','DD-MON-RR'),to_date('07-JUN-17','DD-MON-RR'),'123',null,'890',123,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (226,250,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','GP,RT,AS,T5',9985.77,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (227,252,'1',to_date('11-SEP-17','DD-MON-RR'),to_date('12-SEP-17','DD-MON-RR'),'0651','Q5001','G4,EE,AA,AQ',16124.57,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (228,254,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (230,258,'1',to_date('11-SEP-17','DD-MON-RR'),to_date('12-SEP-17','DD-MON-RR'),'0651','Q5001','G4,EE,AA,AQ',16124.57,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (231,259,'6',to_date('25-OCT-16','DD-MON-RR'),to_date('25-OCT-16','DD-MON-RR'),'0636','J9190',null,64.33,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (232,259,'3',to_date('25-OCT-16','DD-MON-RR'),to_date('25-OCT-16','DD-MON-RR'),'0335','96409',null,507,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (233,259,'5',to_date('25-OCT-16','DD-MON-RR'),to_date('25-OCT-16','DD-MON-RR'),'0636','J7050',null,8.6,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (234,260,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),'0582','99509','GP,QS,LT,EE',1859.02,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (235,261,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','GP,RT,AS,T5',9985.77,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (236,262,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','GP,RT,AS,T5',9985.77,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (237,268,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','G4,RT,LT,P3',17888.41,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (238,268,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0430','97140','JA,EE,QS,SG',4829.52,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (239,269,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','G4,RT,LT,P3',17888.41,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (240,269,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0430','97140','JA,EE,QS,SG',4829.52,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (241,270,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','G4,RT,LT,P3',17888.41,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (242,270,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0430','97140','JA,EE,QS,SG',4829.52,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (243,273,'1',to_date('22-APR-11','DD-MON-RR'),to_date('22-APR-11','DD-MON-RR'),null,'73610',null,60,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (244,275,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','GP,RT,AS,T5',9985.77,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (245,276,'1',to_date('18-APR-11','DD-MON-RR'),to_date('18-APR-11','DD-MON-RR'),'212','99212','21,ac,14,21',60,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (246,280,'1',to_date('11-SEP-17','DD-MON-RR'),to_date('11-SEP-17','DD-MON-RR'),'0450','99285','JA,SG,AS,EE',11348.29,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (247,281,'1',to_date('11-SEP-17','DD-MON-RR'),to_date('11-SEP-17','DD-MON-RR'),'0450','99285','JA,SG,AS,EE',11348.29,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (248,282,'1',to_date('11-SEP-17','DD-MON-RR'),to_date('11-SEP-17','DD-MON-RR'),'0450','99285','JA,SG,AS,EE',11348.29,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (249,285,'1',to_date('01-JAN-17','DD-MON-RR'),to_date('02-JAN-17','DD-MON-RR'),'123',null,'08, 05',100,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (250,285,'2',to_date('01-JAN-17','DD-MON-RR'),to_date('02-JAN-17','DD-MON-RR'),'456',null,'12, 500',300,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (251,288,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','GP,RT,AS,T5',9985.77,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (252,291,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','GP,RT,AS,T5',9985.77,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (253,292,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (254,296,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','GP,RT,AS,T5',9985.77,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (255,303,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','GP,RT,AS,T5',9985.77,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (256,304,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0551','G0154','JA,RT,LT,SG',16564.32,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (257,306,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','GP,RT,AS,T5',9985.77,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (258,307,'1',to_date('18-APR-11','DD-MON-RR'),to_date('18-APR-11','DD-MON-RR'),'212','99212','21,ac,14,21',60,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (259,308,'2',to_date('25-OCT-16','DD-MON-RR'),to_date('25-OCT-16','DD-MON-RR'),'0333','77386',null,3357,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (260,308,'5',to_date('25-OCT-16','DD-MON-RR'),to_date('25-OCT-16','DD-MON-RR'),'0636','J7050',null,8.6,to_date('16-JAN-18','DD-MON-RR'),to_date('16-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (261,311,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0551','G0154','JA,RT,LT,SG',16564.32,to_date('17-JAN-18','DD-MON-RR'),to_date('17-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (263,313,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('18-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (264,314,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('18-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (265,315,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('18-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (266,316,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('18-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (267,317,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('18-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (268,318,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('18-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (269,319,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('18-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (270,320,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('18-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (271,321,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('18-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (272,322,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('18-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (273,323,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('18-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (274,324,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('18-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (275,325,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('18-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (276,326,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('18-JAN-18','DD-MON-RR'),to_date('18-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (277,328,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (278,329,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (279,330,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (280,331,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (281,332,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (282,333,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (284,336,'8',to_date('25-OCT-16','DD-MON-RR'),to_date('25-OCT-16','DD-MON-RR'),'0636','J9280',null,802.95,to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (285,336,'6',to_date('25-OCT-16','DD-MON-RR'),to_date('25-OCT-16','DD-MON-RR'),'0636','J9190',null,64.33,to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (286,336,'4',to_date('25-OCT-16','DD-MON-RR'),to_date('25-OCT-16','DD-MON-RR'),'0352','77014',null,1372,to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (287,337,'8',to_date('25-OCT-16','DD-MON-RR'),to_date('25-OCT-16','DD-MON-RR'),'0636','J9280',null,802.95,to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (288,337,'4',to_date('25-OCT-16','DD-MON-RR'),to_date('25-OCT-16','DD-MON-RR'),'0352','77014',null,1372,to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (289,337,'6',to_date('25-OCT-16','DD-MON-RR'),to_date('25-OCT-16','DD-MON-RR'),'0636','J9190',null,64.33,to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (290,338,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (291,339,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('19-JAN-18','DD-MON-RR'),to_date('19-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (292,341,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('22-JAN-18','DD-MON-RR'),to_date('22-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (293,342,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('22-JAN-18','DD-MON-RR'),to_date('22-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (294,343,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('22-JAN-18','DD-MON-RR'),to_date('22-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (295,344,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('22-JAN-18','DD-MON-RR'),to_date('22-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (296,345,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('22-JAN-18','DD-MON-RR'),to_date('22-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (297,346,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('23-JAN-18','DD-MON-RR'),to_date('23-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (298,347,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('23-JAN-18','DD-MON-RR'),to_date('23-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (299,348,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('23-JAN-18','DD-MON-RR'),to_date('23-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (300,349,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('23-JAN-18','DD-MON-RR'),to_date('23-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (301,350,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('23-JAN-18','DD-MON-RR'),to_date('23-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (302,351,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('23-JAN-18','DD-MON-RR'),to_date('23-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (303,352,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('23-JAN-18','DD-MON-RR'),to_date('23-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (304,353,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('23-JAN-18','DD-MON-RR'),to_date('23-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (305,354,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('24-JAN-18','DD-MON-RR'),to_date('24-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (306,355,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('24-JAN-18','DD-MON-RR'),to_date('24-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (307,356,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('24-JAN-18','DD-MON-RR'),to_date('24-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (308,357,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('24-JAN-18','DD-MON-RR'),to_date('24-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (309,358,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','GP,RT,AS,T5',9985.77,to_date('24-JAN-18','DD-MON-RR'),to_date('24-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (310,359,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','GP,RT,AS,T5',9985.77,to_date('24-JAN-18','DD-MON-RR'),to_date('24-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (311,360,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('24-JAN-18','DD-MON-RR'),to_date('24-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (312,361,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (313,362,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (314,363,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','G4,RT,LT,P3',17888.41,to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (315,363,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0430','97140','JA,EE,QS,SG',4829.52,to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (316,364,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','G4,RT,LT,P3',17888.41,to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (317,364,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0430','97140','JA,EE,QS,SG',4829.52,to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (318,373,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','G4,RT,LT,P3',17888.41,to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (319,373,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0430','97140','JA,EE,QS,SG',4829.52,to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (320,376,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (321,377,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (322,378,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (323,379,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('25-JAN-18','DD-MON-RR'),to_date('25-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (324,380,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (325,381,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (326,382,'1',to_date('11-SEP-17','DD-MON-RR'),to_date('12-SEP-17','DD-MON-RR'),'0651','Q5001','G4,EE,AA,AQ',16124.57,to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (328,384,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (329,385,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (330,387,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (331,388,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (332,389,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (333,390,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('26-JAN-18','DD-MON-RR'),to_date('26-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (334,391,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (335,392,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (336,393,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (337,394,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (338,395,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (339,396,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (340,397,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (341,398,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (342,399,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (343,400,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (344,401,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (345,402,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (346,403,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (347,404,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (348,405,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (349,406,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (350,407,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('29-JAN-18','DD-MON-RR'),to_date('29-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (351,408,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (352,409,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (353,410,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (354,411,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (355,412,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (356,413,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','G4,RT,LT,P3',17888.41,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (357,413,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0430','97140','JA,EE,QS,SG',4829.52,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (359,419,'1',to_date('11-SEP-17','DD-MON-RR'),to_date('12-SEP-17','DD-MON-RR'),'0651','Q5001','G4,EE,AA,AQ',16124.57,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (360,420,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (361,421,'1',to_date('14-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0551','G0154','G4,QS,LT,T5',9750.41,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (362,422,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (363,423,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (364,424,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (365,425,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (366,426,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (367,427,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (368,428,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (369,430,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0651','Q5001','GP,QS,QS,T5',11593.46,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (370,431,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('11-SEP-17','DD-MON-RR'),'0450','99283','G4,EE,LT,T5',1622.7,to_date('30-JAN-18','DD-MON-RR'),to_date('30-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (371,432,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0430','97140','JA,EE,QS,SG',4829.52,to_date('31-JAN-18','DD-MON-RR'),to_date('31-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (372,432,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','G4,RT,LT,P3',17888.41,to_date('31-JAN-18','DD-MON-RR'),to_date('31-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (373,433,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0430','97140','JA,EE,QS,SG',4829.52,to_date('31-JAN-18','DD-MON-RR'),to_date('31-JAN-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (374,434,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (375,435,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (376,439,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('01-FEB-18','DD-MON-RR'),to_date('01-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (377,440,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('02-FEB-18','DD-MON-RR'),to_date('02-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (378,441,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('02-FEB-18','DD-MON-RR'),to_date('02-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (379,442,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('05-FEB-18','DD-MON-RR'),to_date('05-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (380,443,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('05-FEB-18','DD-MON-RR'),to_date('05-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (381,444,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('05-FEB-18','DD-MON-RR'),to_date('05-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (382,445,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('05-FEB-18','DD-MON-RR'),to_date('05-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (383,446,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('06-FEB-18','DD-MON-RR'),to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (384,447,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('06-FEB-18','DD-MON-RR'),to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (385,448,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('06-FEB-18','DD-MON-RR'),to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (386,449,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('06-FEB-18','DD-MON-RR'),to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (387,450,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('06-FEB-18','DD-MON-RR'),to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (388,451,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('06-FEB-18','DD-MON-RR'),to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (389,454,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('06-FEB-18','DD-MON-RR'),to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (390,455,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('06-FEB-18','DD-MON-RR'),to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (391,457,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('06-FEB-18','DD-MON-RR'),to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (392,459,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('06-FEB-18','DD-MON-RR'),to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (393,460,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('06-FEB-18','DD-MON-RR'),to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (394,461,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('06-FEB-18','DD-MON-RR'),to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (395,463,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('06-FEB-18','DD-MON-RR'),to_date('06-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (396,464,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (397,465,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (398,466,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (399,467,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (400,468,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (401,469,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (402,471,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (403,472,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (404,473,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (405,474,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (406,475,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (407,476,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (408,477,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (409,478,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (410,479,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (411,480,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (412,481,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (413,482,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (414,483,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (415,484,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (416,485,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (417,486,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (418,487,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (419,488,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (420,489,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (421,490,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (422,491,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (423,492,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (424,493,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('07-FEB-18','DD-MON-RR'),to_date('07-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (425,499,'1',to_date('11-SEP-17','DD-MON-RR'),to_date('12-SEP-17','DD-MON-RR'),'0651','Q5001','G4,EE,AA,AQ',16124.57,to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (426,504,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0450','99283','JA,EE,QS,EE',10365.13,to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (427,507,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0450','99283','JA,EE,QS,EE',10365.13,to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (428,508,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (429,509,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (430,510,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (431,511,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (432,517,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0551','G0154','JA,RT,LT,SG',16564.32,to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (433,518,'1',to_date('12-APR-11','DD-MON-RR'),to_date('12-APR-11','DD-MON-RR'),null,'99284',null,646,to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (434,519,'1',to_date('11-SEP-17','DD-MON-RR'),to_date('12-SEP-17','DD-MON-RR'),'0651','Q5001','G4,EE,AA,AQ',16124.57,to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (435,520,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (436,521,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (437,522,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('08-FEB-18','DD-MON-RR'),to_date('08-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (438,524,'123',to_date('01-SEP-16','DD-MON-RR'),to_date('01-NOV-17','DD-MON-RR'),'111',null,'A, B, C',101.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (439,525,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0551','G0154','JA,RT,LT,SG',16564.32,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (440,526,'101',to_date('01-JAN-17','DD-MON-RR'),to_date('10-OCT-17','DD-MON-RR'),'111',null,'XYZ',10.5,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (441,527,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','GP,RT,AS,T5',9985.77,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (442,528,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (443,529,'123',to_date('01-JAN-17','DD-MON-RR'),to_date('02-FEB-17','DD-MON-RR'),'111',null,'ABC',10.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (444,530,'222',to_date('01-JAN-17','DD-MON-RR'),to_date('02-FEB-17','DD-MON-RR'),'111',null,'ABC',10.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (454,548,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (456,550,'10085',to_date('11-SEP-17','DD-MON-RR'),to_date('21-SEP-17','DD-MON-RR'),'11','A2054',null,9999,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (457,551,'10087',to_date('11-SEP-17','DD-MON-RR'),to_date('21-SEP-17','DD-MON-RR'),'16','test123',null,111,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (458,552,'10087',to_date('11-SEP-17','DD-MON-RR'),to_date('21-SEP-17','DD-MON-RR'),'16','test986',null,111,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (459,553,'10087',to_date('11-SEP-17','DD-MON-RR'),to_date('21-SEP-17','DD-MON-RR'),'16','test456',null,111,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (460,554,'10087',to_date('11-SEP-17','DD-MON-RR'),to_date('21-SEP-17','DD-MON-RR'),'20','test456',null,111,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (461,555,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (462,556,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (463,557,'222',to_date('01-SEP-17','DD-MON-RR'),to_date('01-OCT-17','DD-MON-RR'),'1',null,'xyz',10.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (464,558,'333',to_date('01-OCT-17','DD-MON-RR'),to_date('01-DEC-17','DD-MON-RR'),'1',null,'XYZ',10.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (465,560,'10087',to_date('11-SEP-17','DD-MON-RR'),to_date('21-SEP-17','DD-MON-RR'),'20','test456',null,111,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (466,561,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (467,562,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (468,563,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0450','99283','JA,EE,QS,EE',10365.13,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (469,564,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (470,565,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (471,566,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (472,567,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (473,568,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (474,569,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (475,570,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (476,571,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (477,572,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('09-FEB-18','DD-MON-RR'),to_date('09-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (478,573,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('10-FEB-18','DD-MON-RR'),to_date('10-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (479,577,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','G4,RT,LT,P3',17888.41,to_date('11-FEB-18','DD-MON-RR'),to_date('11-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (480,577,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0430','97140','JA,EE,QS,SG',4829.52,to_date('11-FEB-18','DD-MON-RR'),to_date('11-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (481,578,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0430','97140','JA,EE,QS,SG',4829.52,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (482,578,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','G4,RT,LT,P3',17888.41,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (483,579,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651','Q5001','G4,RT,LT,P3',17888.41,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (484,579,'2',to_date('14-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0430','97140','JA,EE,QS,SG',4829.52,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (485,583,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (486,584,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (487,585,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (488,586,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (489,587,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (490,588,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (491,589,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (492,590,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (493,591,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (494,594,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (495,595,'1000089',to_date('12-DEC-17','DD-MON-RR'),to_date('12-DEC-17','DD-MON-RR'),'456','256','modifier',2.01,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (496,596,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('10-SEP-17','DD-MON-RR'),'0582','99509','GP,QS,LT,EE',1859.02,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (497,597,'1',to_date('13-SEP-17','DD-MON-RR'),to_date('14-SEP-17','DD-MON-RR'),'0551','G0154','JA,RT,LT,SG',16564.32,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (498,598,'4',to_date('30-JAN-17','DD-MON-RR'),to_date('01-FEB-17','DD-MON-RR'),'0123','ABC123','A,B, C, D',101.011,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (499,599,'101',to_date('11-NOV-15','DD-MON-RR'),to_date('12-DEC-16','DD-MON-RR'),'111','XYZ123','XYZ',200,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (500,599,'5',to_date('11-JAN-16','DD-MON-RR'),to_date('02-FEB-19','DD-MON-RR'),'123','ABC111','A, B, C',1000.1,to_date('12-FEB-18','DD-MON-RR'),to_date('12-FEB-18','DD-MON-RR'));
Insert into ARS277_REQUEST_TRACKING.CLAIM_SVC_LINES (SUBMISSIONSVCLINEID,SUBMISSIONID,REF02SVCLNNMBR,DTP03SVCFRMDT,DTP03SVCTODT,SVC01REVCD,SVC01PROCCD,SVC01MOD,SVC02CHRGAMT,DATECREATED,DATEMODIFIED) values (501,600,'1',to_date('10-SEP-17','DD-MON-RR'),to_date('13-SEP-17','DD-MON-RR'),'0651',null,'GP,RT,