package gov.va.med.ewv.util;

public enum ProviderType
{
    RENDERING("Rendering Provider", "RENDERING PROVIDER"),
    ATTENDING("Attending Physician", "ATTENDING PHYSICIAN"),
    OPERATING("Operating Physician", "OPERATING PHYSICIAN"),
    SERVICE_LOCATION("Service Location", "SERVICE LOCATION"),
    OTHER("Other Provider", "OTHER PROVIDER");
    
    private String selected = null;
    private String valueOf  = null;
    
    ProviderType(String label, String dbType)
    {
        selected = label;
        valueOf = dbType;
    }
    
    public String toString()
    {
        return selected;
    }
    
    public String getValueOf()
    {
        return valueOf;
    }
    
    public static ProviderType typeOf(String value)
    {
        ProviderType val = null;
        
        if (value.equals("ATTENDING PHYSICIAN")) {
            val = ProviderType.ATTENDING;
        } else if (value.equals("RENDERING PROVIDER")) {
            val = ProviderType.RENDERING;
        } else if (value.equals("OTHER PROVIDER")) {
            val = ProviderType.OTHER;
        } else if (value.equals("OPERATING PHYSICIAN")) {
            val = ProviderType.OPERATING;
        } else if (value.equals("SERVICE LOCATION")) {
          val = ProviderType.SERVICE_LOCATION;
      }
        
        return val;
    }
}
