package gov.va.med.ewv.util;

public enum OhiType
{
    PRIMARY("Primary Ohi", "P"),
    SECONDARY("Secondary Ohi", "S"),
    TERTIARY("Tertiary Ohi", "T"),
    UNKNOWN("Unknown Ohi Type", "U");
    
    private String selected = null;
    private String valueOf  = null;
    
    OhiType(String label, String dbType)
    {
        selected = label;
        valueOf = dbType;
    }
    
    public String toString()
    {
        return selected;
    }
    
    public String getValueOf()
    {
        return valueOf;
    }
    
    public static OhiType typeOf(String value)
    {
        OhiType val = null;
        
        if (value.equals("P")) {
            val = OhiType.PRIMARY;
        } else if (value.equals("S")) {
            val = OhiType.SECONDARY;
        } else if (value.equals("T")) {
            val = OhiType.TERTIARY;
        } else {
          val = OhiType.UNKNOWN;
        }
        
        return val;
    }
}
