package gov.va.med.ewv.util;

public enum HealthInfoType
{
    VALUE("BE","Value"), CONDITION("BG","Condition"), OCCUR_SPAN("BI","Occurrence Span"), OCCUR("BH","Occurrence"), DRG("DR","Diagnosis Relate Group");
    
    String valueOf = null;
    String alt = null;
    
    HealthInfoType(String type, String altDesc)
    {
        valueOf = type;
        alt = altDesc;
    }
    
    public String getValueOf()
    {
        return valueOf;
    }
    
    public String altDescription()
    {
        return alt;
    }
    
    public static HealthInfoType typeOf(String value)
    {
        HealthInfoType val = null;
        
        value = value.trim();
        
        if (value.equals("BE"))
        {
            val = HealthInfoType.VALUE;
        }
        else if (value.equals("BG"))
        {
            val = HealthInfoType.CONDITION;
        }
        else if (value.equals("BI"))
        {
            val = HealthInfoType.OCCUR_SPAN;
        }
        else if (value.equals("BH"))
        {
            val = HealthInfoType.OCCUR;
        }
        else if (value.equals("DR"))
        {
            val = HealthInfoType.DRG;
        }
        
        return val;
    }
    
}
