package gov.va.med.ewv.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;

import org.apache.commons.logging.Log;
import org.hibernate.validator.constraints.Length;

import gov.va.med.domain.fee.EwvClaims;

public class EwvUtils
{
    public static String shorten(String value, int toLength)
    {
        if ((value != null) && (value.length() > toLength))
        {
            value = value.substring(0, toLength) + "...";
        }
        else if (value == null)
        {
            value = "";
        }
        
        return value;
    }
    
    // Used for a bunch of strings
    public static boolean okToRender(String... strings)
    {
        boolean render = false;
        
        for (String str : strings)
        {
            if (str != null && !str.isEmpty() && str.length() > 0)
            {
                // if any one of the strings contain something, then render = true
                render = true;
                break;
            }
        }
        
        return render;
    }
    
    // Used for a List of objects, followed by a bunch of strings
    // This is done because we often have a set of codes, with other fields
    public static boolean okToRender(List<Object> objectList, String... strings)
    {
        boolean render = false;
        
        // Check the multiple strings
        for (String str : strings) {
            if (str != null && !str.isEmpty() && str.length() > 0) {
                // if any one of the strings contain something, then render = true
                render = true;
                break;
            }
        }
        
        // Check the List of objects
        if (objectList.size() > 0) {
            render = true;
        }
        
        return render;
    }
    
    // Used for a List of objects only
    // This is done because we often have 
    public static boolean okToRender(List objectList)
    {
        boolean render = false;
        
        // Check the List of objects
        if (objectList.size() > 0) {
            render = true;
        }
        
        return render;
    }
    
    public static String addLineBreaks(String hccodesPoaNotes)
    {
        StringBuffer buffer = new StringBuffer();
        
        if (hccodesPoaNotes != null)
        {
            for (int x = 0; x <= (hccodesPoaNotes.length() - 1); x++)
            {
                buffer.append(hccodesPoaNotes.charAt(x));
                
                if ((x > 0) && (x % 100) == 0)
                {
                    if (Character.isLetter(hccodesPoaNotes.charAt(x - 1)) && Character.isLetter(hccodesPoaNotes.charAt(x)))
                    {
                        // then we are splitting a word.
                        buffer.append("-" + System.getProperty("line.separator"));
                    }
                    else
                    {
                        buffer.append(System.getProperty("line.separator"));
                    }
                }
            }
        }
        
        String ret = buffer.toString();
        
        return ret.trim();
    }
    
    public static int getMaxLength(Class classOf, String fieldGetterName)
    {
        Method m;
        int ret = 1;
        
        try {
            if ((m = classOf.getMethod(fieldGetterName)) != null) {
                Length anno = m.getAnnotation(Length.class);
                ret = anno.max();
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
        return ret;
    }

    public static String concatWithSeparator(String separator, String... strings)
    {
      String returnVal = "";
      
      for (String nextString : strings) {
        if (nextString != null &&! nextString.isEmpty()) {
          
          // Only need the separator if we already have written a value
          if (!returnVal.isEmpty()) {
            returnVal += separator;
          }
          returnVal += nextString;
        }
      }
      
      return returnVal;
    }
    
    public static String defaultToSpace(String input)
    {
        return ((input == null) ? " ":input);
    }

    public static boolean anyTrue(Boolean... booleans)
    {
        boolean ret = false;
        
        for(Boolean b : booleans) {
            // a single true value in list is ok
            if(b.booleanValue() == true) {
                ret = true;
                break;
            }
        }
        
        return ret;
    }

  public static String formatAsCurrency(String inString)
  {
    String returnVal = "";
    double amountAsDouble;
    Formatter formatter = new Formatter();
    
    if (inString != null) {
      try {  
        amountAsDouble = Double.parseDouble(inString);
        formatter.format("%01.2f", amountAsDouble);
        returnVal = formatter.toString();
      } catch (NumberFormatException nfe) {
        returnVal = "Error";
      }
    }
      
    return returnVal;
  }
  
  public static String formatAsInteger(String inString)
  {
    String returnVal = "";
    Integer amountAsInteger;
    Formatter formatter = new Formatter();
    
    if (inString != null) {
      try {  
        amountAsInteger = Integer.parseInt(inString);
        formatter.format("%01d", amountAsInteger);
        returnVal = formatter.toString();

      } catch (NumberFormatException nfe) {
        returnVal = "Err";
      }
    }
      
    return returnVal;
  }
  
  public static String formatAsInteger(Long inInteger)
  {
    String returnVal = "";
    Formatter formatter = new Formatter();
    
    if (inInteger != null) {
      try {  
        formatter.format("%01d", inInteger);
        returnVal = formatter.toString();

      } catch (NumberFormatException nfe) {
        returnVal = "Err";
      }
    }
      
    return returnVal;
  }
  
  public static String combineModifiers(String delim, String... modifiers)
  {
      StringBuffer out = new StringBuffer();
      
      if (modifiers != null)
      {
          int size = modifiers.length;
          int count = 0;
          
          for (String mod : modifiers) {
              if (mod != null && !mod.isEmpty()) {
                  out.append(mod);
                  
                  if (count < size) {
                      // only append the delimiter if we are not at end of delimiter list...
                      out.append(delim);
                  }
              } else {
                  // if we reject a null modifier, decrement the size...
                  size--;
              }
              
              count++;
          }
      }
      
      String ret = out.toString().trim();
      
      if (ret.endsWith(",")) {
          ret = ret.substring(0, ret.lastIndexOf(","));
      }
      
      return ret;
  }
  
  public static String formatAsDate(String inString)
  {
    return formatAsDate(inString, "MM/dd/yy");
  }
  
  public static String formatAsDate(String inString, String inFormat)
  {
    String returnVal = "";
    
    SimpleDateFormat formatter = new SimpleDateFormat(inFormat);
    
    if (inString != null && !inString.isEmpty()) {
      try {
        Date stringAsDate = formatter.parse(inString);
        
        // If there was an error, the result is set to null
        if (stringAsDate == null) {
          returnVal = "Error";
        } else {
          returnVal = formatter.format(stringAsDate);
        }
      }
      catch (Exception e) {
        returnVal = "Error";
      }
    }
      
    return returnVal;
  }
  
  public static String formatAsDate2(String inString, Log log)
  {
    if (log != null) {
      //log.info("In formatAsDate2 with: " + inString);
    }
    return formatAsDate2(inString, "MM/dd/yy", log);
  }
  
  public static String formatAsDate2(String inString, String inFormat, Log log)
  {
    if (log != null) {
      //log.info("In formatAsDate2 with: " + inString + " and format:" + inFormat + ":");
    }
    String returnVal = "";
    
    // The incoming format might be "D8" or "RD8", which are special non-java formats
    //   that come out of the database.  The values have already been converted out of those
    //   2 formats, but they signal how to handle the converted values
    String formatToUse = null;
    if ("D8".equals(inFormat) || "D8 ".equals(inFormat)) {
      if (log != null) {
        //log.info("Noticed D8 format");
      }
      return formatAsDate2(inString, "MM/dd/yy", log);
    } else if ("RD8".equals(inFormat) || "RD8 ".equals(inFormat)) {
      if (log != null) {
        //log.info("Noticed RD8 format");
      }
      String firstDateString = inString.substring(0, 10);
      if (log != null) {
        //log.info("First string: " + firstDateString);
      }
      String secondDateString = inString.substring(11,21);
      if (log != null) {
        //log.info("Second string: " + secondDateString);
      }
      String resultString = formatDateRangeEWV2(firstDateString, secondDateString, " - ", true);
      if (log != null) {
        //log.info("Result: " + resultString);
      }
      return resultString;
    } else if (inFormat != null) {
      formatToUse = inFormat;
      if (log != null) {
        //log.info("Using incoming format: " + formatToUse);
      }
    } else {
      formatToUse = "MM/dd/yy";
      if (log != null) {
        //log.info("Using default format: " + formatToUse);
      }
    }
    
    SimpleDateFormat formatter = new SimpleDateFormat(formatToUse);
    
    if (inString != null && !inString.isEmpty()) {
      try {
        Date stringAsDate = formatter.parse(inString);
        if (log != null) {
          //log.info("After calling parse, result: " + stringAsDate);
        }
        // If there was an error, the result is set to null
        if (stringAsDate == null) {
          returnVal = "Error";
        } else {
          returnVal = formatter.format(stringAsDate);
        }
      }
      catch (Exception e) {
        returnVal = "Error";
      }
    }
      
    return returnVal;
  }
  
  public static String formatDateRangeEWV2(String beginDate,
                                           String endDate,
                                           String separator,
                                           boolean twoYearDates)
  {
    StringBuffer buffer = new StringBuffer("");
    
    if(beginDate != null)
    {
      if (twoYearDates) {
        buffer.append(formatAsDate(beginDate));
      } else {
        buffer.append(beginDate);
      }
    }
    
    if(endDate != null) {
      buffer.append(separator);

      if (twoYearDates) {
        buffer.append(formatAsDate(endDate));
      } else {
        buffer.append(endDate);
      }
    }
    
    return buffer.toString();
  }

  public static String formatPDIForOutput(String numberString)
  {
      StringBuffer buf = new StringBuffer();
      
      if((numberString != null) && (numberString.length() == 15))
      {
          buf.append(numberString.substring(0, 4));
          buf.append(" ");
          buf.append(numberString.substring(4, 7));
          buf.append(" ");
          buf.append(numberString.substring(7, 9));
          buf.append(" ");
          buf.append(numberString.substring(9, numberString.length()));
      }
      else if(numberString != null)
      {
          // just return the input
          buf.append(numberString);
      }
      
      return buf.toString();
  }

  final public static java.util.Properties getPropertiesDeprecated(final String pFileName)
  throws IOException {
    // If the incoming parameter is null, throw an IOException rather than
    // waiting for a NullPointerException later
    if (pFileName == null) {
      throw new IOException("Properties file name may not be null");
    }
    
    // Put an input stream onto the specified properties file
    InputStream inputStream = EwvUtils.class.getResourceAsStream(pFileName);
    
    // Load the file into a properties object for return
    final java.util.Properties props = new java.util.Properties();
    if (inputStream != null) {
      props.load(inputStream);
    }
    
    return props;
  }

  // Used to determine whether we have duplicate payer ids
  // Returns true if non-null duplicates exist in the given list
  public static boolean hasNonNullDuplicates(List list) {
    HashSet set = new HashSet();
    for (int i = 0; i < list.size(); i++) {
      // Don't complain about duplicate nulls
      Object nextObject = list.get(i);
      if (nextObject != null) {
        // If a false is returned when we try to add this object, it must be
        //   a duplicate of an earlier value
        boolean val = set.add(nextObject);
        if (val == false) {
          return true;
        }
      }
    }
    
    // If we ran into no dups, report that the list contains none
    return false;
   }
  
  public static ClaimFormat determineClaimFormat(EwvClaims claim) {
	    String claimTypeString = claim.getClaimType();
	    return ClaimFormat.typeOf(claimTypeString);
	  }

  public static ClaimType determineClaimType(EwvClaims claim) {
	    String claimTypeString = claim.getClaimType();
	    return ClaimType.typeOf(claimTypeString);
	  }
	  
}
