package gov.va.med.ewv.util;

public enum ClaimFormat
{
    FORMAT4010("4010"),
    FORMAT5010("5010"),
    NONE(null);
    
    String valueOf = null;
    
    ClaimFormat(String code)
    {
        valueOf = code;
    }
    
    public String getValueOf()
    {
        return valueOf;
    }
    
    public static ClaimFormat typeOf(String value)
    {
        ClaimFormat val = null;
        
        if (value.equals("004010X096A1") || value.equals("004010X097A1") || value.equals("004010X098A1"))
        {
            val = ClaimFormat.FORMAT4010;
        }
        else if (value.substring(0,10).equals("005010X222") || value.substring(0,10).equals("005010X223") || value.substring(0,10).equals("005010X224"))
        {
            val = ClaimFormat.FORMAT5010;
        }
        
        return val;
    }
}
