package gov.va.med.ewv.util;

public enum AdjustmentType {
   CO, OA, PR, PI, CR;
   /**
    *  Sort Order: CO < OA < PI < PR < CR < null
    * @param o1
    * @param o2
    * @return
    */
   public static int compare(AdjustmentType o1, AdjustmentType o2) {
       int ret;       
       if (o1 != null && o2 != null) {
    	   ret = compareOrdinals(o1, o2) ;
       } else if (o1 != null) {
    	   ret = 1;
       } else { // o1 == null
    	   ret = -1;
       }
       return ret;
   }
   
   private static final int compareOrdinals(AdjustmentType o1, AdjustmentType o2) {
	   int x = o1.ordinal();
	   int y = o2.ordinal();
	   
	   // FIXME: int compare operation should be like this, but method is new in Java 7.
	   //return Integer.compare(x, y);
	   
	   // Could do this but causes new objects which is not worth the memory.
	   //return Integer.valueOf(x).compareTo(Integer.valueOf(y));
	   
	   // So ...
	   return Double.compare(x, y);
	   // ... which causes a promotion, but this runs on a server with an FPU so who cares.
	   // There are faster ways, but not worth the loss of clarity.
   }
}
