package gov.va.med.ewv.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.springframework.stereotype.Service;

import gov.va.med.domain.fee.EwvClaims;
import gov.va.med.domain.fee.EwvProcedureCodes;
import gov.va.med.ewv.codes.CodeBase;
import gov.va.med.ewv.codes.ProcedureCode;
import gov.va.med.ewv.codes.ProcedureCodesContainer;
import gov.va.med.ewv.service.IEwvProcedureCodesInfoService;

@Service
public class EwvProcedureCodesInfoServiceImpl implements IEwvProcedureCodesInfoService {

	@Override
	public ProcedureCodesContainer populateProcedureCodesContainer(EwvClaims claimBean) {
		String inPrincipalProcedure = claimBean.getHccodesPrincipalProcedure();
		String inDateOfProcedure = claimBean.getHccodesPrincipalProcDate();
		Set<EwvProcedureCodes> codes = claimBean.getEwvProcedureCodeses();
		ProcedureCodesContainer ret = null;

		String principalProcedure = inPrincipalProcedure;
		String dateOfProcedure = inDateOfProcedure;

		if (codes != null) {
			List<ProcedureCode> listOfProcedureCodes = createListOfProcedureCodes(inPrincipalProcedure,
					inDateOfProcedure, codes);

			ret = new ProcedureCodesContainer(principalProcedure, dateOfProcedure, listOfProcedureCodes);
		}
		return ret;
	}

	@Override
	public List<ProcedureCode> createListOfProcedureCodes(String principalProcedureCode, String principalProcedureDate,
			Set<EwvProcedureCodes> codes) {
		List<ProcedureCode> returnList = new ArrayList<ProcedureCode>();

		// Add in the principal procedure
		if (principalProcedureCode != null && !principalProcedureCode.isEmpty()) {
			ProcedureCode principalProcedureBean = new ProcedureCode(1L, principalProcedureCode,
					principalProcedureDate);
			returnList.add(principalProcedureBean);
		}

		// Add in the codes from the list
		for (EwvProcedureCodes codeBean : codes) {
			ProcedureCode bean = new ProcedureCode(codeBean.getProcSeq().longValue(), codeBean.getProcedureCode(),
					codeBean.getProcedureDate());
			returnList.add(bean);
		}

		Collections.sort(returnList);

		// Experience shows that the diagnosis codes in the database include
		// sequence numbers
		// that sometimes start with 1, and sometimes with 2.
		returnList = CodeBase.renumber(returnList);

		return returnList;
	}

}
