package gov.va.med.ewv.service.impl;

import org.springframework.stereotype.Service;

import gov.va.med.domain.fee.EwvClaims;
import gov.va.med.ewv.model.response.PatientHeaderInfo;
import gov.va.med.ewv.model.response.PatientInfo;
import gov.va.med.ewv.model.response.VendorInfo;
import gov.va.med.ewv.service.IEwvPatientAndVendorInfoService;
import gov.va.med.ewv.util.ClaimFormat;
import gov.va.med.ewv.util.ClaimType;
import gov.va.med.ewv.util.EwvUtils;

@Service
public class EwvPatientAndVendorInfoServiceImpl implements IEwvPatientAndVendorInfoService {

	@Override
	public PatientHeaderInfo populatePatientHeaderInfo(EwvClaims claim) {
	    String medicareCrossOver = claim.getMedicareCrossover();
	    String patientName = claim.getPatientName();
	    String billingNPI = claim.getBillingVendorNpi();
	    String memberID = claim.getMemberId();
	    String tin = claim.getBillingVendorTaxIdNum();
	    String pdi = claim.getPdi();
	    String pcn = claim.getInvoicePatientAccountNum();
	    String pcnShort = EwvUtils.shorten(pcn, 20);
	    boolean usePcnModalPanel = pcnShort.endsWith("...");

	    ClaimFormat claimFormat = EwvUtils.determineClaimFormat(claim);
	    ClaimType claimType = EwvUtils.determineClaimType(claim);
	    
	    String format = claimType.getAltValue()+"("+claimFormat.getValueOf()+")";

	    return new PatientHeaderInfo(format,
	                                 claimType,
	                                 medicareCrossOver,
	                                 patientName,
	                                 billingNPI,
	                                 memberID,
	                                 tin, 
	                                 pdi,
	                                 pcn,
	                                 pcnShort,
	                                 usePcnModalPanel);
	}

	@Override
	public PatientInfo populatePatientInfo(EwvClaims claim) {
	return new PatientInfo(claim.getPatientName(), 
			claim.getPatientIdNumber(), 
			claim.getPatientDob(),
			// Need to change the below to getPatientDateOfDeath_5010
			"",
			claim.getPatientGender(), 
			claim.getPatientAddressLine1(),
			claim.getPatientAddressLine2(), 
			claim.getPatientCity(), 
			claim.getPatientState(), 
			claim.getPatientPostalCode(), 
			claim.getPatientCountry());
	}

	@Override
	public VendorInfo populateBillingProviderInfo(EwvClaims claim) {
		// TODO Auto-generated method stub
		return new VendorInfo(claim.getBillingVendorName(), 
				claim.getBillingVendorTaxIdNum(),
				claim.getBillingVendorNpi(), 
				//claim.getBillingVendorTaxonomyCode(),
				"",
				claim.getBillingVendorAddressLine1(), 
				claim.getBillingVendorAddressLine2(), 
				claim.getBillingVendorCity(),
				claim.getBillingVendorState(), 
				claim.getBillingVendorPostalCode(),
				""
				//claim.getBillingVendorCountry()
				);
	}

	@Override
	public VendorInfo populateServiceLocationInfo(EwvClaims claim) {
		// TODO Auto-generated method stub
		return new VendorInfo(claim.getServiceVendorName(), 
				claim.getServiceVendorTaxIdNum(), 
				claim.getServiceVendorNpi(),
				"",
				//claim.getBillingVendorTaxonomyCode(),
				claim.getServiceVendorAddressLine1(),
				claim.getServiceVendorAddressLine2(), 
				claim.getServiceVendorCity(), 
				claim.getServiceVendorState(), 
				claim.getServiceVendorPostalCode(),
				""
				//claim.getServiceVendorCountry()
				);
	} 
}
