package gov.va.med.ewv.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ars.dao.fpps.IEwvHealthInformationRepository;
import gov.va.med.domain.fee.EwvClaims;
import gov.va.med.domain.fee.EwvHealthInformation;
import gov.va.med.ewv.model.response.HealthCareInfoResponse;
import gov.va.med.ewv.model.response.HealthCareInformationLine;
import gov.va.med.ewv.service.IEwvHealthCareInfoService;
import gov.va.med.ewv.util.HealthInfoType;

@Service
public class EwvHealthCareInfoServiceImpl implements IEwvHealthCareInfoService {

	@Autowired
	IEwvHealthInformationRepository ewvHealthInformationRepository;

	@Override
	public List<HealthCareInformationLine> populateHealthCareInfoLine(HealthInfoType healthInfoType,
			EwvClaims claim) {
		Set<EwvHealthInformation> healthInfo = ewvHealthInformationRepository.getHealthInformationoByClaimGuid(claim.getGuid());
		ArrayList<HealthCareInformationLine> returnList = new ArrayList<HealthCareInformationLine>(0);

		for (EwvHealthInformation info : healthInfo)
		{
			// TODO Greg was indicating this as a temp solution, will need to be changed
			HealthInfoType infoType = HealthInfoType.typeOf(info.getQualifier());

			if ((infoType != null) && (infoType.equals(healthInfoType)))
			{
				returnList.add(createHealthCareInformationList(info,infoType));

			}
		}

		//if ((!accumulated) && (healthCareInformationLineList.size() > 0))
		if (returnList.size() > 0)
		{
			Collections.sort(returnList);

		}

		return returnList;
	}

	@Override
	public HealthCareInformationLine createHealthCareInformationList
	(EwvHealthInformation info, HealthInfoType typeOf) 
	{
		String qualifier = info.getQualifier();
		String description = info.getDescription();
		String code = info.getCode();
		String date = info.getClaimDate();
		String format = info.getFormat();

		//      log.info("Debugging: Formatting incoming date: " + date);
		//      String formattedDate = Ewv2Utils.formatAsDate2(date, format, log);
		//      log.info("Debugging: Formatted version: " + formattedDate);
		//      
		String amount = info.getAmount();

		Long sequence = 0L;
		if( info.getHiSeq() != null  )
			sequence= info.getHiSeq().longValue();

		HealthCareInformationLine bean
		= new HealthCareInformationLine(sequence,
				typeOf,
				qualifier, 
				description, 
				code, 
				date, 
				format, 
				amount);

		return bean;
	}

	@Override
	public HealthCareInfoResponse populateHealthCareInfoResponse(EwvClaims claim) {
        
        List<HealthCareInformationLine> healthCareValueInformationBeanList
          = populateHealthCareInfoLine(HealthInfoType.VALUE, claim);
        List<HealthCareInformationLine> healthCareConditionInformationBeanList
          = populateHealthCareInfoLine(HealthInfoType.CONDITION, claim);
        List<HealthCareInformationLine> healthCareOccurranceSpanInformationBeanList
          = populateHealthCareInfoLine(HealthInfoType.OCCUR_SPAN, claim);
        List<HealthCareInformationLine> healthCareOccurranceInformationBeanList
        = populateHealthCareInfoLine(HealthInfoType.OCCUR, claim);
        List<HealthCareInformationLine> healthCareDRGInformationBeanList
        = populateHealthCareInfoLine(HealthInfoType.DRG, claim);
        
        HealthCareInfoResponse healthCareInfoResponse = new HealthCareInfoResponse();
        healthCareInfoResponse.setHealthCareConditionInformationBeanList(healthCareConditionInformationBeanList);
        healthCareInfoResponse.setHealthCareDRGInformationBeanList(healthCareDRGInformationBeanList);
        healthCareInfoResponse.setHealthCareOccurranceInformationBeanList(healthCareOccurranceInformationBeanList);
        healthCareInfoResponse.setHealthCareOccurranceSpanInformationBeanList(healthCareOccurranceSpanInformationBeanList);;
        healthCareInfoResponse.setHealthCareValueInformationBeanList(healthCareValueInformationBeanList);
	
        return healthCareInfoResponse;
	}
}
