package gov.va.med.ewv.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.springframework.stereotype.Service;

import gov.va.med.domain.fee.EwvClaims;
import gov.va.med.domain.fee.EwvECodes5010;
import gov.va.med.ewv.codes.CodeBase;
import gov.va.med.ewv.codes.ECode;
import gov.va.med.ewv.codes.ECodesContainer;
import gov.va.med.ewv.service.IEwvE_CodesInfoService;

@Service
public class EwvE_CodesInfoServiceImpl implements IEwvE_CodesInfoService {
	
	@Override
	public ECodesContainer populateECodesContainer(EwvClaims claimBean) {
		//Set<EwvECodes5010> codes = eCodesRepository.getEwvECodes5010ByClaimGuid(claimBean.getGuid());
		List<ECode> eCodes = createListOfECodes(claimBean.getEwvECodes5010s());

		ECodesContainer ret = new ECodesContainer(eCodes);

		//boolean okToRender = EwvUtils.okToRender(eCodes);
		// ret.setShouldRender(ok);
		return ret;
	}

	@Override
	public List<ECode> createListOfECodes(Set<EwvECodes5010> eCodes) {
		List<ECode> returnList = new ArrayList<>();

		for (EwvECodes5010 codeBean : eCodes) {
			Long sequence = codeBean.getSequenceNum().longValue();
			returnList.add(new ECode(sequence, codeBean.getECode(), codeBean.getPoaIndicator5010()));
		}

		Collections.sort(returnList);

		// Experience shows that the codes in the database include sequence
		// numbers that sometimes start with 1, and sometimes with 2.
		returnList = CodeBase.renumber(returnList);

		return returnList;
	}
}
