package gov.va.med.ewv.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.springframework.stereotype.Service;

import gov.va.med.domain.fee.EwvClaims;
import gov.va.med.domain.fee.EwvDiagnosisCodes;
import gov.va.med.ewv.codes.CodeBase;
import gov.va.med.ewv.codes.DiagnosisCode;
import gov.va.med.ewv.codes.DiagnosisCodesContainer;
import gov.va.med.ewv.service.IEwvDiagnosisCodesInfoService;
import gov.va.med.ewv.util.EwvUtils;

@Service
public class EwvDiagnosisCodeInfoServiceImpl implements IEwvDiagnosisCodesInfoService {

	@Override
	public DiagnosisCodesContainer populateDiagnosisCodes(EwvClaims claim) {
		// Present on Admission notes has multiple versions
		//Set<EwvDiagnosisCodes> diagnosisCodes = ewvDiagnosisCodesRepository.getDiagnosisCodesByClaimGuid(claim.getGuid());
		
		String presentOnAdmissionNotesLong = EwvUtils.addLineBreaks(claim.getHccodesPoaNotes());
		String presentOnAdmissionNotesShort = EwvUtils.shorten(presentOnAdmissionNotesLong, 10);
		boolean usePresentOnAdmissionModalPanel = false;
		if (presentOnAdmissionNotesShort.endsWith("...")) {
			usePresentOnAdmissionModalPanel = true;
		}

		String principalDiagnosisMasterCode = claim.getHccodesPrincipalDiagnosis();
		// Need to uncomment when the updated schema jar is added
		// String principalDiagnosisPoa =
		// claim.getHccodesPrincipalDiagnosisPoa();
		String principalDiagnosisPoa = "";
		String admittingDiagnosisMasterCode = claim.getHccodesAdmittingDiagnosis();
		String reasonForVisitMasterCode = claim.getHccodesReasonForVists();
		String eCodeMasterCode = claim.getHccodesECode();

		// Phase 2 codes do not need to be split into four columnar lists.
		List<DiagnosisCode> diagnosisCodesList = createListOfDxCodes(principalDiagnosisMasterCode,
				principalDiagnosisPoa, claim.getEwvDiagnosisCodeses());

		DiagnosisCodesContainer diagCodes = new DiagnosisCodesContainer(presentOnAdmissionNotesShort,
				presentOnAdmissionNotesLong, usePresentOnAdmissionModalPanel, principalDiagnosisMasterCode,
				principalDiagnosisPoa, admittingDiagnosisMasterCode, reasonForVisitMasterCode, eCodeMasterCode,
				diagnosisCodesList);

		return diagCodes;
	}

	// This method, new to Phase II, adds in the Principal Diagnosis and does
	// not split the codes into four lists, for four columns.
	@Override
	public List<DiagnosisCode> createListOfDxCodes(String principalDiagnosisMasterCode, String principalDiagnosisPoa,
			Set<EwvDiagnosisCodes> codes) {
		List<DiagnosisCode> returnList = new ArrayList<DiagnosisCode>();

		// Add in the principal diagnosis
		returnList.add(new DiagnosisCode(1L, principalDiagnosisMasterCode, principalDiagnosisPoa));

		for (EwvDiagnosisCodes codeBean : codes) {
			// Need to change back to Long
			Long sequence = codeBean.getDiagSeq().longValue();
			returnList.add(new DiagnosisCode(sequence, codeBean.getDiagnosisCode(), codeBean.getPoaIndicator5010()));
		}

		Collections.sort(returnList);

		// Experience shows that the diagnosis codes in the database include
		// sequence numbers that sometimes start with 1, and sometimes with 2.
		returnList = CodeBase.renumber(returnList);

		return returnList;
	}

	// This method, new to Phase II, adds in the Principal Diagnosis and does
	// not split the codes into four lists, for four columns.

	/*@Override
	public List<ECode> createListOfECodes(Set<EwvECodes5010> eCodes) {
		List<ECode> returnList = new ArrayList<ECode>();

		for (EwvECodes5010 codeBean : eCodes) {
			// Long sequence = codeBean.getSequenceNum().longValue();
			Long sequence = 0L;
			returnList.add(new ECode(sequence, codeBean.getECode(), codeBean.getPoaIndicator5010()));
		}

		Collections.sort(returnList);

		// Experience shows that the codes in the database include sequence
		// numbers
		// that sometimes start with 1, and sometimes with 2.
		returnList = CodeBase.renumber(returnList);

		return returnList;
	}

	@Override
	public ECodesContainer populateECodesContainer(EwvClaims claimBean) {
		Set<EwvECodes5010> eCodesSet = claimBean.getEwvECodes5010s();
		List<ECode> eCodes = createListOfECodes(eCodesSet);
		ECodesContainer ret = new ECodesContainer(eCodes);
		return ret;
	}*/
}
