package gov.va.med.ewv.service.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ars.dao.fpps.IEwvClaimRepository;
import gov.va.med.domain.fee.EwvClaims;
import gov.va.med.ewv.codes.DiagnosisCodesContainer;
import gov.va.med.ewv.codes.ECodesContainer;
import gov.va.med.ewv.codes.ProcedureCodesContainer;
import gov.va.med.ewv.model.response.EwvClaimDetailResponse;
import gov.va.med.ewv.model.response.PatientHeaderInfo;
import gov.va.med.ewv.service.IEwvAmbulanceAndServiceLinesInfoService;
import gov.va.med.ewv.service.IEwvBillingMiscInfoService;
import gov.va.med.ewv.service.IEwvClaimService;
import gov.va.med.ewv.service.IEwvDiagnosisCodesInfoService;
import gov.va.med.ewv.service.IEwvHealthCareInfoService;
import gov.va.med.ewv.service.IEwvOhiService;
import gov.va.med.ewv.service.IEwvPatientAndVendorInfoService;
import gov.va.med.ewv.service.IEwvProcedureCodesInfoService;
import gov.va.med.ewv.service.IEwvE_CodesInfoService;
import gov.va.med.ewv.util.ClaimFormat;
import gov.va.med.ewv.util.ClaimType;
import gov.va.med.ewv.util.EwvUtils;
import gov.va.med.ewv.util.PdiFilterUtil;


@Service
public class EwvClaimServiceImpl implements IEwvClaimService{

	private static final Logger logger = LogManager.getLogger(EwvClaimServiceImpl.class);
	
	@Autowired
	IEwvClaimRepository ewvClaimRepository;
	
	@Autowired
	IEwvPatientAndVendorInfoService ewvPatientAndVendorInfoService;
	
	@Autowired
	IEwvBillingMiscInfoService ewvBillingMiscInfoService;
	
	@Autowired
	IEwvAmbulanceAndServiceLinesInfoService ewvBillingAndServiceLinesInfoService;
	
	@Autowired
	IEwvDiagnosisCodesInfoService ewvDiagnosisCodesInfoService;
	
	@Autowired
	IEwvHealthCareInfoService ewvHealthCareInfoService;

	@Autowired
	IEwvProcedureCodesInfoService ewvProcedureCodesInfoService;
	
	@Autowired
	IEwvAmbulanceAndServiceLinesInfoService ewvAmbulanceAndServiceLinesInfoService;
	
	@Autowired
	IEwvOhiService ewvOhiService;
	
	@Autowired
	IEwvE_CodesInfoService ewvE_CodesInfoService;
	
	@Override
	public EwvClaimDetailResponse getEwvClaim(String unfilteredPdiNumber) {
		
	    EwvClaimDetailResponse ewvClaimDetailResponse = new EwvClaimDetailResponse();
	    try {
	    	
	    	PdiFilterUtil ewvFilterUtil = new PdiFilterUtil();
	    	String pdiNumber = ewvFilterUtil.filterPdiNumber(unfilteredPdiNumber); 
	    	
	    	EwvClaims claim = ewvClaimRepository.getEwvClaimByPdiNumber(pdiNumber);	
	    	logger.debug(" fpps response :"+claim);
	    	if(claim != null) {
		    	ClaimType claimType = ClaimType.typeOf(claim.getClaimType());
		       
		        // construct the claim detail response
		        ewvClaimDetailResponse.setPatientHeaderInfo(ewvPatientAndVendorInfoService.populatePatientHeaderInfo(claim));
		    	ewvClaimDetailResponse.setPatientInfo(ewvPatientAndVendorInfoService.populatePatientInfo(claim));
		    	ewvClaimDetailResponse.setServiceLocationInfo(ewvPatientAndVendorInfoService.populateServiceLocationInfo(claim));
		    	ewvClaimDetailResponse.setBillingProviderInfo(ewvPatientAndVendorInfoService.populateBillingProviderInfo(claim));
		    	ewvClaimDetailResponse.setBillingMiscellanous(ewvBillingMiscInfoService.populateBillingAndAdmissionInfo(claimType, claim));
		    	ewvClaimDetailResponse.setDiagnosisCodesInfo(ewvDiagnosisCodesInfoService.populateDiagnosisCodes(claim));
		    	ewvClaimDetailResponse.setProcedureCodesInfo(ewvProcedureCodesInfoService.populateProcedureCodesContainer(claim));	    	
		    	ewvClaimDetailResponse.setE_CodesInfo(ewvE_CodesInfoService.populateECodesContainer(claim));
		    	ewvClaimDetailResponse.setHealthCareInfo(ewvHealthCareInfoService.populateHealthCareInfoResponse(claim));   			    
		    	ewvClaimDetailResponse.setServiceLinesInfo(ewvAmbulanceAndServiceLinesInfoService.populateServiceLines(claim));   			    
			    ewvClaimDetailResponse.setOhiInfo(ewvOhiService.getOhiData(pdiNumber));
	    	}
	    } catch (Throwable e) {
	    	logger.error("claim retrieval for pdiNumber  :"+unfilteredPdiNumber +" failed with exception : "+e);
		    }  

	    return ewvClaimDetailResponse;
	}	    
}
