package gov.va.med.ewv.service.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

import gov.va.med.domain.fee.EwvClaims;
import gov.va.med.ewv.model.response.BillingAndAdmissionInfo;
import gov.va.med.ewv.service.IEwvBillingMiscInfoService;
import gov.va.med.ewv.util.ClaimType;
import gov.va.med.ewv.util.EwvUtils;

@Service
public class EwvBillingMiscInfoService implements IEwvBillingMiscInfoService {

	private static final Logger logger = LogManager.getLogger(EwvBillingMiscInfoService.class);

	@Override
    public BillingAndAdmissionInfo populateBillingAndAdmissionInfo(ClaimType claimType, EwvClaims claim)
    {
        String patientAccountNumber = claim.getInvoicePatientAccountNum();
        
        String totalClaimCharges = claim.getSvcLineTotalClaimCharges();
        String typeOfBillOrFrequency = " ";
        String frequency = " ";
        
        if(claimType.equals(ClaimType.PROFESSIONAL))
        {
            // POS/Frequency without slash, UI handles the extra field
            typeOfBillOrFrequency = EwvUtils.defaultToSpace(claim.getPos());
            frequency = EwvUtils.defaultToSpace(claim.getInvoiceFrequency());
        }
        else if(claimType.equals(ClaimType.DENTAL))
        {
          // POS/Frequency without slash, UI handles the extra field
          typeOfBillOrFrequency = EwvUtils.defaultToSpace(claim.getPos());
          frequency = EwvUtils.defaultToSpace(claim.getInvoiceFrequency());
            // POS/Frequency with slash
            //typeOfBillOrFrequency = EwvUtils.defaultToSpace(claimBean.getPos())+"/"+ EwvUtils.defaultToSpace(claimBean.getInvoiceFrequency());
        }
        else if(claimType.equals(ClaimType.INSTITUTIONAL))
        {   
            // Type of Bill
            typeOfBillOrFrequency = EwvUtils.defaultToSpace(claim.getInvoiceTypeOfBill())+"/"+ EwvUtils.defaultToSpace(claim.getInvoiceFrequency());
        }
        
        String statementFromTo = EwvUtils.formatDateRangeEWV2(claim.getInvoiceStatementFromDate(),
                                                               claim.getInvoiceStatementToDate(),
                                                               " to ",
                                                               true);
        String statementFromToEWV2 = EwvUtils.formatDateRangeEWV2(
        		                     claim.getInvoiceStatementFromDate(),
        		                     claim.getInvoiceStatementToDate(),
        		                     " Thru ",
        		                     true);
            
        String previousPDIOrClaimNumber = claim.getInvoicePreviousPdi();
        
        String patientPaidAmount = claim.getInvoicePatientPaidAmt();
        String patientSignature = claim.getInvoicePatientSignature();
        String patientStatus = claim.getInvoicePatientStatus();
        String admissionType = claim.getInvoiceAdmissionType();
        String providerAcceptsAssignment = claim.getInvoiceProvAcceptsAssignmt();
        String admissionSource = claim.getInvoiceAdmissionSource();
        String assignmentOfBenefits = claim.getInvoiceAssignmentOfBenefits();
        
        // Admission date and hour are needed separate for EWV2
        String admissionDateOrHour = claim.getInvoiceAdmissionDateHour();
        String admissionDate = null;
        String admissionHour = null;

        if (admissionDateOrHour != null && !admissionDateOrHour.isEmpty()) {
          // Get the date portion of this field
          try {
            // Get the date portion
            if (admissionDateOrHour.length() >= 10) {
              admissionDate = admissionDateOrHour.substring(0,10);
            }
            
            // Get the time portion
            if (admissionDateOrHour.length() == 16) {
              admissionHour = admissionDateOrHour.substring(11,16);
            } else {
              admissionHour = "";
            }
            
            // Convert the date portion to a 2-digit date
            String twoDigitAdmissionDate = EwvUtils.formatAsDate(admissionDate);
            
            // Put the full string together again, with the 2-digit date
            admissionDateOrHour = twoDigitAdmissionDate + " " + admissionHour;
          } catch (StringIndexOutOfBoundsException e) {
        	  logger.error("Exception occurred : "+e);
          }
          
        }
        
        String dischargeDateHour = claim.getInvoiceDischargeDateHour();
        
        // Need to be altered once the updated EWV schema model jar is added 
//        String medicareIcn = claim.getMedicareIcn();
//        String renderingPrvdName = claim.getRenderingPrvdName();
//        String renderingPrvdNpi = claim.getRenderingPrvdNpi();
//        String renderingPrvdTaxonomyCode = claim.getRenderingPrvdTaxonomyCode();
        
        String medicareIcn = "";
        String renderingPrvdName = "";
        String renderingPrvdNpi = "";
        String renderingPrvdTaxonomyCode = "";
        
        String accidentDate = claim.getInvoiceAccidentDate();
        String accidentIndicator = claim.getInvoiceAccidentIndicator();
        String priorAuthorizationReferral = claim.getInvoicePriorAuthorization1();
        String priorAuthorizationReferralShort = null;
        boolean usePriorAuthorizationModalPanel = false;
        priorAuthorizationReferralShort = EwvUtils.shorten(priorAuthorizationReferral, 20);
        if (priorAuthorizationReferralShort.endsWith("...")) {
          usePriorAuthorizationModalPanel = true;
        }
        
        // Added for Phase II
        String admittingDiagnosis = claim.getHccodesAdmittingDiagnosis();
        String reasonForVisit = claim.getHccodesReasonForVists();
        String eCode = claim.getHccodesECode();
        String poaNotesPlain = claim.getHccodesPoaNotes();
        String poaNotesLong = EwvUtils.addLineBreaks(poaNotesPlain);
        String poaNotesShort = EwvUtils.shorten(poaNotesLong, 15);
        boolean usePoaNotesModelPanel = false;
        if (poaNotesShort.endsWith("...")) {
          usePoaNotesModelPanel = true;
        }
        
        // Needed to altered once the updated model jar is added 
//        String reasonForVisit2_5010 = claim.getHccodesReasonForVisit2_5010();
//        String reasonForVisit3_5010 = claim.getHccodesReasonForVisit3_5010();
//        String referralLong_5010 = claim.getInvoiceReferral_5010();
        
        String reasonForVisit2_5010 = "";
        String reasonForVisit3_5010 = "";
        String referralLong_5010 = "";
        
        String referralShort_5010 = null;
        boolean useReferralModalPanel_5010 = false;
        referralShort_5010 = EwvUtils.shorten(referralLong_5010, 20);
        if (referralShort_5010.endsWith("...")) {
          useReferralModalPanel_5010 = true;
        }

        BillingAndAdmissionInfo billingMiscInfo
          = new BillingAndAdmissionInfo(patientAccountNumber,
        		                       totalClaimCharges,
        		                       typeOfBillOrFrequency,
        		                       statementFromTo,
        		                       statementFromToEWV2,
        		                       previousPDIOrClaimNumber,
        		                       patientPaidAmount,
        		                       patientSignature,
        		                       patientStatus,
        		                       priorAuthorizationReferral,
        		                       admissionType,
        		                       providerAcceptsAssignment,
        		                       admissionSource,
        		                       assignmentOfBenefits,
        		                       admissionDateOrHour,
        		                       admissionDate,
        		                       admissionHour,
        		                       dischargeDateHour,
        		                       medicareIcn,
        		                       renderingPrvdName,
        		                       renderingPrvdNpi,
        		                       renderingPrvdTaxonomyCode,
        		                       accidentDate,
        		                       accidentIndicator,
        		                       priorAuthorizationReferralShort,
        		                       usePriorAuthorizationModalPanel,
        		                       frequency,
        		                       
        		                       // Added for Phase II
        		                       admittingDiagnosis,
        		                       reasonForVisit,
        		                       eCode,
        		                       poaNotesShort,
        		                       poaNotesLong,
        		                       usePoaNotesModelPanel,
        		                       
                                       // Added for 5010
                                       reasonForVisit2_5010,
                                       reasonForVisit3_5010,
                                       referralLong_5010,
                                       referralShort_5010,
                                       useReferralModalPanel_5010);
        
        
        return billingMiscInfo;
    }

}
