package gov.va.med.ewv.service;

import java.util.List;
import java.util.Set;

import gov.va.med.domain.fee.EwvClaims;
import gov.va.med.domain.fee.EwvServiceLines;
import gov.va.med.domain.fee.EwvSvcLineDme;
import gov.va.med.ewv.exceptions.NonUniqueRecordsException;
import gov.va.med.ewv.model.response.AmbulanceInfo;
import gov.va.med.ewv.model.response.MedicalEquipmentLine;
import gov.va.med.ewv.util.ServiceLine;

public interface IEwvAmbulanceAndServiceLinesInfoService {

	AmbulanceInfo populateServiceLineLevelAmbulanceInfo(EwvServiceLines serviceLineBean)
			throws NonUniqueRecordsException;

	ServiceLine populateServiceLine(EwvServiceLines line, EwvClaims claim) throws NonUniqueRecordsException;

	List<ServiceLine> populateServiceLines(EwvClaims claim) throws NonUniqueRecordsException;

	List<MedicalEquipmentLine> createMedicalEquipmentLines(Set<EwvSvcLineDme> list);

	AmbulanceInfo populateClaimLevelAmbulanceInfo(EwvClaims claimBean) throws NonUniqueRecordsException;
}
