package gov.va.med.ewv.model.response;

import java.io.Serializable;

import gov.va.med.ewv.util.EwvUtils;

public class ToothLine implements Serializable, Comparable<ToothLine>
{
    private static final long serialVersionUID = 500026968907938620L;
    private String toothNumber;
    private String surface1;
    private String surface2;
    private String surface3;
    private String surface4;
    private String surface5;
    
    public ToothLine(String toothNumber, 
                     String surface1, 
                     String surface2,
                     String surface3,
                     String surface4,
                     String surface5)
    {
        this.toothNumber = EwvUtils.formatAsInteger(toothNumber);
        this.surface1 = surface1;
        this.surface2 = surface2;
        this.surface3 = surface3;
        this.surface4 = surface4;
        this.surface5 = surface5;
    }
    
    public String getToothNumber()
    {
        return toothNumber;
    }
    
    public void setToothNumber(String toothNumber)
    {
        this.toothNumber = toothNumber;
    }
    
    public String getSurface1()
    {
        return surface1;
    }
    
    public void setSurface1(String surface1)
    {
        this.surface1 = surface1;
    }
    
    public String getSurface2()
    {
        return surface2;
    }
    
    public void setSurface2(String surface2)
    {
        this.surface2 = surface2;
    }
    
    public String getSurface3()
    {
        return surface3;
    }
    
    public void setSurface3(String surface3)
    {
        this.surface3 = surface3;
    }
    
    public String getSurface4()
    {
        return surface4;
    }
    
    public void setSurface4(String surface4)
    {
        this.surface4 = surface4;
    }
    
    public String getSurface5()
    {
        return surface5;
    }
    
    public void setSurface5(String surface5)
    {
        this.surface5 = surface5;
    }
    
    public int compareTo(ToothLine line)
    {
        int equal = 0;
        int gt = 1;
        int lt = -1;
        int ret = equal;
        
        int myToothNumber = Integer.parseInt(toothNumber);
        int theirToothNumber = Integer.parseInt(line.getToothNumber());
        
        if (myToothNumber == theirToothNumber)
        {
            ret = equal;
        }
        else if (myToothNumber > theirToothNumber)
        {
            ret = gt;
        }
        else if (myToothNumber < theirToothNumber)
        {
            ret = lt;
        }
        
        return ret;
    }
    
}
