package gov.va.med.ewv.model.response;

import gov.va.med.ewv.util.DTOBase;
import gov.va.med.ewv.util.EwvUtils;


public class QuickViewServiceLineOhiOutputRow
       extends DTOBase
       //implements Comparable<QuickViewServiceLineOhiOutputRow>
{
    private String lineNumber;
	private String beginDateOfService;
    private String charge;
    private String primaryPayerProcedureCode;
    private String primaryPayerPaidAmount;
    private ServiceLineOhiAdjustment primaryServiceLineAdjustment;
    private String secondaryPayerProcedureCode;
    private String secondaryPayerPaidAmount;
    private ServiceLineOhiAdjustment secondaryServiceLineAdjustment;
    private String ohiModifiers;
    
	public QuickViewServiceLineOhiOutputRow() {
	}
	
	public QuickViewServiceLineOhiOutputRow
	      (String lineNumber,
           String beginDateOfService,
           String charge,
           String primaryPayerProcedureCode,
           String primaryPayerPaidAmount,
           ServiceLineOhiAdjustment primaryServiceLineAdjustment,
           String secondaryPayerProcedureCode,
           String secondaryPayerPaidAmount,
           ServiceLineOhiAdjustment secondaryServiceLineAdjustment,
           String ohiModifiers)
    {
        this.setLineNumber(EwvUtils.formatAsInteger(lineNumber));
        this.setBeginDateOfService(EwvUtils.formatAsDate(beginDateOfService));
        this.setCharge(EwvUtils.formatAsCurrency(charge));
        this.setPrimaryPayerProcedureCode(primaryPayerProcedureCode);
        this.setPrimaryPayerPaidAmount(EwvUtils.formatAsCurrency(primaryPayerPaidAmount));
        this.setPrimaryServiceLineAdjustment(primaryServiceLineAdjustment);
        this.setSecondaryPayerProcedureCode(secondaryPayerProcedureCode);
        this.setSecondaryPayerPaidAmount(EwvUtils.formatAsCurrency(secondaryPayerPaidAmount));
        this.setSecondaryServiceLineAdjustment(secondaryServiceLineAdjustment);
        this.setOhiModifiers(ohiModifiers);
    }

	public void setLineNumber(String lineNumber) {
		this.lineNumber = lineNumber;
	}

	public String getLineNumber() {
		return lineNumber;
	}

	public void setBeginDateOfService(String beginDateOfService) {
		this.beginDateOfService = beginDateOfService;
	}

	public String getBeginDateOfService() {
		return beginDateOfService;
	}

	public void setCharge(String charge) {
		this.charge = charge;
	}

	public String getCharge() {
		return charge;
	}

	public void setPrimaryPayerProcedureCode(String primaryPayerProcedureCode) {
		this.primaryPayerProcedureCode = primaryPayerProcedureCode;
	}

	public String getPrimaryPayerProcedureCode() {
		return primaryPayerProcedureCode;
	}

	public void setPrimaryPayerPaidAmount(String primaryPayerPaidAmount) {
		this.primaryPayerPaidAmount = primaryPayerPaidAmount;
	}

	public String getPrimaryPayerPaidAmount() {
		return primaryPayerPaidAmount;
	}

	public void setPrimaryServiceLineAdjustment(
			ServiceLineOhiAdjustment primaryServiceLineAdjustment) {
		this.primaryServiceLineAdjustment = primaryServiceLineAdjustment;
	}

	public ServiceLineOhiAdjustment getPrimaryServiceLineAdjustment() {
		return primaryServiceLineAdjustment;
	}

    public void setSecondaryPayerProcedureCode(String secondaryPayerProcedureCode) {
      this.secondaryPayerProcedureCode = secondaryPayerProcedureCode;
    }

    public String getSecondaryPayerProcedureCode() {
      return secondaryPayerProcedureCode;
    }

	public void setSecondaryPayerPaidAmount(String secondaryPayerPaidAmount) {
		this.secondaryPayerPaidAmount = secondaryPayerPaidAmount;
	}

	public String getSecondaryPayerPaidAmount() {
		return secondaryPayerPaidAmount;
	}

	public void setSecondaryServiceLineAdjustment(
			ServiceLineOhiAdjustment secondaryServiceLineAdjustment) {
		this.secondaryServiceLineAdjustment = secondaryServiceLineAdjustment;
	}

	public ServiceLineOhiAdjustment getSecondaryServiceLineAdjustment() {
		return secondaryServiceLineAdjustment;
	}

	public String getOhiModifiers() {
		return ohiModifiers;
	}

	public void setOhiModifiers(String ohiModifiers) {
		this.ohiModifiers = ohiModifiers;
	}
    
//    // Used in sorting
//    public int compareTo(QuickViewServiceLineOhiOutputRow line)
//    {
//      SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy");
//      int equal = 0;
//      int mineLess = -1;
//      int mineGreater = 1;
//      
//      int returnValue = equal;
//      
//      Date myFromDate = null;
//      Date theirFromDate = null;
//      String myProcedureCode = null;
//      String theirProcedureCode = null;
//      try {
//        if (beginDateOfService != null && line.getBeginDateOfService() != null) {
//          myFromDate = formatter.parse(beginDateOfService);
//          theirFromDate = formatter.parse(line.getBeginDateOfService());
//          returnValue = myFromDate.compareTo(theirFromDate);
//          if (returnValue == equal) {
//            myProcedureCode = primaryPayerProcedureCode;
//            theirProcedureCode = line.getPrimaryPayerProcedureCode();
//            if (myProcedureCode != null && theirProcedureCode != null) {
//              returnValue = myProcedureCode.compareToIgnoreCase(theirProcedureCode);
//            } else if (myProcedureCode == null && theirProcedureCode != null) {
//              returnValue = mineLess;
//            } else if (myProcedureCode != null && theirProcedureCode == null) {
//              returnValue = mineGreater;
//            }
//          }
//        }
//      } catch (Exception e) {
//        // If these dates cannot be parsed for sorting, they could not be parsed for display
//        beginDateOfService = "Error";
//        returnValue = equal;
//      }
//
//      return returnValue;
//    }
    
}
