package gov.va.med.ewv.model.response;
import java.io.Serializable;

import gov.va.med.ewv.util.EwvUtils;

public class PatientInfo implements Serializable
{
    private static final long serialVersionUID = 9212340001239829834L;
    private String            patientName      = "   ";
    private String            patientIdNumber  = "  ";
    private String            dateOfBirth      = "  ";
    private String            dateOfDeath_5010      = "  ";
    private String            gender           = "   ";
    private String addressLineOne;
    private String addressLineTwo;
    private String city;
    private String state;
    private String postalCode;
    private String country;
    
    public PatientInfo(String patientName,
                           String patientIdNumber,
                           String dateOfBirth,
                           String dateOfDeath_5010,
                           String gender,
                           String addressLineOne, 
                           String addressLineTwo,
                           String city,
                           String state,
                           String postalCode,
                           String country)
    {        
        this.patientName = patientName;
        this.patientIdNumber = patientIdNumber;
        this.dateOfBirth = EwvUtils.formatAsDate(dateOfBirth, "MM/dd/yyyy");
        this.dateOfDeath_5010 = EwvUtils.formatAsDate(dateOfDeath_5010, "MM/dd/yyyy");
        this.gender = gender;
        this.addressLineOne = addressLineOne;
        this.addressLineTwo = addressLineTwo;
        this.city = city;
        this.state = state;
        this.postalCode = postalCode;
        this.country = country;
    }

	/**
	 * @return the patientName
	 */
	public String getPatientName() {
		return patientName;
	}

	/**
	 * @param patientName the patientName to set
	 */
	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	/**
	 * @return the patientIdNumber
	 */
	public String getPatientIdNumber() {
		return patientIdNumber;
	}

	/**
	 * @param patientIdNumber the patientIdNumber to set
	 */
	public void setPatientIdNumber(String patientIdNumber) {
		this.patientIdNumber = patientIdNumber;
	}

	/**
	 * @return the dateOfBirth
	 */
	public String getDateOfBirth() {
		return dateOfBirth;
	}

	/**
	 * @param dateOfBirth the dateOfBirth to set
	 */
	public void setDateOfBirth(String dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}

	/**
	 * @return the dateOfDeath_5010
	 */
	public String getDateOfDeath_5010() {
		return dateOfDeath_5010;
	}

	/**
	 * @param dateOfDeath_5010 the dateOfDeath_5010 to set
	 */
	public void setDateOfDeath_5010(String dateOfDeath_5010) {
		this.dateOfDeath_5010 = dateOfDeath_5010;
	}

	/**
	 * @return the gender
	 */
	public String getGender() {
		return gender;
	}

	/**
	 * @param gender the gender to set
	 */
	public void setGender(String gender) {
		this.gender = gender;
	}

	/**
	 * @return the addressLineOne
	 */
	public String getAddressLineOne() {
		return addressLineOne;
	}

	/**
	 * @param addressLineOne the addressLineOne to set
	 */
	public void setAddressLineOne(String addressLineOne) {
		this.addressLineOne = addressLineOne;
	}

	/**
	 * @return the addressLineTwo
	 */
	public String getAddressLineTwo() {
		return addressLineTwo;
	}

	/**
	 * @param addressLineTwo the addressLineTwo to set
	 */
	public void setAddressLineTwo(String addressLineTwo) {
		this.addressLineTwo = addressLineTwo;
	}

	/**
	 * @return the city
	 */
	public String getCity() {
		return city;
	}

	/**
	 * @param city the city to set
	 */
	public void setCity(String city) {
		this.city = city;
	}

	/**
	 * @return the state
	 */
	public String getState() {
		return state;
	}

	/**
	 * @param state the state to set
	 */
	public void setState(String state) {
		this.state = state;
	}

	/**
	 * @return the postalCode
	 */
	public String getPostalCode() {
		return postalCode;
	}

	/**
	 * @param postalCode the postalCode to set
	 */
	public void setPostalCode(String postalCode) {
		this.postalCode = postalCode;
	}

	/**
	 * @return the country
	 */
	public String getCountry() {
		return country;
	}

	/**
	 * @param country the country to set
	 */
	public void setCountry(String country) {
		this.country = country;
	}

	/**
	 * @return the serialversionuid
	 */
	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	@Override
	public String toString() {
		return "PatientInfo [patientName=" + patientName + ", patientIdNumber=" + patientIdNumber + ", dateOfBirth="
				+ dateOfBirth + ", dateOfDeath_5010=" + dateOfDeath_5010 + ", gender=" + gender + ", addressLineOne="
				+ addressLineOne + ", addressLineTwo=" + addressLineTwo + ", city=" + city + ", state=" + state
				+ ", postalCode=" + postalCode + ", country=" + country + "]";
	}
    
}
