package gov.va.med.ewv.model.response;

import gov.va.med.ewv.util.ClaimFormat;
import gov.va.med.ewv.util.ClaimType;
import gov.va.med.ewv.util.EwvUtils;

public class PatientHeaderInfo {
	private String format = "";
	private ClaimFormat claimFormat = ClaimFormat.NONE;
	private ClaimType claimType = ClaimType.NONE;
	private String medicareCrossOver = " ";
	private String patientName = " ";
	private String billingNPI = " ";
	private String memberID = " ";

	private String tin = " ";
	private String pdi = " ";
	private String pcn = " ";
	private String pcnShort;
	private boolean usePcnModalPanel;

	public PatientHeaderInfo(String format, ClaimType claimType, String medicareCrossOver, String patientName,
			String billingNPI, String memberID, String tin, String pdi, String pcn, String pcnShort,
			boolean usePcnModalPanel) {
		super();
		this.format = format;
		this.claimType = claimType;
		this.medicareCrossOver = medicareCrossOver;
		this.patientName = patientName;
		this.billingNPI = billingNPI;
		this.memberID = memberID;
		this.tin = tin;
		this.pdi = EwvUtils.formatPDIForOutput(pdi);
		this.pcn = pcn;
		this.pcnShort = pcnShort;
		this.usePcnModalPanel = usePcnModalPanel;
	}

	public PatientHeaderInfo() {

	}

	
	/**
	 * @return the format
	 */
	public String getFormat() {
		return format;
	}

	/**
	 * @param format the format to set
	 */
	public void setFormat(String format) {
		this.format = format;
	}

	public ClaimFormat getClaimFormat() {
		return claimFormat;
	}

	public void setClaimFormat(ClaimFormat claimFormat) {
		this.claimFormat = claimFormat;
	}

	public ClaimType getClaimType() {
		return claimType;
	}

	public void setClaimType(ClaimType claimType) {
		this.claimType = claimType;
	}

	public String getMedicareCrossOver() {
		return medicareCrossOver;
	}

	public void setMedicareCrossOver(String medicareCrossOver) {
		this.medicareCrossOver = medicareCrossOver;
	}

	public String getPatientName() {
		return patientName;
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	public String getBillingNPI() {
		return billingNPI;
	}

	public void setBillingNPI(String billingNPI) {
		this.billingNPI = billingNPI;
	}

	public String getMemberID() {
		return memberID;
	}

	public void setMemberID(String memberID) {
		this.memberID = memberID;
	}

	public String getTin() {
		return tin;
	}

	public void setTin(String tin) {
		this.tin = tin;
	}

	public String getPdi() {
		return pdi;
	}

	public void setPdi(String pdi) {
		this.pdi = pdi;
	}

	public String getPcn() {
		return pcn;
	}

	public void setPcn(String pcn) {
		this.pcn = pcn;
	}

	public String getPcnShort() {
		return pcnShort;
	}

	public void setPcnShort(String pcnShort) {
		this.pcnShort = pcnShort;
	}

	public boolean isUsePcnModalPanel() {
		return usePcnModalPanel;
	}

	public void setUsePcnModalPanel(boolean usePcnModalPanel) {
		this.usePcnModalPanel = usePcnModalPanel;
	}

	@Override
	public String toString() {
		return "PatientHeaderInfo [claimFormat=" + claimFormat + ", claimType=" + claimType + ", medicareCrossOver="
				+ medicareCrossOver + ", patientName=" + patientName + ", billingNPI=" + billingNPI + ", memberID="
				+ memberID + ", tin=" + tin + ", pdi=" + pdi + ", pcn=" + pcn + ", pcnShort=" + pcnShort
				+ ", usePcnModalPanel=" + usePcnModalPanel + "]";
	}

}
