package gov.va.med.ewv.model.response;

import java.io.Serializable;
import java.util.List;


public class OhiInfoContainer implements Serializable
{
    private static final long serialVersionUID = -6801004666161058008L;
    
    private List<ClaimOhiContainer> claimOhiList;
    private List<QuickViewServiceLineOhiOutputRow> quickviewServiceLineOhiOutputRows;
    private List<DetailServiceLineOhiOutputRow> detailServiceLineOhiOutputRows;
    
    // Phase Two Pieces
    private ClaimOhi primaryOhi;
    private ClaimOhi secondaryOhi;
    private boolean isTertiaryOhi;
    
    private String pdi;
    
    // These are three manifestations of the Payer ID problem, any one of which will
    //   cause the OHI sections to not display in Quickview
    private boolean hasMultiplePrimaryPayers;
    private boolean hasMultipleSecondaryPayers;
    private boolean hasMultiplePayersWithSamePayerId;
    
    // This flag is set to true if any of the above three is true
    private boolean hasPayerIdProblem;
    
    // This is a fourth type of Payer ID problem, but it is handled in the normal Quickview
    private boolean hasMultipleAdjudicationsFromSamePayer;

    public OhiInfoContainer
      (List<ClaimOhiContainer> claimOhiList,
       ClaimOhi primaryOhi,
       ClaimOhi secondaryOhi,
       Boolean isTertiaryOhi,
       List<QuickViewServiceLineOhiOutputRow> quickviewServiceLineOhiAdjustmentRows,
       List<DetailServiceLineOhiOutputRow> detailServiceLineOhiAdjustmentRows,
       boolean hasPayerIdProblem,
       boolean hasMultiplePrimaryPayers,
       boolean hasMultipleSecondaryPayers,
       boolean hasMultiplePayersWithSamePayerId,
       boolean hasMultipleAdjudicationsFromSamePayer)
    {
        this.claimOhiList = claimOhiList;
        this.pdi = " ";
        this.primaryOhi = primaryOhi;
        this.secondaryOhi = secondaryOhi;
        this.isTertiaryOhi = isTertiaryOhi;
        this.quickviewServiceLineOhiOutputRows = quickviewServiceLineOhiAdjustmentRows;
        this.detailServiceLineOhiOutputRows = detailServiceLineOhiAdjustmentRows;
        this.hasPayerIdProblem = hasPayerIdProblem;
        this.hasMultiplePrimaryPayers = hasMultiplePrimaryPayers;
        this.hasMultipleSecondaryPayers = hasMultipleSecondaryPayers;
        this.hasMultiplePayersWithSamePayerId = hasMultiplePayersWithSamePayerId;
        this.hasMultipleAdjudicationsFromSamePayer = hasMultipleAdjudicationsFromSamePayer;
    }
    
    public OhiInfoContainer()
    {
        this.pdi = " ";
    }

    public String getPdi()
    {
        return pdi;
    }
    
    public void setPdi(String pdi)
    {
        this.pdi = pdi;
    }
    
    public void setPrimaryOhi(ClaimOhi primaryOhi) {
		this.primaryOhi = primaryOhi;
	}

    public ClaimOhi getPrimaryOhi() {
		return primaryOhi;
	}

    public void setSecondaryOhi(ClaimOhi secondaryOhi) {
		this.secondaryOhi = secondaryOhi;
	}

    public ClaimOhi getSecondaryOhi() {
		return secondaryOhi;
	}

    public void setTertiaryOhi(boolean isTertiaryOhi) {
		this.isTertiaryOhi = isTertiaryOhi;
	}

    public String getIsTertiaryOhi() {
		if (isTertiaryOhi) {
			return "Y";
		} else {
			return "N";
		}
	}

    public List<QuickViewServiceLineOhiOutputRow> getQuickviewServiceLineOhiOutputRows() {
      return quickviewServiceLineOhiOutputRows;
    }

    public void setQuickviewServiceLineOhiOutputRows(
        List<QuickViewServiceLineOhiOutputRow> quickviewServiceLineOhiOutputRows) {
      this.quickviewServiceLineOhiOutputRows = quickviewServiceLineOhiOutputRows;
    }

    public List<ClaimOhiContainer> getClaimOhiList() {
      return claimOhiList;
    }

    public void setClaimOhiList(List<ClaimOhiContainer> claimOhiList) {
      this.claimOhiList = claimOhiList;
    }

    public List<DetailServiceLineOhiOutputRow> getDetailServiceLineOhiOutputRows() {
      return detailServiceLineOhiOutputRows;
    }

    public void setDetailServiceLineOhiOutputRows(
        List<DetailServiceLineOhiOutputRow> detailServiceLineOhiOutputRows) {
      this.detailServiceLineOhiOutputRows = detailServiceLineOhiOutputRows;
    }
    
    public boolean isHasPayerIdProblem() {
      return hasPayerIdProblem;
    }

    public void setHasPayerIdProblem(boolean hasPayerIdProblem) {
      this.hasPayerIdProblem = hasPayerIdProblem;
    }

    public boolean getShouldRenderClaimOhis()
    {
      boolean returnVal = false;
      
      if (claimOhiList != null && claimOhiList.size() > 0) {
        returnVal = true;
      }
      
      if (primaryOhi != null) {
        returnVal = true;
      }
      
      if (secondaryOhi != null) {
        returnVal = true;
      }
      
      return returnVal;
    }

    public boolean getShouldRenderServiceLineOhis()
    {
      boolean returnVal = false;
      
      if (detailServiceLineOhiOutputRows != null && detailServiceLineOhiOutputRows.size() > 0) {
        returnVal = true;
      }
      
      return returnVal;
    }

    public boolean getShouldRenderQuickview()
    {
      boolean returnVal = false;
      
      if (getShouldRenderClaimOhis()) {
        returnVal = true;
      }
      
      if (getShouldRenderServiceLineOhis()) {
        returnVal = true;
      }
      
      return returnVal;
    }
    
    public boolean getShouldRenderRemittanceRemarks()
    {
      boolean returnVal = false;
      
      if (primaryOhi != null
            && primaryOhi.getRemittanceRemarkCodes() != null
            && primaryOhi.getRemittanceRemarkCodes().size() > 0) {
        returnVal = true;
      }
      
      if (secondaryOhi != null
            && secondaryOhi.getRemittanceRemarkCodes() != null
            && secondaryOhi.getRemittanceRemarkCodes().size() > 0) {
        returnVal = true;
      }
      
      return returnVal;
    }
    
    public boolean getShouldRenderClaimOhisDetail()
    {
      boolean returnVal = false;
      
      if (claimOhiList != null && claimOhiList.size() > 0) {
        returnVal = true;
      }
      
      return returnVal;
    }

    public boolean getHasMultiplePrimaryPayers() {
      return hasMultiplePrimaryPayers;
    }

    public void setHasMultiplePrimaryPayers(boolean hasMultiplePrimaryPayers) {
      this.hasMultiplePrimaryPayers = hasMultiplePrimaryPayers;
    }

    public boolean getHasMultipleSecondaryPayers() {
      return hasMultipleSecondaryPayers;
    }

    public void setHasMultipleSecondaryPayers(boolean hasMultipleSecondaryPayers) {
      this.hasMultipleSecondaryPayers = hasMultipleSecondaryPayers;
    }

    public boolean getHasMultiplePayersWithSamePayerId() {
      return hasMultiplePayersWithSamePayerId;
    }

    public void setHasMultiplePayersWithSamePayerId(boolean hasMultiplePayersWithSamePayerId) {
      this.hasMultiplePayersWithSamePayerId = hasMultiplePayersWithSamePayerId;
    }

    public boolean getHasMultipleAdjudicationsFromSamePayer() {
      return hasMultipleAdjudicationsFromSamePayer;
    }

    public void setHasMultipleAdjudicationsFromSamePayer(boolean hasMultipleAdjudicationsFromSamePayer) {
      this.hasMultipleAdjudicationsFromSamePayer = hasMultipleAdjudicationsFromSamePayer;
    }

    public String getPayerProblemExplanation() {
      String returnValue = "";
      boolean addHyphen = false;
      
      if (hasMultiplePrimaryPayers) {
        returnValue += "Multiple Primary Payers";
        addHyphen = true;
      }
      
      if (hasMultipleSecondaryPayers) {
        if (addHyphen) {
          returnValue += " - ";
        }
        returnValue += "Multiple Secondary Payers";
        addHyphen = true;
      }
      
//      if (hasMultipleAdjudicationsFromSamePayer) {
//        if (addHyphen) {
//          returnValue += " - ";
//        }
//        returnValue += "Multiple Service Line Adjudications From Same Payer ID";
//        addHyphen = true;
//      }
//      
      if (hasMultiplePayersWithSamePayerId) {
        if (addHyphen) {
          returnValue += " - ";
        }
        returnValue += "Multiple Payers With the Same Payer ID";
      }
      
      
      return returnValue;
    }
}
