package gov.va.med.ewv.model.response;

import java.io.Serializable;
import java.util.List;

import gov.va.med.ewv.codes.RemittanceCode;
import gov.va.med.ewv.util.DTOBase;
import gov.va.med.ewv.util.EwvUtils;

public class MedicareOutPatientAdjudicationBean extends DTOBase implements Serializable
{
    private String       ohiPayerId;
    private List<RemittanceCode> remittanceRemarkCodes;
    
    private String       reimbursementRate;
    private String        claimHcpcsPayableAmount;
    private String        esrdPaidAmount;
    private String       nonPayableProfessionalComponentAmount;
    
    public MedicareOutPatientAdjudicationBean(String ohiPayerId, List<RemittanceCode> remittanceRemarkCodes, String reimbursementRate, String claimHcpcsPayableAmount, String esrdPaidAmount, String nonPayableProfessionalComponentAmount)
    {
        this.ohiPayerId = ohiPayerId;
        this.remittanceRemarkCodes = remittanceRemarkCodes;
        this.reimbursementRate = EwvUtils.formatAsCurrency(reimbursementRate);
        this.claimHcpcsPayableAmount = EwvUtils.formatAsCurrency(claimHcpcsPayableAmount);
        this.esrdPaidAmount = EwvUtils.formatAsCurrency(esrdPaidAmount);
        this.nonPayableProfessionalComponentAmount = EwvUtils.formatAsCurrency(nonPayableProfessionalComponentAmount);
    }

    public String getOhiPayerId()
    {
        return ohiPayerId;
    }

    public void setOhiPayerId(String ohiPayerId)
    {
        this.ohiPayerId = ohiPayerId;
    }

    public List<RemittanceCode> getRemittanceRemarkCodes()
    {
        return remittanceRemarkCodes;
    }

    public void setRemittanceRemarkCodes(List<RemittanceCode> remittanceRemarkCodes)
    {
        this.remittanceRemarkCodes = remittanceRemarkCodes;
    }

    public String getReimbursementRate()
    {
        return reimbursementRate;
    }

    public void setReimbursementRate(String reimbursementRate)
    {
        this.reimbursementRate = reimbursementRate;
    }

    public String getNonPayableProfessionalComponentAmount()
    {
        return nonPayableProfessionalComponentAmount;
    }

    public void setNonPayableProfessionalComponentAmount(String nonPayableProfessionalComponentAmount)
    {
        this.nonPayableProfessionalComponentAmount = nonPayableProfessionalComponentAmount;
    }

    public String getClaimHcpcsPayableAmount() {
      return claimHcpcsPayableAmount;
    }

    public void setClaimHcpcsPayableAmount(String claimHcpcsPayableAmount) {
      this.claimHcpcsPayableAmount = claimHcpcsPayableAmount;
    }

    public String getEsrdPaidAmount() {
      return esrdPaidAmount;
    }

    public void setEsrdPaidAmount(String esrdPaidAmount) {
      this.esrdPaidAmount = esrdPaidAmount;
    }
    
    
    
    
    
}
