package gov.va.med.ewv.model.response;


import java.io.Serializable;
import java.util.List;

import gov.va.med.ewv.codes.RemittanceCode;
import gov.va.med.ewv.util.DTOBase;
import gov.va.med.ewv.util.EwvUtils;

public class MedicareInPatientAdjudicationBean extends DTOBase implements Serializable
{
    private static final long serialVersionUID = -559834452574454702L;

    private String       ohiPayerId;
    
    private String       lifetimeReserveDays;
    private String       coveredDays;
    private String       lifetimePsychiatricDays;
    private String       nonPayableProfessionalComponent;
    private String       claimDisproportionateShare;
    private String       costReportDayCount;
    private List<RemittanceCode> remittanceRemarkCodes;
    
    private String        ppsOperatingFederalSpecDrugAmount;
    private String        ppsCapitalOutlierAmount;
    private String        claimIndirectTeachingAmount;
    private String        claimDrugAmount;
    private String        ppsCapitalExceptionAmount;
    private String        mspPassThruAmount;
    private String        claimPpsCapitalAmount;
    private String        ppsCapitalFspDrugAmount;
    private String        ppsCapitalHspDrugAmount;
    private String        ppsCapitalDshDrugAmount;
    private String        oldCapitalAmount;
    private String        ppsCapitalImeAmount;
    private String        ppsOperHospitalSpecicalDrugAmount;
    
    public MedicareInPatientAdjudicationBean(String ohiPayerId, String coveredDays, String ppsOperatingFederalSpecDrugAmount, String lifetimeReserveDays, String ppsCapitalOutlierAmount, String lifetimePsychiatricDays, String claimIndirectTeachingAmount, String claimDrugAmount, String nonPayableProfessionalComponent, String claimDisproportionateShare, String ppsCapitalExceptionAmount, String mspPassThruAmount, String costReportDayCount, String claimPpsCapitalAmount,
            String ppsCapitalFspDrugAmount, String ppsCapitalHspDrugAmount, String ppsCapitalDshDrugAmount, String oldCapitalAmount, List<RemittanceCode> remittanceRemarkCodes, String ppsCapitalImeAmount, String ppsOperHospitalSpecicalDrugAmount)
    {
        this.ohiPayerId = ohiPayerId;
        this.coveredDays = EwvUtils.formatAsInteger(coveredDays);
        this.ppsOperatingFederalSpecDrugAmount = EwvUtils.formatAsCurrency(ppsOperatingFederalSpecDrugAmount);
        this.lifetimeReserveDays = EwvUtils.formatAsInteger(lifetimeReserveDays);
        this.ppsCapitalOutlierAmount = EwvUtils.formatAsCurrency(ppsCapitalOutlierAmount);
        this.lifetimePsychiatricDays = EwvUtils.formatAsInteger(lifetimePsychiatricDays);
        this.claimIndirectTeachingAmount = EwvUtils.formatAsCurrency(claimIndirectTeachingAmount);
        this.claimDrugAmount = EwvUtils.formatAsCurrency(claimDrugAmount);
        this.nonPayableProfessionalComponent = EwvUtils.formatAsCurrency(nonPayableProfessionalComponent);
        this.claimDisproportionateShare = EwvUtils.formatAsCurrency(claimDisproportionateShare);
        this.ppsCapitalExceptionAmount = EwvUtils.formatAsCurrency(ppsCapitalExceptionAmount);
        this.mspPassThruAmount = EwvUtils.formatAsCurrency(mspPassThruAmount);
        this.costReportDayCount = EwvUtils.formatAsInteger(costReportDayCount);
        this.claimPpsCapitalAmount = EwvUtils.formatAsCurrency(claimPpsCapitalAmount);
        this.ppsCapitalFspDrugAmount = EwvUtils.formatAsCurrency(ppsCapitalFspDrugAmount);
        this.ppsCapitalHspDrugAmount = EwvUtils.formatAsCurrency(ppsCapitalHspDrugAmount);
        this.ppsCapitalDshDrugAmount = EwvUtils.formatAsCurrency(ppsCapitalDshDrugAmount);
        this.oldCapitalAmount = EwvUtils.formatAsCurrency(oldCapitalAmount);
        this.remittanceRemarkCodes = remittanceRemarkCodes;
        this.ppsCapitalImeAmount = EwvUtils.formatAsCurrency(ppsCapitalImeAmount);
        this.ppsOperHospitalSpecicalDrugAmount = EwvUtils.formatAsCurrency(ppsOperHospitalSpecicalDrugAmount);
    }
    
    public String getOhiPayerId()
    {
        return ohiPayerId;
    }
    
    public void setOhiPayerId(String ohiPayerId)
    {
        this.ohiPayerId = ohiPayerId;
    }
    
    public String getLifetimeReserveDays()
    {
        return lifetimeReserveDays;
    }
    
    public void setLifetimeReserveDays(String lifetimeReserveDays)
    {
        this.lifetimeReserveDays = lifetimeReserveDays;
    }
    
    public String getCoveredDays()
    {
        return coveredDays;
    }
    
    public void setCoveredDays(String coveredDays)
    {
        this.coveredDays = coveredDays;
    }
    
    public String getLifetimePsychiatricDays()
    {
        return lifetimePsychiatricDays;
    }
    
    public void setLifetimePsychiatricDays(String lifetimePsychiatricDays)
    {
        this.lifetimePsychiatricDays = lifetimePsychiatricDays;
    }
    
    public String getNonPayableProfessionalComponent()
    {
        return nonPayableProfessionalComponent;
    }
    
    public void setNonPayableProfessionalComponent(String nonPayableProfessionalComponent)
    {
        this.nonPayableProfessionalComponent = nonPayableProfessionalComponent;
    }
    
    public String getClaimDisproportionateShare()
    {
        return claimDisproportionateShare;
    }
    
    public void setClaimDisproportionateShare(String claimDisproportionateShare)
    {
        this.claimDisproportionateShare = claimDisproportionateShare;
    }
    
    public String getCostReportDayCount()
    {
        return costReportDayCount;
    }
    
    public void setCostReportDayCount(String costReportDayCount)
    {
        this.costReportDayCount = costReportDayCount;
    }
    
    public List<RemittanceCode> getRemittanceRemarkCodes()
    {
        return remittanceRemarkCodes;
    }
    
    public void setRemittanceRemarkCodes(List<RemittanceCode> remittanceRemarkCodes)
    {
        this.remittanceRemarkCodes = remittanceRemarkCodes;
    }

    public String getPpsOperatingFederalSpecDrugAmount() {
      return ppsOperatingFederalSpecDrugAmount;
    }

    public void setPpsOperatingFederalSpecDrugAmount(String ppsOperatingFederalSpecDrugAmount) {
      this.ppsOperatingFederalSpecDrugAmount = ppsOperatingFederalSpecDrugAmount;
    }

    public String getPpsCapitalOutlierAmount() {
      return ppsCapitalOutlierAmount;
    }

    public void setPpsCapitalOutlierAmount(String ppsCapitalOutlierAmount) {
      this.ppsCapitalOutlierAmount = ppsCapitalOutlierAmount;
    }

    public String getClaimIndirectTeachingAmount() {
      return claimIndirectTeachingAmount;
    }

    public void setClaimIndirectTeachingAmount(String claimIndirectTeachingAmount) {
      this.claimIndirectTeachingAmount = claimIndirectTeachingAmount;
    }

    public String getClaimDrugAmount() {
      return claimDrugAmount;
    }

    public void setClaimDrugAmount(String claimDrugAmount) {
      this.claimDrugAmount = claimDrugAmount;
    }

    public String getPpsCapitalExceptionAmount() {
      return ppsCapitalExceptionAmount;
    }

    public void setPpsCapitalExceptionAmount(String ppsCapitalExceptionAmount) {
      this.ppsCapitalExceptionAmount = ppsCapitalExceptionAmount;
    }

    public String getMspPassThruAmount() {
      return mspPassThruAmount;
    }

    public void setMspPassThruAmount(String mspPassThruAmount) {
      this.mspPassThruAmount = mspPassThruAmount;
    }

    public String getClaimPpsCapitalAmount() {
      return claimPpsCapitalAmount;
    }

    public void setClaimPpsCapitalAmount(String claimPpsCapitalAmount) {
      this.claimPpsCapitalAmount = claimPpsCapitalAmount;
    }

    public String getPpsCapitalFspDrugAmount() {
      return ppsCapitalFspDrugAmount;
    }

    public void setPpsCapitalFspDrugAmount(String ppsCapitalFspDrugAmount) {
      this.ppsCapitalFspDrugAmount = ppsCapitalFspDrugAmount;
    }

    public String getPpsCapitalHspDrugAmount() {
      return ppsCapitalHspDrugAmount;
    }

    public void setPpsCapitalHspDrugAmount(String ppsCapitalHspDrugAmount) {
      this.ppsCapitalHspDrugAmount = ppsCapitalHspDrugAmount;
    }

    public String getPpsCapitalDshDrugAmount() {
      return ppsCapitalDshDrugAmount;
    }

    public void setPpsCapitalDshDrugAmount(String ppsCapitalDshDrugAmount) {
      this.ppsCapitalDshDrugAmount = ppsCapitalDshDrugAmount;
    }

    public String getOldCapitalAmount() {
      return oldCapitalAmount;
    }

    public void setOldCapitalAmount(String oldCapitalAmount) {
      this.oldCapitalAmount = oldCapitalAmount;
    }

    public String getPpsCapitalImeAmount() {
      return ppsCapitalImeAmount;
    }

    public void setPpsCapitalImeAmount(String ppsCapitalImeAmount) {
      this.ppsCapitalImeAmount = ppsCapitalImeAmount;
    }

    public String getPpsOperHospitalSpecicalDrugAmount() {
      return ppsOperHospitalSpecicalDrugAmount;
    }

    public void setPpsOperHospitalSpecicalDrugAmount(String ppsOperHospitalSpecicalDrugAmount) {
      this.ppsOperHospitalSpecicalDrugAmount = ppsOperHospitalSpecicalDrugAmount;
    }
    
//    public boolean getShouldRender()
//    {
//      boolean ok = EwvUtils.okToRender(claim.getInpRemittanceRemarkCode1(),
//          claim.getInpRemittanceRemarkCode2(),
//          claim.getInpRemittanceRemarkCode3(),
//          claim.getInpRemittanceRemarkCode4(),
//          claim.getInpRemittanceRemarkCode5(),
//          coveredDays,
//          ppsOperatingFederalSpecDrugAmount,
//          lifetimeReserveDays, 
//          ppsCapitalOutlierAmount, 
//          lifetimePsychiatricDays,
//          claimIndirectTeachingAmount,
//          claimDrugAmount,
//          nonPayableProfessionalComponent,
//          claimDisproportionateShare,
//          ppsCapitalExceptionAmount,
//          mspPassThruAmount, 
//          costReportDayCount,
//          claimPpsCapitalAmount,
//          ppsCapitalFspDrugAmount,
//          ppsCapitalHspDrugAmount, 
//          ppsCapitalDshDrugAmount,
//          oldCapitalAmount, 
//          ppsCapitalImeAmount, 
//          ppsOperHospitalSpecicalDrugAmount);
//
//ret.setShouldRender(ok);
//    }
//    
}
