package gov.va.med.ewv.model.response;

import java.io.Serializable;

import gov.va.med.ewv.util.EwvUtils;
import gov.va.med.ewv.util.HealthInfoType;

public class HealthCareInformationLine implements Serializable, Comparable<HealthCareInformationLine>
{
    private static final long serialVersionUID = 170293192036907824L;
    private String qualifier;
    private String descriptionLong;
    private String descriptionShort;
    private String code;
    private String date;
    private String format;
    private String amount;
    private HealthInfoType type;
    private String description;
    
    private boolean isOccur = false;
    private boolean isOccurSpan = false;
    private boolean isValue = false;
    private boolean isCondition = false;
    private Long    healthInfoSequence;

    public HealthCareInformationLine(Long sequence,
                                     HealthInfoType typeOf,
                                     String qualifier,
                                     String description,
                                     String code,
                                     String date,
                                     String format,
                                     String amount)
    {
        this.qualifier = qualifier;
        this.descriptionLong = typeOf.altDescription();
        this.descriptionShort = EwvUtils.shorten(descriptionLong, 20);
        this.code = code;
        this.date = EwvUtils.formatAsDate2(date, format, null);
        this.format = format;
        this.amount = EwvUtils.formatAsCurrency(amount);
        this.type = typeOf;
        this.description = description;
        
        isOccur = type.equals(HealthInfoType.OCCUR);
        isOccurSpan = type.equals(HealthInfoType.OCCUR_SPAN);
        isValue = type.equals(HealthInfoType.VALUE);
        isCondition = type.equals(HealthInfoType.CONDITION);
        
        this.healthInfoSequence = sequence;
    }
    
    
    public String getQualifier()
    {
        return qualifier;
    }
    
    public void setQualifier(String qualifier)
    {
        this.qualifier = qualifier;
    }
    
    public String getDescriptionLong()
    {
        return descriptionLong;
    }
    
    public void setDescriptionLong(String descriptionLong)
    {
        this.descriptionLong = descriptionLong;
    }
    
    public String getDescriptionShort()
    {
        return descriptionShort;
    }
    
    public void setDescriptionShort(String descriptionShort)
    {
        this.descriptionShort = descriptionShort;
    }
    
    public String getCode()
    {
        return code;
    }
    
    public void setCode(String code)
    {
        this.code = code;
    }
    
    public String getDate()
    {
        return date;
    }
    
    public void setDate(String date)
    {
        this.date = date;
    }
    
    public String getFormat()
    {
        return format;
    }
    
    public void setFormat(String format)
    {
        this.format = format;
    }
    
    public HealthInfoType getType()
    {
        return type;
    }

    public void setType(HealthInfoType type)
    {
        this.type = type;
    }
    
    
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}


	public boolean getIsOccur()
    {
        return isOccur;
    }


    public boolean getIsOccurSpan()
    {
        return isOccurSpan;
    }


    public boolean getIsValue()
    {
        return isValue;
    }


    public boolean getIsCondition()
    {
        return isCondition;
    }
    
    public String getSequenceNumber()
    {
        String ret = null;
        
        if(healthInfoSequence == null)
        {
            ret = " ";
        }
        else
        {
            ret = Long.toString(healthInfoSequence)+". ";    
        }
        
        return ret; 
    }
    
    public Long getHealthInfoSequence()
    {
        return ((healthInfoSequence == null) ? 0L:healthInfoSequence );
    }

    public int compareTo(HealthCareInformationLine bean)
    {
        int equal = 0;
        int gt = 1;
        int lt = -1;
        int ret = equal;
        
        long mySequence = healthInfoSequence;
        long theirSequence = bean.getHealthInfoSequence();
        
        if (mySequence == theirSequence)
        {
            ret = equal;
        }
        else if (mySequence > theirSequence)
        {
            ret = gt;
        }
        else if (mySequence < theirSequence)
        {
            ret = lt;
        }
        
        return ret;
    }


    public String getAmount() {
      return amount;
    }


    public void setAmount(String amount) {
      this.amount = amount;
    }


    public void setOccur(boolean isOccur) {
      this.isOccur = isOccur;
    }


    public void setOccurSpan(boolean isOccurSpan) {
      this.isOccurSpan = isOccurSpan;
    }


    public void setValue(boolean isValue) {
      this.isValue = isValue;
    }


    public void setCondition(boolean isCondition) {
      this.isCondition = isCondition;
    }


    public void setHealthInfoSequence(Long healthInfoSequence) {
      this.healthInfoSequence = healthInfoSequence;
    }

    
}
