package gov.va.med.ewv.model.response;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;

import gov.va.med.ewv.codes.DiagnosisCode;
import gov.va.med.ewv.codes.DiagnosisCodesContainer;
import gov.va.med.ewv.codes.ECode;
import gov.va.med.ewv.codes.ECodesContainer;
import gov.va.med.ewv.codes.ProcedureCode;
import gov.va.med.ewv.codes.ProcedureCodesContainer;
import gov.va.med.ewv.util.ClaimFormat;
import gov.va.med.ewv.util.ClaimType;
import gov.va.med.ewv.util.ServiceLine;

public class EwvClaimDetailResponse{

	private PatientHeaderInfo patientHeaderInfo;
	private PatientInfo patientInfo;
	private VendorInfo serviceLocationInfo;
	private VendorInfo billingProviderInfo;
	private BillingAndAdmissionInfo billingMiscellanous;
	@JsonIgnore
	private DiagnosisCodesContainer diagnosisCodesInfo;
	private ProcedureCodesContainer procedureCodesInfo;
	@JsonIgnore
	private ECodesContainer e_CodesInfo;
	private List<String> px;
	private List<String> dx;
	private List<String> eCodes;
	private HealthCareInfoResponse healthCareInfo;
	private List<ServiceLine> serviceLinesInfo;
	private OhiInfoContainer ohiInfo;
	
	public EwvClaimDetailResponse() {
		super();
		// TODO Auto-generated constructor stub
	}

	/**
	 * @return the patientHeaderInfo
	 */
	public PatientHeaderInfo getPatientHeaderInfo() {
		return patientHeaderInfo;
	}

	/**
	 * @param patientHeaderInfo the patientHeaderInfo to set
	 */
	public void setPatientHeaderInfo(PatientHeaderInfo patientHeaderInfo) {
		this.patientHeaderInfo = patientHeaderInfo;
	}

	/**
	 * @return the patientInfo
	 */
	public PatientInfo getPatientInfo() {
		return patientInfo;
	}

	/**
	 * @param patientInfo the patientInfo to set
	 */
	public void setPatientInfo(PatientInfo patientInfo) {
		this.patientInfo = patientInfo;
	}

	/**
	 * @return the serviceLocationInfo
	 */
	public VendorInfo getServiceLocationInfo() {
		return serviceLocationInfo;
	}

	/**
	 * @param serviceLocationInfo the serviceLocationInfo to set
	 */
	public void setServiceLocationInfo(VendorInfo serviceLocationInfo) {
		this.serviceLocationInfo = serviceLocationInfo;
	}

	/**
	 * @return the billingProviderInfo
	 */
	public VendorInfo getBillingProviderInfo() {
		return billingProviderInfo;
	}

	/**
	 * @param billingProviderInfo the billingProviderInfo to set
	 */
	public void setBillingProviderInfo(VendorInfo billingProviderInfo) {
		this.billingProviderInfo = billingProviderInfo;
	}

	/**
	 * @return the billingMiscellanous
	 */
	public BillingAndAdmissionInfo getBillingMiscellanous() {
		return billingMiscellanous;
	}

	/**
	 * @param billingMiscellanous the billingMiscellanous to set
	 */
	public void setBillingMiscellanous(BillingAndAdmissionInfo billingMiscellanous) {
		this.billingMiscellanous = billingMiscellanous;
	}

	/**
	 * @return the diagnosisCodesInfo
	 */
	public DiagnosisCodesContainer getDiagnosisCodesInfo() {
		return diagnosisCodesInfo;
	}

	/**
	 * @param diagnosisCodesInfo the diagnosisCodesInfo to set
	 */
	public void setDiagnosisCodesInfo(DiagnosisCodesContainer diagnosisCodesInfo) {
		this.diagnosisCodesInfo = diagnosisCodesInfo;
	}

	/**
	 * @return the procedureCodesInfo
	 */
	public ProcedureCodesContainer getProcedureCodesInfo() {
		return procedureCodesInfo;
	}

	/**
	 * @param procedureCodesInfo the procedureCodesInfo to set
	 */
	public void setProcedureCodesInfo(ProcedureCodesContainer procedureCodesInfo) {
		this.procedureCodesInfo = procedureCodesInfo;
	}
	
	public ECodesContainer getE_CodesInfo() {
		return e_CodesInfo;
	}

	public void setE_CodesInfo(ECodesContainer e_CodesInfo) {
		this.e_CodesInfo = e_CodesInfo;
	}

	/**
	 * @return the healthCareInfo
	 */
	public HealthCareInfoResponse getHealthCareInfo() {
		return healthCareInfo;
	}

	/**
	 * @param healthCareInfo the healthCareInfo to set
	 */
	public void setHealthCareInfo(HealthCareInfoResponse healthCareInfo) {
		this.healthCareInfo = healthCareInfo;
	}

	/**
	 * @return the serviceLinesInfo
	 */
	public List<ServiceLine> getServiceLinesInfo() {
		return serviceLinesInfo;
	}

	/**
	 * @param serviceLinesInfo the serviceLinesInfo to set
	 */
	public void setServiceLinesInfo(List<ServiceLine> serviceLinesInfo) {
		this.serviceLinesInfo = serviceLinesInfo;
	}

	/**
	 * @return the ohiInfo
	 */
	public OhiInfoContainer getOhiInfo() {
		return ohiInfo;
	}

	/**
	 * @param ohiInfo the ohiInfo to set
	 */
	public void setOhiInfo(OhiInfoContainer ohiInfo) {
		this.ohiInfo = ohiInfo;
	}

	public List<String> getPx() {
		ClaimType claimType = this.patientHeaderInfo.getClaimType();
		if (isInstitutional(claimType) && procedureCodesInfo.getShouldOtherProcCodesRender()) {
			// Add new string list for front-end displaying PX list
			px = new ArrayList<>();
			for (ProcedureCode code : procedureCodesInfo.getProcedureCodes()) {
				String procedureCode = code.getSequenceNumberAsString() + code.getValue();
				px.add(procedureCode);
			}
		}
		return px;
	}

	public List<String> getDx() {
		ClaimType claimType = patientHeaderInfo.getClaimType();
		ClaimFormat claimFormat = patientHeaderInfo.getClaimFormat();
		
		if(! (is4010(claimFormat) && isDental(claimType))) {
			dx = new ArrayList<>();
			for (DiagnosisCode code : this.diagnosisCodesInfo.getDiagnosisCodes()) {
				String diagnosisCode = code.getSequenceNumberAsString() + code.getValue();
				dx.add(diagnosisCode);
			}
		}
		return dx;
	}

	public List<String> geteCodes() {
		ClaimType claimType = this.patientHeaderInfo.getClaimType();
		ClaimFormat claimFormat = this.patientHeaderInfo.getClaimFormat();
		
		if(is5010(claimFormat) && isInstitutional(claimType) && e_CodesInfo.getShouldRender()) {
			eCodes = new ArrayList<>();
			for (ECode code : e_CodesInfo.getE_Codes()) {
				String eCode = code.getSequenceNumberAsString() + "." + code.getValueWithPoa();
				eCodes.add(eCode);
			}
    	}
		return eCodes;
	}

	private boolean isInstitutional(ClaimType claimType) {
		return ((claimType == null) ? false : claimType.equals(ClaimType.INSTITUTIONAL));
	}

	private boolean isProfessional(ClaimType claimType) {
		return ((claimType == null) ? false : claimType.equals(ClaimType.PROFESSIONAL));
	}

	private boolean isDental(ClaimType claimType) {
		return ((claimType == null) ? false : claimType.equals(ClaimType.DENTAL));
	}

	private boolean is4010(ClaimFormat claimFormat) {
		return ((claimFormat == null) ? false : claimFormat.equals(ClaimFormat.FORMAT4010));
	}

	private boolean is5010(ClaimFormat claimFormat) {
		return ((claimFormat == null) ? false : claimFormat.equals(ClaimFormat.FORMAT5010));
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((billingMiscellanous == null) ? 0 : billingMiscellanous.hashCode());
		result = prime * result + ((billingProviderInfo == null) ? 0 : billingProviderInfo.hashCode());
		result = prime * result + ((diagnosisCodesInfo == null) ? 0 : diagnosisCodesInfo.hashCode());
		result = prime * result + ((dx == null) ? 0 : dx.hashCode());
		result = prime * result + ((eCodes == null) ? 0 : eCodes.hashCode());
		result = prime * result + ((e_CodesInfo == null) ? 0 : e_CodesInfo.hashCode());
		result = prime * result + ((healthCareInfo == null) ? 0 : healthCareInfo.hashCode());
		result = prime * result + ((ohiInfo == null) ? 0 : ohiInfo.hashCode());
		result = prime * result + ((patientHeaderInfo == null) ? 0 : patientHeaderInfo.hashCode());
		result = prime * result + ((patientInfo == null) ? 0 : patientInfo.hashCode());
		result = prime * result + ((procedureCodesInfo == null) ? 0 : procedureCodesInfo.hashCode());
		result = prime * result + ((px == null) ? 0 : px.hashCode());
		result = prime * result + ((serviceLinesInfo == null) ? 0 : serviceLinesInfo.hashCode());
		result = prime * result + ((serviceLocationInfo == null) ? 0 : serviceLocationInfo.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		EwvClaimDetailResponse other = (EwvClaimDetailResponse) obj;
		if (billingMiscellanous == null) {
			if (other.billingMiscellanous != null)
				return false;
		} else if (!billingMiscellanous.equals(other.billingMiscellanous))
			return false;
		if (billingProviderInfo == null) {
			if (other.billingProviderInfo != null)
				return false;
		} else if (!billingProviderInfo.equals(other.billingProviderInfo))
			return false;
		if (diagnosisCodesInfo == null) {
			if (other.diagnosisCodesInfo != null)
				return false;
		} else if (!diagnosisCodesInfo.equals(other.diagnosisCodesInfo))
			return false;
		if (dx == null) {
			if (other.dx != null)
				return false;
		} else if (!dx.equals(other.dx))
			return false;
		if (eCodes == null) {
			if (other.eCodes != null)
				return false;
		} else if (!eCodes.equals(other.eCodes))
			return false;
		if (e_CodesInfo == null) {
			if (other.e_CodesInfo != null)
				return false;
		} else if (!e_CodesInfo.equals(other.e_CodesInfo))
			return false;
		if (healthCareInfo == null) {
			if (other.healthCareInfo != null)
				return false;
		} else if (!healthCareInfo.equals(other.healthCareInfo))
			return false;
		if (ohiInfo == null) {
			if (other.ohiInfo != null)
				return false;
		} else if (!ohiInfo.equals(other.ohiInfo))
			return false;
		if (patientHeaderInfo == null) {
			if (other.patientHeaderInfo != null)
				return false;
		} else if (!patientHeaderInfo.equals(other.patientHeaderInfo))
			return false;
		if (patientInfo == null) {
			if (other.patientInfo != null)
				return false;
		} else if (!patientInfo.equals(other.patientInfo))
			return false;
		if (procedureCodesInfo == null) {
			if (other.procedureCodesInfo != null)
				return false;
		} else if (!procedureCodesInfo.equals(other.procedureCodesInfo))
			return false;
		if (px == null) {
			if (other.px != null)
				return false;
		} else if (!px.equals(other.px))
			return false;
		if (serviceLinesInfo == null) {
			if (other.serviceLinesInfo != null)
				return false;
		} else if (!serviceLinesInfo.equals(other.serviceLinesInfo))
			return false;
		if (serviceLocationInfo == null) {
			if (other.serviceLocationInfo != null)
				return false;
		} else if (!serviceLocationInfo.equals(other.serviceLocationInfo))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("EwvClaimDetailResponse [patientHeaderInfo=");
		builder.append(patientHeaderInfo);
		builder.append(", patientInfo=");
		builder.append(patientInfo);
		builder.append(", serviceLocationInfo=");
		builder.append(serviceLocationInfo);
		builder.append(", billingProviderInfo=");
		builder.append(billingProviderInfo);
		builder.append(", billingMiscellanous=");
		builder.append(billingMiscellanous);
		builder.append(", diagnosisCodesInfo=");
		builder.append(diagnosisCodesInfo);
		builder.append(", procedureCodesInfo=");
		builder.append(procedureCodesInfo);
		builder.append(", e_CodesInfo=");
		builder.append(e_CodesInfo);
		builder.append(", healthCareInfo=");
		builder.append(healthCareInfo);
		builder.append(", serviceLinesInfo=");
		builder.append(serviceLinesInfo);
		builder.append(", ohiInfo=");
		builder.append(ohiInfo);
		builder.append("]");
		return builder.toString();
	}

	public EwvClaimDetailResponse(PatientHeaderInfo patientHeaderInfo, PatientInfo patientInfo,
			VendorInfo serviceLocationInfo, VendorInfo billingProviderInfo, BillingAndAdmissionInfo billingMiscellanous,
			DiagnosisCodesContainer diagnosisCodesInfo, ProcedureCodesContainer procedureCodesInfo, ECodesContainer e_CodesInfo,
			HealthCareInfoResponse healthCareInfo, List<ServiceLine> serviceLinesInfo, OhiInfoContainer ohiInfo) {
		super();
		this.patientHeaderInfo = patientHeaderInfo;
		this.patientInfo = patientInfo;
		this.serviceLocationInfo = serviceLocationInfo;
		this.billingProviderInfo = billingProviderInfo;
		this.billingMiscellanous = billingMiscellanous;
		this.diagnosisCodesInfo = diagnosisCodesInfo;
		this.procedureCodesInfo = procedureCodesInfo;
		this.e_CodesInfo = e_CodesInfo;
		this.healthCareInfo = healthCareInfo;
		this.serviceLinesInfo = serviceLinesInfo;
		this.ohiInfo = ohiInfo;
	}	
}
