package gov.va.med.ewv.model.response;

import java.io.Serializable;

import gov.va.med.ewv.util.DrugCategory_5010;
import gov.va.med.ewv.util.EwvUtils;

public class DrugLine implements Serializable
{
    private static final long serialVersionUID = 500026969907938620L;
    private String drugRx;
    private String drugRxNdcCode;
    private String drugRxQuantityPlusType;
    private String drugRxCharge;
    
    // Added quantity and type for Phase II, when they should be separate
    private String drugRxQuantity;
    private String drugRxType;
    
    // New for 5010
    private DrugCategory_5010 drugCategory_5010;

    public DrugLine(String drugRx,
    		        String drugRxNdcCode,
    		        String drugRxQuantityPlusType,
 		            String drugRxQuantity,
		            String drugRxType,
    		        String drugRxCharge,
    		        DrugCategory_5010 drugCategory_5010)
    {
        this.drugRx = drugRx;
        this.drugRxNdcCode = drugRxNdcCode;
        this.drugRxQuantityPlusType = drugRxQuantityPlusType;
        //this.drugRxQuantity = Ewv2Utils.formatAsInteger(drugRxQuantity);
        this.drugRxQuantity = drugRxQuantity;
        this.drugRxType = drugRxType;
        this.drugRxCharge = EwvUtils.formatAsCurrency(drugRxCharge);
        this.drugCategory_5010 = drugCategory_5010;
    }
    
    public String getDrugRx()
    {
        return drugRx;
    }
    
    public void setDrugRx(String drugRx)
    {
        this.drugRx = drugRx;
    }
    
    public String getDrugRxNdcCode()
    {
        return drugRxNdcCode;
    }
    
    public void setDrugRxNdcCode(String drugRxNdcCode)
    {
        this.drugRxNdcCode = drugRxNdcCode;
    }
    
    public String getDrugRxQuantityPlusType()
    {
        return drugRxQuantityPlusType;
    }
    
    public void setDrugRxQuantityPlusType(String drugRxQuantityPlusType)
    {
        this.drugRxQuantityPlusType = drugRxQuantityPlusType;
    }
    
    public String getDrugRxQuantity()
    {
        return drugRxQuantity;
    }
    
    public void setDrugRxQuantity(String drugRxQuantity)
    {
        this.drugRxQuantity = drugRxQuantity;
    }
    
    public String getDrugRxType()
    {
        return drugRxType;
    }
    
    public void setDrugRxType(String drugRxType)
    {
        this.drugRxType = drugRxType;
    }

    public DrugCategory_5010 getDrugCategory_5010() {
      return drugCategory_5010;
    }

    public void setDrugCategory_5010(DrugCategory_5010 drugCategory_5010) {
      this.drugCategory_5010 = drugCategory_5010;
    }

    public String getDrugRxCharge() {
      return drugRxCharge;
    }

    public void setDrugRxCharge(String drugRxCharge) {
      this.drugRxCharge = drugRxCharge;
    }

    public boolean getShouldAmountShow() {
      boolean returnVal = false;
      
      if (drugRxCharge != null && drugRxCharge.length() > 0) {
        returnVal = true;
      }
      
      //if (drugRxType != null && drugRxType.length() > 0) {
      //  returnVal = true;
      //}
      
      return returnVal;
    }

}
