package gov.va.med.ewv.model.response;

import gov.va.med.ewv.util.DTOBase;
import gov.va.med.ewv.util.EwvUtils;

public class DetailServiceLineOhiOutputRow extends DTOBase
{
    private String lineNumber;
	private String payerId;
    private String paymentSequenceIndicator;
    private String beginDateOfService;
    private String adjudicationDate;
    private String bundledUnbundledLineNumber;
    private String revenueCode;
    private String procedureCode;
    private String modifiers;
    private String lineCharge;
    private String payerPaidAmount;
    private String quantity;
    private ServiceLineOhiAdjustment adjustment;
    
	public DetailServiceLineOhiOutputRow() {
	}
	
	public DetailServiceLineOhiOutputRow
	      (String lineNumber,
           String payerId,
           String paymentSequenceIndicator,
           String beginDateOfService,
           String adjudicationDate,
           String bundledUnbundledLineNumber,
           String revenueCode,
           String procedureCode,
           String modifiers,
           String lineCharge,
           String payerPaidAmount,
           String quantity,
           ServiceLineOhiAdjustment adjustment)
    {
        this.lineNumber = lineNumber;
        this.payerId = payerId;
        this.paymentSequenceIndicator = paymentSequenceIndicator;
        this.beginDateOfService = EwvUtils.formatAsDate(beginDateOfService);
        this.adjudicationDate = EwvUtils.formatAsDate(adjudicationDate);
        this.bundledUnbundledLineNumber = bundledUnbundledLineNumber;
        this.revenueCode = revenueCode;
        this.procedureCode = procedureCode;
        this.modifiers = modifiers;
        this.lineCharge = EwvUtils.formatAsCurrency(lineCharge);
        this.payerPaidAmount = EwvUtils.formatAsCurrency(payerPaidAmount);
        //this.quantity = EwvUtils.formatAsInteger(quantity);
        this.quantity = quantity;
        this.adjustment = adjustment;
    }

	public void setLineNumber(String lineNumber) {
		this.lineNumber = lineNumber;
	}

	public String getLineNumber() {
		return lineNumber;
	}

  public String getPayerId() {
    return payerId;
  }

  public void setPayerId(String payerId) {
    this.payerId = payerId;
  }

  public String getPaymentSequenceIndicator() {
    return paymentSequenceIndicator;
  }

  public void setPaymentSequenceIndicator(String paymentSequenceIndicator) {
    this.paymentSequenceIndicator = paymentSequenceIndicator;
  }

  public String getAdjudicationDate() {
    return adjudicationDate;
  }

  public void setAdjudicationDate(String adjudicationDate) {
    this.adjudicationDate = adjudicationDate;
  }

  public String getBundledUnbundledLineNumber() {
    return bundledUnbundledLineNumber;
  }

  public void setBundledUnbundledLineNumber(String bundledUnbundledLineNumber) {
    this.bundledUnbundledLineNumber = bundledUnbundledLineNumber;
  }

  public String getRevenueCode() {
    return revenueCode;
  }

  public void setRevenueCode(String revenueCode) {
    this.revenueCode = revenueCode;
  }

  public String getProcedureCode() {
    return procedureCode;
  }

  public void setProcedureCode(String procedureCode) {
    this.procedureCode = procedureCode;
  }

  public String getModifiers() {
    return modifiers;
  }

  public void setModifiers(String modifiers) {
    this.modifiers = modifiers;
  }

  public String getLineCharge() {
    return lineCharge;
  }

  public void setLineCharge(String lineCharge) {
    this.lineCharge = lineCharge;
  }

  public String getPayerPaidAmount() {
    return payerPaidAmount;
  }

  public void setPayerPaidAmount(String payerPaidAmount) {
    this.payerPaidAmount = payerPaidAmount;
  }

  public String getQuantity() {
    return quantity;
  }

  public void setQuantity(String quantity) {
    this.quantity = quantity;
  }

  public ServiceLineOhiAdjustment getAdjustment() {
    return adjustment;
  }

  public void setAdjustment(ServiceLineOhiAdjustment adjustment) {
    this.adjustment = adjustment;
  }

  public String getBeginDateOfService() {
    return beginDateOfService;
  }

  public void setBeginDateOfService(String beginDateOfService) {
    this.beginDateOfService = beginDateOfService;
  }
    
}
